/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aivision.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.aivision.model.DocumentLanguage;
import com.oracle.bmc.aivision.model.ImageFeature;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="featureType")
@JsonFilter(value="explicitlySetFilter")
public final class ImageTextDetectionFeature
extends ImageFeature {
    @JsonProperty(value="language")
    private final DocumentLanguage language;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ImageTextDetectionFeature(DocumentLanguage language) {
        this.language = language;
    }

    public DocumentLanguage getLanguage() {
        return this.language;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ImageTextDetectionFeature(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", language=").append(String.valueOf((Object)this.language));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImageTextDetectionFeature)) {
            return false;
        }
        ImageTextDetectionFeature other = (ImageTextDetectionFeature)((Object)o);
        return Objects.equals((Object)this.language, (Object)other.language) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.language == null ? 43 : this.language.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="language")
        private DocumentLanguage language;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder language(DocumentLanguage language) {
            this.language = language;
            this.__explicitlySet__.add("language");
            return this;
        }

        public ImageTextDetectionFeature build() {
            ImageTextDetectionFeature model = new ImageTextDetectionFeature(this.language);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ImageTextDetectionFeature model) {
            if (model.wasPropertyExplicitlySet("language")) {
                this.language(model.getLanguage());
            }
            return this;
        }
    }
}

