/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aivision;

import com.oracle.bmc.aivision.AIServiceVision;
import com.oracle.bmc.aivision.model.ModelSummary;
import com.oracle.bmc.aivision.model.ProjectSummary;
import com.oracle.bmc.aivision.model.WorkRequestError;
import com.oracle.bmc.aivision.model.WorkRequestLogEntry;
import com.oracle.bmc.aivision.model.WorkRequestSummary;
import com.oracle.bmc.aivision.requests.ListModelsRequest;
import com.oracle.bmc.aivision.requests.ListProjectsRequest;
import com.oracle.bmc.aivision.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.aivision.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.aivision.requests.ListWorkRequestsRequest;
import com.oracle.bmc.aivision.responses.ListModelsResponse;
import com.oracle.bmc.aivision.responses.ListProjectsResponse;
import com.oracle.bmc.aivision.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.aivision.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.aivision.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class AIServiceVisionPaginators {
    private final AIServiceVision client;

    public AIServiceVisionPaginators(AIServiceVision client) {
        this.client = client;
    }

    public Iterable<ListModelsResponse> listModelsResponseIterator(final ListModelsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListModelsRequest.Builder>(){

            @Override
            public ListModelsRequest.Builder get() {
                return ListModelsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListModelsResponse, String>(){

            @Override
            public String apply(ListModelsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListModelsRequest.Builder>, ListModelsRequest>(){

            @Override
            public ListModelsRequest apply(RequestBuilderAndToken<ListModelsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListModelsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListModelsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListModelsRequest, ListModelsResponse>(){

            @Override
            public ListModelsResponse apply(ListModelsRequest request) {
                return AIServiceVisionPaginators.this.client.listModels(request);
            }
        });
    }

    public Iterable<ModelSummary> listModelsRecordIterator(final ListModelsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListModelsRequest.Builder>(){

            @Override
            public ListModelsRequest.Builder get() {
                return ListModelsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListModelsResponse, String>(){

            @Override
            public String apply(ListModelsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListModelsRequest.Builder>, ListModelsRequest>(){

            @Override
            public ListModelsRequest apply(RequestBuilderAndToken<ListModelsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListModelsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListModelsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListModelsRequest, ListModelsResponse>(){

            @Override
            public ListModelsResponse apply(ListModelsRequest request) {
                return AIServiceVisionPaginators.this.client.listModels(request);
            }
        }, (Function)new Function<ListModelsResponse, List<ModelSummary>>(){

            @Override
            public List<ModelSummary> apply(ListModelsResponse response) {
                return response.getModelCollection().getItems();
            }
        });
    }

    public Iterable<ListProjectsResponse> listProjectsResponseIterator(final ListProjectsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListProjectsRequest.Builder>(){

            @Override
            public ListProjectsRequest.Builder get() {
                return ListProjectsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListProjectsResponse, String>(){

            @Override
            public String apply(ListProjectsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListProjectsRequest.Builder>, ListProjectsRequest>(){

            @Override
            public ListProjectsRequest apply(RequestBuilderAndToken<ListProjectsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListProjectsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListProjectsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListProjectsRequest, ListProjectsResponse>(){

            @Override
            public ListProjectsResponse apply(ListProjectsRequest request) {
                return AIServiceVisionPaginators.this.client.listProjects(request);
            }
        });
    }

    public Iterable<ProjectSummary> listProjectsRecordIterator(final ListProjectsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListProjectsRequest.Builder>(){

            @Override
            public ListProjectsRequest.Builder get() {
                return ListProjectsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListProjectsResponse, String>(){

            @Override
            public String apply(ListProjectsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListProjectsRequest.Builder>, ListProjectsRequest>(){

            @Override
            public ListProjectsRequest apply(RequestBuilderAndToken<ListProjectsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListProjectsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListProjectsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListProjectsRequest, ListProjectsResponse>(){

            @Override
            public ListProjectsResponse apply(ListProjectsRequest request) {
                return AIServiceVisionPaginators.this.client.listProjects(request);
            }
        }, (Function)new Function<ListProjectsResponse, List<ProjectSummary>>(){

            @Override
            public List<ProjectSummary> apply(ListProjectsResponse response) {
                return response.getProjectCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return AIServiceVisionPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return AIServiceVisionPaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getWorkRequestErrorCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return AIServiceVisionPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return AIServiceVisionPaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            @Override
            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getWorkRequestLogEntryCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return AIServiceVisionPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return AIServiceVisionPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            @Override
            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getWorkRequestSummaryCollection().getItems();
            }
        });
    }
}

