/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aispeech.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CancelTranscriptionTaskRequest
extends BmcRequest<Void> {
    private String transcriptionJobId;
    private String transcriptionTaskId;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;

    public String getTranscriptionJobId() {
        return this.transcriptionJobId;
    }

    public String getTranscriptionTaskId() {
        return this.transcriptionTaskId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public Builder toBuilder() {
        return new Builder().transcriptionJobId(this.transcriptionJobId).transcriptionTaskId(this.transcriptionTaskId).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",transcriptionJobId=").append(String.valueOf(this.transcriptionJobId));
        sb.append(",transcriptionTaskId=").append(String.valueOf(this.transcriptionTaskId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CancelTranscriptionTaskRequest)) {
            return false;
        }
        CancelTranscriptionTaskRequest other = (CancelTranscriptionTaskRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.transcriptionJobId, other.transcriptionJobId) && Objects.equals(this.transcriptionTaskId, other.transcriptionTaskId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.transcriptionJobId == null ? 43 : this.transcriptionJobId.hashCode());
        result = result * 59 + (this.transcriptionTaskId == null ? 43 : this.transcriptionTaskId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CancelTranscriptionTaskRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String transcriptionJobId = null;
        private String transcriptionTaskId = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder transcriptionJobId(String transcriptionJobId) {
            this.transcriptionJobId = transcriptionJobId;
            return this;
        }

        public Builder transcriptionTaskId(String transcriptionTaskId) {
            this.transcriptionTaskId = transcriptionTaskId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CancelTranscriptionTaskRequest o) {
            this.transcriptionJobId(o.getTranscriptionJobId());
            this.transcriptionTaskId(o.getTranscriptionTaskId());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CancelTranscriptionTaskRequest build() {
            CancelTranscriptionTaskRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public CancelTranscriptionTaskRequest buildWithoutInvocationCallback() {
            CancelTranscriptionTaskRequest request = new CancelTranscriptionTaskRequest();
            request.transcriptionJobId = this.transcriptionJobId;
            request.transcriptionTaskId = this.transcriptionTaskId;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

