/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aispeech.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.aispeech.model.AudioFormatDetails;
import com.oracle.bmc.aispeech.model.ObjectLocation;
import com.oracle.bmc.aispeech.model.TranscriptionModelDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TranscriptionTask
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="timeStarted")
    private final Date timeStarted;
    @JsonProperty(value="timeFinished")
    private final Date timeFinished;
    @JsonProperty(value="percentComplete")
    private final Integer percentComplete;
    @JsonProperty(value="ttlInDays")
    private final Integer ttlInDays;
    @JsonProperty(value="modelDetails")
    private final TranscriptionModelDetails modelDetails;
    @JsonProperty(value="audioFormatDetails")
    private final AudioFormatDetails audioFormatDetails;
    @JsonProperty(value="fileSizeInBytes")
    private final Integer fileSizeInBytes;
    @JsonProperty(value="fileDurationInSeconds")
    private final Integer fileDurationInSeconds;
    @JsonProperty(value="processingDurationInSeconds")
    private final Integer processingDurationInSeconds;
    @JsonProperty(value="inputLocation")
    private final ObjectLocation inputLocation;
    @JsonProperty(value="outputLocation")
    private final ObjectLocation outputLocation;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "timeStarted", "timeFinished", "percentComplete", "ttlInDays", "modelDetails", "audioFormatDetails", "fileSizeInBytes", "fileDurationInSeconds", "processingDurationInSeconds", "inputLocation", "outputLocation", "lifecycleState", "lifecycleDetails"})
    public TranscriptionTask(String id, String displayName, Date timeStarted, Date timeFinished, Integer percentComplete, Integer ttlInDays, TranscriptionModelDetails modelDetails, AudioFormatDetails audioFormatDetails, Integer fileSizeInBytes, Integer fileDurationInSeconds, Integer processingDurationInSeconds, ObjectLocation inputLocation, ObjectLocation outputLocation, LifecycleState lifecycleState, String lifecycleDetails) {
        this.id = id;
        this.displayName = displayName;
        this.timeStarted = timeStarted;
        this.timeFinished = timeFinished;
        this.percentComplete = percentComplete;
        this.ttlInDays = ttlInDays;
        this.modelDetails = modelDetails;
        this.audioFormatDetails = audioFormatDetails;
        this.fileSizeInBytes = fileSizeInBytes;
        this.fileDurationInSeconds = fileDurationInSeconds;
        this.processingDurationInSeconds = processingDurationInSeconds;
        this.inputLocation = inputLocation;
        this.outputLocation = outputLocation;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeFinished() {
        return this.timeFinished;
    }

    public Integer getPercentComplete() {
        return this.percentComplete;
    }

    public Integer getTtlInDays() {
        return this.ttlInDays;
    }

    public TranscriptionModelDetails getModelDetails() {
        return this.modelDetails;
    }

    public AudioFormatDetails getAudioFormatDetails() {
        return this.audioFormatDetails;
    }

    public Integer getFileSizeInBytes() {
        return this.fileSizeInBytes;
    }

    public Integer getFileDurationInSeconds() {
        return this.fileDurationInSeconds;
    }

    public Integer getProcessingDurationInSeconds() {
        return this.processingDurationInSeconds;
    }

    public ObjectLocation getInputLocation() {
        return this.inputLocation;
    }

    public ObjectLocation getOutputLocation() {
        return this.outputLocation;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TranscriptionTask(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", timeFinished=").append(String.valueOf(this.timeFinished));
        sb.append(", percentComplete=").append(String.valueOf(this.percentComplete));
        sb.append(", ttlInDays=").append(String.valueOf(this.ttlInDays));
        sb.append(", modelDetails=").append(String.valueOf((Object)this.modelDetails));
        sb.append(", audioFormatDetails=").append(String.valueOf((Object)this.audioFormatDetails));
        sb.append(", fileSizeInBytes=").append(String.valueOf(this.fileSizeInBytes));
        sb.append(", fileDurationInSeconds=").append(String.valueOf(this.fileDurationInSeconds));
        sb.append(", processingDurationInSeconds=").append(String.valueOf(this.processingDurationInSeconds));
        sb.append(", inputLocation=").append(String.valueOf((Object)this.inputLocation));
        sb.append(", outputLocation=").append(String.valueOf((Object)this.outputLocation));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TranscriptionTask)) {
            return false;
        }
        TranscriptionTask other = (TranscriptionTask)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.timeStarted, other.timeStarted) && Objects.equals(this.timeFinished, other.timeFinished) && Objects.equals(this.percentComplete, other.percentComplete) && Objects.equals(this.ttlInDays, other.ttlInDays) && Objects.equals((Object)this.modelDetails, (Object)other.modelDetails) && Objects.equals((Object)this.audioFormatDetails, (Object)other.audioFormatDetails) && Objects.equals(this.fileSizeInBytes, other.fileSizeInBytes) && Objects.equals(this.fileDurationInSeconds, other.fileDurationInSeconds) && Objects.equals(this.processingDurationInSeconds, other.processingDurationInSeconds) && Objects.equals((Object)this.inputLocation, (Object)other.inputLocation) && Objects.equals((Object)this.outputLocation, (Object)other.outputLocation) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = result * 59 + (this.timeFinished == null ? 43 : this.timeFinished.hashCode());
        result = result * 59 + (this.percentComplete == null ? 43 : this.percentComplete.hashCode());
        result = result * 59 + (this.ttlInDays == null ? 43 : this.ttlInDays.hashCode());
        result = result * 59 + (this.modelDetails == null ? 43 : this.modelDetails.hashCode());
        result = result * 59 + (this.audioFormatDetails == null ? 43 : this.audioFormatDetails.hashCode());
        result = result * 59 + (this.fileSizeInBytes == null ? 43 : this.fileSizeInBytes.hashCode());
        result = result * 59 + (this.fileDurationInSeconds == null ? 43 : this.fileDurationInSeconds.hashCode());
        result = result * 59 + (this.processingDurationInSeconds == null ? 43 : this.processingDurationInSeconds.hashCode());
        result = result * 59 + (this.inputLocation == null ? 43 : this.inputLocation.hashCode());
        result = result * 59 + (this.outputLocation == null ? 43 : this.outputLocation.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Accepted("ACCEPTED"),
        InProgress("IN_PROGRESS"),
        Succeeded("SUCCEEDED"),
        Failed("FAILED"),
        Canceled("CANCELED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="timeFinished")
        private Date timeFinished;
        @JsonProperty(value="percentComplete")
        private Integer percentComplete;
        @JsonProperty(value="ttlInDays")
        private Integer ttlInDays;
        @JsonProperty(value="modelDetails")
        private TranscriptionModelDetails modelDetails;
        @JsonProperty(value="audioFormatDetails")
        private AudioFormatDetails audioFormatDetails;
        @JsonProperty(value="fileSizeInBytes")
        private Integer fileSizeInBytes;
        @JsonProperty(value="fileDurationInSeconds")
        private Integer fileDurationInSeconds;
        @JsonProperty(value="processingDurationInSeconds")
        private Integer processingDurationInSeconds;
        @JsonProperty(value="inputLocation")
        private ObjectLocation inputLocation;
        @JsonProperty(value="outputLocation")
        private ObjectLocation outputLocation;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder timeFinished(Date timeFinished) {
            this.timeFinished = timeFinished;
            this.__explicitlySet__.add("timeFinished");
            return this;
        }

        public Builder percentComplete(Integer percentComplete) {
            this.percentComplete = percentComplete;
            this.__explicitlySet__.add("percentComplete");
            return this;
        }

        public Builder ttlInDays(Integer ttlInDays) {
            this.ttlInDays = ttlInDays;
            this.__explicitlySet__.add("ttlInDays");
            return this;
        }

        public Builder modelDetails(TranscriptionModelDetails modelDetails) {
            this.modelDetails = modelDetails;
            this.__explicitlySet__.add("modelDetails");
            return this;
        }

        public Builder audioFormatDetails(AudioFormatDetails audioFormatDetails) {
            this.audioFormatDetails = audioFormatDetails;
            this.__explicitlySet__.add("audioFormatDetails");
            return this;
        }

        public Builder fileSizeInBytes(Integer fileSizeInBytes) {
            this.fileSizeInBytes = fileSizeInBytes;
            this.__explicitlySet__.add("fileSizeInBytes");
            return this;
        }

        public Builder fileDurationInSeconds(Integer fileDurationInSeconds) {
            this.fileDurationInSeconds = fileDurationInSeconds;
            this.__explicitlySet__.add("fileDurationInSeconds");
            return this;
        }

        public Builder processingDurationInSeconds(Integer processingDurationInSeconds) {
            this.processingDurationInSeconds = processingDurationInSeconds;
            this.__explicitlySet__.add("processingDurationInSeconds");
            return this;
        }

        public Builder inputLocation(ObjectLocation inputLocation) {
            this.inputLocation = inputLocation;
            this.__explicitlySet__.add("inputLocation");
            return this;
        }

        public Builder outputLocation(ObjectLocation outputLocation) {
            this.outputLocation = outputLocation;
            this.__explicitlySet__.add("outputLocation");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public TranscriptionTask build() {
            TranscriptionTask model = new TranscriptionTask(this.id, this.displayName, this.timeStarted, this.timeFinished, this.percentComplete, this.ttlInDays, this.modelDetails, this.audioFormatDetails, this.fileSizeInBytes, this.fileDurationInSeconds, this.processingDurationInSeconds, this.inputLocation, this.outputLocation, this.lifecycleState, this.lifecycleDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TranscriptionTask model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeFinished")) {
                this.timeFinished(model.getTimeFinished());
            }
            if (model.wasPropertyExplicitlySet("percentComplete")) {
                this.percentComplete(model.getPercentComplete());
            }
            if (model.wasPropertyExplicitlySet("ttlInDays")) {
                this.ttlInDays(model.getTtlInDays());
            }
            if (model.wasPropertyExplicitlySet("modelDetails")) {
                this.modelDetails(model.getModelDetails());
            }
            if (model.wasPropertyExplicitlySet("audioFormatDetails")) {
                this.audioFormatDetails(model.getAudioFormatDetails());
            }
            if (model.wasPropertyExplicitlySet("fileSizeInBytes")) {
                this.fileSizeInBytes(model.getFileSizeInBytes());
            }
            if (model.wasPropertyExplicitlySet("fileDurationInSeconds")) {
                this.fileDurationInSeconds(model.getFileDurationInSeconds());
            }
            if (model.wasPropertyExplicitlySet("processingDurationInSeconds")) {
                this.processingDurationInSeconds(model.getProcessingDurationInSeconds());
            }
            if (model.wasPropertyExplicitlySet("inputLocation")) {
                this.inputLocation(model.getInputLocation());
            }
            if (model.wasPropertyExplicitlySet("outputLocation")) {
                this.outputLocation(model.getOutputLocation());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            return this;
        }
    }
}

