/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aispeech.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.aispeech.model.InputLocation;
import com.oracle.bmc.aispeech.model.OutputLocation;
import com.oracle.bmc.aispeech.model.TranscriptionModelDetails;
import com.oracle.bmc.aispeech.model.TranscriptionNormalization;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TranscriptionJob
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="modelDetails")
    private final TranscriptionModelDetails modelDetails;
    @JsonProperty(value="normalization")
    private final TranscriptionNormalization normalization;
    @JsonProperty(value="timeAccepted")
    private final Date timeAccepted;
    @JsonProperty(value="timeStarted")
    private final Date timeStarted;
    @JsonProperty(value="timeFinished")
    private final Date timeFinished;
    @JsonProperty(value="totalTasks")
    private final Integer totalTasks;
    @JsonProperty(value="outstandingTasks")
    private final Integer outstandingTasks;
    @JsonProperty(value="successfulTasks")
    private final Integer successfulTasks;
    @JsonProperty(value="ttlInDays")
    private final Integer ttlInDays;
    @JsonProperty(value="percentComplete")
    private final Integer percentComplete;
    @JsonProperty(value="inputLocation")
    private final InputLocation inputLocation;
    @JsonProperty(value="outputLocation")
    private final OutputLocation outputLocation;
    @JsonProperty(value="createdBy")
    private final String createdBy;
    @JsonProperty(value="additionalTranscriptionFormats")
    private final List<AdditionalTranscriptionFormats> additionalTranscriptionFormats;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "compartmentId", "description", "modelDetails", "normalization", "timeAccepted", "timeStarted", "timeFinished", "totalTasks", "outstandingTasks", "successfulTasks", "ttlInDays", "percentComplete", "inputLocation", "outputLocation", "createdBy", "additionalTranscriptionFormats", "lifecycleState", "lifecycleDetails", "freeformTags", "definedTags", "systemTags"})
    public TranscriptionJob(String id, String displayName, String compartmentId, String description, TranscriptionModelDetails modelDetails, TranscriptionNormalization normalization, Date timeAccepted, Date timeStarted, Date timeFinished, Integer totalTasks, Integer outstandingTasks, Integer successfulTasks, Integer ttlInDays, Integer percentComplete, InputLocation inputLocation, OutputLocation outputLocation, String createdBy, List<AdditionalTranscriptionFormats> additionalTranscriptionFormats, LifecycleState lifecycleState, String lifecycleDetails, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags) {
        this.id = id;
        this.displayName = displayName;
        this.compartmentId = compartmentId;
        this.description = description;
        this.modelDetails = modelDetails;
        this.normalization = normalization;
        this.timeAccepted = timeAccepted;
        this.timeStarted = timeStarted;
        this.timeFinished = timeFinished;
        this.totalTasks = totalTasks;
        this.outstandingTasks = outstandingTasks;
        this.successfulTasks = successfulTasks;
        this.ttlInDays = ttlInDays;
        this.percentComplete = percentComplete;
        this.inputLocation = inputLocation;
        this.outputLocation = outputLocation;
        this.createdBy = createdBy;
        this.additionalTranscriptionFormats = additionalTranscriptionFormats;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDescription() {
        return this.description;
    }

    public TranscriptionModelDetails getModelDetails() {
        return this.modelDetails;
    }

    public TranscriptionNormalization getNormalization() {
        return this.normalization;
    }

    public Date getTimeAccepted() {
        return this.timeAccepted;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeFinished() {
        return this.timeFinished;
    }

    public Integer getTotalTasks() {
        return this.totalTasks;
    }

    public Integer getOutstandingTasks() {
        return this.outstandingTasks;
    }

    public Integer getSuccessfulTasks() {
        return this.successfulTasks;
    }

    public Integer getTtlInDays() {
        return this.ttlInDays;
    }

    public Integer getPercentComplete() {
        return this.percentComplete;
    }

    public InputLocation getInputLocation() {
        return this.inputLocation;
    }

    public OutputLocation getOutputLocation() {
        return this.outputLocation;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public List<AdditionalTranscriptionFormats> getAdditionalTranscriptionFormats() {
        return this.additionalTranscriptionFormats;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TranscriptionJob(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", modelDetails=").append(String.valueOf((Object)this.modelDetails));
        sb.append(", normalization=").append(String.valueOf((Object)this.normalization));
        sb.append(", timeAccepted=").append(String.valueOf(this.timeAccepted));
        sb.append(", timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", timeFinished=").append(String.valueOf(this.timeFinished));
        sb.append(", totalTasks=").append(String.valueOf(this.totalTasks));
        sb.append(", outstandingTasks=").append(String.valueOf(this.outstandingTasks));
        sb.append(", successfulTasks=").append(String.valueOf(this.successfulTasks));
        sb.append(", ttlInDays=").append(String.valueOf(this.ttlInDays));
        sb.append(", percentComplete=").append(String.valueOf(this.percentComplete));
        sb.append(", inputLocation=").append(String.valueOf((Object)this.inputLocation));
        sb.append(", outputLocation=").append(String.valueOf((Object)this.outputLocation));
        sb.append(", createdBy=").append(String.valueOf(this.createdBy));
        sb.append(", additionalTranscriptionFormats=").append(String.valueOf(this.additionalTranscriptionFormats));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TranscriptionJob)) {
            return false;
        }
        TranscriptionJob other = (TranscriptionJob)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.description, other.description) && Objects.equals((Object)this.modelDetails, (Object)other.modelDetails) && Objects.equals((Object)this.normalization, (Object)other.normalization) && Objects.equals(this.timeAccepted, other.timeAccepted) && Objects.equals(this.timeStarted, other.timeStarted) && Objects.equals(this.timeFinished, other.timeFinished) && Objects.equals(this.totalTasks, other.totalTasks) && Objects.equals(this.outstandingTasks, other.outstandingTasks) && Objects.equals(this.successfulTasks, other.successfulTasks) && Objects.equals(this.ttlInDays, other.ttlInDays) && Objects.equals(this.percentComplete, other.percentComplete) && Objects.equals((Object)this.inputLocation, (Object)other.inputLocation) && Objects.equals((Object)this.outputLocation, (Object)other.outputLocation) && Objects.equals(this.createdBy, other.createdBy) && Objects.equals(this.additionalTranscriptionFormats, other.additionalTranscriptionFormats) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.modelDetails == null ? 43 : this.modelDetails.hashCode());
        result = result * 59 + (this.normalization == null ? 43 : this.normalization.hashCode());
        result = result * 59 + (this.timeAccepted == null ? 43 : this.timeAccepted.hashCode());
        result = result * 59 + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = result * 59 + (this.timeFinished == null ? 43 : this.timeFinished.hashCode());
        result = result * 59 + (this.totalTasks == null ? 43 : this.totalTasks.hashCode());
        result = result * 59 + (this.outstandingTasks == null ? 43 : this.outstandingTasks.hashCode());
        result = result * 59 + (this.successfulTasks == null ? 43 : this.successfulTasks.hashCode());
        result = result * 59 + (this.ttlInDays == null ? 43 : this.ttlInDays.hashCode());
        result = result * 59 + (this.percentComplete == null ? 43 : this.percentComplete.hashCode());
        result = result * 59 + (this.inputLocation == null ? 43 : this.inputLocation.hashCode());
        result = result * 59 + (this.outputLocation == null ? 43 : this.outputLocation.hashCode());
        result = result * 59 + (this.createdBy == null ? 43 : this.createdBy.hashCode());
        result = result * 59 + (this.additionalTranscriptionFormats == null ? 43 : this.additionalTranscriptionFormats.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Accepted("ACCEPTED"),
        InProgress("IN_PROGRESS"),
        Succeeded("SUCCEEDED"),
        Failed("FAILED"),
        Canceling("CANCELING"),
        Canceled("CANCELED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum AdditionalTranscriptionFormats implements BmcEnum
    {
        Srt("SRT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, AdditionalTranscriptionFormats> map;

        private AdditionalTranscriptionFormats(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AdditionalTranscriptionFormats create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'AdditionalTranscriptionFormats', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(AdditionalTranscriptionFormats.class);
            map = new HashMap<String, AdditionalTranscriptionFormats>();
            for (AdditionalTranscriptionFormats v : AdditionalTranscriptionFormats.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="modelDetails")
        private TranscriptionModelDetails modelDetails;
        @JsonProperty(value="normalization")
        private TranscriptionNormalization normalization;
        @JsonProperty(value="timeAccepted")
        private Date timeAccepted;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="timeFinished")
        private Date timeFinished;
        @JsonProperty(value="totalTasks")
        private Integer totalTasks;
        @JsonProperty(value="outstandingTasks")
        private Integer outstandingTasks;
        @JsonProperty(value="successfulTasks")
        private Integer successfulTasks;
        @JsonProperty(value="ttlInDays")
        private Integer ttlInDays;
        @JsonProperty(value="percentComplete")
        private Integer percentComplete;
        @JsonProperty(value="inputLocation")
        private InputLocation inputLocation;
        @JsonProperty(value="outputLocation")
        private OutputLocation outputLocation;
        @JsonProperty(value="createdBy")
        private String createdBy;
        @JsonProperty(value="additionalTranscriptionFormats")
        private List<AdditionalTranscriptionFormats> additionalTranscriptionFormats;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder modelDetails(TranscriptionModelDetails modelDetails) {
            this.modelDetails = modelDetails;
            this.__explicitlySet__.add("modelDetails");
            return this;
        }

        public Builder normalization(TranscriptionNormalization normalization) {
            this.normalization = normalization;
            this.__explicitlySet__.add("normalization");
            return this;
        }

        public Builder timeAccepted(Date timeAccepted) {
            this.timeAccepted = timeAccepted;
            this.__explicitlySet__.add("timeAccepted");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder timeFinished(Date timeFinished) {
            this.timeFinished = timeFinished;
            this.__explicitlySet__.add("timeFinished");
            return this;
        }

        public Builder totalTasks(Integer totalTasks) {
            this.totalTasks = totalTasks;
            this.__explicitlySet__.add("totalTasks");
            return this;
        }

        public Builder outstandingTasks(Integer outstandingTasks) {
            this.outstandingTasks = outstandingTasks;
            this.__explicitlySet__.add("outstandingTasks");
            return this;
        }

        public Builder successfulTasks(Integer successfulTasks) {
            this.successfulTasks = successfulTasks;
            this.__explicitlySet__.add("successfulTasks");
            return this;
        }

        public Builder ttlInDays(Integer ttlInDays) {
            this.ttlInDays = ttlInDays;
            this.__explicitlySet__.add("ttlInDays");
            return this;
        }

        public Builder percentComplete(Integer percentComplete) {
            this.percentComplete = percentComplete;
            this.__explicitlySet__.add("percentComplete");
            return this;
        }

        public Builder inputLocation(InputLocation inputLocation) {
            this.inputLocation = inputLocation;
            this.__explicitlySet__.add("inputLocation");
            return this;
        }

        public Builder outputLocation(OutputLocation outputLocation) {
            this.outputLocation = outputLocation;
            this.__explicitlySet__.add("outputLocation");
            return this;
        }

        public Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            this.__explicitlySet__.add("createdBy");
            return this;
        }

        public Builder additionalTranscriptionFormats(List<AdditionalTranscriptionFormats> additionalTranscriptionFormats) {
            this.additionalTranscriptionFormats = additionalTranscriptionFormats;
            this.__explicitlySet__.add("additionalTranscriptionFormats");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public TranscriptionJob build() {
            TranscriptionJob model = new TranscriptionJob(this.id, this.displayName, this.compartmentId, this.description, this.modelDetails, this.normalization, this.timeAccepted, this.timeStarted, this.timeFinished, this.totalTasks, this.outstandingTasks, this.successfulTasks, this.ttlInDays, this.percentComplete, this.inputLocation, this.outputLocation, this.createdBy, this.additionalTranscriptionFormats, this.lifecycleState, this.lifecycleDetails, this.freeformTags, this.definedTags, this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TranscriptionJob model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("modelDetails")) {
                this.modelDetails(model.getModelDetails());
            }
            if (model.wasPropertyExplicitlySet("normalization")) {
                this.normalization(model.getNormalization());
            }
            if (model.wasPropertyExplicitlySet("timeAccepted")) {
                this.timeAccepted(model.getTimeAccepted());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeFinished")) {
                this.timeFinished(model.getTimeFinished());
            }
            if (model.wasPropertyExplicitlySet("totalTasks")) {
                this.totalTasks(model.getTotalTasks());
            }
            if (model.wasPropertyExplicitlySet("outstandingTasks")) {
                this.outstandingTasks(model.getOutstandingTasks());
            }
            if (model.wasPropertyExplicitlySet("successfulTasks")) {
                this.successfulTasks(model.getSuccessfulTasks());
            }
            if (model.wasPropertyExplicitlySet("ttlInDays")) {
                this.ttlInDays(model.getTtlInDays());
            }
            if (model.wasPropertyExplicitlySet("percentComplete")) {
                this.percentComplete(model.getPercentComplete());
            }
            if (model.wasPropertyExplicitlySet("inputLocation")) {
                this.inputLocation(model.getInputLocation());
            }
            if (model.wasPropertyExplicitlySet("outputLocation")) {
                this.outputLocation(model.getOutputLocation());
            }
            if (model.wasPropertyExplicitlySet("createdBy")) {
                this.createdBy(model.getCreatedBy());
            }
            if (model.wasPropertyExplicitlySet("additionalTranscriptionFormats")) {
                this.additionalTranscriptionFormats(model.getAdditionalTranscriptionFormats());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }
}

