/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aispeech;

import com.oracle.bmc.aispeech.AIServiceSpeech;
import com.oracle.bmc.aispeech.model.TranscriptionJob;
import com.oracle.bmc.aispeech.model.TranscriptionTask;
import com.oracle.bmc.aispeech.requests.GetTranscriptionJobRequest;
import com.oracle.bmc.aispeech.requests.GetTranscriptionTaskRequest;
import com.oracle.bmc.aispeech.responses.GetTranscriptionJobResponse;
import com.oracle.bmc.aispeech.responses.GetTranscriptionTaskResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class AIServiceSpeechWaiters {
    private final ExecutorService executorService;
    private final AIServiceSpeech client;

    public AIServiceSpeechWaiters(ExecutorService executorService, AIServiceSpeech client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetTranscriptionJobRequest, GetTranscriptionJobResponse> forTranscriptionJob(GetTranscriptionJobRequest request, TranscriptionJob.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTranscriptionJob(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetTranscriptionJobRequest, GetTranscriptionJobResponse> forTranscriptionJob(GetTranscriptionJobRequest request, TranscriptionJob.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forTranscriptionJob(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetTranscriptionJobRequest, GetTranscriptionJobResponse> forTranscriptionJob(GetTranscriptionJobRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, TranscriptionJob.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forTranscriptionJob(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetTranscriptionJobRequest, GetTranscriptionJobResponse> forTranscriptionJob(BmcGenericWaiter waiter, GetTranscriptionJobRequest request, TranscriptionJob.LifecycleState ... targetStates) {
        final HashSet<TranscriptionJob.LifecycleState> targetStatesSet = new HashSet<TranscriptionJob.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetTranscriptionJobRequest, GetTranscriptionJobResponse>(){

            @Override
            public GetTranscriptionJobResponse apply(GetTranscriptionJobRequest request) {
                return AIServiceSpeechWaiters.this.client.getTranscriptionJob(request);
            }
        }, (Predicate)new Predicate<GetTranscriptionJobResponse>(){

            @Override
            public boolean test(GetTranscriptionJobResponse response) {
                return targetStatesSet.contains((Object)response.getTranscriptionJob().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetTranscriptionTaskRequest, GetTranscriptionTaskResponse> forTranscriptionTask(GetTranscriptionTaskRequest request, TranscriptionTask.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTranscriptionTask(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetTranscriptionTaskRequest, GetTranscriptionTaskResponse> forTranscriptionTask(GetTranscriptionTaskRequest request, TranscriptionTask.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forTranscriptionTask(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetTranscriptionTaskRequest, GetTranscriptionTaskResponse> forTranscriptionTask(GetTranscriptionTaskRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, TranscriptionTask.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forTranscriptionTask(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetTranscriptionTaskRequest, GetTranscriptionTaskResponse> forTranscriptionTask(BmcGenericWaiter waiter, GetTranscriptionTaskRequest request, TranscriptionTask.LifecycleState ... targetStates) {
        final HashSet<TranscriptionTask.LifecycleState> targetStatesSet = new HashSet<TranscriptionTask.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetTranscriptionTaskRequest, GetTranscriptionTaskResponse>(){

            @Override
            public GetTranscriptionTaskResponse apply(GetTranscriptionTaskRequest request) {
                return AIServiceSpeechWaiters.this.client.getTranscriptionTask(request);
            }
        }, (Predicate)new Predicate<GetTranscriptionTaskResponse>(){

            @Override
            public boolean test(GetTranscriptionTaskResponse response) {
                return targetStatesSet.contains((Object)response.getTranscriptionTask().getLifecycleState());
            }
        }, false), (Object)request);
    }
}

