/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aianomalydetection.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PerSignalDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="signalName")
    private final String signalName;
    @JsonProperty(value="mviRatio")
    private final Double mviRatio;
    @JsonProperty(value="isQuantized")
    private final Boolean isQuantized;
    @JsonProperty(value="fap")
    private final Float fap;
    @JsonProperty(value="min")
    private final Double min;
    @JsonProperty(value="max")
    private final Double max;
    @JsonProperty(value="std")
    private final Double std;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="details")
    private final String details;

    @Deprecated
    @ConstructorProperties(value={"signalName", "mviRatio", "isQuantized", "fap", "min", "max", "std", "status", "details"})
    public PerSignalDetails(String signalName, Double mviRatio, Boolean isQuantized, Float fap, Double min, Double max, Double std, Status status, String details) {
        this.signalName = signalName;
        this.mviRatio = mviRatio;
        this.isQuantized = isQuantized;
        this.fap = fap;
        this.min = min;
        this.max = max;
        this.std = std;
        this.status = status;
        this.details = details;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getSignalName() {
        return this.signalName;
    }

    public Double getMviRatio() {
        return this.mviRatio;
    }

    public Boolean getIsQuantized() {
        return this.isQuantized;
    }

    public Float getFap() {
        return this.fap;
    }

    public Double getMin() {
        return this.min;
    }

    public Double getMax() {
        return this.max;
    }

    public Double getStd() {
        return this.std;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getDetails() {
        return this.details;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PerSignalDetails(");
        sb.append("super=").append(super.toString());
        sb.append("signalName=").append(String.valueOf(this.signalName));
        sb.append(", mviRatio=").append(String.valueOf(this.mviRatio));
        sb.append(", isQuantized=").append(String.valueOf(this.isQuantized));
        sb.append(", fap=").append(String.valueOf(this.fap));
        sb.append(", min=").append(String.valueOf(this.min));
        sb.append(", max=").append(String.valueOf(this.max));
        sb.append(", std=").append(String.valueOf(this.std));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", details=").append(String.valueOf(this.details));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PerSignalDetails)) {
            return false;
        }
        PerSignalDetails other = (PerSignalDetails)((Object)o);
        return Objects.equals(this.signalName, other.signalName) && Objects.equals(this.mviRatio, other.mviRatio) && Objects.equals(this.isQuantized, other.isQuantized) && Objects.equals(this.fap, other.fap) && Objects.equals(this.min, other.min) && Objects.equals(this.max, other.max) && Objects.equals(this.std, other.std) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.details, other.details) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.signalName == null ? 43 : this.signalName.hashCode());
        result = result * 59 + (this.mviRatio == null ? 43 : this.mviRatio.hashCode());
        result = result * 59 + (this.isQuantized == null ? 43 : this.isQuantized.hashCode());
        result = result * 59 + (this.fap == null ? 43 : this.fap.hashCode());
        result = result * 59 + (this.min == null ? 43 : this.min.hashCode());
        result = result * 59 + (this.max == null ? 43 : this.max.hashCode());
        result = result * 59 + (this.std == null ? 43 : this.std.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.details == null ? 43 : this.details.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Status implements BmcEnum
    {
        Accepted("ACCEPTED"),
        Dropped("DROPPED"),
        Other("OTHER"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="signalName")
        private String signalName;
        @JsonProperty(value="mviRatio")
        private Double mviRatio;
        @JsonProperty(value="isQuantized")
        private Boolean isQuantized;
        @JsonProperty(value="fap")
        private Float fap;
        @JsonProperty(value="min")
        private Double min;
        @JsonProperty(value="max")
        private Double max;
        @JsonProperty(value="std")
        private Double std;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="details")
        private String details;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder signalName(String signalName) {
            this.signalName = signalName;
            this.__explicitlySet__.add("signalName");
            return this;
        }

        public Builder mviRatio(Double mviRatio) {
            this.mviRatio = mviRatio;
            this.__explicitlySet__.add("mviRatio");
            return this;
        }

        public Builder isQuantized(Boolean isQuantized) {
            this.isQuantized = isQuantized;
            this.__explicitlySet__.add("isQuantized");
            return this;
        }

        public Builder fap(Float fap) {
            this.fap = fap;
            this.__explicitlySet__.add("fap");
            return this;
        }

        public Builder min(Double min) {
            this.min = min;
            this.__explicitlySet__.add("min");
            return this;
        }

        public Builder max(Double max) {
            this.max = max;
            this.__explicitlySet__.add("max");
            return this;
        }

        public Builder std(Double std) {
            this.std = std;
            this.__explicitlySet__.add("std");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder details(String details) {
            this.details = details;
            this.__explicitlySet__.add("details");
            return this;
        }

        public PerSignalDetails build() {
            PerSignalDetails model = new PerSignalDetails(this.signalName, this.mviRatio, this.isQuantized, this.fap, this.min, this.max, this.std, this.status, this.details);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PerSignalDetails model) {
            if (model.wasPropertyExplicitlySet("signalName")) {
                this.signalName(model.getSignalName());
            }
            if (model.wasPropertyExplicitlySet("mviRatio")) {
                this.mviRatio(model.getMviRatio());
            }
            if (model.wasPropertyExplicitlySet("isQuantized")) {
                this.isQuantized(model.getIsQuantized());
            }
            if (model.wasPropertyExplicitlySet("fap")) {
                this.fap(model.getFap());
            }
            if (model.wasPropertyExplicitlySet("min")) {
                this.min(model.getMin());
            }
            if (model.wasPropertyExplicitlySet("max")) {
                this.max(model.getMax());
            }
            if (model.wasPropertyExplicitlySet("std")) {
                this.std(model.getStd());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("details")) {
                this.details(model.getDetails());
            }
            return this;
        }
    }
}

