/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aianomalydetection.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.aianomalydetection.model.PerSignalDetails;
import com.oracle.bmc.aianomalydetection.model.RowReductionDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ModelTrainingResults
extends ExplicitlySetBmcModel {
    @JsonProperty(value="fap")
    private final Float fap;
    @JsonProperty(value="multivariateFap")
    private final Float multivariateFap;
    @JsonProperty(value="isTrainingGoalAchieved")
    private final Boolean isTrainingGoalAchieved;
    @JsonProperty(value="warning")
    private final String warning;
    @JsonProperty(value="signalDetails")
    private final List<PerSignalDetails> signalDetails;
    @JsonProperty(value="rowReductionDetails")
    private final RowReductionDetails rowReductionDetails;

    @Deprecated
    @ConstructorProperties(value={"fap", "multivariateFap", "isTrainingGoalAchieved", "warning", "signalDetails", "rowReductionDetails"})
    public ModelTrainingResults(Float fap, Float multivariateFap, Boolean isTrainingGoalAchieved, String warning, List<PerSignalDetails> signalDetails, RowReductionDetails rowReductionDetails) {
        this.fap = fap;
        this.multivariateFap = multivariateFap;
        this.isTrainingGoalAchieved = isTrainingGoalAchieved;
        this.warning = warning;
        this.signalDetails = signalDetails;
        this.rowReductionDetails = rowReductionDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Float getFap() {
        return this.fap;
    }

    public Float getMultivariateFap() {
        return this.multivariateFap;
    }

    public Boolean getIsTrainingGoalAchieved() {
        return this.isTrainingGoalAchieved;
    }

    public String getWarning() {
        return this.warning;
    }

    public List<PerSignalDetails> getSignalDetails() {
        return this.signalDetails;
    }

    public RowReductionDetails getRowReductionDetails() {
        return this.rowReductionDetails;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ModelTrainingResults(");
        sb.append("super=").append(super.toString());
        sb.append("fap=").append(String.valueOf(this.fap));
        sb.append(", multivariateFap=").append(String.valueOf(this.multivariateFap));
        sb.append(", isTrainingGoalAchieved=").append(String.valueOf(this.isTrainingGoalAchieved));
        sb.append(", warning=").append(String.valueOf(this.warning));
        sb.append(", signalDetails=").append(String.valueOf(this.signalDetails));
        sb.append(", rowReductionDetails=").append(String.valueOf((Object)this.rowReductionDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModelTrainingResults)) {
            return false;
        }
        ModelTrainingResults other = (ModelTrainingResults)((Object)o);
        return Objects.equals(this.fap, other.fap) && Objects.equals(this.multivariateFap, other.multivariateFap) && Objects.equals(this.isTrainingGoalAchieved, other.isTrainingGoalAchieved) && Objects.equals(this.warning, other.warning) && Objects.equals(this.signalDetails, other.signalDetails) && Objects.equals((Object)this.rowReductionDetails, (Object)other.rowReductionDetails) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.fap == null ? 43 : this.fap.hashCode());
        result = result * 59 + (this.multivariateFap == null ? 43 : this.multivariateFap.hashCode());
        result = result * 59 + (this.isTrainingGoalAchieved == null ? 43 : this.isTrainingGoalAchieved.hashCode());
        result = result * 59 + (this.warning == null ? 43 : this.warning.hashCode());
        result = result * 59 + (this.signalDetails == null ? 43 : this.signalDetails.hashCode());
        result = result * 59 + (this.rowReductionDetails == null ? 43 : this.rowReductionDetails.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="fap")
        private Float fap;
        @JsonProperty(value="multivariateFap")
        private Float multivariateFap;
        @JsonProperty(value="isTrainingGoalAchieved")
        private Boolean isTrainingGoalAchieved;
        @JsonProperty(value="warning")
        private String warning;
        @JsonProperty(value="signalDetails")
        private List<PerSignalDetails> signalDetails;
        @JsonProperty(value="rowReductionDetails")
        private RowReductionDetails rowReductionDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder fap(Float fap) {
            this.fap = fap;
            this.__explicitlySet__.add("fap");
            return this;
        }

        public Builder multivariateFap(Float multivariateFap) {
            this.multivariateFap = multivariateFap;
            this.__explicitlySet__.add("multivariateFap");
            return this;
        }

        public Builder isTrainingGoalAchieved(Boolean isTrainingGoalAchieved) {
            this.isTrainingGoalAchieved = isTrainingGoalAchieved;
            this.__explicitlySet__.add("isTrainingGoalAchieved");
            return this;
        }

        public Builder warning(String warning) {
            this.warning = warning;
            this.__explicitlySet__.add("warning");
            return this;
        }

        public Builder signalDetails(List<PerSignalDetails> signalDetails) {
            this.signalDetails = signalDetails;
            this.__explicitlySet__.add("signalDetails");
            return this;
        }

        public Builder rowReductionDetails(RowReductionDetails rowReductionDetails) {
            this.rowReductionDetails = rowReductionDetails;
            this.__explicitlySet__.add("rowReductionDetails");
            return this;
        }

        public ModelTrainingResults build() {
            ModelTrainingResults model = new ModelTrainingResults(this.fap, this.multivariateFap, this.isTrainingGoalAchieved, this.warning, this.signalDetails, this.rowReductionDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ModelTrainingResults model) {
            if (model.wasPropertyExplicitlySet("fap")) {
                this.fap(model.getFap());
            }
            if (model.wasPropertyExplicitlySet("multivariateFap")) {
                this.multivariateFap(model.getMultivariateFap());
            }
            if (model.wasPropertyExplicitlySet("isTrainingGoalAchieved")) {
                this.isTrainingGoalAchieved(model.getIsTrainingGoalAchieved());
            }
            if (model.wasPropertyExplicitlySet("warning")) {
                this.warning(model.getWarning());
            }
            if (model.wasPropertyExplicitlySet("signalDetails")) {
                this.signalDetails(model.getSignalDetails());
            }
            if (model.wasPropertyExplicitlySet("rowReductionDetails")) {
                this.rowReductionDetails(model.getRowReductionDetails());
            }
            return this;
        }
    }
}

