/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aianomalydetection.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.aianomalydetection.model.InfluxDetails;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="influxVersion")
@JsonFilter(value="explicitlySetFilter")
public final class InfluxDetailsV1v8
extends InfluxDetails {
    @JsonProperty(value="databaseName")
    private final String databaseName;
    @JsonProperty(value="retentionPolicyName")
    private final String retentionPolicyName;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public InfluxDetailsV1v8(String databaseName, String retentionPolicyName) {
        this.databaseName = databaseName;
        this.retentionPolicyName = retentionPolicyName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getRetentionPolicyName() {
        return this.retentionPolicyName;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("InfluxDetailsV1v8(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", databaseName=").append(String.valueOf(this.databaseName));
        sb.append(", retentionPolicyName=").append(String.valueOf(this.retentionPolicyName));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InfluxDetailsV1v8)) {
            return false;
        }
        InfluxDetailsV1v8 other = (InfluxDetailsV1v8)((Object)o);
        return Objects.equals(this.databaseName, other.databaseName) && Objects.equals(this.retentionPolicyName, other.retentionPolicyName) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.databaseName == null ? 43 : this.databaseName.hashCode());
        result = result * 59 + (this.retentionPolicyName == null ? 43 : this.retentionPolicyName.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="databaseName")
        private String databaseName;
        @JsonProperty(value="retentionPolicyName")
        private String retentionPolicyName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            this.__explicitlySet__.add("databaseName");
            return this;
        }

        public Builder retentionPolicyName(String retentionPolicyName) {
            this.retentionPolicyName = retentionPolicyName;
            this.__explicitlySet__.add("retentionPolicyName");
            return this;
        }

        public InfluxDetailsV1v8 build() {
            InfluxDetailsV1v8 model = new InfluxDetailsV1v8(this.databaseName, this.retentionPolicyName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(InfluxDetailsV1v8 model) {
            if (model.wasPropertyExplicitlySet("databaseName")) {
                this.databaseName(model.getDatabaseName());
            }
            if (model.wasPropertyExplicitlySet("retentionPolicyName")) {
                this.retentionPolicyName(model.getRetentionPolicyName());
            }
            return this;
        }
    }
}

