/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aianomalydetection;

import com.oracle.bmc.aianomalydetection.AnomalyDetection;
import com.oracle.bmc.aianomalydetection.model.AiPrivateEndpoint;
import com.oracle.bmc.aianomalydetection.model.DataAsset;
import com.oracle.bmc.aianomalydetection.model.Model;
import com.oracle.bmc.aianomalydetection.model.Project;
import com.oracle.bmc.aianomalydetection.requests.GetAiPrivateEndpointRequest;
import com.oracle.bmc.aianomalydetection.requests.GetDataAssetRequest;
import com.oracle.bmc.aianomalydetection.requests.GetModelRequest;
import com.oracle.bmc.aianomalydetection.requests.GetProjectRequest;
import com.oracle.bmc.aianomalydetection.requests.GetWorkRequestRequest;
import com.oracle.bmc.aianomalydetection.responses.GetAiPrivateEndpointResponse;
import com.oracle.bmc.aianomalydetection.responses.GetDataAssetResponse;
import com.oracle.bmc.aianomalydetection.responses.GetModelResponse;
import com.oracle.bmc.aianomalydetection.responses.GetProjectResponse;
import com.oracle.bmc.aianomalydetection.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class AnomalyDetectionWaiters {
    private final ExecutorService executorService;
    private final AnomalyDetection client;

    public AnomalyDetectionWaiters(ExecutorService executorService, AnomalyDetection client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetAiPrivateEndpointRequest, GetAiPrivateEndpointResponse> forAiPrivateEndpoint(GetAiPrivateEndpointRequest request, AiPrivateEndpoint.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAiPrivateEndpoint(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAiPrivateEndpointRequest, GetAiPrivateEndpointResponse> forAiPrivateEndpoint(GetAiPrivateEndpointRequest request, AiPrivateEndpoint.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAiPrivateEndpoint(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetAiPrivateEndpointRequest, GetAiPrivateEndpointResponse> forAiPrivateEndpoint(GetAiPrivateEndpointRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, AiPrivateEndpoint.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forAiPrivateEndpoint(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetAiPrivateEndpointRequest, GetAiPrivateEndpointResponse> forAiPrivateEndpoint(BmcGenericWaiter waiter, GetAiPrivateEndpointRequest request, AiPrivateEndpoint.LifecycleState ... targetStates) {
        final HashSet<AiPrivateEndpoint.LifecycleState> targetStatesSet = new HashSet<AiPrivateEndpoint.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetAiPrivateEndpointRequest, GetAiPrivateEndpointResponse>(){

            @Override
            public GetAiPrivateEndpointResponse apply(GetAiPrivateEndpointRequest request) {
                return AnomalyDetectionWaiters.this.client.getAiPrivateEndpoint(request);
            }
        }, (Predicate)new Predicate<GetAiPrivateEndpointResponse>(){

            @Override
            public boolean test(GetAiPrivateEndpointResponse response) {
                return targetStatesSet.contains((Object)response.getAiPrivateEndpoint().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)AiPrivateEndpoint.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDataAssetRequest, GetDataAssetResponse> forDataAsset(GetDataAssetRequest request, DataAsset.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDataAsset(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDataAssetRequest, GetDataAssetResponse> forDataAsset(GetDataAssetRequest request, DataAsset.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDataAsset(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDataAssetRequest, GetDataAssetResponse> forDataAsset(GetDataAssetRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, DataAsset.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDataAsset(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDataAssetRequest, GetDataAssetResponse> forDataAsset(BmcGenericWaiter waiter, GetDataAssetRequest request, DataAsset.LifecycleState ... targetStates) {
        final HashSet<DataAsset.LifecycleState> targetStatesSet = new HashSet<DataAsset.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDataAssetRequest, GetDataAssetResponse>(){

            @Override
            public GetDataAssetResponse apply(GetDataAssetRequest request) {
                return AnomalyDetectionWaiters.this.client.getDataAsset(request);
            }
        }, (Predicate)new Predicate<GetDataAssetResponse>(){

            @Override
            public boolean test(GetDataAssetResponse response) {
                return targetStatesSet.contains((Object)response.getDataAsset().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)DataAsset.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetModelRequest, GetModelResponse> forModel(GetModelRequest request, Model.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forModel(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetModelRequest, GetModelResponse> forModel(GetModelRequest request, Model.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forModel(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetModelRequest, GetModelResponse> forModel(GetModelRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Model.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forModel(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetModelRequest, GetModelResponse> forModel(BmcGenericWaiter waiter, GetModelRequest request, Model.LifecycleState ... targetStates) {
        final HashSet<Model.LifecycleState> targetStatesSet = new HashSet<Model.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetModelRequest, GetModelResponse>(){

            @Override
            public GetModelResponse apply(GetModelRequest request) {
                return AnomalyDetectionWaiters.this.client.getModel(request);
            }
        }, (Predicate)new Predicate<GetModelResponse>(){

            @Override
            public boolean test(GetModelResponse response) {
                return targetStatesSet.contains((Object)response.getModel().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Model.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetProjectRequest, GetProjectResponse> forProject(GetProjectRequest request, Project.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forProject(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetProjectRequest, GetProjectResponse> forProject(GetProjectRequest request, Project.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forProject(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetProjectRequest, GetProjectResponse> forProject(GetProjectRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Project.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forProject(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetProjectRequest, GetProjectResponse> forProject(BmcGenericWaiter waiter, GetProjectRequest request, Project.LifecycleState ... targetStates) {
        final HashSet<Project.LifecycleState> targetStatesSet = new HashSet<Project.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetProjectRequest, GetProjectResponse>(){

            @Override
            public GetProjectResponse apply(GetProjectRequest request) {
                return AnomalyDetectionWaiters.this.client.getProject(request);
            }
        }, (Predicate)new Predicate<GetProjectResponse>(){

            @Override
            public boolean test(GetProjectResponse response) {
                return targetStatesSet.contains((Object)response.getProject().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Project.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return AnomalyDetectionWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

