/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aianomalydetection;

import com.oracle.bmc.aianomalydetection.AnomalyDetection;
import com.oracle.bmc.aianomalydetection.model.AiPrivateEndpointSummary;
import com.oracle.bmc.aianomalydetection.model.DataAssetSummary;
import com.oracle.bmc.aianomalydetection.model.ModelSummary;
import com.oracle.bmc.aianomalydetection.model.ProjectSummary;
import com.oracle.bmc.aianomalydetection.model.WorkRequestError;
import com.oracle.bmc.aianomalydetection.model.WorkRequestLogEntry;
import com.oracle.bmc.aianomalydetection.model.WorkRequestSummary;
import com.oracle.bmc.aianomalydetection.requests.ListAiPrivateEndpointsRequest;
import com.oracle.bmc.aianomalydetection.requests.ListDataAssetsRequest;
import com.oracle.bmc.aianomalydetection.requests.ListModelsRequest;
import com.oracle.bmc.aianomalydetection.requests.ListProjectsRequest;
import com.oracle.bmc.aianomalydetection.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.aianomalydetection.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.aianomalydetection.requests.ListWorkRequestsRequest;
import com.oracle.bmc.aianomalydetection.responses.ListAiPrivateEndpointsResponse;
import com.oracle.bmc.aianomalydetection.responses.ListDataAssetsResponse;
import com.oracle.bmc.aianomalydetection.responses.ListModelsResponse;
import com.oracle.bmc.aianomalydetection.responses.ListProjectsResponse;
import com.oracle.bmc.aianomalydetection.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.aianomalydetection.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.aianomalydetection.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class AnomalyDetectionPaginators {
    private final AnomalyDetection client;

    public AnomalyDetectionPaginators(AnomalyDetection client) {
        this.client = client;
    }

    public Iterable<ListAiPrivateEndpointsResponse> listAiPrivateEndpointsResponseIterator(final ListAiPrivateEndpointsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAiPrivateEndpointsRequest.Builder>(){

            @Override
            public ListAiPrivateEndpointsRequest.Builder get() {
                return ListAiPrivateEndpointsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAiPrivateEndpointsResponse, String>(){

            @Override
            public String apply(ListAiPrivateEndpointsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAiPrivateEndpointsRequest.Builder>, ListAiPrivateEndpointsRequest>(){

            @Override
            public ListAiPrivateEndpointsRequest apply(RequestBuilderAndToken<ListAiPrivateEndpointsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAiPrivateEndpointsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAiPrivateEndpointsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAiPrivateEndpointsRequest, ListAiPrivateEndpointsResponse>(){

            @Override
            public ListAiPrivateEndpointsResponse apply(ListAiPrivateEndpointsRequest request) {
                return AnomalyDetectionPaginators.this.client.listAiPrivateEndpoints(request);
            }
        });
    }

    public Iterable<AiPrivateEndpointSummary> listAiPrivateEndpointsRecordIterator(final ListAiPrivateEndpointsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAiPrivateEndpointsRequest.Builder>(){

            @Override
            public ListAiPrivateEndpointsRequest.Builder get() {
                return ListAiPrivateEndpointsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAiPrivateEndpointsResponse, String>(){

            @Override
            public String apply(ListAiPrivateEndpointsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAiPrivateEndpointsRequest.Builder>, ListAiPrivateEndpointsRequest>(){

            @Override
            public ListAiPrivateEndpointsRequest apply(RequestBuilderAndToken<ListAiPrivateEndpointsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAiPrivateEndpointsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAiPrivateEndpointsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAiPrivateEndpointsRequest, ListAiPrivateEndpointsResponse>(){

            @Override
            public ListAiPrivateEndpointsResponse apply(ListAiPrivateEndpointsRequest request) {
                return AnomalyDetectionPaginators.this.client.listAiPrivateEndpoints(request);
            }
        }, (Function)new Function<ListAiPrivateEndpointsResponse, List<AiPrivateEndpointSummary>>(){

            @Override
            public List<AiPrivateEndpointSummary> apply(ListAiPrivateEndpointsResponse response) {
                return response.getAiPrivateEndpointCollection().getItems();
            }
        });
    }

    public Iterable<ListDataAssetsResponse> listDataAssetsResponseIterator(final ListDataAssetsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDataAssetsRequest.Builder>(){

            @Override
            public ListDataAssetsRequest.Builder get() {
                return ListDataAssetsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDataAssetsResponse, String>(){

            @Override
            public String apply(ListDataAssetsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDataAssetsRequest.Builder>, ListDataAssetsRequest>(){

            @Override
            public ListDataAssetsRequest apply(RequestBuilderAndToken<ListDataAssetsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDataAssetsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDataAssetsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDataAssetsRequest, ListDataAssetsResponse>(){

            @Override
            public ListDataAssetsResponse apply(ListDataAssetsRequest request) {
                return AnomalyDetectionPaginators.this.client.listDataAssets(request);
            }
        });
    }

    public Iterable<DataAssetSummary> listDataAssetsRecordIterator(final ListDataAssetsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDataAssetsRequest.Builder>(){

            @Override
            public ListDataAssetsRequest.Builder get() {
                return ListDataAssetsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDataAssetsResponse, String>(){

            @Override
            public String apply(ListDataAssetsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDataAssetsRequest.Builder>, ListDataAssetsRequest>(){

            @Override
            public ListDataAssetsRequest apply(RequestBuilderAndToken<ListDataAssetsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDataAssetsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDataAssetsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDataAssetsRequest, ListDataAssetsResponse>(){

            @Override
            public ListDataAssetsResponse apply(ListDataAssetsRequest request) {
                return AnomalyDetectionPaginators.this.client.listDataAssets(request);
            }
        }, (Function)new Function<ListDataAssetsResponse, List<DataAssetSummary>>(){

            @Override
            public List<DataAssetSummary> apply(ListDataAssetsResponse response) {
                return response.getDataAssetCollection().getItems();
            }
        });
    }

    public Iterable<ListModelsResponse> listModelsResponseIterator(final ListModelsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListModelsRequest.Builder>(){

            @Override
            public ListModelsRequest.Builder get() {
                return ListModelsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListModelsResponse, String>(){

            @Override
            public String apply(ListModelsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListModelsRequest.Builder>, ListModelsRequest>(){

            @Override
            public ListModelsRequest apply(RequestBuilderAndToken<ListModelsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListModelsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListModelsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListModelsRequest, ListModelsResponse>(){

            @Override
            public ListModelsResponse apply(ListModelsRequest request) {
                return AnomalyDetectionPaginators.this.client.listModels(request);
            }
        });
    }

    public Iterable<ModelSummary> listModelsRecordIterator(final ListModelsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListModelsRequest.Builder>(){

            @Override
            public ListModelsRequest.Builder get() {
                return ListModelsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListModelsResponse, String>(){

            @Override
            public String apply(ListModelsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListModelsRequest.Builder>, ListModelsRequest>(){

            @Override
            public ListModelsRequest apply(RequestBuilderAndToken<ListModelsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListModelsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListModelsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListModelsRequest, ListModelsResponse>(){

            @Override
            public ListModelsResponse apply(ListModelsRequest request) {
                return AnomalyDetectionPaginators.this.client.listModels(request);
            }
        }, (Function)new Function<ListModelsResponse, List<ModelSummary>>(){

            @Override
            public List<ModelSummary> apply(ListModelsResponse response) {
                return response.getModelCollection().getItems();
            }
        });
    }

    public Iterable<ListProjectsResponse> listProjectsResponseIterator(final ListProjectsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListProjectsRequest.Builder>(){

            @Override
            public ListProjectsRequest.Builder get() {
                return ListProjectsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListProjectsResponse, String>(){

            @Override
            public String apply(ListProjectsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListProjectsRequest.Builder>, ListProjectsRequest>(){

            @Override
            public ListProjectsRequest apply(RequestBuilderAndToken<ListProjectsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListProjectsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListProjectsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListProjectsRequest, ListProjectsResponse>(){

            @Override
            public ListProjectsResponse apply(ListProjectsRequest request) {
                return AnomalyDetectionPaginators.this.client.listProjects(request);
            }
        });
    }

    public Iterable<ProjectSummary> listProjectsRecordIterator(final ListProjectsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListProjectsRequest.Builder>(){

            @Override
            public ListProjectsRequest.Builder get() {
                return ListProjectsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListProjectsResponse, String>(){

            @Override
            public String apply(ListProjectsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListProjectsRequest.Builder>, ListProjectsRequest>(){

            @Override
            public ListProjectsRequest apply(RequestBuilderAndToken<ListProjectsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListProjectsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListProjectsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListProjectsRequest, ListProjectsResponse>(){

            @Override
            public ListProjectsResponse apply(ListProjectsRequest request) {
                return AnomalyDetectionPaginators.this.client.listProjects(request);
            }
        }, (Function)new Function<ListProjectsResponse, List<ProjectSummary>>(){

            @Override
            public List<ProjectSummary> apply(ListProjectsResponse response) {
                return response.getProjectCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return AnomalyDetectionPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return AnomalyDetectionPaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getWorkRequestErrorCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return AnomalyDetectionPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return AnomalyDetectionPaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            @Override
            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getWorkRequestLogEntryCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return AnomalyDetectionPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return AnomalyDetectionPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            @Override
            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getWorkRequestSummaryCollection().getItems();
            }
        });
    }
}

