/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aianomalydetection;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.aianomalydetection.AnomalyDetectionAsync;
import com.oracle.bmc.aianomalydetection.model.AiPrivateEndpoint;
import com.oracle.bmc.aianomalydetection.model.AiPrivateEndpointCollection;
import com.oracle.bmc.aianomalydetection.model.AnomalyDetectResult;
import com.oracle.bmc.aianomalydetection.model.DataAsset;
import com.oracle.bmc.aianomalydetection.model.DataAssetCollection;
import com.oracle.bmc.aianomalydetection.model.Model;
import com.oracle.bmc.aianomalydetection.model.ModelCollection;
import com.oracle.bmc.aianomalydetection.model.Project;
import com.oracle.bmc.aianomalydetection.model.ProjectCollection;
import com.oracle.bmc.aianomalydetection.model.WorkRequest;
import com.oracle.bmc.aianomalydetection.model.WorkRequestErrorCollection;
import com.oracle.bmc.aianomalydetection.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.aianomalydetection.model.WorkRequestSummaryCollection;
import com.oracle.bmc.aianomalydetection.requests.CancelWorkRequestRequest;
import com.oracle.bmc.aianomalydetection.requests.ChangeAiPrivateEndpointCompartmentRequest;
import com.oracle.bmc.aianomalydetection.requests.ChangeDataAssetCompartmentRequest;
import com.oracle.bmc.aianomalydetection.requests.ChangeModelCompartmentRequest;
import com.oracle.bmc.aianomalydetection.requests.ChangeProjectCompartmentRequest;
import com.oracle.bmc.aianomalydetection.requests.CreateAiPrivateEndpointRequest;
import com.oracle.bmc.aianomalydetection.requests.CreateDataAssetRequest;
import com.oracle.bmc.aianomalydetection.requests.CreateModelRequest;
import com.oracle.bmc.aianomalydetection.requests.CreateProjectRequest;
import com.oracle.bmc.aianomalydetection.requests.DeleteAiPrivateEndpointRequest;
import com.oracle.bmc.aianomalydetection.requests.DeleteDataAssetRequest;
import com.oracle.bmc.aianomalydetection.requests.DeleteModelRequest;
import com.oracle.bmc.aianomalydetection.requests.DeleteProjectRequest;
import com.oracle.bmc.aianomalydetection.requests.DetectAnomaliesRequest;
import com.oracle.bmc.aianomalydetection.requests.GetAiPrivateEndpointRequest;
import com.oracle.bmc.aianomalydetection.requests.GetDataAssetRequest;
import com.oracle.bmc.aianomalydetection.requests.GetModelRequest;
import com.oracle.bmc.aianomalydetection.requests.GetProjectRequest;
import com.oracle.bmc.aianomalydetection.requests.GetWorkRequestRequest;
import com.oracle.bmc.aianomalydetection.requests.ListAiPrivateEndpointsRequest;
import com.oracle.bmc.aianomalydetection.requests.ListDataAssetsRequest;
import com.oracle.bmc.aianomalydetection.requests.ListModelsRequest;
import com.oracle.bmc.aianomalydetection.requests.ListProjectsRequest;
import com.oracle.bmc.aianomalydetection.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.aianomalydetection.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.aianomalydetection.requests.ListWorkRequestsRequest;
import com.oracle.bmc.aianomalydetection.requests.UpdateAiPrivateEndpointRequest;
import com.oracle.bmc.aianomalydetection.requests.UpdateDataAssetRequest;
import com.oracle.bmc.aianomalydetection.requests.UpdateModelRequest;
import com.oracle.bmc.aianomalydetection.requests.UpdateProjectRequest;
import com.oracle.bmc.aianomalydetection.responses.CancelWorkRequestResponse;
import com.oracle.bmc.aianomalydetection.responses.ChangeAiPrivateEndpointCompartmentResponse;
import com.oracle.bmc.aianomalydetection.responses.ChangeDataAssetCompartmentResponse;
import com.oracle.bmc.aianomalydetection.responses.ChangeModelCompartmentResponse;
import com.oracle.bmc.aianomalydetection.responses.ChangeProjectCompartmentResponse;
import com.oracle.bmc.aianomalydetection.responses.CreateAiPrivateEndpointResponse;
import com.oracle.bmc.aianomalydetection.responses.CreateDataAssetResponse;
import com.oracle.bmc.aianomalydetection.responses.CreateModelResponse;
import com.oracle.bmc.aianomalydetection.responses.CreateProjectResponse;
import com.oracle.bmc.aianomalydetection.responses.DeleteAiPrivateEndpointResponse;
import com.oracle.bmc.aianomalydetection.responses.DeleteDataAssetResponse;
import com.oracle.bmc.aianomalydetection.responses.DeleteModelResponse;
import com.oracle.bmc.aianomalydetection.responses.DeleteProjectResponse;
import com.oracle.bmc.aianomalydetection.responses.DetectAnomaliesResponse;
import com.oracle.bmc.aianomalydetection.responses.GetAiPrivateEndpointResponse;
import com.oracle.bmc.aianomalydetection.responses.GetDataAssetResponse;
import com.oracle.bmc.aianomalydetection.responses.GetModelResponse;
import com.oracle.bmc.aianomalydetection.responses.GetProjectResponse;
import com.oracle.bmc.aianomalydetection.responses.GetWorkRequestResponse;
import com.oracle.bmc.aianomalydetection.responses.ListAiPrivateEndpointsResponse;
import com.oracle.bmc.aianomalydetection.responses.ListDataAssetsResponse;
import com.oracle.bmc.aianomalydetection.responses.ListModelsResponse;
import com.oracle.bmc.aianomalydetection.responses.ListProjectsResponse;
import com.oracle.bmc.aianomalydetection.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.aianomalydetection.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.aianomalydetection.responses.ListWorkRequestsResponse;
import com.oracle.bmc.aianomalydetection.responses.UpdateAiPrivateEndpointResponse;
import com.oracle.bmc.aianomalydetection.responses.UpdateDataAssetResponse;
import com.oracle.bmc.aianomalydetection.responses.UpdateModelResponse;
import com.oracle.bmc.aianomalydetection.responses.UpdateProjectResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnomalyDetectionAsyncClient
extends BaseAsyncClient
implements AnomalyDetectionAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("ANOMALYDETECTION").serviceEndpointPrefix("").serviceEndpointTemplate("https://anomalydetection.aiservice.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(AnomalyDetectionAsyncClient.class);

    private AnomalyDetectionAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<CancelWorkRequestResponse> cancelWorkRequest(CancelWorkRequestRequest request, AsyncHandler<CancelWorkRequestRequest, CancelWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CancelWorkRequestResponse::builder).logger(LOG, "cancelWorkRequest").serviceDetails("AnomalyDetection", "CancelWorkRequest", "").method(Method.DELETE).requestBuilder(CancelWorkRequestRequest::builder).basePath("/20210101").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", CancelWorkRequestResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeAiPrivateEndpointCompartmentResponse> changeAiPrivateEndpointCompartment(ChangeAiPrivateEndpointCompartmentRequest request, AsyncHandler<ChangeAiPrivateEndpointCompartmentRequest, ChangeAiPrivateEndpointCompartmentResponse> handler) {
        Validate.notBlank((String)request.getAiPrivateEndpointId(), (String)"aiPrivateEndpointId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeAiPrivateEndpointCompartmentDetails(), "changeAiPrivateEndpointCompartmentDetails is required");
        return this.clientCall(request, ChangeAiPrivateEndpointCompartmentResponse::builder).logger(LOG, "changeAiPrivateEndpointCompartment").serviceDetails("AnomalyDetection", "ChangeAiPrivateEndpointCompartment", "").method(Method.POST).requestBuilder(ChangeAiPrivateEndpointCompartmentRequest::builder).basePath("/20210101").appendPathParam("aiPrivateEndpoints").appendPathParam(request.getAiPrivateEndpointId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeAiPrivateEndpointCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeAiPrivateEndpointCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeDataAssetCompartmentResponse> changeDataAssetCompartment(ChangeDataAssetCompartmentRequest request, AsyncHandler<ChangeDataAssetCompartmentRequest, ChangeDataAssetCompartmentResponse> handler) {
        Validate.notBlank((String)request.getDataAssetId(), (String)"dataAssetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeDataAssetCompartmentDetails(), "changeDataAssetCompartmentDetails is required");
        return this.clientCall(request, ChangeDataAssetCompartmentResponse::builder).logger(LOG, "changeDataAssetCompartment").serviceDetails("AnomalyDetection", "ChangeDataAssetCompartment", "").method(Method.POST).requestBuilder(ChangeDataAssetCompartmentRequest::builder).basePath("/20210101").appendPathParam("dataAssets").appendPathParam(request.getDataAssetId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(DataAsset.class, ChangeDataAssetCompartmentResponse.Builder::dataAsset).handleResponseHeaderString("etag", ChangeDataAssetCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeDataAssetCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeModelCompartmentResponse> changeModelCompartment(ChangeModelCompartmentRequest request, AsyncHandler<ChangeModelCompartmentRequest, ChangeModelCompartmentResponse> handler) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeModelCompartmentDetails(), "changeModelCompartmentDetails is required");
        return this.clientCall(request, ChangeModelCompartmentResponse::builder).logger(LOG, "changeModelCompartment").serviceDetails("AnomalyDetection", "ChangeModelCompartment", "").method(Method.POST).requestBuilder(ChangeModelCompartmentRequest::builder).basePath("/20210101").appendPathParam("models").appendPathParam(request.getModelId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeModelCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeProjectCompartmentResponse> changeProjectCompartment(ChangeProjectCompartmentRequest request, AsyncHandler<ChangeProjectCompartmentRequest, ChangeProjectCompartmentResponse> handler) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeProjectCompartmentDetails(), "changeProjectCompartmentDetails is required");
        return this.clientCall(request, ChangeProjectCompartmentResponse::builder).logger(LOG, "changeProjectCompartment").serviceDetails("AnomalyDetection", "ChangeProjectCompartment", "").method(Method.POST).requestBuilder(ChangeProjectCompartmentRequest::builder).basePath("/20210101").appendPathParam("projects").appendPathParam(request.getProjectId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeProjectCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateAiPrivateEndpointResponse> createAiPrivateEndpoint(CreateAiPrivateEndpointRequest request, AsyncHandler<CreateAiPrivateEndpointRequest, CreateAiPrivateEndpointResponse> handler) {
        Objects.requireNonNull(request.getCreateAiPrivateEndpointDetails(), "createAiPrivateEndpointDetails is required");
        return this.clientCall(request, CreateAiPrivateEndpointResponse::builder).logger(LOG, "createAiPrivateEndpoint").serviceDetails("AnomalyDetection", "CreateAiPrivateEndpoint", "").method(Method.POST).requestBuilder(CreateAiPrivateEndpointRequest::builder).basePath("/20210101").appendPathParam("aiPrivateEndpoints").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", CreateAiPrivateEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateAiPrivateEndpointResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateDataAssetResponse> createDataAsset(CreateDataAssetRequest request, AsyncHandler<CreateDataAssetRequest, CreateDataAssetResponse> handler) {
        Objects.requireNonNull(request.getCreateDataAssetDetails(), "createDataAssetDetails is required");
        return this.clientCall(request, CreateDataAssetResponse::builder).logger(LOG, "createDataAsset").serviceDetails("AnomalyDetection", "CreateDataAsset", "").method(Method.POST).requestBuilder(CreateDataAssetRequest::builder).basePath("/20210101").appendPathParam("dataAssets").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DataAsset.class, CreateDataAssetResponse.Builder::dataAsset).handleResponseHeaderString("etag", CreateDataAssetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateDataAssetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateModelResponse> createModel(CreateModelRequest request, AsyncHandler<CreateModelRequest, CreateModelResponse> handler) {
        Objects.requireNonNull(request.getCreateModelDetails(), "createModelDetails is required");
        return this.clientCall(request, CreateModelResponse::builder).logger(LOG, "createModel").serviceDetails("AnomalyDetection", "CreateModel", "").method(Method.POST).requestBuilder(CreateModelRequest::builder).basePath("/20210101").appendPathParam("models").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Model.class, CreateModelResponse.Builder::model).handleResponseHeaderString("etag", CreateModelResponse.Builder::etag).handleResponseHeaderString("location", CreateModelResponse.Builder::location).handleResponseHeaderString("opc-work-request-id", CreateModelResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateModelResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateProjectResponse> createProject(CreateProjectRequest request, AsyncHandler<CreateProjectRequest, CreateProjectResponse> handler) {
        Objects.requireNonNull(request.getCreateProjectDetails(), "createProjectDetails is required");
        return this.clientCall(request, CreateProjectResponse::builder).logger(LOG, "createProject").serviceDetails("AnomalyDetection", "CreateProject", "").method(Method.POST).requestBuilder(CreateProjectRequest::builder).basePath("/20210101").appendPathParam("projects").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Project.class, CreateProjectResponse.Builder::project).handleResponseHeaderString("etag", CreateProjectResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateProjectResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteAiPrivateEndpointResponse> deleteAiPrivateEndpoint(DeleteAiPrivateEndpointRequest request, AsyncHandler<DeleteAiPrivateEndpointRequest, DeleteAiPrivateEndpointResponse> handler) {
        Validate.notBlank((String)request.getAiPrivateEndpointId(), (String)"aiPrivateEndpointId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteAiPrivateEndpointResponse::builder).logger(LOG, "deleteAiPrivateEndpoint").serviceDetails("AnomalyDetection", "DeleteAiPrivateEndpoint", "").method(Method.DELETE).requestBuilder(DeleteAiPrivateEndpointRequest::builder).basePath("/20210101").appendPathParam("aiPrivateEndpoints").appendPathParam(request.getAiPrivateEndpointId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteAiPrivateEndpointResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteAiPrivateEndpointResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteDataAssetResponse> deleteDataAsset(DeleteDataAssetRequest request, AsyncHandler<DeleteDataAssetRequest, DeleteDataAssetResponse> handler) {
        Validate.notBlank((String)request.getDataAssetId(), (String)"dataAssetId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteDataAssetResponse::builder).logger(LOG, "deleteDataAsset").serviceDetails("AnomalyDetection", "DeleteDataAsset", "").method(Method.DELETE).requestBuilder(DeleteDataAssetRequest::builder).basePath("/20210101").appendPathParam("dataAssets").appendPathParam(request.getDataAssetId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteDataAssetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteModelResponse> deleteModel(DeleteModelRequest request, AsyncHandler<DeleteModelRequest, DeleteModelResponse> handler) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteModelResponse::builder).logger(LOG, "deleteModel").serviceDetails("AnomalyDetection", "DeleteModel", "").method(Method.DELETE).requestBuilder(DeleteModelRequest::builder).basePath("/20210101").appendPathParam("models").appendPathParam(request.getModelId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteModelResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteModelResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteProjectResponse> deleteProject(DeleteProjectRequest request, AsyncHandler<DeleteProjectRequest, DeleteProjectResponse> handler) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteProjectResponse::builder).logger(LOG, "deleteProject").serviceDetails("AnomalyDetection", "DeleteProject", "").method(Method.DELETE).requestBuilder(DeleteProjectRequest::builder).basePath("/20210101").appendPathParam("projects").appendPathParam(request.getProjectId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteProjectResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteProjectResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DetectAnomaliesResponse> detectAnomalies(DetectAnomaliesRequest request, AsyncHandler<DetectAnomaliesRequest, DetectAnomaliesResponse> handler) {
        Objects.requireNonNull(request.getDetectAnomaliesDetails(), "detectAnomaliesDetails is required");
        return this.clientCall(request, DetectAnomaliesResponse::builder).logger(LOG, "detectAnomalies").serviceDetails("AnomalyDetection", "DetectAnomalies", "").method(Method.POST).requestBuilder(DetectAnomaliesRequest::builder).basePath("/20210101").appendPathParam("actions").appendPathParam("detectAnomalies").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(AnomalyDetectResult.class, DetectAnomaliesResponse.Builder::anomalyDetectResult).handleResponseHeaderString("opc-request-id", DetectAnomaliesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetAiPrivateEndpointResponse> getAiPrivateEndpoint(GetAiPrivateEndpointRequest request, AsyncHandler<GetAiPrivateEndpointRequest, GetAiPrivateEndpointResponse> handler) {
        Validate.notBlank((String)request.getAiPrivateEndpointId(), (String)"aiPrivateEndpointId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetAiPrivateEndpointResponse::builder).logger(LOG, "getAiPrivateEndpoint").serviceDetails("AnomalyDetection", "GetAiPrivateEndpoint", "").method(Method.GET).requestBuilder(GetAiPrivateEndpointRequest::builder).basePath("/20210101").appendPathParam("aiPrivateEndpoints").appendPathParam(request.getAiPrivateEndpointId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AiPrivateEndpoint.class, GetAiPrivateEndpointResponse.Builder::aiPrivateEndpoint).handleResponseHeaderString("opc-request-id", GetAiPrivateEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetAiPrivateEndpointResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetDataAssetResponse> getDataAsset(GetDataAssetRequest request, AsyncHandler<GetDataAssetRequest, GetDataAssetResponse> handler) {
        Validate.notBlank((String)request.getDataAssetId(), (String)"dataAssetId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDataAssetResponse::builder).logger(LOG, "getDataAsset").serviceDetails("AnomalyDetection", "GetDataAsset", "").method(Method.GET).requestBuilder(GetDataAssetRequest::builder).basePath("/20210101").appendPathParam("dataAssets").appendPathParam(request.getDataAssetId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DataAsset.class, GetDataAssetResponse.Builder::dataAsset).handleResponseHeaderString("etag", GetDataAssetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDataAssetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetModelResponse> getModel(GetModelRequest request, AsyncHandler<GetModelRequest, GetModelResponse> handler) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetModelResponse::builder).logger(LOG, "getModel").serviceDetails("AnomalyDetection", "GetModel", "").method(Method.GET).requestBuilder(GetModelRequest::builder).basePath("/20210101").appendPathParam("models").appendPathParam(request.getModelId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Model.class, GetModelResponse.Builder::model).handleResponseHeaderString("etag", GetModelResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetModelResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetProjectResponse> getProject(GetProjectRequest request, AsyncHandler<GetProjectRequest, GetProjectResponse> handler) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetProjectResponse::builder).logger(LOG, "getProject").serviceDetails("AnomalyDetection", "GetProject", "").method(Method.GET).requestBuilder(GetProjectRequest::builder).basePath("/20210101").appendPathParam("projects").appendPathParam(request.getProjectId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Project.class, GetProjectResponse.Builder::project).handleResponseHeaderString("etag", GetProjectResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetProjectResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("AnomalyDetection", "GetWorkRequest", "").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20210101").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ListAiPrivateEndpointsResponse> listAiPrivateEndpoints(ListAiPrivateEndpointsRequest request, AsyncHandler<ListAiPrivateEndpointsRequest, ListAiPrivateEndpointsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListAiPrivateEndpointsResponse::builder).logger(LOG, "listAiPrivateEndpoints").serviceDetails("AnomalyDetection", "ListAiPrivateEndpoints", "").method(Method.GET).requestBuilder(ListAiPrivateEndpointsRequest::builder).basePath("/20210101").appendPathParam("aiPrivateEndpoints").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AiPrivateEndpointCollection.class, ListAiPrivateEndpointsResponse.Builder::aiPrivateEndpointCollection).handleResponseHeaderString("opc-request-id", ListAiPrivateEndpointsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAiPrivateEndpointsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListDataAssetsResponse> listDataAssets(ListDataAssetsRequest request, AsyncHandler<ListDataAssetsRequest, ListDataAssetsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListDataAssetsResponse::builder).logger(LOG, "listDataAssets").serviceDetails("AnomalyDetection", "ListDataAssets", "").method(Method.GET).requestBuilder(ListDataAssetsRequest::builder).basePath("/20210101").appendPathParam("dataAssets").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("projectId", (Object)request.getProjectId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DataAssetCollection.class, ListDataAssetsResponse.Builder::dataAssetCollection).handleResponseHeaderString("opc-request-id", ListDataAssetsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDataAssetsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListModelsResponse> listModels(ListModelsRequest request, AsyncHandler<ListModelsRequest, ListModelsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListModelsResponse::builder).logger(LOG, "listModels").serviceDetails("AnomalyDetection", "ListModels", "").method(Method.GET).requestBuilder(ListModelsRequest::builder).basePath("/20210101").appendPathParam("models").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("projectId", (Object)request.getProjectId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ModelCollection.class, ListModelsResponse.Builder::modelCollection).handleResponseHeaderString("opc-request-id", ListModelsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListModelsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListProjectsResponse> listProjects(ListProjectsRequest request, AsyncHandler<ListProjectsRequest, ListProjectsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListProjectsResponse::builder).logger(LOG, "listProjects").serviceDetails("AnomalyDetection", "ListProjects", "").method(Method.GET).requestBuilder(ListProjectsRequest::builder).basePath("/20210101").appendPathParam("projects").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ProjectCollection.class, ListProjectsResponse.Builder::projectCollection).handleResponseHeaderString("opc-request-id", ListProjectsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListProjectsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("AnomalyDetection", "ListWorkRequestErrors", "").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20210101").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("AnomalyDetection", "ListWorkRequestLogs", "").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20210101").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("AnomalyDetection", "ListWorkRequests", "").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20210101").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<UpdateAiPrivateEndpointResponse> updateAiPrivateEndpoint(UpdateAiPrivateEndpointRequest request, AsyncHandler<UpdateAiPrivateEndpointRequest, UpdateAiPrivateEndpointResponse> handler) {
        Validate.notBlank((String)request.getAiPrivateEndpointId(), (String)"aiPrivateEndpointId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateAiPrivateEndpointDetails(), "updateAiPrivateEndpointDetails is required");
        return this.clientCall(request, UpdateAiPrivateEndpointResponse::builder).logger(LOG, "updateAiPrivateEndpoint").serviceDetails("AnomalyDetection", "UpdateAiPrivateEndpoint", "").method(Method.PUT).requestBuilder(UpdateAiPrivateEndpointRequest::builder).basePath("/20210101").appendPathParam("aiPrivateEndpoints").appendPathParam(request.getAiPrivateEndpointId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", UpdateAiPrivateEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateAiPrivateEndpointResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateDataAssetResponse> updateDataAsset(UpdateDataAssetRequest request, AsyncHandler<UpdateDataAssetRequest, UpdateDataAssetResponse> handler) {
        Validate.notBlank((String)request.getDataAssetId(), (String)"dataAssetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDataAssetDetails(), "updateDataAssetDetails is required");
        return this.clientCall(request, UpdateDataAssetResponse::builder).logger(LOG, "updateDataAsset").serviceDetails("AnomalyDetection", "UpdateDataAsset", "").method(Method.PUT).requestBuilder(UpdateDataAssetRequest::builder).basePath("/20210101").appendPathParam("dataAssets").appendPathParam(request.getDataAssetId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DataAsset.class, UpdateDataAssetResponse.Builder::dataAsset).handleResponseHeaderString("etag", UpdateDataAssetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateDataAssetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateModelResponse> updateModel(UpdateModelRequest request, AsyncHandler<UpdateModelRequest, UpdateModelResponse> handler) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateModelDetails(), "updateModelDetails is required");
        return this.clientCall(request, UpdateModelResponse::builder).logger(LOG, "updateModel").serviceDetails("AnomalyDetection", "UpdateModel", "").method(Method.PUT).requestBuilder(UpdateModelRequest::builder).basePath("/20210101").appendPathParam("models").appendPathParam(request.getModelId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateModelResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateModelResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateProjectResponse> updateProject(UpdateProjectRequest request, AsyncHandler<UpdateProjectRequest, UpdateProjectResponse> handler) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateProjectDetails(), "updateProjectDetails is required");
        return this.clientCall(request, UpdateProjectResponse::builder).logger(LOG, "updateProject").serviceDetails("AnomalyDetection", "UpdateProject", "").method(Method.PUT).requestBuilder(UpdateProjectRequest::builder).basePath("/20210101").appendPathParam("projects").appendPathParam(request.getProjectId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Project.class, UpdateProjectResponse.Builder::project).handleResponseHeaderString("etag", UpdateProjectResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateProjectResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public AnomalyDetectionAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)AnomalyDetectionAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AnomalyDetectionAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(AnomalyDetectionAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AnomalyDetectionAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)AnomalyDetectionAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AnomalyDetectionAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)AnomalyDetectionAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public AnomalyDetectionAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)AnomalyDetectionAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public AnomalyDetectionAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)AnomalyDetectionAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public AnomalyDetectionAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)AnomalyDetectionAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, AnomalyDetectionAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public AnomalyDetectionAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new AnomalyDetectionAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

