/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import java.util.List;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xpath.XPathConvertAsExpr;
import oracle.xml.xpath.XPathFunctionContext;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import org.w3c.dom.NodeList;

public class XPathFunctionImpl
implements XPathFunction {
    XPathFunctionContext context;
    OXMLFunction function;
    int nargs;
    XPathConvertAsExpr[] argCvts;

    public XPathFunctionImpl(OXMLFunction oXMLFunction, int n) {
        this.function = oXMLFunction;
        this.nargs = n;
        this.argCvts = new XPathConvertAsExpr[this.nargs];
        for (int i = 0; i < this.nargs; ++i) {
            OXMLSequenceType oXMLSequenceType = oXMLFunction.getArgType(i);
            this.argCvts[i] = new XPathConvertAsExpr(oXMLSequenceType);
        }
        this.context = new XPathFunctionContext();
    }

    public Object evaluate(List list) throws XPathFunctionException {
        XPathSequence xPathSequence = null;
        try {
            Object object;
            OXMLSequence[] oXMLSequenceArray = new XPathSequence[this.nargs];
            for (int i = 0; i < this.nargs; ++i) {
                object = (XPathSequence)this.context.createSequence();
                oXMLSequenceArray[i] = object;
                Object e = list.get(i);
                OXMLItem oXMLItem = this.context.createItem();
                if (e instanceof XMLNode) {
                    oXMLItem.setNode((XMLNode)e);
                    ((XPathSequence)object).appendItem(oXMLItem);
                } else if (e instanceof Boolean) {
                    oXMLItem.setBoolean(OXMLSequenceType.TBOOLEAN, (Boolean)e);
                    ((XPathSequence)object).appendItem(oXMLItem);
                } else if (e instanceof Double) {
                    oXMLItem.setDouble(OXMLSequenceType.TDOUBLE, (Double)e);
                    ((XPathSequence)object).appendItem(oXMLItem);
                } else if (e instanceof String) {
                    oXMLItem.setString(OXMLSequenceType.TSTRING, (String)e);
                    ((XPathSequence)object).appendItem(oXMLItem);
                } else if (e instanceof NodeList) {
                    NodeList nodeList = (NodeList)e;
                    for (int j = 0; j < nodeList.getLength(); ++j) {
                        oXMLItem.setNode((XMLNode)nodeList.item(j));
                        ((XPathSequence)object).appendItem(oXMLItem);
                        oXMLItem = this.context.createItem();
                    }
                }
                this.argCvts[i].convert((XPathSequence)object);
            }
            xPathSequence = (XPathSequence)this.function.invoke((OXMLFunctionContext)this.context, oXMLSequenceArray);
            OXMLSequenceType oXMLSequenceType = this.function.getReturnType();
            if (oXMLSequenceType.isNode()) {
                object = xPathSequence.getNodeList();
                if (object.getLength() == 1) {
                    return object.item(0);
                }
                return object;
            }
            int n = oXMLSequenceType.getPrimitiveId();
            switch (n) {
                case 2: {
                    return new Boolean(xPathSequence.getBooleanValue());
                }
                case 3: 
                case 4: 
                case 5: 
                case 22: {
                    return new Double(xPathSequence.getNumberValue());
                }
            }
            return xPathSequence.getStringValue();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            throw new XPathFunctionException(exception.getMessage());
        }
    }
}

