/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xti;

import oracle.xml.xti.XTIConstants;
import oracle.xml.xti.XTIException;
import oracle.xml.xti.XTIUtil;

public class XTIDecompressor
implements XTIConstants {
    static byte[] uncompressXTINPage(byte[] byArray, int n) throws XTIException {
        byte[] byArray2 = new byte[8192];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = true;
        if (n == 0) {
            XTIDecompressor.decompressRootPage(byArray, byArray2);
            return byArray2;
        }
        while (n2 < 4096 && bl) {
            n3 = byArray[n2] & 0xF;
            switch (n3) {
                case 2: {
                    n2 = XTIDecompressor.decompressAttributeNode(byArray, byArray2, n2, n4, n);
                    break;
                }
                case 3: 
                case 4: 
                case 8: {
                    n2 = XTIDecompressor.decompressTextNode(byArray, byArray2, n2, n4, n);
                    break;
                }
                case 9: 
                case 11: {
                    n2 = XTIDecompressor.decompressDocumentFragment(byArray, byArray2, n2, n4, n);
                    break;
                }
                case 1: {
                    n2 = XTIDecompressor.decompressElementNode(byArray, byArray2, n2, n4, n);
                    break;
                }
                case 7: {
                    n2 = XTIDecompressor.decompressPINode(byArray, byArray2, n2, n4, n);
                    break;
                }
                default: {
                    bl = false;
                }
            }
            ++n4;
        }
        return byArray2;
    }

    static void decompressRootPage(byte[] byArray, byte[] byArray2) {
        System.arraycopy(byArray, 0, byArray2, 0, 4096);
    }

    static int decompressDocumentFragment(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        if (byArray[n] == 0) {
            return ++n;
        }
        int n4 = 32 * n2;
        byArray2[n4 + 0] = byArray[n++];
        byte by = byArray[n++];
        n += XTIDecompressor.writeXTINAddress(byArray, byArray2, n, n2, 12, (byte)(by & 3), n3);
        return n;
    }

    static int decompressAttributeNode(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        if (byArray[n] == 0) {
            return ++n;
        }
        int n4 = 32 * n2;
        byArray2[n4 + 0] = byArray[n++];
        byte by = byArray[n++];
        byte by2 = byArray[n++];
        n += XTIDecompressor.writeXTICAddress(byArray, byArray2, n, n4, (byte)((by & 0xF0) >> 4));
        n += XTIDecompressor.writeXTICTextAddress(byArray, byArray2, n, n4 + 12, (byte)((by & 0xC) >> 2));
        n += XTIDecompressor.writeXTINAddress(byArray, byArray2, n, n2, 20, (byte)(by & 3), n3);
        n += XTIDecompressor.writeXTINAddress(byArray, byArray2, n, n2, 24, (byte)((by2 & 0x18) >> 3), n3);
        byArray2[n4 + 28] = (byte)(by2 & 3);
        return n;
    }

    static int decompressElementNode(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        if (byArray[n] == 0) {
            return ++n;
        }
        int n4 = 32 * n2;
        byArray2[n4 + 0] = byArray[n++];
        byte by = byArray[n++];
        byte by2 = byArray[n++];
        n += XTIDecompressor.writeXTICAddress(byArray, byArray2, n, n4, (byte)((by & 0x38) >> 3));
        n += XTIDecompressor.writeXTINAddress(byArray, byArray2, n, n2, 12, (byte)(by & 3), n3);
        n += XTIDecompressor.writeXTINAddress(byArray, byArray2, n, n2, 16, (byte)((by2 & 0xC0) >> 6), n3);
        n += XTIDecompressor.writeXTINAddress(byArray, byArray2, n, n2, 20, (byte)((by2 & 0x30) >> 4), n3);
        n += XTIDecompressor.writeXTINAddress(byArray, byArray2, n, n2, 24, (byte)((by2 & 0xC) >> 2), n3);
        n += XTIDecompressor.writeXTINAddress(byArray, byArray2, n, n2, 28, (byte)(by2 & 3), n3);
        return n;
    }

    static int decompressPINode(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        if (byArray[n] == 0) {
            return ++n;
        }
        int n4 = 32 * n2;
        byArray2[n4 + 0] = byArray[n++];
        byte by = byArray[n++];
        byte by2 = byArray[n++];
        n += XTIDecompressor.writeXTICAddress(byArray, byArray2, n, n4, by);
        n += XTIDecompressor.writeXTINAddress(byArray, byArray2, n, n2, 16, (byte)((by2 & 0x30) >> 4), n3);
        n += XTIDecompressor.writeXTINAddress(byArray, byArray2, n, n2, 20, (byte)((by2 & 0xC) >> 2), n3);
        n += XTIDecompressor.writeXTINAddress(byArray, byArray2, n, n2, 24, (byte)(by2 & 3), n3);
        return n;
    }

    static int decompressTextNode(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        if (byArray[n] == 0) {
            return ++n;
        }
        int n4 = 32 * n2;
        byArray2[n4 + 0] = byArray[n++];
        byte by = byArray[n++];
        n += XTIDecompressor.writeXTICTextAddress(byArray, byArray2, n, n4 + 4, (byte)((by & 0xC0) >> 6));
        n += XTIDecompressor.writeXTINAddress(byArray, byArray2, n, n2, 16, (byte)((by & 0x30) >> 4), n3);
        n += XTIDecompressor.writeXTINAddress(byArray, byArray2, n, n2, 20, (byte)((by & 0xC) >> 2), n3);
        n += XTIDecompressor.writeXTINAddress(byArray, byArray2, n, n2, 24, (byte)(by & 3), n3);
        return n;
    }

    static int writeXTINAddress(byte[] byArray, byte[] byArray2, int n, int n2, int n3, byte by, int n4) {
        n2 *= 32;
        if (by == 0) {
            return 0;
        }
        if (by == 1) {
            int n5 = XTIUtil.byteArrayToShort(byArray, n);
            n += 2;
            int n6 = 0 | n4 << 8 | n5;
            byte[] byArray3 = XTIUtil.intToByteArray(n6);
            for (int i = 0; i < 4; ++i) {
                byArray2[n2 + n3 + i] = byArray3[i];
            }
            return 2;
        }
        if (by == 2) {
            byte by2 = byArray[n++];
            byte by3 = byArray[n++];
            int n7 = 0;
            n7 = by2 == 0 ? n4 : n4 - (by2 + 1);
            int n8 = 0 | n7 << 8 | by3;
            byte[] byArray4 = XTIUtil.intToByteArray(n8);
            for (int i = 0; i < 4; ++i) {
                byArray2[n2 + n3 + i] = byArray4[i];
            }
            return 4;
        }
        if (by == 3) {
            byArray2[n2 + n3++] = byArray[n++];
            byArray2[n2 + n3++] = byArray[n++];
            byArray2[n2 + n3++] = byArray[n++];
            byArray2[n2 + n3] = byArray[n];
            return 4;
        }
        return 0;
    }

    static int writeXTICAddress(byte[] byArray, byte[] byArray2, int n, int n2, byte by) {
        if (by == 6) {
            byArray2[4 + n2] = byArray[n++];
            byArray2[5 + n2] = byArray[n++];
            byArray2[6 + n2] = byArray[n++];
            byArray2[7 + n2] = byArray[n++];
            byArray2[8 + n2] = byArray[n++];
            byArray2[9 + n2] = byArray[n++];
            byArray2[10 + n2] = byArray[n++];
            byArray2[11 + n2] = byArray[n];
            return 8;
        }
        if (by == 5) {
            byArray2[4 + n2] = byArray[n++];
            byArray2[5 + n2] = byArray[n++];
            byArray2[6 + n2] = byArray[n++];
            byArray2[7 + n2] = byArray[n++];
            byArray2[10 + n2] = byArray[n++];
            byArray2[11 + n2] = byArray[n];
            return 6;
        }
        if (by == 4) {
            byArray2[6 + n2] = byArray[n++];
            byArray2[7 + n2] = byArray[n++];
            byArray2[8 + n2] = byArray[n++];
            byArray2[9 + n2] = byArray[n++];
            byArray2[10 + n2] = byArray[n++];
            byArray2[11 + n2] = byArray[n];
            return 6;
        }
        if (by == 3) {
            byArray2[6 + n2] = byArray[n++];
            byArray2[7 + n2] = byArray[n++];
            byArray2[10 + n2] = byArray[n++];
            byArray2[11 + n2] = byArray[n];
            return 4;
        }
        if (by == 2) {
            byArray2[8 + n2] = byArray[n++];
            byArray2[9 + n2] = byArray[n++];
            byArray2[10 + n2] = byArray[n++];
            byArray2[11 + n2] = byArray[n];
            return 4;
        }
        if (by == 1) {
            byArray2[10 + n2] = byArray[n++];
            byArray2[11 + n2] = byArray[n];
            return 2;
        }
        return -1;
    }

    static int writeXTICTextAddress(byte[] byArray, byte[] byArray2, int n, int n2, byte by) {
        if (by == 3) {
            byArray2[n2] = byArray[n++];
            byArray2[1 + n2] = byArray[n++];
            byArray2[2 + n2] = byArray[n++];
            byArray2[3 + n2] = byArray[n++];
            byArray2[4 + n2] = byArray[n++];
            byArray2[5 + n2] = byArray[n++];
            byArray2[6 + n2] = byArray[n++];
            byArray2[7 + n2] = byArray[n];
            return 8;
        }
        if (by == 2) {
            byArray2[n2] = byArray[n++];
            byArray2[1 + n2] = byArray[n++];
            byArray2[2 + n2] = byArray[n++];
            byArray2[3 + n2] = byArray[n++];
            byArray2[4 + n2] = byArray[n++];
            byArray2[5 + n2] = byArray[n];
            return 6;
        }
        if (by == 1) {
            byArray2[n2] = byArray[n++];
            byArray2[1 + n2] = byArray[n++];
            byArray2[2 + n2] = byArray[n++];
            byArray2[3 + n2] = byArray[n];
            return 4;
        }
        if (by == 0) {
            byArray2[n2] = byArray[n++];
            byArray2[1 + n2] = byArray[n];
            return 2;
        }
        return 0;
    }
}

