/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathVariableResolver;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.scalable.BinaryNav;
import oracle.xml.util.FastVector;
import oracle.xml.util.XMLUtil;
import oracle.xml.xpath.PathExpr;
import oracle.xml.xpath.XPathConstantExpr;
import oracle.xml.xpath.XPathContext;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XPathExtFunction;
import oracle.xml.xpath.XPathFunctionCall;
import oracle.xml.xpath.XPathPredicate;
import oracle.xml.xpath.XPathRuntimeContext;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XPathStep;
import oracle.xml.xpath.XPathVarReference;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xslt.XSLException;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JXPathExpression
implements XPathExpression {
    private String exprString;
    private XSLExprBase expression;
    private XPathVariableResolver varResolver;
    private boolean createNode;
    private boolean enableException;
    private XMLSchema schema;
    private boolean secure;
    private EntityResolver entResolver;
    private int depth = 0;

    JXPathExpression(XSLExprBase xSLExprBase, XPathVariableResolver xPathVariableResolver, String string) {
        this.exprString = string;
        this.expression = xSLExprBase;
        this.varResolver = xPathVariableResolver;
    }

    public String toString() {
        return this.exprString;
    }

    public boolean hasBackwardAxis() {
        return this.expression.backAxis;
    }

    void setXMLSchema(XMLSchema xMLSchema) {
        this.schema = xMLSchema;
    }

    boolean supportIndex() {
        return this.expression.supportIndex();
    }

    void setSecure(boolean bl) {
        this.secure = bl;
    }

    void setEntityResolver(EntityResolver entityResolver) {
        this.entResolver = entityResolver;
    }

    @Override
    public Object evaluate(Object object, QName qName) throws XPathExpressionException {
        if (qName == null) {
            throw new NullPointerException();
        }
        XPathRuntimeContext xPathRuntimeContext = null;
        XMLError xMLError = new XMLError();
        try {
            Object object2;
            xPathRuntimeContext = new XPathRuntimeContext();
            xPathRuntimeContext.init();
            xPathRuntimeContext.setXMLSchema(this.schema);
            if (this.varResolver != null) {
                xPathRuntimeContext.setVarResolver(this.varResolver);
            }
            XMLNode xMLNode = null;
            XPathContext xPathContext = null;
            if (object instanceof XMLNode) {
                xMLNode = (XMLNode)object;
            } else if (object instanceof XPathContext) {
                ((XPathContext)object).resetXPathError();
                xPathContext = (XPathContext)object;
                xMLNode = (XMLNode)xPathContext.getContextNode();
                if (xMLNode == null) {
                    xMLNode = new XMLDocument();
                }
                if ((object2 = xPathContext.getXPathVariableResolver()) != null) {
                    xPathRuntimeContext.setVarResolver((XPathVariableResolver)object2);
                }
            } else if (object instanceof Node) {
                xMLNode = XMLUtil.getXMLDocumentFromDoc((Node)object);
            } else if (object == null) {
                xMLNode = new XMLDocument();
            } else if (object instanceof BinaryNav) {
                if (!this.expression.supportIndex()) {
                    throw new UnsupportedOperationException("Expression does not support binary index");
                }
                object2 = (BinaryNav)object;
                xPathRuntimeContext.setBinaryNav((BinaryNav)object2);
                xPathRuntimeContext.setContextIndex(((BinaryNav)object2).getCurrentIndex());
            } else {
                throw new IllegalArgumentException();
            }
            if (xMLNode != null) {
                object2 = xMLNode.getSrcRoot();
                xPathRuntimeContext.addSourceContext((XMLElement)object2, xMLNode.getDocument());
                xPathRuntimeContext.setContextNode(xMLNode);
            }
            xPathRuntimeContext.setContextSize(1);
            xPathRuntimeContext.setContextPosition(1);
            xPathRuntimeContext.setXPathContext(xPathContext);
            xPathRuntimeContext.setCreateNode(this.createNode);
            xPathRuntimeContext.setEnableException(this.enableException);
            try {
                if (xPathRuntimeContext.getCtxForm() == 0 && this.expression.isStreamable()) {
                    this.expression.streamingEvaluate(xPathRuntimeContext);
                } else {
                    this.expression.evaluate(xPathRuntimeContext);
                }
                object2 = (XPathSequence)xPathRuntimeContext.peekExprValue();
                if (qName.equals(XPathConstants.NODESET)) {
                    return ((XPathSequence)object2).getNodeList();
                }
                if (qName.equals(XPathConstants.NODE)) {
                    if (((XPathSequence)object2).next()) {
                        return XPathSequence.nextNode((OXMLSequence)object2);
                    }
                    return null;
                }
                if (qName.equals(XPathConstants.STRING)) {
                    return ((XPathSequence)object2).getStringValue();
                }
                if (qName.equals(XPathConstants.BOOLEAN)) {
                    return new Boolean(((XPathSequence)object2).getBooleanValue());
                }
                if (qName.equals(XPathConstants.NUMBER)) {
                    return new Double(((XPathSequence)object2).getNumberValue());
                }
                if (qName.equals(XPathContext.OBJECT)) {
                    return ((XPathSequence)object2).getObjectValue();
                }
                if (qName.equals(XPathContext.SEQUENCE)) {
                    return object2;
                }
                throw new IllegalArgumentException();
            }
            catch (XQException xQException) {
                Throwable throwable = xQException.getCause();
                if (throwable != null && throwable instanceof XSLException && throwable.getMessage().equals("TERMINATE PROCESSING")) {
                    throw (XSLException)throwable;
                }
                String string = null;
                String string2 = XMLError.getXPathErrorID(xQException.getErrorCode());
                if (string2 != null) {
                    string = xMLError.getMessage0(Integer.parseInt(string2));
                } else if (throwable != null && throwable instanceof Exception) {
                    string = throwable.getMessage();
                }
                if (string == null) {
                    string = xMLError.getMessage0(23002);
                }
                XPathExpressionException xPathExpressionException = new XPathExpressionException(string);
                if (throwable != null) {
                    xPathExpressionException.initCause(throwable);
                }
                throw xPathExpressionException;
            }
        }
        catch (XSLException xSLException) {
            XPathExpressionException xPathExpressionException = new XPathExpressionException(xSLException.getMessage());
            xPathExpressionException.initCause(xSLException);
            throw xPathExpressionException;
        }
    }

    @Override
    public String evaluate(Object object) throws XPathExpressionException {
        return (String)this.evaluate(object, XPathConstants.STRING);
    }

    @Override
    public Object evaluate(InputSource inputSource, QName qName) throws XPathExpressionException {
        DOMParser dOMParser = new DOMParser();
        dOMParser.setPreserveWhitespace(true);
        dOMParser.setValidationMode(0);
        if (this.secure) {
            dOMParser.setSecureProcessing();
        }
        if (this.entResolver != null) {
            dOMParser.setEntityResolver(this.entResolver);
        }
        try {
            dOMParser.parse(inputSource);
        }
        catch (IOException iOException) {
            XPathExpressionException xPathExpressionException = new XPathExpressionException(iOException.getMessage());
            xPathExpressionException.initCause(iOException);
            throw xPathExpressionException;
        }
        catch (SAXException sAXException) {
            XPathExpressionException xPathExpressionException = new XPathExpressionException(sAXException.getMessage());
            xPathExpressionException.initCause(sAXException);
            throw xPathExpressionException;
        }
        XMLDocument xMLDocument = dOMParser.getDocument();
        return this.evaluate(xMLDocument, qName);
    }

    @Override
    public String evaluate(InputSource inputSource) throws XPathExpressionException {
        return (String)this.evaluate(inputSource, XPathConstants.STRING);
    }

    public void setCreateNode(boolean bl) {
        this.createNode = bl;
    }

    public boolean getCreateNode() {
        return this.createNode;
    }

    void setEnableException(boolean bl) {
        this.enableException = bl;
    }

    boolean getEnableException() {
        return this.enableException;
    }

    boolean validateXPathExpression() throws XPathException {
        int n = this.expression.getStepList().size();
        for (int i = 0; i < n; ++i) {
            XPathStep xPathStep = (XPathStep)this.expression.getStepList().get(i);
            if (xPathStep.axisClass.axisType != 3) {
                throw new XPathException(1013, this.exprString);
            }
            if (xPathStep.prevSeparator == 6) {
                throw new XPathException(1013, this.exprString);
            }
            if (xPathStep.predicates == null) continue;
            XPathPredicate xPathPredicate = xPathStep.predicates;
            for (int j = 0; j < xPathPredicate.predicates.size(); ++j) {
                if (xPathPredicate.predicates.elementAt(j) instanceof XPathConstantExpr) continue;
                throw new XPathException(1013, this.exprString);
            }
        }
        return true;
    }

    boolean validateCreateXPathExpression(XSLExprBase xSLExprBase) throws XPathException {
        if (xSLExprBase == null) {
            return true;
        }
        if (xSLExprBase instanceof XPathConstantExpr || xSLExprBase instanceof XPathVarReference) {
            return true;
        }
        int n = xSLExprBase.getStepList().size();
        for (int i = 0; i < n; ++i) {
            XPathStep xPathStep = (XPathStep)xSLExprBase.getStepList().get(i);
            if (xPathStep.axisClass.axisType != 3 && xPathStep.axisClass.axisType != 2 && xPathStep.axisClass.axisType != 8) {
                throw new XPathException(1013, this.exprString);
            }
            if (xPathStep.prevSeparator == 6) {
                throw new XPathException(1013, this.exprString);
            }
            if (xPathStep.predicates != null) {
                XPathPredicate xPathPredicate = xPathStep.predicates;
                for (int j = 0; j < xPathPredicate.predicates.size(); ++j) {
                    int n2;
                    FastVector fastVector;
                    XSLExprBase xSLExprBase2;
                    if (xPathPredicate.predicates.elementAt(j) instanceof PathExpr) {
                        this.validateCreateXPathExpression(xSLExprBase);
                        continue;
                    }
                    if (xPathPredicate.predicates.elementAt(j) instanceof XPathExtFunction) {
                        xSLExprBase2 = (XPathExtFunction)xPathPredicate.predicates.elementAt(j);
                        fastVector = xSLExprBase2.exprVector;
                        for (n2 = 0; fastVector != null && n2 < fastVector.size(); ++n2) {
                            this.validateCreateXPathExpression((XSLExprBase)fastVector.elementAt(n2));
                        }
                        continue;
                    }
                    if (xPathPredicate.predicates.elementAt(j) instanceof XPathFunctionCall) {
                        xSLExprBase2 = (XPathFunctionCall)xPathPredicate.predicates.elementAt(j);
                        fastVector = ((XPathFunctionCall)xSLExprBase2).exprVector;
                        for (n2 = 0; fastVector != null && n2 < fastVector.size(); ++n2) {
                            this.validateCreateXPathExpression((XSLExprBase)fastVector.elementAt(n2));
                        }
                        this.validateCreateXPathExpression(((XPathFunctionCall)xSLExprBase2).expr1);
                        this.validateCreateXPathExpression(((XPathFunctionCall)xSLExprBase2).expr2);
                        this.validateCreateXPathExpression(((XPathFunctionCall)xSLExprBase2).expr3);
                        continue;
                    }
                    if (xPathPredicate.predicates.elementAt(j) instanceof XPathConstantExpr || xPathPredicate.predicates.elementAt(j) instanceof XPathVarReference) continue;
                    throw new XPathException(1013, this.exprString);
                }
                continue;
            }
            if (xPathStep.axisClass.axisType == 3) {
                ++this.depth;
                continue;
            }
            if (xPathStep.axisClass.axisType != 8) continue;
            --this.depth;
            if (this.depth > 0) continue;
            throw new XPathException(1013, this.exprString);
        }
        return true;
    }
}

