/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jaxp;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import oracle.xml.fdom.FDOMDocumentBuilder;
import oracle.xml.jaxp.JXTransformerHandler;
import oracle.xml.jaxp.JXUtil;
import oracle.xml.jaxp.JXXMLFilter;
import oracle.xml.parser.v2.DOMLocator;
import oracle.xml.parser.v2.DocumentBuilder;
import oracle.xml.parser.v2.SAXParser;
import oracle.xml.parser.v2.XMLConstants;
import oracle.xml.parser.v2.XMLContentHandler;
import oracle.xml.parser.v2.XMLDOMException;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLDocumentFragment;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLParser;
import oracle.xml.parser.v2.XSLStylesheet;
import oracle.xml.util.XMLError;
import oracle.xml.util.XMLUtil;
import oracle.xml.xslt.XSLDocumentBuilder;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLOutput;
import oracle.xml.xslt.XSLProcessor;
import oracle.xml.xslt.XSLSAXPrintDriver;
import oracle.xml.xslt.XSLTDebuggerTraceEventsListener;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class JXTransformer
extends Transformer
implements XMLConstants {
    private oracle.xml.xslt.XSLStylesheet m_templates;
    private XSLOutput m_output;
    private Properties m_transXSLT;
    private Properties m_transProps;
    private URIResolver m_uriResolver;
    private ErrorListener m_errorListener;
    private final XMLError m_err = new XMLError();
    private final XSLProcessor m_processor = new XSLProcessor();
    private Connection m_domConn;
    private String m_domKind;
    private String compVersion = JDKVERSION;
    private boolean m_doe_pi = false;
    private Boolean secure = Boolean.FALSE;
    private static final Set<String> outputKeys = new HashSet<String>(20);
    private static final String JDKVERSION;
    private static oracle.xml.xslt.XSLStylesheet IDENXSL;
    private static oracle.xml.xslt.XSLStylesheet IDENXSLROOT;

    public JXTransformer() {
        this(IDENXSL);
    }

    public JXTransformer(XSLStylesheet xSLStylesheet) {
        this(xSLStylesheet.xss);
    }

    public JXTransformer(oracle.xml.xslt.XSLStylesheet xSLStylesheet) {
        try {
            this.m_output = new XSLOutput(xSLStylesheet);
            this.m_output.setPrefixHash(xSLStylesheet.getXSLOutput().getPrefixHash());
            this.m_templates = xSLStylesheet;
            this.m_transXSLT = xSLStylesheet.getXSLOutput().getDefaultProps();
            this.m_transProps = xSLStylesheet.getOutputProperties();
        }
        catch (XSLException xSLException) {
            try {
                this.reportException(xSLException, 0, 1900, null);
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
        }
    }

    public void setXSLTDebugListener(XSLTDebuggerTraceEventsListener xSLTDebuggerTraceEventsListener, XMLContentHandler xMLContentHandler) {
        this.m_processor.setXSLTDebugListener(xSLTDebuggerTraceEventsListener, xMLContentHandler);
    }

    public void setGenerate_Output_Escaping_PIs(boolean bl) {
        this.m_doe_pi = bl;
    }

    void setCompVersion(String string) {
        if (string != null) {
            this.compVersion = string;
        }
    }

    public void setSecure(Boolean bl) {
        this.secure = bl;
        this.m_processor.setAttribute("http://javax.xml.XMLConstants/feature/secure-processing", bl);
    }

    @Override
    public void transform(Source source, Result result) throws TransformerException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        XMLElement xMLElement = null;
        Object object5 = null;
        Properties properties = this.m_output.getProps();
        if (this.m_uriResolver != null) {
            this.m_processor.setURIResolver(this.m_uriResolver);
        }
        if (source instanceof DOMSource) {
            object4 = ((DOMSource)source).getNode();
            if (object4 instanceof XMLElement) {
                xMLElement = (XMLElement)object4;
            } else if (object4 instanceof XMLNode) {
                object5 = object4;
            } else if (object4 != null) {
                xMLElement = XMLUtil.getXMLDocumentFromDoc((Node)object4);
            }
        } else {
            object4 = SAXSource.sourceToInputSource(source);
            XMLReader xMLReader = null;
            object3 = null;
            if (source instanceof SAXSource && (xMLReader = ((SAXSource)source).getXMLReader()) instanceof JXXMLFilter) {
                properties = ((JXXMLFilter)xMLReader).getTransHandler().getTransformer().getOutputProperties();
            }
            if (xMLReader == null) {
                xMLReader = new SAXParser();
            }
            if (xMLReader instanceof SAXParser) {
                if (this.secure != null && this.secure.booleanValue()) {
                    ((SAXParser)xMLReader).setSecureProcessing();
                }
                if ((object2 = source.getSystemId()) != null) {
                    try {
                        ((SAXParser)xMLReader).setBaseURL(new URL((String)object2));
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.reportException(malformedURLException, 1, 1108, null);
                    }
                }
            }
            try {
                object3 = xMLReader instanceof JXXMLFilter ? new XSLDocumentBuilder() : new DocumentBuilder();
                if ("oracle.xml.parser.XMLDocument.THICK".equals(this.m_domKind)) {
                    ((DocumentBuilder)object3).setAttribute("oracle.xml.parser.XMLDocument.Connection", this.m_domConn);
                    ((DocumentBuilder)object3).setAttribute("oracle.xml.parser.XMLDocument.Kind", this.m_domKind);
                }
                xMLReader.setContentHandler((ContentHandler)object3);
                if (xMLReader instanceof SAXParser) {
                    ((SAXParser)xMLReader).setLexHandler((LexicalHandler)object3);
                }
                xMLReader.parse((InputSource)object4);
            }
            catch (Exception exception) {
                object = new DOMLocator(((DocumentBuilder)object3).getLocator());
                this.reportException(exception, 0, 1004, (SourceLocator)object);
            }
            xMLElement = xMLReader instanceof JXXMLFilter ? ((XSLDocumentBuilder)object3).getResultFragment() : ((DocumentBuilder)object3).getDocument();
        }
        boolean bl = false;
        if (result instanceof DOMResult) {
            object3 = ((DOMResult)result).getNode();
            if (object3 == null) {
                object3 = "oracle.xml.parser.XMLDocument.THICK".equals(this.m_domKind) ? new XMLDocument(this.m_domConn, null) : new XMLDocument();
                ((DOMResult)result).setNode((Node)object3);
                object4 = new XSLDocumentBuilder((XMLElement)object3);
                bl = true;
            } else if (object3 instanceof XMLElement) {
                object2 = object3.getNodeType() == 9 ? (XMLDocument)object3 : (XMLDocument)object3.getOwnerDocument();
                object = (XMLDocumentFragment)((XMLDocument)object2).createDocumentFragment();
                object4 = new XSLDocumentBuilder((XMLElement)object);
            } else if (object3.getNodeType() == 9 || object3.getNodeType() == 1 || object3.getNodeType() == 11) {
                object4 = new FDOMDocumentBuilder((Node)object3);
            } else {
                object4 = null;
                this.reportException(null, 0, 1103, null);
            }
        } else if (result instanceof SAXResult) {
            object4 = ((SAXResult)result).getHandler();
        } else {
            Object object6;
            object3 = (StreamResult)result;
            object2 = ((StreamResult)object3).getWriter();
            object = ((StreamResult)object3).getOutputStream();
            String string = ((StreamResult)object3).getSystemId();
            if (object == null && object2 == null) {
                if (string == null) {
                    this.reportException(null, 0, 1122, null);
                }
                try {
                    if (string.startsWith("file:/")) {
                        object6 = new URL(string);
                        string = ((URL)object6).getFile();
                    }
                    object = new FileOutputStream(string);
                }
                catch (IOException iOException) {
                    this.reportException(iOException, 0, 1110, null);
                }
            }
            if (this.m_transProps.size() == 0 && properties.size() > 0) {
                this.m_output.setProps(properties);
            } else {
                this.m_output.setProps(this.m_transProps);
            }
            if (object != null) {
                object4 = new XSLSAXPrintDriver((OutputStream)object, this.m_output);
            } else {
                object6 = object2 instanceof PrintWriter ? (PrintWriter)object2 : new PrintWriter((Writer)object2);
                object4 = new XSLSAXPrintDriver((PrintWriter)object6, this.m_output);
            }
        }
        try {
            if (this.m_templates == IDENXSL) {
                if (XMLUtil.reportDocEvents(object4, XMLParser.getReportedCHClasses())) {
                    object4.startDocument();
                }
                if (this.compVersion == "JDK_1.4") {
                    if (xMLElement instanceof XMLDocument) {
                        for (object3 = (XMLNode)xMLElement.getFirstChild(); object3 != null; object3 = (XMLNode)((XMLNode)object3).getNextSibling()) {
                            ((XMLNode)object3).reportSAXEvents((ContentHandler)object4);
                        }
                    } else if (xMLElement != null) {
                        xMLElement.reportSAXEvents((ContentHandler)object4);
                    } else if (object5 instanceof XMLNode) {
                        if (object4 instanceof XSLSAXPrintDriver) {
                            ((XSLSAXPrintDriver)object4).setPrintWS(true);
                        }
                        ((XMLNode)object5).reportSAXEvents((ContentHandler)object4);
                    }
                } else if (xMLElement != null) {
                    object3 = xMLElement.getParentNode();
                    if (object3 == null) {
                        this.m_templates = IDENXSLROOT;
                    }
                    this.m_processor.processXSL(this.m_templates, xMLElement, (ContentHandler)object4);
                } else if (object5 instanceof XMLNode) {
                    if (object4 instanceof XSLSAXPrintDriver) {
                        ((XSLSAXPrintDriver)object4).setPrintWS(true);
                    }
                    ((XMLNode)object5).reportSAXEvents((ContentHandler)object4);
                }
                if (XMLUtil.reportDocEvents(object4, XMLParser.getReportedCHClasses())) {
                    object4.endDocument();
                }
            } else if (xMLElement != null) {
                if (this.m_doe_pi) {
                    this.m_processor.setIsJAXP(true);
                }
                this.m_processor.processXSL(this.m_templates, xMLElement, (ContentHandler)object4);
            } else {
                this.reportException(null, 0, 1101, null);
            }
            if (object4 instanceof XSLSAXPrintDriver) {
                ((XSLSAXPrintDriver)object4).flush();
            }
            if (object4 instanceof JXTransformerHandler) {
                object4.endDocument();
            }
        }
        catch (XSLException xSLException) {
            this.reportXSLException(xSLException);
        }
        catch (XMLDOMException xMLDOMException) {
            this.reportException(xMLDOMException, 0, 0, null);
        }
        catch (Exception exception) {
            this.reportException(exception, 0, 1900, null);
        }
        if (result instanceof DOMResult && !bl) {
            object3 = ((DOMResult)result).getNode();
            object2 = ((DOMResult)result).getNextSibling();
            if (object3 instanceof XMLElement) {
                object = ((XSLDocumentBuilder)object4).getResultFragment();
                if (object2 == null) {
                    object3.appendChild((Node)object);
                } else {
                    object3.insertBefore((Node)object, (Node)object2);
                }
            }
        }
    }

    @Override
    public void setParameter(String string, Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        String string2 = JXUtil.getURI(string);
        String string3 = JXUtil.getLocalName(string);
        try {
            if (string2 == null) {
                this.reportException(null, 1, 1113, null);
                return;
            }
            if (string3 == null) {
                this.reportException(null, 1, 1112, null);
                return;
            }
            try {
                if (object instanceof String) {
                    object = new StringBuffer((String)object);
                }
                this.m_processor.setParam(string2, string3, object);
            }
            catch (XSLException xSLException) {
                this.reportException(xSLException, 0, 1900, null);
            }
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    @Override
    public Object getParameter(String string) {
        String string2 = JXUtil.getURI(string);
        String string3 = JXUtil.getLocalName(string);
        Object object = null;
        try {
            if (string2 == null) {
                this.reportException(null, 1, 1113, null);
                return null;
            }
            if (string3 == null) {
                this.reportException(null, 1, 1112, null);
                return null;
            }
            try {
                String string4;
                object = this.m_processor.getParam(string2, string3);
                if (object != null && object instanceof StringBuffer && (string4 = object.toString()) != null && string4.length() > 2) {
                    if (string4.startsWith("'") && string4.endsWith("'")) {
                        string4 = string4.substring(1, string4.length() - 1);
                    }
                    return string4;
                }
            }
            catch (XSLException xSLException) {
                this.reportException(xSLException, 0, 1900, null);
            }
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return object;
    }

    @Override
    public void clearParameters() {
        try {
            this.m_processor.resetParams();
        }
        catch (XSLException xSLException) {
            try {
                this.reportException(xSLException, 0, 1900, null);
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
        }
    }

    @Override
    public void setURIResolver(URIResolver uRIResolver) {
        this.m_uriResolver = uRIResolver;
    }

    @Override
    public URIResolver getURIResolver() {
        return this.m_uriResolver;
    }

    @Override
    public void setOutputProperties(Properties properties) {
        if (properties == null) {
            this.m_transProps.clear();
            return;
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = properties.get(string);
            if (object != null) {
                this.m_transProps.put(string, object);
            } else {
                this.m_transProps.remove(string);
            }
            if (!string.equals("method")) continue;
            if (object == null) {
                object = "xml";
            }
            JXUtil.setDefaultProps(this.m_transXSLT, (String)object);
        }
    }

    @Override
    public Properties getOutputProperties() {
        return (Properties)this.m_transProps.clone();
    }

    private void checkPropertyName(String string) {
        boolean bl;
        boolean bl2 = string.charAt(0) == '{';
        int n = string.indexOf(125);
        if (bl2 && n < 2 || !bl2 && n != -1 || bl2 && n + 1 >= string.length()) {
            String string2 = "property name: \"" + string + '\"';
            throw new IllegalArgumentException(string2);
        }
        boolean bl3 = bl = bl2 && n >= 2;
        if (!bl) {
            if (!outputKeys.contains(string)) {
                String string3 = "property name: \"" + string + '\"';
                throw new IllegalArgumentException(string3);
            }
        } else {
            String string4 = string.substring(n + 1);
            try {
                XMLUtil.validateName(string4);
            }
            catch (DOMException dOMException) {
                throw new IllegalArgumentException(dOMException);
            }
        }
    }

    @Override
    public void setOutputProperty(String string, String string2) {
        this.checkPropertyName(string);
        this.m_transProps.put(string, string2);
        if (string.equals("method")) {
            if (string2 == null) {
                string2 = "xml";
            }
            JXUtil.setDefaultProps(this.m_transXSLT, string2);
        }
    }

    @Override
    public String getOutputProperty(String string) {
        this.checkPropertyName(string);
        return this.m_transProps.getProperty(string);
    }

    @Override
    public void setErrorListener(ErrorListener errorListener) {
        this.m_errorListener = errorListener;
    }

    @Override
    public ErrorListener getErrorListener() {
        if (this.m_errorListener == null) {
            return new ErrorListener(){

                @Override
                public void warning(TransformerException transformerException) {
                }

                @Override
                public void error(TransformerException transformerException) {
                }

                @Override
                public void fatalError(TransformerException transformerException) {
                }
            };
        }
        return this.m_errorListener;
    }

    void setConnection(Connection connection) {
        this.m_domConn = connection;
    }

    void setDOMKind(String string) {
        this.m_domKind = string;
        if (string == null) {
            this.m_domKind = "oracle.xml.parser.XMLDocument.THIN";
        }
    }

    private void reportException(Exception exception, int n, int n2, SourceLocator sourceLocator) throws TransformerException {
        this.m_err.reset();
        if (exception == null) {
            this.m_err.error0(n2, n);
        } else if (exception.getMessage() == null) {
            this.m_err.error1(n2, n, "null");
        } else {
            this.m_err.error1(n2, n, exception.getMessage());
        }
        String string = this.m_err.formatErrorMesg(0);
        TransformerException transformerException = sourceLocator != null ? (exception != null ? new TransformerException(string, sourceLocator, exception) : new TransformerException(string, sourceLocator)) : (exception != null ? new TransformerException(string, exception) : new TransformerException(string));
        if (this.m_errorListener == null) {
            try {
                if (!XMLParser.getNoShowForInvalidURLError()) {
                    this.m_err.setErrorStream(System.err);
                }
                this.m_err.printErrorListener();
                if (n == 0) {
                    throw transformerException;
                }
            }
            catch (IOException iOException) {
                throw new TransformerException(iOException);
            }
            return;
        }
        switch (n) {
            case 0: {
                this.m_errorListener.fatalError(transformerException);
                throw transformerException;
            }
            case 1: {
                this.m_errorListener.error(transformerException);
                break;
            }
            case 2: {
                this.m_errorListener.warning(transformerException);
            }
        }
    }

    private void reportXSLException(XSLException xSLException) throws TransformerException {
        XMLError xMLError = xSLException.getXMLError();
        int n = xSLException.getMessageType(0);
        if (xMLError == null) {
            TransformerException transformerException = new TransformerException(xSLException.getMessage());
            throw transformerException;
        }
        DOMLocator dOMLocator = new DOMLocator(xMLError.getLocator());
        String string = xMLError.formatErrorMesg(0);
        TransformerException transformerException = new TransformerException(string, dOMLocator, xSLException);
        if (this.m_errorListener == null) {
            try {
                if (!XMLParser.getNoShowForInvalidURLError()) {
                    xMLError.setErrorStream(System.err);
                }
                xMLError.printErrorListener();
                if (n == 0) {
                    throw transformerException;
                }
            }
            catch (IOException iOException) {
                throw new TransformerException(iOException);
            }
            return;
        }
        switch (n) {
            case 0: {
                this.m_errorListener.fatalError(transformerException);
                throw transformerException;
            }
            case 1: {
                this.m_errorListener.error(transformerException);
                break;
            }
            case 2: {
                this.m_errorListener.warning(transformerException);
            }
        }
    }

    static {
        outputKeys.add("method");
        outputKeys.add("version");
        outputKeys.add("encoding");
        outputKeys.add("omit-xml-declaration");
        outputKeys.add("standalone");
        outputKeys.add("doctype-public");
        outputKeys.add("doctype-system");
        outputKeys.add("cdata-section-elements");
        outputKeys.add("indent");
        outputKeys.add("media-type");
        String string = XMLUtil.getProperty("oracle.xdkjava.transformer.compatible.jdkversion", "JDK_1.5");
        JDKVERSION = string.equals("JDK_1.4") ? "JDK_1.4" : "JDK_1.5";
        try {
            IDENXSL = new oracle.xml.xslt.XSLStylesheet(new StringReader("<stylesheet version='1.0'  xmlns='http://www.w3.org/1999/XSL/Transform'>  <template match='@*|node()'>     <copy-of select='.'/>  </template></stylesheet>"), null);
            IDENXSLROOT = new oracle.xml.xslt.XSLStylesheet(new StringReader("<stylesheet version='1.0' xmlns='http://www.w3.org/1999/XSL/Transform'>  <template match='/'>     <copy-of select='.'/>  </template></stylesheet>"), null);
        }
        catch (XSLException xSLException) {
            // empty catch block
        }
    }
}

