/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import oracle.xml.parser.v2.XMLByteReader;

class XMLUTF8Reader
extends XMLByteReader {
    boolean fourByte;
    private int saveFourByte;
    private boolean allowIllegalUTF8Encoding = false;
    private static final byte[] newLineAndUTF = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3};

    XMLUTF8Reader(InputStream inputStream, String string, String string2) {
        super(inputStream, string, string2);
    }

    void reset() {
        this.fourByte = false;
        this.saveFourByte = -1;
        super.reset();
    }

    void fillBuffer() throws IOException {
        int n = this.byteIndex;
        int n2 = this.endPos;
        while (true) {
            try {
                while (true) {
                    int n3;
                    byte by;
                    byte by2;
                    if ((by2 = newLineAndUTF[(by = this.byteBuffer[n]) & 0xFF]) == 2 && this.allowIllegalUTF8Encoding && (n3 = by & 0xFF) < 192) {
                        by2 = 0;
                    }
                    if (by2 == 0) {
                        this.charBuffer[n2] = (char)by;
                        ++n;
                        ++n2;
                        continue;
                    }
                    if (by2 == 1) {
                        if (by == 13 && this.byteBuffer[n + 1] == 10) {
                            ++n;
                        }
                        this.charBuffer[n2] = 10;
                        this.setLineNumber(n2);
                        ++n;
                        ++n2;
                        continue;
                    }
                    if (by2 == 2) {
                        n += this.readUTF8Char(n, n2);
                        ++n2;
                        continue;
                    }
                    if (n >= this.eofIndex) {
                        this.charBuffer[n2] = 65535;
                        this.eofPos = n2;
                        this.endPos = n2;
                        this.byteIndex = n;
                        return;
                    }
                    n += this.readUTF8Char(n, n2);
                    ++n2;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.byteIndex = n;
                this.endPos = n2;
                if (n2 < this.BUFSIZE) {
                    this.fillByteBuffer();
                    n = this.byteIndex;
                    continue;
                }
                return;
            }
            break;
        }
    }

    void checkUTF8Byte(int n, int n2) throws IOException {
        for (int i = 1; i <= n2; ++i) {
            if ((this.byteBuffer[n + i] & 0xC0) == 128) continue;
            throw new UTFDataFormatException(this.err.getMessage0(170));
        }
    }

    int readUTF8Char(int n, int n2) throws IOException {
        if (this.saveFourByte != -1) {
            this.fourByte = this.saveFourByte == 1;
            this.saveFourByte = -1;
        }
        if ((this.byteBuffer[n] & 0xE0) == 192) {
            this.checkUTF8Byte(n, 1);
            int n3 = ((this.byteBuffer[n] & 0x1F) << 6) + (this.byteBuffer[n + 1] & 0x3F);
            if (n3 < 128) {
                throw new UTFDataFormatException(this.err.getMessage1(171, n3 + ""));
            }
            this.charBuffer[n2] = (char)n3;
            return 2;
        }
        if ((this.byteBuffer[n] & 0xF0) == 224) {
            this.checkUTF8Byte(n, 2);
            int n4 = ((this.byteBuffer[n] & 0xF) << 12) + ((this.byteBuffer[n + 1] & 0x3F) << 6) + (this.byteBuffer[n + 2] & 0x3F);
            if (n4 >= 55296 && n4 < 57344 || n4 == 65535 || n4 == 65534 || n4 < 2048) {
                String string = this.err.getMessage1(171, Integer.toHexString(n4));
                throw new UTFDataFormatException(string);
            }
            this.charBuffer[n2] = (char)n4;
            return 3;
        }
        if ((this.byteBuffer[n] & 0xF8) == 240) {
            int n5 = 4;
            this.checkUTF8Byte(n, 3);
            int n6 = ((this.byteBuffer[n] & 7) << 18) + ((this.byteBuffer[n + 1] & 0x3F) << 12) + ((this.byteBuffer[n + 2] & 0x3F) << 6) + (this.byteBuffer[n + 3] & 0x3F);
            if (n6 >= 65536 && n6 <= 0x10FFFF) {
                if (!this.fourByte) {
                    n6 = (n6 - 65536 >> 10) + 55296;
                    this.fourByte = true;
                    n5 = 0;
                } else {
                    n6 = (n6 - 65536 & 0x3FF) + 56320;
                    this.fourByte = false;
                }
            } else {
                String string = this.err.getMessage1(171, Integer.toHexString(n6));
                throw new UTFDataFormatException(string);
            }
            if (this.charBuffer.length == n2) {
                this.saveFourByte = this.fourByte ? 0 : 1;
            }
            this.charBuffer[n2] = (char)n6;
            return n5;
        }
        if ((this.byteBuffer[n] & 0xFC) == 248) {
            throw new UTFDataFormatException(this.err.getMessage0(172));
        }
        if ((this.byteBuffer[n] & 0xFE) == 252) {
            throw new UTFDataFormatException(this.err.getMessage0(173));
        }
        throw new UTFDataFormatException(this.err.getMessage0(170));
    }

    final void setAllowIllegalUTF8Encoding(boolean bl) {
        this.allowIllegalUTF8Encoding = bl;
    }

    final boolean isAllowIllegalUTF8Encoding() {
        return this.allowIllegalUTF8Encoding;
    }
}

