/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.logging.Logger;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.GeneratedScrollableResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class InsensitiveScrollableResultSet
extends GeneratedScrollableResultSet {
    protected boolean isAllFetched;
    protected boolean isDoneFetchingRows = false;
    protected final long maxRows;
    final boolean resultFromCache;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;

    InsensitiveScrollableResultSet(PhysicalConnection physicalConnection, OracleStatement oracleStatement) throws SQLException {
        super(physicalConnection, oracleStatement);
        this.fetchedRowCount = oracleStatement.validRows;
        this.resultFromCache = oracleStatement.resultFromCache;
        oracleStatement.resultFromCache = false;
        this.isAllFetched = oracleStatement.isAllFetched;
        this.maxRows = oracleStatement.getMaxRows();
        if (this.maxRows > 0L && this.maxRows <= this.fetchedRowCount) {
            this.fetchedRowCount = this.maxRows;
            this.doneFetchingRows(false);
        }
    }

    void ensureOpen() throws SQLException {
        this.ensureOpen(null);
    }

    void ensureOpen(String string) throws SQLException {
        if (this.closed) {
            if (this.connection.isClosed()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, string).fillInStackTrace();
            }
            throw (SQLException)DatabaseError.createSqlException(10, string).fillInStackTrace();
        }
        this.ensureOpenStatement(string);
    }

    void ensureOpenPlus(String string) throws SQLException {
        this.ensureOpen(string);
        if (this.isForwardOnly()) {
            throw (SQLException)DatabaseError.createSqlException(75, string).fillInStackTrace();
        }
    }

    private final void ensureOpenStatement(String string) throws SQLException {
        if (this.statement.closed) {
            throw (SQLException)DatabaseError.createSqlException(9, string).fillInStackTrace();
        }
    }

    protected boolean isForwardOnly() {
        return false;
    }

    @Override
    public int getType() throws SQLException {
        this.ensureOpen("getType");
        return 1004;
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.ensureOpen("getConcurrency");
        return 1007;
    }

    @Override
    public String getCursorName() throws SQLException {
        Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();
        Throwable throwable = null;
        try {
            try {
                this.ensureOpen("getCursorName");
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "getCursorName").fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (closeableLock != null) {
                if (throwable != null) {
                    try {
                        closeableLock.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    closeableLock.close();
                }
            }
            throw throwable3;
        }
    }

    @Override
    public void close() throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                return;
            }
            super.close();
            if (this.statement.numReturnParams <= 0) {
                this.doneFetchingRows(false);
                this.statement.endOfResultSet(false);
                this.statement.closeCursorOnPlainStatement();
            }
            this.statement.closeByDependent();
            if (this.statement.isClosed() && this.statement.wrapper != null) {
                this.statement.wrapper.beClosed(this.connection.isClosed());
            }
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            this.ensureOpen("wasNull");
            boolean bl = this.statement.wasNullValue(this.currentRow);
            return bl;
        }
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.ensureOpen("rowDeleted");
        return false;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getMetaData");
            if (!this.statement.isOpen) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 144, "getMetaData").fillInStackTrace();
            }
            ResultSetMetaData resultSetMetaData = this.statement.getResultSetMetaData();
            return resultSetMetaData;
        }
    }

    @Override
    public Statement getStatement() throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getStatement");
            oracle.jdbc.internal.OracleStatement oracleStatement = this.statement.wrapper == null ? this.statement : this.statement.wrapper;
            return oracleStatement;
        }
    }

    @Override
    public int findColumn(String string) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            this.ensureOpen("findColumn");
            int n2 = this.statement.getColumnIndex(string);
            return n2;
        }
    }

    @Override
    public void setFetchSize(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            this.ensureOpen("setFetchSize");
            this.statement.setPrefetchInternal(n2, false, false);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getFetchSize");
            int n2 = this.statement.getPrefetchInternal(false);
            return n2;
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            this.ensureOpen("isBeforeFirst");
            boolean bl = !this.isEmptyResultSet() && this.currentRow == -1L;
            return bl;
        }
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            this.ensureOpen("isAfterLast");
            boolean bl = this.currentRow == this.fetchedRowCount;
            return bl;
        }
    }

    @Override
    public boolean isFirst() throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            this.ensureOpen("isFirst");
            boolean bl = !this.isEmptyResultSet() && this.currentRow == 0L;
            return bl;
        }
    }

    @Override
    public boolean isLast() throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            this.ensureOpen("isLast");
            if (this.isForwardOnly()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "isLast").fillInStackTrace();
            }
            if (!this.isAllFetched && this.currentRow + 1L == this.fetchedRowCount) {
                this.fetchMoreRows();
            }
            assert (this.isAllFetched || this.fetchedRowCount > this.currentRow + 1L) : "isAllFetched: " + this.isAllFetched + ", fetchedRowCount: " + this.fetchedRowCount + ", currentRow: " + this.currentRow;
            if (this.fetchedRowCount == 0L) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.isAllFetched && this.currentRow + 1L == this.fetchedRowCount;
            return bl;
        }
    }

    @Override
    public int getRow() throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getRow");
            if (this.isEmptyResultSet()) {
                int n2 = 0;
                return n2;
            }
            if (this.currentRow == this.fetchedRowCount) {
                int n3 = 0;
                return n3;
            }
            int n4 = (int)this.currentRow + 1;
            return n4;
        }
    }

    @Override
    public boolean absolute(int n2) throws SQLException {
        this.ensureOpen("absolute");
        if (this.connection.isClosed()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "absolute").fillInStackTrace();
        }
        if (this.isForwardOnly()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "absolute").fillInStackTrace();
        }
        return this.absoluteInternal(n2);
    }

    @Override
    public boolean first() throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            this.ensureOpen("first");
            if (this.connection.isClosed()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "first").fillInStackTrace();
            }
            if (this.isForwardOnly()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "first").fillInStackTrace();
            }
            boolean bl = this.absoluteInternal(1L);
            return bl;
        }
    }

    @Override
    public boolean next() throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            this.ensureOpen("next");
            if (this.statement.sqlKind.isPlsqlOrCall()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 166, "next").fillInStackTrace();
            }
            boolean bl = this.absoluteInternal(this.currentRow + 2L);
            return bl;
        }
    }

    @Override
    public boolean previous() throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            this.ensureOpenPlus("previous");
            if (this.currentRow > -1L) {
                boolean bl = this.absoluteInternal(this.currentRow);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public boolean last() throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            this.ensureOpenPlus("last");
            if (this.isEmptyResultSet()) {
                boolean bl = false;
                return bl;
            }
            while (!this.isAllFetched) {
                this.fetchMoreRows();
            }
            this.currentRow = this.fetchedRowCount - 1L;
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            this.ensureOpenPlus("beforeFirst");
            if (this.isForwardOnly()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "beforeFirst").fillInStackTrace();
            }
            this.absolute(0);
        }
    }

    @Override
    public void afterLast() throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            this.ensureOpenPlus("afterLast");
            if (!this.isEmptyResultSet()) {
                while (!this.isAllFetched) {
                    this.fetchMoreRows();
                }
                this.currentRow = this.fetchedRowCount;
            }
        }
    }

    @Override
    public boolean relative(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            this.ensureOpenPlus("relative");
            if (n2 == 0) {
                boolean bl = this.isValidRow();
                return bl;
            }
            if (n2 == 1) {
                boolean bl = this.next();
                return bl;
            }
            if (n2 == -1) {
                boolean bl = this.previous();
                return bl;
            }
            if (this.currentRow + (long)n2 < 0L) {
                boolean bl = this.absoluteInternal(0L);
                return bl;
            }
            boolean bl = this.absoluteInternal(this.currentRow + (long)n2 + 1L);
            return bl;
        }
    }

    @Override
    public void refreshRow() throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            this.ensureOpen("refreshRow");
            if (!this.statement.isRowidPrepended) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "refreshRow").fillInStackTrace();
            }
            if (this.currentRow < 0L || this.currentRow >= this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11, "refreshRow").fillInStackTrace();
            }
            try {
                long l2 = this.currentRow;
                if (this.getFetchDirection() == 1001) {
                    l2 = Math.max(0L, this.currentRow - (long)this.getFetchSize());
                }
                this.refreshRows(l2, this.getFetchSize());
            }
            catch (SQLRecoverableException sQLRecoverableException) {
                throw sQLRecoverableException;
            }
            catch (SQLException sQLException) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Unsupported syntax for refreshRow()", (Throwable)sQLException).fillInStackTrace();
            }
        }
    }

    @Override
    public <T> T getObject(int n2, Class<T> clazz) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            assert (clazz != null) : "type: null";
            this.ensureOpen("getObject");
            this.ensureValidColumnIndex(n2);
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14, "getObject").fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289, "getObject").fillInStackTrace();
            }
            T t2 = this.statement.getObject(this.currentRow, n2, clazz);
            return t2;
        }
    }

    private final void ensureValidColumnIndex(int n2) throws SQLException {
        if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getObject").fillInStackTrace();
        }
    }

    @Override
    public int getBytes(int n2, byte[] byArray, int n3) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getBytes").fillInStackTrace();
            }
            if (this.connection.isClosed()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getBytes").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            int n4 = this.statement.getBytes(this.currentRow, n2, byArray, n3);
            return n4;
        }
    }

    @Override
    public OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getAuthorizationIndicator");
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14, "getAuthorizationIndicator").fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289, "getAuthorizationIndicator").fillInStackTrace();
            }
            OracleResultSet.AuthorizationIndicator authorizationIndicator = this.statement.getAuthorizationIndicator(this.currentRow, n2);
            return authorizationIndicator;
        }
    }

    void hackLast() throws SQLException {
        assert (this.isAfterLast()) : "not after last";
        this.currentRow = this.fetchedRowCount - 1L;
    }

    protected boolean absoluteInternal(long l2) throws SQLException {
        long l3 = l2 - 1L;
        if (l2 == 0L) {
            this.currentRow = l3;
        } else if (l3 >= 0L && l3 < this.fetchedRowCount) {
            this.currentRow = l3;
        } else if (l3 >= 0L) {
            this.fetchNextRows(l3);
        } else {
            this.fetchLastRows(-l2);
        }
        assert (this.currentRow < this.fetchedRowCount || this.isAllFetched) : "currentRow: " + this.currentRow + ", fetchedRowCount: " + this.fetchedRowCount + ", isAllFetched: " + this.isAllFetched;
        assert (-1L <= this.currentRow && this.currentRow <= this.fetchedRowCount) : "currentRow: " + this.currentRow + ", fetchedRowCount: " + this.fetchedRowCount;
        return this.isCurrentRowValid();
    }

    private final void fetchNextRows(long l2) throws SQLException {
        while (!this.isAllFetched && this.fetchedRowCount <= l2) {
            this.fetchMoreRows();
        }
        this.handleFetchNextRowsCompletion(l2);
    }

    private final void handleFetchNextRowsCompletion(long l2) throws SQLException {
        if (l2 < this.fetchedRowCount) {
            this.currentRow = l2;
        } else {
            assert (this.isAllFetched) : "isAllFetched: " + this.isAllFetched;
            this.currentRow = this.fetchedRowCount;
            if (this.isForwardOnly()) {
                this.doneFetchingRows(false);
            }
        }
    }

    private final void fetchLastRows(long l2) throws SQLException {
        while (!this.isAllFetched) {
            this.fetchMoreRows();
        }
        long l3 = this.fetchedRowCount - l2;
        this.currentRow = l3 >= 0L && l3 < this.fetchedRowCount ? l3 : -1L;
    }

    protected void fetchMoreRows() throws SQLException {
        assert (!this.isAllFetched) : "isAllFetched: " + this.isAllFetched;
        this.clearWarnings();
        this.fetchedRowCount += this.statement.fetchMoreRows(this.fetchedRowCount);
        this.handleFetchMoreRowsCompletion();
    }

    private final void handleFetchMoreRowsCompletion() throws SQLException {
        this.isAllFetched = this.statement.isAllFetched;
        if (this.currentRow == this.fetchedRowCount && this.isForwardOnly()) {
            this.doneFetchingRows(false);
        }
        if (this.maxRows > 0L && this.fetchedRowCount > this.maxRows) {
            this.fetchedRowCount = this.maxRows;
            this.doneFetchingRows(false);
            this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 275);
        }
    }

    @Override
    protected void doneFetchingRows(boolean bl) throws SQLException {
        if (this.isDoneFetchingRows) {
            return;
        }
        this.isDoneFetchingRows = true;
        this.isAllFetched = true;
        try {
            this.statement.closeQuery();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected boolean isEmptyResultSet() throws SQLException {
        if (this.fetchedRowCount > 0L) {
            return false;
        }
        if (this.isAllFetched) {
            return true;
        }
        this.fetchMoreRows();
        assert (this.fetchedRowCount >= 0L) : "fetchedRowCount: " + this.fetchedRowCount;
        return this.fetchedRowCount == 0L;
    }

    @Override
    boolean isValidRow() throws SQLException {
        return this.isCurrentRowValid();
    }

    private final boolean isCurrentRowValid() {
        return this.currentRow > -1L && this.currentRow < this.fetchedRowCount;
    }

    protected long getValidRows() {
        return this.fetchedRowCount;
    }

    @Override
    OracleStatement getOracleStatement() throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            OracleStatement oracleStatement = this.statement;
            return oracleStatement;
        }
    }

    @Override
    void removeCurrentRowFromCache() throws SQLException {
        assert (this.currentRow < this.fetchedRowCount) : "currentRow:" + this.currentRow + " fetchedRowCount:" + this.fetchedRowCount;
        if (!this.isAllFetched && this.currentRow + 1L == this.fetchedRowCount) {
            this.fetchMoreRows();
        }
        this.statement.removeRowFromCache(this.currentRow);
        --this.fetchedRowCount;
    }

    @Override
    public boolean isFromResultSetCache() throws SQLException {
        return this.resultFromCache;
    }

    @Override
    public byte[] getCompileKey() throws SQLException {
        return this.statement.getCompileKey();
    }

    @Override
    public byte[] getRuntimeKey() throws SQLException {
        return this.statement.getRuntimeKey();
    }

    @Override
    int refreshRows(long l2, int n2) throws SQLException {
        return this.statement.refreshRows(l2, n2);
    }

    @Override
    void insertRow(RowId rowId) throws SQLException {
        if (this.currentRow < this.fetchedRowCount) {
            this.statement.insertRow(this.currentRow + 1L, rowId);
            ++this.currentRow;
        } else {
            this.statement.insertRow(this.currentRow, rowId);
        }
        ++this.fetchedRowCount;
    }

    @Override
    int getColumnCount() throws SQLException {
        if (this.statement.accessors != null) {
            return this.statement.numberOfDefinePositions - (1 + this.statement.offsetOfFirstUserColumn);
        }
        return this.getMetaData().getColumnCount();
    }

    RowId getPrependedRowId() throws SQLException {
        return this.statement.getPrependedRowId(this.currentRow);
    }

    @Override
    public int getCursorId() throws SQLException {
        return this.statement.cursorId;
    }

    static {
        try {
            $$$methodRef$$$56 = InsensitiveScrollableResultSet.class.getDeclaredConstructor(PhysicalConnection.class, OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$55 = InsensitiveScrollableResultSet.class.getDeclaredMethod("getCursorId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$54 = InsensitiveScrollableResultSet.class.getDeclaredMethod("getPrependedRowId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$53 = InsensitiveScrollableResultSet.class.getDeclaredMethod("getColumnCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$52 = InsensitiveScrollableResultSet.class.getDeclaredMethod("insertRow", RowId.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$51 = InsensitiveScrollableResultSet.class.getDeclaredMethod("refreshRows", Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$50 = InsensitiveScrollableResultSet.class.getDeclaredMethod("getRuntimeKey", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$49 = InsensitiveScrollableResultSet.class.getDeclaredMethod("getCompileKey", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$48 = InsensitiveScrollableResultSet.class.getDeclaredMethod("isFromResultSetCache", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$47 = InsensitiveScrollableResultSet.class.getDeclaredMethod("removeCurrentRowFromCache", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$46 = InsensitiveScrollableResultSet.class.getDeclaredMethod("getOracleStatement", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$45 = InsensitiveScrollableResultSet.class.getDeclaredMethod("getValidRows", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$44 = InsensitiveScrollableResultSet.class.getDeclaredMethod("isCurrentRowValid", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$43 = InsensitiveScrollableResultSet.class.getDeclaredMethod("isValidRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$42 = InsensitiveScrollableResultSet.class.getDeclaredMethod("isEmptyResultSet", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$41 = InsensitiveScrollableResultSet.class.getDeclaredMethod("doneFetchingRows", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$40 = InsensitiveScrollableResultSet.class.getDeclaredMethod("handleFetchMoreRowsCompletion", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = InsensitiveScrollableResultSet.class.getDeclaredMethod("fetchMoreRows", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = InsensitiveScrollableResultSet.class.getDeclaredMethod("fetchLastRows", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = InsensitiveScrollableResultSet.class.getDeclaredMethod("handleFetchNextRowsCompletion", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = InsensitiveScrollableResultSet.class.getDeclaredMethod("fetchNextRows", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = InsensitiveScrollableResultSet.class.getDeclaredMethod("absoluteInternal", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = InsensitiveScrollableResultSet.class.getDeclaredMethod("hackLast", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = InsensitiveScrollableResultSet.class.getDeclaredMethod("getAuthorizationIndicator", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = InsensitiveScrollableResultSet.class.getDeclaredMethod("getBytes", Integer.TYPE, byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = InsensitiveScrollableResultSet.class.getDeclaredMethod("ensureValidColumnIndex", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = InsensitiveScrollableResultSet.class.getDeclaredMethod("getObject", Integer.TYPE, Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = InsensitiveScrollableResultSet.class.getDeclaredMethod("refreshRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = InsensitiveScrollableResultSet.class.getDeclaredMethod("relative", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = InsensitiveScrollableResultSet.class.getDeclaredMethod("afterLast", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = InsensitiveScrollableResultSet.class.getDeclaredMethod("beforeFirst", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = InsensitiveScrollableResultSet.class.getDeclaredMethod("last", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = InsensitiveScrollableResultSet.class.getDeclaredMethod("previous", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = InsensitiveScrollableResultSet.class.getDeclaredMethod("next", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = InsensitiveScrollableResultSet.class.getDeclaredMethod("first", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = InsensitiveScrollableResultSet.class.getDeclaredMethod("absolute", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = InsensitiveScrollableResultSet.class.getDeclaredMethod("getRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = InsensitiveScrollableResultSet.class.getDeclaredMethod("isLast", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = InsensitiveScrollableResultSet.class.getDeclaredMethod("isFirst", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = InsensitiveScrollableResultSet.class.getDeclaredMethod("isAfterLast", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = InsensitiveScrollableResultSet.class.getDeclaredMethod("isBeforeFirst", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = InsensitiveScrollableResultSet.class.getDeclaredMethod("getFetchSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = InsensitiveScrollableResultSet.class.getDeclaredMethod("setFetchSize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = InsensitiveScrollableResultSet.class.getDeclaredMethod("findColumn", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = InsensitiveScrollableResultSet.class.getDeclaredMethod("getStatement", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = InsensitiveScrollableResultSet.class.getDeclaredMethod("getMetaData", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = InsensitiveScrollableResultSet.class.getDeclaredMethod("rowDeleted", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = InsensitiveScrollableResultSet.class.getDeclaredMethod("wasNull", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = InsensitiveScrollableResultSet.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = InsensitiveScrollableResultSet.class.getDeclaredMethod("getCursorName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = InsensitiveScrollableResultSet.class.getDeclaredMethod("getConcurrency", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = InsensitiveScrollableResultSet.class.getDeclaredMethod("getType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = InsensitiveScrollableResultSet.class.getDeclaredMethod("isForwardOnly", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = InsensitiveScrollableResultSet.class.getDeclaredMethod("ensureOpenStatement", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = InsensitiveScrollableResultSet.class.getDeclaredMethod("ensureOpenPlus", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = InsensitiveScrollableResultSet.class.getDeclaredMethod("ensureOpen", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = InsensitiveScrollableResultSet.class.getDeclaredMethod("ensureOpen", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

