/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4CCallableStatement;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CInputStream;
import oracle.jdbc.driver.T4CPreparedStatement;
import oracle.jdbc.driver.T4CStatement;
import oracle.jdbc.internal.AbstractConnectionBuilder;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleCallableStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OraclePreparedStatement;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CDriverExtension
extends OracleDriverExtension
implements Monitor {
    private OracleDriverExtension shardingDriverExtension = null;
    private static String shardingDriverExtensionClassName;
    private static final Monitor DEFAULT_CONN_MONITOR;
    private final Monitor.CloseableLock monitorLock = this.newDefaultLock();
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;

    T4CDriverExtension() {
    }

    @Override
    @DefaultLevel(value=Logging.FINEST)
    final Connection getConnection(String string, @Blind(value=PropertiesBlinder.class) Properties properties, AbstractConnectionBuilder<?, ?> abstractConnectionBuilder) throws SQLException {
        T4CConnection t4CConnection = new T4CConnection(string, properties, this);
        if (t4CConnection.useShardingDriverConnection() && !t4CConnection.isShardingDriverMode()) {
            if (this.shardingDriverExtension == null) {
                try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
                    if (this.shardingDriverExtension == null) {
                        this.shardingDriverExtension = (OracleDriverExtension)Class.forName(shardingDriverExtensionClassName).newInstance();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.shardingDriverExtension.getConnection(string, properties, abstractConnectionBuilder);
        }
        t4CConnection.connect(abstractConnectionBuilder);
        return t4CConnection;
    }

    @Override
    final CompletionStage<Connection> getConnectionAsync(String string, @Blind(value=PropertiesBlinder.class) Properties properties, AbstractConnectionBuilder<?, ?> abstractConnectionBuilder) {
        try {
            T4CConnection t4CConnection = new T4CConnection(string, properties, this);
            return t4CConnection.connectAsync(abstractConnectionBuilder).thenApply(void_ -> t4CConnection);
        }
        catch (SQLException sQLException) {
            return CompletionStageUtil.failedStage(sQLException);
        }
    }

    @Override
    oracle.jdbc.internal.OracleStatement allocateStatement(OracleConnection oracleConnection, @Blind(value=PropertiesBlinder.class) Properties properties) throws SQLException {
        return new T4CStatement((PhysicalConnection)oracleConnection, properties);
    }

    @Override
    OraclePreparedStatement allocatePreparedStatement(OracleConnection oracleConnection, String string, @Blind(value=PropertiesBlinder.class) Properties properties) throws SQLException {
        return new T4CPreparedStatement((PhysicalConnection)oracleConnection, string, properties);
    }

    @Override
    OracleCallableStatement allocateCallableStatement(OracleConnection oracleConnection, String string, @Blind(value=PropertiesBlinder.class) Properties properties) throws SQLException {
        return new T4CCallableStatement((PhysicalConnection)oracleConnection, string, properties);
    }

    @Override
    OracleInputStream createInputStream(OracleStatement oracleStatement, int n2, Accessor accessor) throws SQLException {
        return new T4CInputStream(oracleStatement, n2, accessor);
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        return this.monitorLock;
    }

    static {
        try {
            $$$methodRef$$$8 = T4CDriverExtension.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = T4CDriverExtension.class.getDeclaredMethod("lambda$getConnectionAsync$0", T4CConnection.class, Void.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = T4CDriverExtension.class.getDeclaredMethod("getMonitorLock", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T4CDriverExtension.class.getDeclaredMethod("createInputStream", OracleStatement.class, Integer.TYPE, Accessor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4CDriverExtension.class.getDeclaredMethod("allocateCallableStatement", OracleConnection.class, String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4CDriverExtension.class.getDeclaredMethod("allocatePreparedStatement", OracleConnection.class, String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4CDriverExtension.class.getDeclaredMethod("allocateStatement", OracleConnection.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CDriverExtension.class.getDeclaredMethod("getConnectionAsync", String.class, Properties.class, AbstractConnectionBuilder.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CDriverExtension.class.getDeclaredMethod("getConnection", String.class, Properties.class, AbstractConnectionBuilder.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        shardingDriverExtensionClassName = "oracle.jdbc.driver.ShardingDriverExtension";
        DEFAULT_CONN_MONITOR = Monitor.newInstance();
    }
}

