/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DynamicByteArray;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4C8Oall;
import oracle.jdbc.driver.T4CBfileAccessor;
import oracle.jdbc.driver.T4CBinaryDoubleAccessor;
import oracle.jdbc.driver.T4CBinaryFloatAccessor;
import oracle.jdbc.driver.T4CBlobAccessor;
import oracle.jdbc.driver.T4CCharAccessor;
import oracle.jdbc.driver.T4CClobAccessor;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CDateAccessor;
import oracle.jdbc.driver.T4CIntervaldsAccessor;
import oracle.jdbc.driver.T4CIntervalymAccessor;
import oracle.jdbc.driver.T4CJsonAccessor;
import oracle.jdbc.driver.T4CLongAccessor;
import oracle.jdbc.driver.T4CLongRawAccessor;
import oracle.jdbc.driver.T4CNamedTypeAccessor;
import oracle.jdbc.driver.T4CNumberAccessor;
import oracle.jdbc.driver.T4COutRawAccessor;
import oracle.jdbc.driver.T4CPlsqlBooleanAccessor;
import oracle.jdbc.driver.T4CRawAccessor;
import oracle.jdbc.driver.T4CRefTypeAccessor;
import oracle.jdbc.driver.T4CResultSetAccessor;
import oracle.jdbc.driver.T4CRowidAccessor;
import oracle.jdbc.driver.T4CTimestampAccessor;
import oracle.jdbc.driver.T4CTimestampltzAccessor;
import oracle.jdbc.driver.T4CTimestamptzAccessor;
import oracle.jdbc.driver.T4CVarcharAccessor;
import oracle.jdbc.driver.T4CVarnumAccessor;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.oracore.OracleTypeADT;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CStatement
extends OracleStatement {
    static final byte[][][] parameterDatum;
    static final OracleTypeADT[][] parameterOtype;
    static final byte[] EMPTY_BYTE;
    T4CConnection t4Connection;
    private long beyondRowData = 0L;
    final String[] nlsStrings = new String[]{"AUTH_NLS_LXLAN", "AUTH_NLS_LXCTERRITORY", "AUTH_NLS_LXCCURRENCY", "AUTH_NLS_LXCISOCURR", "AUTH_NLS_LXCNUMERICS", "AUTH_NLS_LXCDATEFM", "AUTH_NLS_LXCDATELANG", "AUTH_NLS_LXCSORT", "AUTH_NLS_LXCCALENDAR", "AUTH_NLS_LXCUNIONCUR", "AUTH_NLS_LXCTIMEFM", "AUTH_NLS_LXCSTMPFM", "AUTH_NLS_LXCTTZNFM", "AUTH_NLS_LXCSTZNFM", "SESSION_TIME_ZONE", "AL8KW_ENABLED_ROLES", "AL8KW_ERR_OVLAP", "AL8KW_EDITION", "AL8KW_AUX_SESSSTATE"};
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;

    private final int getFirstRowInBatchForOALL8() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doOall8(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n2) throws SQLException, IOException {
        int n3 = this.prepareForOALL8(bl, bl2, bl3, bl4, n2);
        if (n3 == -1) {
            return;
        }
        boolean bl6 = bl5 && bl4 && this.isRowidPrepended;
        T4C8Oall t4C8Oall = this.initializeOALL8(bl6, n3);
        try {
            t4C8Oall.doOALL(bl, bl2, bl3, bl4, bl5);
        }
        catch (SQLException sQLException) {
            if (!this.handleOALL8Failure(sQLException)) {
                throw sQLException;
            }
        }
        finally {
            this.handleOALL8CompletionAlways(t4C8Oall);
        }
    }

    private final int prepareForOALL8(boolean bl, boolean bl2, boolean bl3, boolean bl4, int n2) throws SQLException {
        if (bl || bl4 || !bl2) {
            this.oacdefSent = null;
        }
        if (bl2) {
            this.beyondRowData = this.bindUseDBA ? this.beyondBindData : 0L;
        }
        this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CStatement.doOall8");
        if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
            this.sqlKind = OracleStatement.SqlKind.OTHER;
        }
        int n3 = this.rowPrefetch;
        if (bl3) {
            this.rowPrefetchInLastFetch = n3 = this.getMaximumRowFetchForOALL8();
            if (n3 == 0 && this.isAllFetched) {
                return -1;
            }
            this.rowData.setPosition(this.beyondRowData);
        }
        this.prepareAccessorRowCountsForOALL8(n2);
        this.prepareBindsByteArrayForOALL8();
        this.allocateTmpByteArray();
        return n3;
    }

    private final int getMaximumRowFetchForOALL8() {
        boolean bl;
        long l2 = this.indexOfFirstRow + (long)this.storedRowCount;
        boolean bl2 = bl = this.maxRows > 0L && this.maxRows <= l2 + (long)this.rowPrefetch;
        if (bl) {
            this.isAllFetched = true;
            return (int)(this.maxRows - l2);
        }
        return this.rowPrefetch;
    }

    private final void prepareAccessorRowCountsForOALL8(int n2) {
        int n3;
        if (this.accessors != null) {
            for (n3 = 0; n3 < this.accessors.length; ++n3) {
                if (this.accessors[n3] == null) continue;
                this.accessors[n3].lastRowProcessed = n2;
            }
        }
        if (this.outBindAccessors != null) {
            for (n3 = 0; n3 < this.outBindAccessors.length; ++n3) {
                if (this.outBindAccessors[n3] == null) continue;
                this.outBindAccessors[n3].lastRowProcessed = 0;
            }
        }
    }

    private final void prepareBindsByteArrayForOALL8() {
        if (this.bindIndicators != null) {
            int n2 = ((this.bindIndicators[this.bindIndicatorSubRange + 3] & 0xFFFF) << 16) + (this.bindIndicators[this.bindIndicatorSubRange + 4] & 0xFFFF);
            int n3 = 0;
            if (this.ibtBindChars != null) {
                n3 = this.ibtBindChars.length * this.connection.conversion.cMaxCharSize;
            }
            for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                int n4 = this.bindIndicatorSubRange + 5 + 10 * i2;
                int n5 = this.bindIndicators[n4 + 2] & 0xFFFF;
                if (n5 == 0) continue;
                int n6 = this.bindIndicators[n4 + 9] & 0xFFFF;
                if (this.bindUseDBA) continue;
                n3 = n6 == 2 ? Math.max(n5 * this.connection.conversion.maxNCharSize, n3) : Math.max(n5 * this.connection.conversion.cMaxCharSize, n3);
            }
            if (this.tmpBindsByteArray == null) {
                this.tmpBindsByteArray = new byte[n3];
            } else if (this.tmpBindsByteArray.length < n3) {
                this.tmpBindsByteArray = null;
                this.tmpBindsByteArray = new byte[n3];
            }
        } else {
            this.tmpBindsByteArray = null;
        }
    }

    private final T4C8Oall initializeOALL8(boolean bl, int n2) throws SQLException {
        T4C8Oall t4C8Oall = this.t4Connection.all8;
        t4C8Oall.typeOfStatement = this.sqlKind;
        t4C8Oall.cursor = this.cursorId;
        t4C8Oall.sqlStmt = this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals);
        t4C8Oall.rowsToFetch = n2;
        t4C8Oall.outBindAccessors = this.outBindAccessors;
        t4C8Oall.numberOfBindPositions = this.numberOfBindPositions;
        t4C8Oall.definesAccessors = this.accessors;
        t4C8Oall.definesLength = this.getNumberOfDefinePositionsForOALL8();
        t4C8Oall.bindBytes = this.bindBytes;
        t4C8Oall.bindChars = this.bindChars;
        t4C8Oall.bindIndicators = this.bindIndicators;
        t4C8Oall.bindIndicatorSubRange = this.bindIndicatorSubRange;
        t4C8Oall.conversion = this.connection.conversion;
        t4C8Oall.tmpBindsByteArray = this.tmpBindsByteArray;
        t4C8Oall.parameterStream = this.parameterStream;
        t4C8Oall.oracleStatement = this;
        t4C8Oall.ibtBindBytes = this.ibtBindBytes;
        t4C8Oall.ibtBindChars = this.ibtBindChars;
        t4C8Oall.ibtBindIndicators = this.ibtBindIndicators;
        t4C8Oall.oacdefBindsSent = this.oacdefSent;
        t4C8Oall.definedColumnType = this.getDefinedColumnTypesForOALL8(bl);
        t4C8Oall.definedColumnSize = this.getDefinedColumnSizesForOALL8(bl);
        t4C8Oall.definedColumnFormOfUse = this.getDefinedColumnFormsOfUseForOALL8(bl);
        t4C8Oall.registration = this.registration;
        t4C8Oall.bindData = this.bindData;
        t4C8Oall.bindDataOffsets = this.bindDataOffsets;
        t4C8Oall.bindDataLengths = this.bindDataLengths;
        t4C8Oall.bindUseDBA = this.bindUseDBA;
        return t4C8Oall;
    }

    private final int getNumberOfDefinePositionsForOALL8() {
        if (this.sqlKind.isDML()) {
            return 0;
        }
        return this.numberOfDefinePositions;
    }

    private final int[] getDefinedColumnTypesForOALL8(boolean bl) {
        if (bl) {
            int[] nArray = new int[this.definedColumnType.length + 1];
            System.arraycopy(this.definedColumnType, 0, nArray, 1, this.definedColumnType.length);
            nArray[0] = -8;
            return nArray;
        }
        return this.definedColumnType;
    }

    private final int[] getDefinedColumnSizesForOALL8(boolean bl) {
        if (bl) {
            int[] nArray = new int[this.definedColumnSize.length + 1];
            System.arraycopy(this.definedColumnSize, 0, nArray, 1, this.definedColumnSize.length);
            return nArray;
        }
        return this.definedColumnSize;
    }

    private final int[] getDefinedColumnFormsOfUseForOALL8(boolean bl) {
        if (bl) {
            int[] nArray = new int[this.definedColumnFormOfUse.length + 1];
            System.arraycopy(this.definedColumnFormOfUse, 0, nArray, 1, this.definedColumnFormOfUse.length);
            return nArray;
        }
        return this.definedColumnFormOfUse;
    }

    private boolean handleOALL8Failure(SQLException sQLException) {
        if (sQLException.getErrorCode() == DatabaseError.getVendorCode(110)) {
            this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 110);
            return true;
        }
        return false;
    }

    private final void handleOALL8CompletionAlways(T4C8Oall t4C8Oall) throws SQLException {
        int n2 = t4C8Oall.getCursorId();
        if (n2 != 0) {
            this.setCursorId(n2);
        }
        this.oacdefSent = t4C8Oall.oacdefBindsSent;
        if (this.connection.isPDBChanged) {
            this.connection.onPDBChange(this);
            this.connection.isPDBChanged = false;
        }
        this.beyondRowData = Math.max(this.beyondRowData, this.rowData.getPosition());
    }

    @Override
    void allocateTmpByteArray() {
        block1: {
            block0: {
                if (this.tmpByteArray != null) break block0;
                this.tmpByteArray = new byte[this.sizeTmpByteArray];
                break block1;
            }
            if (this.sizeTmpByteArray <= this.tmpByteArray.length) break block1;
            this.tmpByteArray = new byte[this.sizeTmpByteArray];
        }
    }

    @Override
    void releaseBuffers() {
        super.releaseBuffers();
        this.tmpByteArray = null;
        this.tmpBindsByteArray = null;
        if (this.t4Connection != null) {
            this.t4Connection.all8.bindChars = null;
            this.t4Connection.all8.bindBytes = null;
            this.t4Connection.all8.tmpBindsByteArray = null;
        }
    }

    @Override
    void allocateRowidAccessor() throws SQLException {
        this.accessors[0] = new T4CRowidAccessor(this, 128, 1, -8, false, this.t4Connection.mare);
    }

    @Override
    void reparseOnRedefineIfNeeded() throws SQLException {
        this.needToParse = true;
    }

    @Override
    protected void defineColumnTypeInternal(int n2, int n3, int n4, short s2, boolean bl, String string) throws SQLException {
        int[] nArray;
        if (this.connection.disableDefinecolumntype) {
            return;
        }
        if (n3 == -15 || n3 == -9 || n3 == -16) {
            s2 = (short)2;
        }
        if (n2 < 1) {
            throw (SQLException)DatabaseError.createSqlException(3).fillInStackTrace();
        }
        if (this.currentResultSet != null && !this.currentResultSet.closed) {
            throw (SQLException)DatabaseError.createSqlException(28).fillInStackTrace();
        }
        int n5 = n2 - 1;
        if (this.definedColumnType == null || this.definedColumnType.length <= n5) {
            if (this.definedColumnType == null) {
                this.definedColumnType = new int[(n5 + 1) * 4];
            } else {
                nArray = new int[(n5 + 1) * 4];
                System.arraycopy(this.definedColumnType, 0, nArray, 0, this.definedColumnType.length);
                this.definedColumnType = nArray;
            }
        }
        this.definedColumnType[n5] = n3;
        if (this.definedColumnSize == null || this.definedColumnSize.length <= n5) {
            if (this.definedColumnSize == null) {
                this.definedColumnSize = new int[(n5 + 1) * 4];
            } else {
                nArray = new int[(n5 + 1) * 4];
                System.arraycopy(this.definedColumnSize, 0, nArray, 0, this.definedColumnSize.length);
                this.definedColumnSize = nArray;
            }
        }
        int n6 = this.definedColumnSize[n5] = n3 == 2005 || n3 == 2004 || n3 == 2016 ? n4 : -1;
        if (this.definedColumnFormOfUse == null || this.definedColumnFormOfUse.length <= n5) {
            if (this.definedColumnFormOfUse == null) {
                this.definedColumnFormOfUse = new int[(n5 + 1) * 4];
            } else {
                nArray = new int[(n5 + 1) * 4];
                System.arraycopy(this.definedColumnFormOfUse, 0, nArray, 0, this.definedColumnFormOfUse.length);
                this.definedColumnFormOfUse = nArray;
            }
        }
        this.definedColumnFormOfUse[n5] = s2;
        this.executeDoneForDefines = false;
    }

    @Override
    public void clearDefines() throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            super.clearDefines();
            this.definedColumnType = null;
            this.definedColumnSize = null;
            this.definedColumnFormOfUse = null;
            if (this.t4Connection != null && this.t4Connection.all8 != null) {
                this.t4Connection.all8.definesAccessors = null;
            }
        }
    }

    @Override
    void doSetSnapshotSCN(long l2) throws SQLException {
        this.inScn = l2;
    }

    @Override
    protected void configureRowData() {
        this.bindData = this.rowData = DynamicByteArray.createDynamicByteArray(this.connection.getBlockSource());
        this.bindUseDBA = this.connection.bindUseDBA;
    }

    @Override
    protected final void locationToPutBytes(Accessor accessor, int n2, int n3) throws SQLException {
        accessor.setOffset(n2, this.allocateRowDataSpace(n3));
    }

    @Override
    long allocateRowDataSpace(int n2) {
        long l2 = this.beyondRowData;
        this.beyondRowData += (long)n2;
        return l2;
    }

    @Override
    Accessor allocateAccessor(int n2, int n3, int n4, int n5, short s2, String string, boolean bl) throws SQLException {
        Accessor accessor = null;
        switch (n2) {
            case 96: {
                accessor = new T4CCharAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 8: {
                if (!bl) {
                    accessor = new T4CLongAccessor(this, n4, n5, s2, n3, this.t4Connection.mare);
                    break;
                }
            }
            case 1: {
                accessor = new T4CVarcharAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 2: {
                accessor = new T4CNumberAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 6: {
                accessor = new T4CVarnumAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 252: {
                accessor = new T4CPlsqlBooleanAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 24: {
                if (!bl) {
                    accessor = new T4CLongRawAccessor(this, n4, n5, s2, n3, this.t4Connection.mare);
                    break;
                }
            }
            case 23: {
                if (bl && string != null) {
                    throw (SQLException)DatabaseError.createSqlException(12, "sqlType=" + n3).fillInStackTrace();
                }
                if (bl) {
                    accessor = new T4COutRawAccessor(this, n5, s2, n3, this.t4Connection.mare);
                    break;
                }
                accessor = new T4CRawAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 100: {
                accessor = new T4CBinaryFloatAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 101: {
                accessor = new T4CBinaryDoubleAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 104: 
            case 208: {
                if (this.sqlKind == OracleStatement.SqlKind.CALL_BLOCK || this.sqlObject.returningIntoParameterCount > 0) {
                    accessor = new T4CVarcharAccessor(this, 18, s2, n3, bl, this.t4Connection.mare);
                    accessor.definedColumnType = -8;
                    break;
                }
                accessor = new T4CRowidAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 102: {
                accessor = new T4CResultSetAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 12: {
                accessor = new T4CDateAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 113: {
                accessor = new T4CBlobAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 119: {
                accessor = new T4CJsonAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 112: {
                accessor = new T4CClobAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 114: {
                accessor = new T4CBfileAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 109: {
                accessor = new T4CNamedTypeAccessor(this, string, s2, n3, bl, this.t4Connection.mare);
                accessor.initMetadata();
                break;
            }
            case 111: {
                accessor = new T4CRefTypeAccessor(this, string, s2, n3, bl, this.t4Connection.mare);
                accessor.initMetadata();
                break;
            }
            case 180: {
                accessor = new T4CTimestampAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 181: {
                accessor = new T4CTimestamptzAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 231: {
                accessor = new T4CTimestampltzAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 182: {
                accessor = new T4CIntervalymAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 183: {
                accessor = new T4CIntervaldsAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 995: {
                throw (SQLException)DatabaseError.createSqlException(89).fillInStackTrace();
            }
            default: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 41, (Object)(n4 + 1)).fillInStackTrace();
            }
        }
        return accessor;
    }

    @Override
    void doDescribe(boolean bl) throws SQLException {
        if (!this.isOpen) {
            throw (SQLException)DatabaseError.createSqlException(144).fillInStackTrace();
        }
        byte[] byArray = this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals);
        try {
            this.t4Connection.needLine();
            this.t4Connection.describe.doODNY(this, 0, this.accessors, byArray);
            this.accessors = this.t4Connection.describe.getAccessors();
            this.numberOfDefinePositions = this.t4Connection.describe.numuds;
            for (int i2 = 0; i2 < this.numberOfDefinePositions; ++i2) {
                this.accessors[i2].initMetadata();
            }
        }
        catch (IOException iOException) {
            ((T4CConnection)this.connection).handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(iOException).fillInStackTrace();
        }
        this.describedWithNames = true;
        this.described = true;
    }

    @Override
    void executeForDescribe() throws SQLException {
        this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CStatement.execute_for_describe");
        try {
            this.doOall8(true, true, this.definedColumnType != null, true, this.definedColumnType != null, this.getFirstRowInBatchForOALL8());
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (IOException iOException) {
            ((T4CConnection)this.connection).handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(iOException).fillInStackTrace();
        }
        finally {
            this.updateAfterDescribeAlways();
        }
        this.updateAfterDescribeWithoutError();
        for (int i2 = 0; i2 < this.numberOfDefinePositions; ++i2) {
            this.accessors[i2].initMetadata();
        }
        this.needToPrepareDefineBuffer = false;
    }

    private final void updateAfterDescribeAlways() throws SQLException {
        this.rowsProcessed = this.t4Connection.all8.rowsProcessed;
        this.validRows = this.t4Connection.all8.getNumRows();
        if (this.connection.checksumMode.needToCalculateFetchChecksum()) {
            if (this.validRows > 0L) {
                this.calculateCheckSum();
            } else if (this.rowsProcessed > 0L) {
                long l2;
                this.checkSum = l2 = CRC64.updateChecksum(this.checkSum, this.rowsProcessed);
            }
        }
    }

    private final void updateAfterDescribeWithoutError() throws SQLException {
        this.needToParse = false;
        if (this.definedColumnType == null) {
            this.implicitDefineForLobPrefetchDone = false;
        }
        this.aFetchWasDoneDuringDescribe = false;
        if (this.t4Connection.all8.aFetchWasDone) {
            this.aFetchWasDoneDuringDescribe = true;
            this.rowPrefetchInLastFetch = this.rowPrefetch;
        }
    }

    @Override
    void executeForRows(boolean bl) throws SQLException {
        try {
            try {
                boolean bl2 = this.prepareForExecuteForRows();
                this.doOall8(this.needToParse, !bl, true, false, bl2, this.getFirstRowInBatchForOALL8());
                this.handleExecuteForRowsCompletion(bl2);
            }
            finally {
                this.handleExecuteForRowsCompletionAlways();
            }
        }
        catch (IOException iOException) {
            ((T4CConnection)this.connection).handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(iOException).fillInStackTrace();
        }
    }

    private final boolean prepareForExecuteForRows() throws SQLException {
        if (this.columnsDefinedByUser) {
            this.needToPrepareDefineBuffer = false;
            return false;
        }
        return this.prepareLobDefinesForExecution();
    }

    private final void handleExecuteForRowsCompletionAlways() throws SQLException {
        this.validRows = this.implicitResultSetStatements == null ? this.t4Connection.all8.getNumRows() : 0L;
        this.calculateCheckSum();
    }

    private final void handleExecuteForRowsCompletion(boolean bl) {
        this.needToParse = false;
        if (bl) {
            this.implicitDefineForLobPrefetchDone = true;
        }
    }

    private final boolean prepareLobDefinesForExecution() throws SQLException {
        if (!this.t4Connection.useLobPrefetch || this.accessors == null || this.defaultLobPrefetchSize == -1 || this.implicitDefineForLobPrefetchDone || this.aFetchWasDoneDuringDescribe || this.definedColumnType != null) {
            return false;
        }
        boolean bl = false;
        int[] nArray = new int[this.accessors.length];
        int[] nArray2 = new int[this.accessors.length];
        int[] nArray3 = new int[this.accessors.length];
        for (int i2 = 0; i2 < this.accessors.length; ++i2) {
            if (this.accessors[i2] == null) continue;
            nArray[i2] = this.getJDBCType(this.accessors[i2].internalType);
            nArray3[i2] = this.accessors[i2].formOfUse;
            if (this.accessors[i2].internalType == 113 || this.accessors[i2].internalType == 112 || this.accessors[i2].internalType == 114) {
                bl = true;
                this.accessors[i2].setPrefetchLength(this.defaultLobPrefetchSize);
                nArray2[i2] = this.defaultLobPrefetchSize;
                continue;
            }
            if (this.accessors[i2].internalType != 119) continue;
            bl = true;
            this.accessors[i2].setPrefetchLength(0x2000000);
            nArray2[i2] = 0x2000000;
        }
        if (bl) {
            this.definedColumnType = nArray;
            this.definedColumnSize = nArray2;
            this.definedColumnFormOfUse = nArray3;
            return true;
        }
        return false;
    }

    @Override
    protected void fetch(int n2, boolean bl) throws SQLException {
        if (!bl) {
            this.setRowDataPositionBeforeFetch();
        }
        this.releaseStreamsBeforeFetch();
        boolean bl2 = this.prepareLobDefinesForExecution();
        try {
            this.doOall8(false, false, true, false, bl2, n2);
            this.handleFetchCompletion(bl2, n2);
        }
        catch (IOException iOException) {
            ((T4CConnection)this.connection).handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(iOException).fillInStackTrace();
        }
    }

    private final void setRowDataPositionBeforeFetch() {
        if (this.rowData != null) {
            this.beyondRowData = this.bindUseDBA ? this.beyondBindData : 0L;
        }
    }

    private final void releaseStreamsBeforeFetch() throws SQLException {
        if (this.streamList != null) {
            while (this.nextStream != null) {
                try {
                    this.nextStream.close();
                }
                catch (IOException iOException) {
                    ((T4CConnection)this.connection).handleIOException(iOException);
                    throw (SQLException)DatabaseError.createSqlException(iOException).fillInStackTrace();
                }
                this.nextStream = this.nextStream.nextStream;
            }
        }
    }

    private final void handleFetchCompletion(boolean bl, int n2) throws SQLException {
        if (bl) {
            this.implicitDefineForLobPrefetchDone = true;
        }
        this.validRows = this.t4Connection.all8.getNumRows();
        if (this.validRows != -2L) {
            this.validRows -= (long)n2;
        }
        this.beyondRowData = Math.max(this.beyondRowData, this.rowData.getPosition());
        this.calculateCheckSum();
    }

    @Override
    void continueReadRow(int n2) throws SQLException {
        try {
            if (!this.isFetchStreams) {
                T4C8Oall t4C8Oall = this.t4Connection.all8;
                t4C8Oall.continueReadRow(n2, this);
                this.beyondRowData = Math.max(this.beyondRowData, this.rowData.getPosition());
            }
        }
        catch (IOException iOException) {
            ((T4CConnection)this.connection).handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(iOException).fillInStackTrace();
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == DatabaseError.getVendorCode(110)) {
                this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 110);
            }
            throw sQLException;
        }
    }

    @Override
    void doClose() throws SQLException {
        this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CStatement.do_close");
        if (this.cursorId != 0) {
            this.t4Connection.closeCursor(this.cursorId);
        }
        this.tmpByteArray = null;
        this.tmpBindsByteArray = null;
        this.definedColumnType = null;
        this.definedColumnSize = null;
        this.definedColumnFormOfUse = null;
        this.oacdefSent = null;
    }

    @Override
    void closeQuery() throws SQLException {
        this.connection.needLine();
        this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CStatement.closeQuery");
        if (this.streamList != null) {
            while (this.nextStream != null) {
                try {
                    this.nextStream.close();
                }
                catch (IOException iOException) {
                    ((T4CConnection)this.connection).handleIOException(iOException);
                    throw (SQLException)DatabaseError.createSqlException(iOException).fillInStackTrace();
                }
                this.nextStream = this.nextStream.nextStream;
            }
        }
        if (!this.isAllFetched && this.cursorId != 0) {
            this.t4Connection.closeQuery(this.cursorId);
        }
    }

    @Override
    public byte[] getRuntimeKey() throws SQLException {
        if (this.md == null) {
            try {
                this.md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                return null;
            }
        } else {
            this.md.reset();
        }
        if (this.maxRows > 0L) {
            return null;
        }
        for (String string : this.nlsStrings) {
            String string2 = (String)this.connection.sessionProperties.get(string);
            if (string2 == null) continue;
            this.md.update(string2.getBytes(StandardCharsets.UTF_16));
        }
        if (this.t4Connection.currentSchema != null) {
            this.md.update(this.t4Connection.currentSchema.getBytes(StandardCharsets.UTF_16));
        }
        this.runtimeKey = this.md.digest();
        return this.runtimeKey;
    }

    T4CStatement(PhysicalConnection physicalConnection, @Blind(value=PropertiesBlinder.class) Properties properties) throws SQLException {
        super(physicalConnection, properties);
        this.nbPostPonedColumns = new int[1];
        this.nbPostPonedColumns[0] = 0;
        this.indexOfPostPonedColumn = new int[1][3];
        this.t4Connection = (T4CConnection)physicalConnection;
    }

    @Override
    void closeCursorOnPlainStatement() throws SQLException {
        if (this.cursorId != 0 && this.t4Connection.isLoggedOn()) {
            this.t4Connection.closeCursor(this.cursorId);
            this.setCursorId(0);
        }
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    static {
        try {
            $$$methodRef$$$42 = T4CStatement.class.getDeclaredConstructor(PhysicalConnection.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$41 = T4CStatement.class.getDeclaredMethod("closeCursorOnPlainStatement", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$40 = T4CStatement.class.getDeclaredMethod("getRuntimeKey", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = T4CStatement.class.getDeclaredMethod("closeQuery", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = T4CStatement.class.getDeclaredMethod("doClose", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = T4CStatement.class.getDeclaredMethod("continueReadRow", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = T4CStatement.class.getDeclaredMethod("handleFetchCompletion", Boolean.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = T4CStatement.class.getDeclaredMethod("releaseStreamsBeforeFetch", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = T4CStatement.class.getDeclaredMethod("setRowDataPositionBeforeFetch", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = T4CStatement.class.getDeclaredMethod("fetch", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = T4CStatement.class.getDeclaredMethod("prepareLobDefinesForExecution", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = T4CStatement.class.getDeclaredMethod("handleExecuteForRowsCompletion", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = T4CStatement.class.getDeclaredMethod("handleExecuteForRowsCompletionAlways", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = T4CStatement.class.getDeclaredMethod("prepareForExecuteForRows", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = T4CStatement.class.getDeclaredMethod("executeForRows", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = T4CStatement.class.getDeclaredMethod("updateAfterDescribeWithoutError", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = T4CStatement.class.getDeclaredMethod("updateAfterDescribeAlways", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = T4CStatement.class.getDeclaredMethod("executeForDescribe", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = T4CStatement.class.getDeclaredMethod("doDescribe", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = T4CStatement.class.getDeclaredMethod("allocateAccessor", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Short.TYPE, String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = T4CStatement.class.getDeclaredMethod("allocateRowDataSpace", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = T4CStatement.class.getDeclaredMethod("locationToPutBytes", Accessor.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = T4CStatement.class.getDeclaredMethod("configureRowData", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = T4CStatement.class.getDeclaredMethod("doSetSnapshotSCN", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = T4CStatement.class.getDeclaredMethod("clearDefines", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = T4CStatement.class.getDeclaredMethod("defineColumnTypeInternal", Integer.TYPE, Integer.TYPE, Integer.TYPE, Short.TYPE, Boolean.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = T4CStatement.class.getDeclaredMethod("reparseOnRedefineIfNeeded", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = T4CStatement.class.getDeclaredMethod("allocateRowidAccessor", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = T4CStatement.class.getDeclaredMethod("releaseBuffers", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = T4CStatement.class.getDeclaredMethod("allocateTmpByteArray", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = T4CStatement.class.getDeclaredMethod("handleOALL8CompletionAlways", T4C8Oall.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = T4CStatement.class.getDeclaredMethod("handleOALL8Failure", SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = T4CStatement.class.getDeclaredMethod("getDefinedColumnFormsOfUseForOALL8", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = T4CStatement.class.getDeclaredMethod("getDefinedColumnSizesForOALL8", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = T4CStatement.class.getDeclaredMethod("getDefinedColumnTypesForOALL8", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = T4CStatement.class.getDeclaredMethod("getNumberOfDefinePositionsForOALL8", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = T4CStatement.class.getDeclaredMethod("initializeOALL8", Boolean.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T4CStatement.class.getDeclaredMethod("prepareBindsByteArrayForOALL8", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4CStatement.class.getDeclaredMethod("prepareAccessorRowCountsForOALL8", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4CStatement.class.getDeclaredMethod("getMaximumRowFetchForOALL8", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4CStatement.class.getDeclaredMethod("prepareForOALL8", Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CStatement.class.getDeclaredMethod("doOall8", Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CStatement.class.getDeclaredMethod("getFirstRowInBatchForOALL8", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        parameterDatum = null;
        parameterOtype = null;
        EMPTY_BYTE = new byte[0];
    }
}

