/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.internal;

import java.lang.reflect.Executable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Logger;

public final class CompletionStageUtil {
    public static final CompletableFuture<Void> VOID_COMPLETED_FUTURE;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;

    private CompletionStageUtil() {
    }

    public static void acceptCompletion(CompletionHandler completionHandler) {
        try {
            completionHandler.handle();
        }
        catch (Exception exception) {
            throw new CompletionException(exception);
        }
    }

    public static <T> T handleCompletion(T t2, Throwable throwable, CompletionHandler completionHandler) {
        CompletionStageUtil.acceptCompletion(completionHandler);
        if (throwable == null) {
            return t2;
        }
        if (throwable instanceof CompletionException) {
            throw (CompletionException)throwable;
        }
        throw new CompletionException(throwable);
    }

    public static <T> BiFunction<T, Throwable, T> completionHandler(CompletionHandler completionHandler) {
        return (object, throwable) -> CompletionStageUtil.handleCompletion(object, throwable, completionHandler);
    }

    public static <T, U> U handleNormalCompletion(T t2, NormalCompletionHandler<T, U> normalCompletionHandler) {
        try {
            return normalCompletionHandler.handle(t2);
        }
        catch (Exception exception) {
            throw new CompletionException(exception);
        }
    }

    public static <T, U> U handleNormalCompletion(T t2, Throwable throwable, NormalCompletionHandler<T, U> normalCompletionHandler) {
        if (throwable == null) {
            return CompletionStageUtil.handleNormalCompletion(t2, normalCompletionHandler);
        }
        if (throwable instanceof CompletionException) {
            throw (CompletionException)throwable;
        }
        throw new CompletionException(throwable);
    }

    public static <T, U> Function<T, U> normalCompletionHandler(NormalCompletionHandler<T, U> normalCompletionHandler) {
        return object -> CompletionStageUtil.handleNormalCompletion(object, normalCompletionHandler);
    }

    public static <E extends Throwable, T> T handleExceptionalCompletion(Throwable throwable, Class<E> clazz, ExceptionalCompletionHandler<? super E, ? extends T> exceptionalCompletionHandler) {
        if (throwable == null) {
            return null;
        }
        Throwable throwable2 = CompletionStageUtil.unwrapCompletionException(throwable);
        if (clazz.isInstance(throwable2)) {
            try {
                return exceptionalCompletionHandler.handle(throwable2);
            }
            catch (Exception exception) {
                throw new CompletionException(exception);
            }
        }
        throw new CompletionException(throwable2);
    }

    public static <E extends Throwable, T> Function<Throwable, T> exceptionalCompletionHandler(Class<E> clazz, ExceptionalCompletionHandler<? super E, T> exceptionalCompletionHandler) {
        return throwable -> CompletionStageUtil.handleExceptionalCompletion(throwable, clazz, exceptionalCompletionHandler);
    }

    public static <T, E extends Throwable, U> U handleCompletion(T t2, NormalCompletionHandler<? super T, U> normalCompletionHandler, Throwable throwable, Class<E> clazz, ExceptionalCompletionHandler<? super E, ? extends U> exceptionalCompletionHandler) {
        return throwable == null ? CompletionStageUtil.handleNormalCompletion(t2, normalCompletionHandler) : CompletionStageUtil.handleExceptionalCompletion(throwable, clazz, exceptionalCompletionHandler);
    }

    public static <T, E extends Throwable, U> BiFunction<T, Throwable, U> completionHandler(NormalCompletionHandler<T, U> normalCompletionHandler, Class<E> clazz, ExceptionalCompletionHandler<? super E, U> exceptionalCompletionHandler) {
        return (object, throwable) -> CompletionStageUtil.handleCompletion(object, normalCompletionHandler, throwable, clazz, exceptionalCompletionHandler);
    }

    public static Throwable unwrapCompletionException(Throwable throwable) {
        if (throwable instanceof CompletionException) {
            return throwable.getCause();
        }
        return throwable;
    }

    public static <T> CompletionStage<T> completedStage(T t2) {
        return CompletableFuture.completedFuture(t2);
    }

    public static <T> CompletionStage<T> failedStage(Throwable throwable) {
        CompletableFuture completableFuture = new CompletableFuture();
        completableFuture.completeExceptionally(throwable);
        return completableFuture;
    }

    public static void callOnComplete(CompletionStage<Void> completionStage, Consumer<Throwable> consumer) {
        CompletionStageUtil.callOnComplete(completionStage, (T void_, Throwable throwable) -> consumer.accept((Throwable)throwable));
    }

    public static <T> void callOnComplete(CompletionStage<T> completionStage, BiConsumer<T, Throwable> biConsumer) {
        CompletableFuture<T> completableFuture = completionStage.toCompletableFuture();
        if (completableFuture.isDone() && !completableFuture.isCompletedExceptionally()) {
            biConsumer.accept(completableFuture.join(), null);
        } else {
            completableFuture.whenComplete((BiConsumer)biConsumer);
        }
    }

    public static <T extends Throwable> T suppress(T t2, Throwable throwable) {
        if (throwable != null) {
            t2.addSuppressed(throwable);
        }
        return t2;
    }

    static {
        try {
            $$$methodRef$$$21 = CompletionStageUtil.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = CompletionStageUtil.class.getDeclaredMethod("lambda$completionHandler$0", CompletionHandler.class, Object.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = CompletionStageUtil.class.getDeclaredMethod("lambda$normalCompletionHandler$1", NormalCompletionHandler.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = CompletionStageUtil.class.getDeclaredMethod("lambda$exceptionalCompletionHandler$2", Class.class, ExceptionalCompletionHandler.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = CompletionStageUtil.class.getDeclaredMethod("lambda$completionHandler$3", NormalCompletionHandler.class, Class.class, ExceptionalCompletionHandler.class, Object.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = CompletionStageUtil.class.getDeclaredMethod("lambda$callOnComplete$4", Consumer.class, Void.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = CompletionStageUtil.class.getDeclaredMethod("suppress", Throwable.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = CompletionStageUtil.class.getDeclaredMethod("callOnComplete", CompletionStage.class, BiConsumer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = CompletionStageUtil.class.getDeclaredMethod("callOnComplete", CompletionStage.class, Consumer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = CompletionStageUtil.class.getDeclaredMethod("failedStage", Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = CompletionStageUtil.class.getDeclaredMethod("completedStage", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = CompletionStageUtil.class.getDeclaredMethod("unwrapCompletionException", Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = CompletionStageUtil.class.getDeclaredMethod("completionHandler", NormalCompletionHandler.class, Class.class, ExceptionalCompletionHandler.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = CompletionStageUtil.class.getDeclaredMethod("handleCompletion", Object.class, NormalCompletionHandler.class, Throwable.class, Class.class, ExceptionalCompletionHandler.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = CompletionStageUtil.class.getDeclaredMethod("exceptionalCompletionHandler", Class.class, ExceptionalCompletionHandler.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = CompletionStageUtil.class.getDeclaredMethod("handleExceptionalCompletion", Throwable.class, Class.class, ExceptionalCompletionHandler.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = CompletionStageUtil.class.getDeclaredMethod("normalCompletionHandler", NormalCompletionHandler.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = CompletionStageUtil.class.getDeclaredMethod("handleNormalCompletion", Object.class, Throwable.class, NormalCompletionHandler.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = CompletionStageUtil.class.getDeclaredMethod("handleNormalCompletion", Object.class, NormalCompletionHandler.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = CompletionStageUtil.class.getDeclaredMethod("completionHandler", CompletionHandler.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = CompletionStageUtil.class.getDeclaredMethod("handleCompletion", Object.class, Throwable.class, CompletionHandler.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = CompletionStageUtil.class.getDeclaredMethod("acceptCompletion", CompletionHandler.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        VOID_COMPLETED_FUTURE = CompletableFuture.completedFuture(null);
    }

    @FunctionalInterface
    public static interface ExceptionalCompletionHandler<E extends Throwable, T>
    extends Function<E, T> {
        public T handle(E var1) throws Exception;

        @Override
        default public T apply(E e2) {
            try {
                return this.handle(e2);
            }
            catch (Exception exception) {
                throw new CompletionException(exception);
            }
        }
    }

    @FunctionalInterface
    public static interface NormalCompletionHandler<T, U>
    extends Function<T, U> {
        public U handle(T var1) throws Exception;

        @Override
        default public U apply(T t2) {
            try {
                return this.handle(t2);
            }
            catch (Exception exception) {
                throw new CompletionException(exception);
            }
        }
    }

    @FunctionalInterface
    public static interface CompletionHandler
    extends Runnable {
        public void handle() throws Exception;

        @Override
        default public void run() {
            try {
                this.handle();
            }
            catch (Exception exception) {
                throw new CompletionException(exception);
            }
        }
    }
}

