/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.Executable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import jdk.net.Sockets;
import oracle.jdbc.diagnostics.SecuredLogger;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.NetStat;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.nt.AsyncOutboundTimeoutHandler;
import oracle.net.nt.DownHostsCache;
import oracle.net.nt.MetricsEnabledSocketFactory;
import oracle.net.nt.NTAdapter;
import oracle.net.nt.NetStatImpl;
import oracle.net.nt.SocketChannelWrapper;
import oracle.net.nt.TcpMultiplexer;
import oracle.net.nt.TimeoutInterruptHandler;
import oracle.net.nt.TimeoutSocketChannel;

public class TcpNTAdapter
implements NTAdapter {
    static final boolean DEBUG = false;
    private static final int[] SUPPORTED_SOCKET_OPTIONS;
    private static Proxy DEFAULT_SOCKS_PROXY;
    protected final SecuredLogger securedLogger;
    private final String addressInfo;
    NetStatImpl netStat = null;
    Boolean useNio;
    int port;
    String host;
    String protocol;
    String uri;
    NVNavigator nav;
    NVPair nvpAddr;
    protected SocketChannelWrapper socketChannel;
    Iterator<InetAddress> inetAddresses = null;
    protected Socket socket;
    protected int sockTimeout;
    protected final Properties socketOptions;
    protected Proxy proxy = null;
    protected boolean isRemoteDNS = true;
    protected int connectTimeout = 0;
    SocketFactory sockFactory;
    private volatile boolean isRegisteredEver = false;
    private static Hashtable<String, InetAddress[]> inetaddressesCache;
    private static Hashtable<String, Integer> circularOffsets;
    private static final Monitor CIRCULAR_OFFSETS_MONITOR;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;

    public TcpNTAdapter(String string, @Blind(value=PropertiesBlinder.class) Properties properties) throws NLException {
        this.socketOptions = properties;
        this.addressInfo = string;
        this.useNio = Boolean.parseBoolean((String)properties.get(20));
        this.isRemoteDNS = Boolean.parseBoolean((String)properties.getOrDefault((Object)39, "false"));
        this.connectTimeout = Integer.parseInt((String)properties.getOrDefault((Object)2, "0"));
        this.securedLogger = null;
        this.netStat = new NetStatImpl();
        this.initializeAddressValues(string);
        this.initializeProxy();
    }

    private void initializeAddressValues(String string) throws NLException {
        this.nav = new NVNavigator();
        this.nvpAddr = new NVFactory().createNVPair(string);
        NVPair nVPair = this.nav.findNVPair(this.nvpAddr, "HOST");
        NVPair nVPair2 = this.nav.findNVPair(this.nvpAddr, "PORT");
        NVPair nVPair3 = this.nav.findNVPair(this.nvpAddr, "PROTOCOL");
        if (nVPair == null) {
            throw new NLException("NoNVPair-04614", "HOST");
        }
        this.host = nVPair.getAtom();
        if (nVPair2 != null) {
            try {
                this.port = Integer.parseInt(nVPair2.getAtom());
            }
            catch (Exception exception) {
                throw (NLException)new NLException(new NetException(116).getMessage()).initCause(exception);
            }
        } else {
            this.port = 1521;
        }
        if (this.port < 0 || this.port > 65535) {
            throw new NLException(new NetException(116).getMessage());
        }
        if (nVPair3 != null) {
            this.protocol = nVPair3.getAtom();
        }
    }

    protected void initializeProxy() {
        this.proxy = this.socketOptions.containsKey(36) && this.socketOptions.containsKey(37) ? new Proxy(Proxy.Type.SOCKS, new InetSocketAddress((String)this.socketOptions.get(36), Integer.parseInt((String)this.socketOptions.get(37)))) : DEFAULT_SOCKS_PROXY;
    }

    @Override
    public void connect(DMSFactory.DMSNoun dMSNoun) throws IOException, InterruptedIOException {
        this.sockFactory = new MetricsEnabledSocketFactory(dMSNoun);
        if (this.isRemoteDNS && this.proxy != null) {
            this.doRemoteDNSLookupConnect(dMSNoun);
        } else {
            this.doLocalDNSLookupConnect(dMSNoun);
        }
        this.setSocketOptions();
    }

    protected void doLocalDNSLookupConnect(DMSFactory.DMSNoun dMSNoun) throws IOException, InterruptedIOException {
        if (this.inetAddresses == null) {
            this.inetAddresses = this.resolveInetAddresses();
        }
        while (true) {
            InetAddress inetAddress = this.inetAddresses.next();
            try {
                this.establishSocket(new InetSocketAddress(inetAddress, this.port), dMSNoun);
            }
            catch (InterruptedIOException interruptedIOException) {
                DownHostsCache.getInstance().markDownHost(inetAddress, this.port);
                throw interruptedIOException;
            }
            catch (IOException iOException) {
                DownHostsCache.getInstance().markDownHost(inetAddress, this.port);
                if (this.inetAddresses.hasNext()) continue;
                this.resetInetAddress();
                throw iOException;
                if (this.inetAddresses.hasNext()) continue;
            }
            break;
        }
    }

    protected void doRemoteDNSLookupConnect(DMSFactory.DMSNoun dMSNoun) throws IOException, InterruptedIOException {
        InetSocketAddress inetSocketAddress = InetSocketAddress.createUnresolved(this.host, this.port);
        this.establishSocket(inetSocketAddress, dMSNoun);
    }

    protected void establishSocket(InetSocketAddress inetSocketAddress, DMSFactory.DMSNoun dMSNoun) throws IOException, InterruptedIOException {
        long l2 = System.currentTimeMillis();
        try {
            if (this.useNio.booleanValue()) {
                this.socketChannel = new TimeoutSocketChannel(inetSocketAddress, this.connectTimeout, this.netStat, this.proxy, this.securedLogger);
                this.socket = this.socketChannel.socket();
            } else {
                this.socket = this.sockFactory.createSocket();
                this.socket.connect(inetSocketAddress, this.connectTimeout);
            }
            this.setReadTimeoutIfRequired(this.socketOptions);
        }
        catch (TimeoutInterruptHandler.IOReadTimeoutException iOReadTimeoutException) {
            this.trySocketClose();
            throw new IOException(this.describeConnectionFailure(iOReadTimeoutException, l2, inetSocketAddress), iOReadTimeoutException);
        }
        catch (InterruptedIOException interruptedIOException) {
            this.trySocketClose();
            InterruptedIOException interruptedIOException2 = new InterruptedIOException(this.describeConnectionFailure(interruptedIOException, l2, inetSocketAddress));
            interruptedIOException2.initCause(interruptedIOException);
            throw interruptedIOException2;
        }
        catch (IOException iOException) {
            this.trySocketClose();
            throw new IOException(this.describeConnectionFailure(iOException, l2, inetSocketAddress), iOException);
        }
    }

    private void trySocketClose() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String describeConnectionFailure(IOException iOException, long l2, InetSocketAddress inetSocketAddress) {
        return String.format("%s, socket connect lapse %d ms. %s %d %s %s %s %s", iOException.getMessage(), System.currentTimeMillis() - l2, inetSocketAddress.getHostString(), this.port, this.proxy == null ? "" : "Proxy = " + this.proxy.toString(), this.connectTimeout, this.inetAddresses, this.useNio);
    }

    @Override
    public CompletionStage<Void> connectAsync(DMSFactory.DMSNoun dMSNoun, AsyncOutboundTimeoutHandler asyncOutboundTimeoutHandler, Executor executor) {
        if (!this.useNio.booleanValue()) {
            return CompletionStageUtil.failedStage(new IOException("Asynchronous connection is not supported when oracle.jdbc.javaNetNio=false"));
        }
        if (this.proxy != null) {
            return CompletionStageUtil.failedStage(new IOException("Asynchronous connection is not supported with proxies"));
        }
        this.sockFactory = new MetricsEnabledSocketFactory(dMSNoun);
        try {
            if (this.inetAddresses == null) {
                this.inetAddresses = this.resolveInetAddresses();
            }
        }
        catch (UnknownHostException unknownHostException) {
            return CompletionStageUtil.failedStage(unknownHostException);
        }
        return this.chainAsyncConnectionAttempts(asyncOutboundTimeoutHandler, executor).thenApply(CompletionStageUtil.normalCompletionHandler(void_ -> {
            this.setSocketOptions();
            return void_;
        }));
    }

    private final CompletionStage<Void> chainAsyncConnectionAttempts(AsyncOutboundTimeoutHandler asyncOutboundTimeoutHandler, Executor executor) {
        InetAddress inetAddress = this.inetAddresses.next();
        InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, this.port);
        long l2 = System.currentTimeMillis();
        this.netStat = new NetStatImpl();
        return TimeoutSocketChannel.openAsync(inetSocketAddress, this.connectTimeout, this.netStat, this.securedLogger, asyncOutboundTimeoutHandler, executor).thenApply(CompletionStageUtil.normalCompletionHandler(timeoutSocketChannel -> {
            this.socketChannel = timeoutSocketChannel;
            this.socket = this.socketChannel.socket();
            this.setReadTimeoutIfRequired(this.socketOptions);
            return true;
        })).exceptionally(CompletionStageUtil.exceptionalCompletionHandler(IOException.class, iOException -> {
            this.trySocketClose();
            DownHostsCache.getInstance().markDownHost(inetAddress, this.port);
            if (this.inetAddresses.hasNext()) {
                return false;
            }
            String string = this.describeConnectionFailure((IOException)iOException, l2, inetSocketAddress);
            this.resetInetAddress();
            IOException iOException2 = new IOException(string, iOException);
            throw iOException2;
        })).thenCompose(bl -> bl != false ? CompletionStageUtil.VOID_COMPLETED_FUTURE : this.chainAsyncConnectionAttempts(asyncOutboundTimeoutHandler, executor));
    }

    protected final Iterator<InetAddress> resolveInetAddresses() throws UnknownHostException {
        InetAddress[] inetAddressArray = InetAddress.getAllByName(this.host);
        boolean bl = Boolean.parseBoolean((String)this.socketOptions.get(18));
        if (bl && inetAddressArray.length > 1) {
            inetAddressArray = TcpNTAdapter.getAddressesInCircularOrder(this.host, inetAddressArray);
        }
        DownHostsCache.getInstance().reorderAddresses(inetAddressArray, this.port);
        return new InetAddressIterator(inetAddressArray);
    }

    @Override
    public final boolean hasMoreInetAddresses() {
        return this.inetAddresses != null && this.inetAddresses.hasNext();
    }

    @Override
    public final void resetInetAddress() {
        this.inetAddresses = null;
    }

    @Override
    public NetStat getNetStat() {
        return this.netStat;
    }

    final void setSocketOptions() throws IOException {
        for (int n2 : SUPPORTED_SOCKET_OPTIONS) {
            Integer n3 = n2;
            String string = (String)this.socketOptions.get(n3);
            if (string == null) continue;
            this.setOption(n2, string);
        }
    }

    @Override
    public void disconnect() throws IOException {
        try {
            if (this.useNio.booleanValue()) {
                this.socketChannel.disconnect();
            } else if (this.socket != null && !this.socket.isClosed()) {
                this.socket.close();
            }
        }
        finally {
            this.socket = null;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    @Override
    public void setOption(int n2, Object object) throws IOException, NetException {
        if (this.isClosed()) {
            throw new NetException(200);
        }
        switch (n2) {
            case 0: {
                this.setTcpNoDelay((String)object);
                break;
            }
            case 1: {
                this.setTcpKeepAlive((String)object);
                break;
            }
            case 3: 
            case 101: {
                this.setTcpReadTimeout((String)object);
                break;
            }
            case 33: {
                this.setTcpKeepAliveIdleTime((String)object);
                break;
            }
            case 34: {
                this.setTcpKeepAliveProbeInterval((String)object);
                break;
            }
            case 35: {
                this.setTcpKeepAliveProbeCount((String)object);
                break;
            }
        }
    }

    private final void setTcpNoDelay(String string) throws IOException {
        this.socket.setTcpNoDelay(string.equals("YES"));
    }

    private final void setTcpKeepAlive(String string) throws IOException {
        if (string.equals("YES")) {
            this.socket.setKeepAlive(true);
        }
    }

    private final void setTcpReadTimeout(String string) throws IOException {
        this.sockTimeout = Integer.parseInt(string);
        if (!this.useNio.booleanValue()) {
            this.socket.setSoTimeout(this.sockTimeout);
        } else {
            this.socketChannel.setSoTimeout(this.sockTimeout);
        }
    }

    private final void setTcpKeepAliveIdleTime(String string) throws IOException {
        this.setSocketOption(this.getSocketOptionByNameAndType("TCP_KEEPIDLE", Integer.class), Integer.valueOf(string));
    }

    private final void setTcpKeepAliveProbeInterval(String string) throws IOException {
        this.setSocketOption(this.getSocketOptionByNameAndType("TCP_KEEPINTERVAL", Integer.class), Integer.valueOf(string));
    }

    private final void setTcpKeepAliveProbeCount(String string) throws IOException {
        this.setSocketOption(this.getSocketOptionByNameAndType("TCP_KEEPCOUNT", Integer.class), Integer.valueOf(string));
    }

    private final <T> SocketOption<T> getSocketOptionByNameAndType(String string, Class<T> clazz) throws IOException {
        Set<SocketOption<?>> set = this.useNio != false ? this.socketChannel.supportedOptions() : Sockets.supportedOptions(this.socket.getClass());
        SocketOption socketOption2 = set.stream().filter(socketOption -> string.equals(socketOption.name())).findFirst().orElseThrow(() -> new IOException("Socket option " + string + " is not supported by SocketChannels opened in this JVM"));
        if (!socketOption2.type().equals(clazz)) {
            throw new IOException("Unexpected type for socket option " + string + ". SocketOption.type() to returns " + socketOption2.type() + " Expected type is: " + clazz);
        }
        return socketOption2;
    }

    private final <T> void setSocketOption(SocketOption<T> socketOption, T t2) throws IOException {
        if (this.useNio.booleanValue()) {
            this.socketChannel.setOption((SocketOption)socketOption, (Object)t2);
        } else {
            Sockets.setOption(this.socket, socketOption, t2);
        }
    }

    @Override
    public Object getOption(int n2) throws IOException, NetException {
        if (this.isClosed()) {
            throw new NetException(200);
        }
        switch (n2) {
            case 101: {
                return "" + this.sockTimeout;
            }
            case 3: {
                if (!this.useNio.booleanValue()) {
                    return Integer.toString(this.socket.getSoTimeout());
                }
                return this.socketChannel.getSoTimeout();
            }
        }
        return null;
    }

    @Override
    public void abort() throws NetException, IOException {
        if (this.socket != null) {
            try {
                this.socket.setSoLinger(true, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.socket.close();
        }
        this.abortTcpMultiplexerRegistration();
    }

    private final void abortTcpMultiplexerRegistration() {
        if (!this.useNio.booleanValue()) {
            return;
        }
        if (this.socketChannel == null) {
            return;
        }
        if (!this.isRegisteredEver) {
            return;
        }
        this.cancelNonBlockingRegistration(new IOException("Connection aborted"));
    }

    @Override
    public void sendUrgentByte(int n2) throws IOException {
        this.socket.sendUrgentData(n2);
    }

    @Override
    public boolean isCharacteristicUrgentSupported() throws IOException {
        try {
            return !this.socket.getOOBInline();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public void setReadTimeoutIfRequired(@Blind(value=PropertiesBlinder.class) Properties properties) throws IOException, NetException {
        String string = (String)properties.get("oracle.net.READ_TIMEOUT");
        if (string == null) {
            string = (String)properties.get(3);
        }
        if (string == null) {
            string = "0";
        }
        this.setOption(3, string);
    }

    public String getAddressInfo() {
        return this.addressInfo;
    }

    @DisableTrace
    public String toString() {
        return "host=" + this.host + ", port=" + this.port + "\n    socket_timeout=" + this.sockTimeout + ", socketOptions=" + this.socketOptions.toString() + "\n    socket=" + this.socket;
    }

    static final InetAddress[] getAddressesInCircularOrder(String string, InetAddress[] inetAddressArray) {
        try (Monitor.CloseableLock closeableLock = CIRCULAR_OFFSETS_MONITOR.acquireCloseableLock();){
            InetAddress[] inetAddressArray2 = inetaddressesCache.get(string);
            Integer n2 = circularOffsets.get(string);
            if (inetAddressArray2 == null || !TcpNTAdapter.areEquals(inetAddressArray2, inetAddressArray)) {
                n2 = new Integer(0);
                inetAddressArray2 = inetAddressArray;
                inetaddressesCache.put(string, inetAddressArray);
                circularOffsets.put(string, n2);
            }
            InetAddress[] inetAddressArray3 = TcpNTAdapter.getCopyAddresses(inetAddressArray2, n2);
            circularOffsets.put(string, new Integer((n2 + 1) % inetAddressArray2.length));
            InetAddress[] inetAddressArray4 = inetAddressArray3;
            return inetAddressArray4;
        }
    }

    private static final boolean areEquals(InetAddress[] inetAddressArray, InetAddress[] inetAddressArray2) {
        if (inetAddressArray.length != inetAddressArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < inetAddressArray.length; ++i2) {
            if (inetAddressArray[i2].equals(inetAddressArray2[i2])) continue;
            return false;
        }
        return true;
    }

    private static final InetAddress[] getCopyAddresses(InetAddress[] inetAddressArray, int n2) {
        InetAddress[] inetAddressArray2 = new InetAddress[inetAddressArray.length];
        for (int i2 = 0; i2 < inetAddressArray.length; ++i2) {
            inetAddressArray2[i2] = inetAddressArray[(i2 + n2) % inetAddressArray.length];
        }
        return inetAddressArray2;
    }

    private final boolean isClosed() {
        if (this.socket == null) {
            return true;
        }
        return this.socket.isClosed();
    }

    @Override
    public boolean isConnectionSocketKeepAlive() throws SocketException {
        return this.socket.getKeepAlive();
    }

    @Override
    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    @Override
    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    @Override
    public NTAdapter.NetworkAdapterType getNetworkAdapterType() {
        return NTAdapter.NetworkAdapterType.TCP;
    }

    @Override
    public final void registerForNonBlockingRead(Consumer<Throwable> consumer) throws IOException {
        this.isRegisteredEver = true;
        this.socketChannel.registerForNonBlockingRead(consumer);
    }

    @Override
    public final void registerForNonBlockingWrite(Consumer<Throwable> consumer) throws IOException {
        this.isRegisteredEver = true;
        this.socketChannel.registerForNonBlockingWrite(consumer);
    }

    @Override
    public final void cancelNonBlockingRegistration(Throwable throwable) {
        TcpMultiplexer.cancelRegistration(this.socketChannel.getUnderlyingChannel(), throwable);
    }

    static {
        try {
            $$$methodRef$$$51 = TcpNTAdapter.class.getDeclaredConstructor(String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$50 = TcpNTAdapter.class.getDeclaredMethod("lambda$connectAsync$0", Void.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$49 = TcpNTAdapter.class.getDeclaredMethod("lambda$chainAsyncConnectionAttempts$1", TimeoutSocketChannel.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$48 = TcpNTAdapter.class.getDeclaredMethod("lambda$chainAsyncConnectionAttempts$2", InetAddress.class, Long.TYPE, InetSocketAddress.class, IOException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$47 = TcpNTAdapter.class.getDeclaredMethod("lambda$chainAsyncConnectionAttempts$3", AsyncOutboundTimeoutHandler.class, Executor.class, Boolean.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$46 = TcpNTAdapter.class.getDeclaredMethod("lambda$getSocketOptionByNameAndType$4", String.class, SocketOption.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$45 = TcpNTAdapter.class.getDeclaredMethod("lambda$getSocketOptionByNameAndType$5", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$44 = TcpNTAdapter.class.getDeclaredMethod("cancelNonBlockingRegistration", Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$43 = TcpNTAdapter.class.getDeclaredMethod("registerForNonBlockingWrite", Consumer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$42 = TcpNTAdapter.class.getDeclaredMethod("registerForNonBlockingRead", Consumer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$41 = TcpNTAdapter.class.getDeclaredMethod("getNetworkAdapterType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$40 = TcpNTAdapter.class.getDeclaredMethod("getSocketChannel", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = TcpNTAdapter.class.getDeclaredMethod("getInetAddress", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = TcpNTAdapter.class.getDeclaredMethod("isConnectionSocketKeepAlive", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = TcpNTAdapter.class.getDeclaredMethod("isClosed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = TcpNTAdapter.class.getDeclaredMethod("getCopyAddresses", InetAddress[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = TcpNTAdapter.class.getDeclaredMethod("areEquals", InetAddress[].class, InetAddress[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = TcpNTAdapter.class.getDeclaredMethod("getAddressesInCircularOrder", String.class, InetAddress[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = TcpNTAdapter.class.getDeclaredMethod("getAddressInfo", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = TcpNTAdapter.class.getDeclaredMethod("setReadTimeoutIfRequired", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = TcpNTAdapter.class.getDeclaredMethod("isCharacteristicUrgentSupported", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = TcpNTAdapter.class.getDeclaredMethod("sendUrgentByte", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = TcpNTAdapter.class.getDeclaredMethod("abortTcpMultiplexerRegistration", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = TcpNTAdapter.class.getDeclaredMethod("abort", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = TcpNTAdapter.class.getDeclaredMethod("getOption", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = TcpNTAdapter.class.getDeclaredMethod("setSocketOption", SocketOption.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = TcpNTAdapter.class.getDeclaredMethod("getSocketOptionByNameAndType", String.class, Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = TcpNTAdapter.class.getDeclaredMethod("setTcpKeepAliveProbeCount", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = TcpNTAdapter.class.getDeclaredMethod("setTcpKeepAliveProbeInterval", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = TcpNTAdapter.class.getDeclaredMethod("setTcpKeepAliveIdleTime", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = TcpNTAdapter.class.getDeclaredMethod("setTcpReadTimeout", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = TcpNTAdapter.class.getDeclaredMethod("setTcpKeepAlive", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = TcpNTAdapter.class.getDeclaredMethod("setTcpNoDelay", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = TcpNTAdapter.class.getDeclaredMethod("setOption", Integer.TYPE, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = TcpNTAdapter.class.getDeclaredMethod("getOutputStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = TcpNTAdapter.class.getDeclaredMethod("getInputStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = TcpNTAdapter.class.getDeclaredMethod("disconnect", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = TcpNTAdapter.class.getDeclaredMethod("setSocketOptions", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = TcpNTAdapter.class.getDeclaredMethod("getNetStat", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = TcpNTAdapter.class.getDeclaredMethod("resetInetAddress", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = TcpNTAdapter.class.getDeclaredMethod("hasMoreInetAddresses", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = TcpNTAdapter.class.getDeclaredMethod("resolveInetAddresses", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = TcpNTAdapter.class.getDeclaredMethod("chainAsyncConnectionAttempts", AsyncOutboundTimeoutHandler.class, Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = TcpNTAdapter.class.getDeclaredMethod("connectAsync", DMSFactory.DMSNoun.class, AsyncOutboundTimeoutHandler.class, Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = TcpNTAdapter.class.getDeclaredMethod("describeConnectionFailure", IOException.class, Long.TYPE, InetSocketAddress.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = TcpNTAdapter.class.getDeclaredMethod("trySocketClose", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = TcpNTAdapter.class.getDeclaredMethod("establishSocket", InetSocketAddress.class, DMSFactory.DMSNoun.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = TcpNTAdapter.class.getDeclaredMethod("doRemoteDNSLookupConnect", DMSFactory.DMSNoun.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = TcpNTAdapter.class.getDeclaredMethod("doLocalDNSLookupConnect", DMSFactory.DMSNoun.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = TcpNTAdapter.class.getDeclaredMethod("connect", DMSFactory.DMSNoun.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = TcpNTAdapter.class.getDeclaredMethod("initializeProxy", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = TcpNTAdapter.class.getDeclaredMethod("initializeAddressValues", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        SUPPORTED_SOCKET_OPTIONS = new int[]{0, 1, 33, 34, 35};
        DEFAULT_SOCKS_PROXY = null;
        try {
            String string = System.getProperty("socksProxyHost", null);
            if (string != null) {
                DEFAULT_SOCKS_PROXY = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(string, Integer.parseInt(System.getProperty("socksProxyPort", "1080"))));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        inetaddressesCache = new Hashtable();
        circularOffsets = new Hashtable();
        CIRCULAR_OFFSETS_MONITOR = Monitor.newInstance();
    }

    private final class InetAddressIterator
    implements Iterator<InetAddress> {
        private final InetAddress[] addresses;
        private int addressIndex = 0;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;

        private InetAddressIterator(InetAddress[] inetAddressArray) {
            this.addresses = inetAddressArray;
        }

        @Override
        public boolean hasNext() {
            return this.addressIndex < this.addresses.length;
        }

        @Override
        public InetAddress next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.addresses[this.addressIndex++];
        }

        public String toString() {
            return "(" + this.addressIndex + "/" + this.addresses.length + ")";
        }

        static {
            try {
                $$$methodRef$$$5 = InetAddressIterator.class.getDeclaredConstructor(TcpNTAdapter.class, InetAddress[].class, 1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = InetAddressIterator.class.getDeclaredConstructor(TcpNTAdapter.class, InetAddress[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = InetAddressIterator.class.getDeclaredMethod("next", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = InetAddressIterator.class.getDeclaredMethod("toString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = InetAddressIterator.class.getDeclaredMethod("next", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = InetAddressIterator.class.getDeclaredMethod("hasNext", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

