/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.zone.ZoneRules;
import java.util.Calendar;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleTimestampWithTimeZone;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.OffsetDST;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMEZONETAB;
import oracle.sql.ZONEIDMAP;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.PRIMITIVE_DATUM})
public class TIMESTAMPTZ
extends Datum
implements OracleTimestampWithTimeZone {
    static final long serialVersionUID = 6708361144588335769L;
    static final Calendar CAL_GMT_US;
    static final TimeZone TIMEZONE_UTC;
    private static int HOUR_MILLISECOND;
    private static int MINUTE_MILLISECOND;
    private static int SECOND_MILLISECOND;
    private static int HOUR_SECOND;
    private static int MINUTE_SECOND;
    private static int OFFSET_HOUR;
    private static int OFFSET_MINUTE;
    private static byte REGIONIDBIT;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;
    private static Executable $$$methodRef$$$58;
    private static Logger $$$loggerRef$$$58;
    private static Executable $$$methodRef$$$59;
    private static Logger $$$loggerRef$$$59;
    private static Executable $$$methodRef$$$60;
    private static Logger $$$loggerRef$$$60;
    private static Executable $$$methodRef$$$61;
    private static Logger $$$loggerRef$$$61;
    private static Executable $$$methodRef$$$62;
    private static Logger $$$loggerRef$$$62;
    private static Executable $$$methodRef$$$63;
    private static Logger $$$loggerRef$$$63;
    private static Executable $$$methodRef$$$64;
    private static Logger $$$loggerRef$$$64;
    private static Executable $$$methodRef$$$65;
    private static Logger $$$loggerRef$$$65;
    private static Executable $$$methodRef$$$66;
    private static Logger $$$loggerRef$$$66;
    private static Executable $$$methodRef$$$67;
    private static Logger $$$loggerRef$$$67;
    private static Executable $$$methodRef$$$68;
    private static Logger $$$loggerRef$$$68;
    private static Executable $$$methodRef$$$69;
    private static Logger $$$loggerRef$$$69;
    private static Executable $$$methodRef$$$70;
    private static Logger $$$loggerRef$$$70;
    private static Executable $$$methodRef$$$71;
    private static Logger $$$loggerRef$$$71;
    private static Executable $$$methodRef$$$72;
    private static Logger $$$loggerRef$$$72;
    private static Executable $$$methodRef$$$73;
    private static Logger $$$loggerRef$$$73;
    private static Executable $$$methodRef$$$74;
    private static Logger $$$loggerRef$$$74;

    public TIMESTAMPTZ() {
        super(TIMESTAMPTZ.initTimestamptz());
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$59, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$59, null, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$59, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$59, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$59, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$59, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$59, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$59, null, throwable2);
            }
            throw throwable;
        }
    }

    public TIMESTAMPTZ(byte[] byArray) {
        super(byArray);
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$60, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$60, null, new Object[]{byArray});
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$60, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$60, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$60, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$60, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$60, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$60, null, throwable2);
            }
            throw throwable;
        }
    }

    public TIMESTAMPTZ(Connection connection, Date date) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, date));
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$61, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$61, null, connection, date);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$61, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$61, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$61, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$61, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$61, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$61, null, throwable2);
            }
            throw throwable;
        }
    }

    public TIMESTAMPTZ(Connection connection, Date date, Calendar calendar) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, date, calendar));
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$62, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$62, null, connection, date, calendar);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$62, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$62, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$62, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$62, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$62, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$62, null, throwable2);
            }
            throw throwable;
        }
    }

    public TIMESTAMPTZ(Connection connection, Time time) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, time));
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$63, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$63, null, connection, time);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$63, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$63, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$63, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$63, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$63, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$63, null, throwable2);
            }
            throw throwable;
        }
    }

    public TIMESTAMPTZ(Connection connection, Time time, Calendar calendar) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, time, calendar));
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$64, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$64, null, connection, time, calendar);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$64, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$64, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$64, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$64, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$64, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$64, null, throwable2);
            }
            throw throwable;
        }
    }

    public TIMESTAMPTZ(Connection connection, Timestamp timestamp) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, timestamp));
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$65, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$65, null, connection, timestamp);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$65, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$65, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$65, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$65, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$65, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$65, null, throwable2);
            }
            throw throwable;
        }
    }

    public TIMESTAMPTZ(Connection connection, Timestamp timestamp, Calendar calendar) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, timestamp, calendar));
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$66, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$66, null, connection, timestamp, calendar);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$66, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$66, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$66, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$66, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$66, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$66, null, throwable2);
            }
            throw throwable;
        }
    }

    public TIMESTAMPTZ(Connection connection, Timestamp timestamp, ZoneId zoneId) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, timestamp, zoneId));
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$67, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$67, null, connection, timestamp, zoneId);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$67, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$67, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$67, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$67, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$67, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$67, null, throwable2);
            }
            throw throwable;
        }
    }

    public TIMESTAMPTZ(Connection connection, DATE dATE) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, dATE));
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$68, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$68, null, connection, dATE);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$68, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$68, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$68, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$68, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$68, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$68, null, throwable2);
            }
            throw throwable;
        }
    }

    public TIMESTAMPTZ(Connection connection, String string) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, string));
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$69, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$69, null, connection, string);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$69, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$69, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$69, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$69, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$69, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$69, null, throwable2);
            }
            throw throwable;
        }
    }

    public TIMESTAMPTZ(Connection connection, String string, Calendar calendar) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, string, calendar));
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$70, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$70, null, connection, string, calendar);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$70, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$70, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$70, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$70, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$70, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$70, null, throwable2);
            }
            throw throwable;
        }
    }

    public TIMESTAMPTZ(OffsetDateTime offsetDateTime) throws SQLException {
        super(TIMESTAMPTZ.toBytes(offsetDateTime));
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$71, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$71, null, offsetDateTime);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$71, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$71, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$71, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$71, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$71, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$71, null, throwable2);
            }
            throw throwable;
        }
    }

    public TIMESTAMPTZ(ZonedDateTime zonedDateTime) throws SQLException {
        super(TIMESTAMPTZ.toBytes(zonedDateTime));
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$72, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$72, null, zonedDateTime);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$72, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$72, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$72, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$72, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$72, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$72, null, throwable2);
            }
            throw throwable;
        }
    }

    public TIMESTAMPTZ(Connection connection, LocalDateTime localDateTime) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, localDateTime));
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$73, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$73, null, connection, localDateTime);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$73, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$73, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$73, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$73, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$73, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$73, null, throwable2);
            }
            throw throwable;
        }
    }

    public TIMESTAMPTZ(OffsetTime offsetTime) throws SQLException {
        super(TIMESTAMPTZ.toBytes(offsetTime));
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$74, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$74, null, offsetTime);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$74, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$74, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$74, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$74, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$74, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$74, null, throwable2);
            }
            throw throwable;
        }
    }

    public static Date toDate(Connection connection, byte[] byArray) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$0, null, connection, byArray);
            }
            int[] nArray = new int[13];
            for (n2 = 0; n2 < 13; ++n2) {
                nArray[n2] = byArray[n2] & 0xFF;
            }
            n2 = TIMESTAMP.getJavaYear(nArray[0], nArray[1]);
            Calendar calendar = Calendar.getInstance();
            calendar.set(1, n2);
            calendar.set(2, nArray[2] - 1);
            calendar.set(5, nArray[3]);
            calendar.set(11, nArray[4] - 1);
            calendar.set(12, nArray[5] - 1);
            calendar.set(13, nArray[6] - 1);
            int n3 = TIMESTAMP.getNanos(byArray, 7) / 1000000;
            calendar.set(14, n3);
            if ((nArray[11] & REGIONIDBIT) != 0) {
                int n4 = TIMESTAMPTZ.getHighOrderbits(nArray[11]);
                TIMEZONETAB tIMEZONETAB = TIMESTAMPTZ.getTIMEZONETAB(connection);
                if (tIMEZONETAB.checkID(n4 += TIMESTAMPTZ.getLowOrderbits(nArray[12]))) {
                    tIMEZONETAB.updateTable(connection, n4);
                }
                int n5 = tIMEZONETAB.getOffset(calendar, n4);
                calendar.add(10, n5 / HOUR_MILLISECOND);
                calendar.add(12, n5 % HOUR_MILLISECOND / MINUTE_MILLISECOND);
            } else {
                calendar.add(10, nArray[11] - OFFSET_HOUR);
                calendar.add(12, nArray[12] - OFFSET_MINUTE);
            }
            long l2 = calendar.getTime().getTime();
            Date date = new Date(l2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$0, null, date);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$0, null, null);
            }
            return date;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$0, null, throwable2);
            }
            throw throwable;
        }
    }

    public static Date toDate2(Connection connection, byte[] byArray) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$1, null, connection, byArray);
            }
            int[] nArray = new int[13];
            for (n2 = 0; n2 < 13; ++n2) {
                nArray[n2] = byArray[n2] & 0xFF;
            }
            n2 = TIMESTAMP.getJavaYear(nArray[0], nArray[1]);
            Calendar calendar = (Calendar)CAL_GMT_US.clone();
            calendar.set(1, n2);
            calendar.set(2, nArray[2] - 1);
            calendar.set(5, nArray[3]);
            calendar.set(11, nArray[4] - 1);
            calendar.set(12, nArray[5] - 1);
            calendar.set(13, nArray[6] - 1);
            int n3 = TIMESTAMP.getNanos(byArray, 7) / 1000000;
            calendar.set(14, n3);
            long l2 = calendar.getTime().getTime();
            Date date = new Date(l2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$1, null, date);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$1, null, null);
            }
            return date;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$1, null, throwable2);
            }
            throw throwable;
        }
    }

    public static Time toTime(Connection connection, byte[] byArray) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$2, null, connection, byArray);
            }
            int n2 = byArray[4] & 0xFF;
            int n3 = byArray[5] & 0xFF;
            int n4 = byArray[6] & 0xFF;
            Calendar calendar = (Calendar)CAL_GMT_US.clone();
            calendar.set(1, 1970);
            calendar.set(2, 0);
            calendar.set(5, 1);
            calendar.set(11, n2 - 1);
            calendar.set(12, n3 - 1);
            calendar.set(13, n4 - 1);
            calendar.set(14, 0);
            Time time = new Time(calendar.getTimeInMillis());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$2, null, time);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$2, null, null);
            }
            return time;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$2, null, throwable2);
            }
            throw throwable;
        }
    }

    public static DATE toDATE(Connection connection, byte[] byArray) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$3, null, connection, byArray);
            }
            DATE dATE = new DATE(TIMESTAMPTZ.toTimestampInSessionTimezone(connection, byArray));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$3, null, dATE);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$3, null, null);
            }
            return dATE;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$3, null, throwable2);
            }
            throw throwable;
        }
    }

    public static TIMESTAMP toTIMESTAMP(Connection connection, byte[] byArray) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$4, null, connection, byArray);
            }
            TIMESTAMP tIMESTAMP = new TIMESTAMP(TIMESTAMPTZ.toTimestampInSessionTimezone(connection, byArray));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$4, null, tIMESTAMP);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$4, null, null);
            }
            return tIMESTAMP;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$4, null, throwable2);
            }
            throw throwable;
        }
    }

    public static Timestamp toTimestamp(Connection connection, byte[] byArray) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            Cloneable cloneable;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$5, null, connection, byArray);
            }
            int[] nArray = new int[13];
            for (int i2 = 0; i2 < 13; ++i2) {
                nArray[i2] = byArray[i2] & 0xFF;
            }
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = (Calendar)CAL_GMT_US.clone();
            Calendar calendar3 = Calendar.getInstance();
            int n2 = TIMESTAMP.getJavaYear(nArray[0], nArray[1]);
            calendar.set(1, n2);
            calendar.set(2, nArray[2] - 1);
            calendar.set(5, nArray[3]);
            calendar.set(11, nArray[4] - 1);
            calendar.set(12, nArray[5] - 1);
            calendar.set(13, nArray[6] - 1);
            calendar.set(14, 0);
            calendar2.set(1, n2);
            calendar2.set(2, nArray[2] - 1);
            calendar2.set(5, nArray[3]);
            calendar2.set(11, nArray[4] - 1);
            calendar2.set(12, nArray[5] - 1);
            calendar2.set(13, nArray[6] - 1);
            calendar2.set(14, 0);
            long l2 = calendar.getTime().getTime();
            if ((nArray[11] & REGIONIDBIT) != 0) {
                int n3 = TIMESTAMPTZ.getHighOrderbits(nArray[11]);
                TIMEZONETAB tIMEZONETAB = TIMESTAMPTZ.getTIMEZONETAB(connection);
                if (tIMEZONETAB.checkID(n3 += TIMESTAMPTZ.getLowOrderbits(nArray[12]))) {
                    tIMEZONETAB.updateTable(connection, n3);
                }
                int n4 = tIMEZONETAB.getOffset(calendar2, n3);
                TimeZone timeZone = calendar.getTimeZone();
                cloneable = calendar3.getTimeZone();
                if (!timeZone.inDaylightTime(calendar.getTime()) && ((TimeZone)cloneable).inDaylightTime(new Timestamp(l2 += (long)n4))) {
                    l2 = cloneable instanceof SimpleTimeZone ? (l2 -= (long)((SimpleTimeZone)cloneable).getDSTSavings()) : (l2 -= (long)HOUR_MILLISECOND);
                }
                if (timeZone.inDaylightTime(calendar.getTime()) && !((TimeZone)cloneable).inDaylightTime(new Timestamp(l2))) {
                    l2 = cloneable instanceof SimpleTimeZone ? (l2 += (long)((SimpleTimeZone)timeZone).getDSTSavings()) : (l2 += (long)HOUR_MILLISECOND);
                }
            } else {
                calendar.add(10, nArray[11] - OFFSET_HOUR);
                calendar.add(12, nArray[12] - OFFSET_MINUTE);
                l2 = calendar.getTime().getTime();
            }
            Timestamp timestamp = new Timestamp(l2);
            long l3 = calendar2.getTime().getTime();
            cloneable = Calendar.getInstance();
            ((Calendar)cloneable).setTimeInMillis(l3);
            Calendar calendar4 = Calendar.getInstance();
            calendar4.setTime(timestamp);
            boolean bl2 = ((Calendar)cloneable).getTimeZone().inDaylightTime(((Calendar)cloneable).getTime());
            boolean bl3 = calendar4.getTimeZone().inDaylightTime(calendar4.getTime());
            if (bl2 && !bl3) {
                timestamp = new Timestamp(l2 - (long)((Calendar)cloneable).getTimeZone().getDSTSavings());
            } else if (!bl2 && bl3) {
                timestamp = new Timestamp(l2 + (long)calendar4.getTimeZone().getDSTSavings());
            }
            int n5 = TIMESTAMP.getNanos(byArray, 7);
            timestamp.setNanos(n5);
            Timestamp timestamp2 = timestamp;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$5, null, timestamp2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$5, null, null);
            }
            return timestamp2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$5, null, throwable2);
            }
            throw throwable;
        }
    }

    public static Timestamp toTimestamp2(Connection connection, byte[] byArray) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$6, null, connection, byArray);
            }
            int[] nArray = new int[13];
            for (n2 = 0; n2 < 13; ++n2) {
                nArray[n2] = byArray[n2] & 0xFF;
            }
            n2 = TIMESTAMP.getJavaYear(nArray[0], nArray[1]);
            Calendar calendar = (Calendar)CAL_GMT_US.clone();
            calendar.clear();
            calendar.set(1, n2);
            calendar.set(2, nArray[2] - 1);
            calendar.set(5, nArray[3]);
            calendar.set(11, nArray[4] - 1);
            calendar.set(12, nArray[5] - 1);
            calendar.set(13, nArray[6] - 1);
            calendar.set(14, 0);
            long l2 = calendar.getTime().getTime();
            Timestamp timestamp = new Timestamp(l2);
            int n3 = TIMESTAMP.getNanos(byArray, 7);
            timestamp.setNanos(n3);
            Timestamp timestamp2 = timestamp;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$6, null, timestamp2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$6, null, null);
            }
            return timestamp2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$6, null, throwable2);
            }
            throw throwable;
        }
    }

    static Timestamp toTimestampInSessionTimezone(Connection connection, byte[] byArray) throws SQLException {
        int n2;
        int[] nArray = new int[13];
        for (n2 = 0; n2 < 13; ++n2) {
            nArray[n2] = byArray[n2] & 0xFF;
        }
        n2 = TIMESTAMP.getJavaYear(nArray[0], nArray[1]);
        Calendar calendar = (Calendar)CAL_GMT_US.clone();
        calendar.clear();
        calendar.set(1, n2);
        calendar.set(2, nArray[2] - 1);
        calendar.set(5, nArray[3]);
        calendar.set(11, nArray[4] - 1);
        calendar.set(12, nArray[5] - 1);
        calendar.set(13, nArray[6] - 1);
        calendar.set(14, 0);
        Calendar calendar2 = TIMESTAMPLTZ.getSessCalendar(connection);
        TIMESTAMPLTZ.TimeZoneAdjust(connection, calendar, calendar2);
        long l2 = calendar2.getTime().getTime();
        Timestamp timestamp = new Timestamp(l2);
        int n3 = TIMESTAMP.getNanos(byArray, 7);
        timestamp.setNanos(n3);
        return timestamp;
    }

    @DisableTrace
    public static String toString(Connection connection, byte[] byArray) throws SQLException {
        int n2;
        String string;
        int n3;
        int[] nArray = new int[13];
        for (int i2 = 0; i2 < 13; ++i2) {
            nArray[i2] = byArray[i2] & 0xFF;
        }
        Calendar calendar = (Calendar)CAL_GMT_US.clone();
        int n4 = TIMESTAMP.getJavaYear(nArray[0], nArray[1]);
        calendar.set(1, n4);
        calendar.set(2, nArray[2] - 1);
        calendar.set(5, nArray[3]);
        calendar.set(11, nArray[4] - 1);
        calendar.set(12, nArray[5] - 1);
        calendar.set(13, nArray[6] - 1);
        calendar.set(14, 0);
        if ((nArray[11] & REGIONIDBIT) != 0) {
            n3 = TIMESTAMPTZ.getHighOrderbits(nArray[11]);
            OracleConnection oracleConnection = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin();
            TIMEZONETAB tIMEZONETAB = oracleConnection.getTIMEZONETAB();
            if (tIMEZONETAB.checkID(n3 += TIMESTAMPTZ.getLowOrderbits(nArray[12]))) {
                tIMEZONETAB.updateTable(oracleConnection, n3);
            }
            string = ZONEIDMAP.getRegion(n3);
            n2 = tIMEZONETAB.getOffset(calendar, n3);
            calendar.add(14, n2);
        } else {
            n3 = nArray[11] - OFFSET_HOUR;
            int n5 = nArray[12] - OFFSET_MINUTE;
            string = n3 + ":";
            string = n5 == 0 ? string + "00" : string + "" + n5;
            calendar.add(10, n3);
            calendar.add(12, n5);
        }
        n4 = calendar.get(1);
        if (calendar.get(0) == 0) {
            n4 = -(n4 - 1);
        }
        n3 = calendar.get(2) + 1;
        int n6 = calendar.get(5);
        int n7 = calendar.get(11);
        n2 = calendar.get(12);
        int n8 = calendar.get(13);
        int n9 = TIMESTAMP.getNanos(byArray, 7);
        return TIMESTAMPTZ.toString(n4, n3, n6, n7, n2, n8, n9, string);
    }

    public static OffsetDateTime toOffsetDateTime(Connection connection, byte[] byArray) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            OffsetDateTime offsetDateTime;
            int n2;
            int n3;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$8, null, connection, byArray);
            }
            int[] nArray = new int[13];
            for (n3 = 0; n3 < 13; ++n3) {
                nArray[n3] = byArray[n3] & 0xFF;
            }
            n3 = TIMESTAMP.getJavaYear(nArray[0], nArray[1]);
            int n4 = TIMESTAMP.getNanos(byArray, 7);
            OffsetDateTime offsetDateTime2 = OffsetDateTime.of(n3, nArray[2], nArray[3], nArray[4] - 1, nArray[5] - 1, nArray[6] - 1, n4, ZoneOffset.UTC);
            ZoneOffset zoneOffset = null;
            if ((nArray[11] & REGIONIDBIT) != 0) {
                n2 = TIMESTAMPTZ.getHighOrderbits(nArray[11]);
                OracleConnection oracleConnection = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin();
                TIMEZONETAB tIMEZONETAB = oracleConnection.getTIMEZONETAB();
                if (tIMEZONETAB.checkID(n2 += TIMESTAMPTZ.getLowOrderbits(nArray[12]))) {
                    tIMEZONETAB.updateTable(oracleConnection, n2);
                }
                int n5 = tIMEZONETAB.getOffset(offsetDateTime2.toInstant().toEpochMilli(), n2);
                zoneOffset = ZoneOffset.ofTotalSeconds(n5 / SECOND_MILLISECOND);
            } else {
                n2 = nArray[11] - OFFSET_HOUR;
                int n6 = nArray[12] - OFFSET_MINUTE;
                zoneOffset = ZoneOffset.ofHoursMinutes(n2, n6);
            }
            OffsetDateTime offsetDateTime3 = offsetDateTime = offsetDateTime2.withOffsetSameInstant(zoneOffset);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$8, null, offsetDateTime3);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$8, null, null);
            }
            return offsetDateTime3;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$8, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static OffsetDateTime toOffsetDateTime(byte[] byArray) throws SQLException {
        int n2;
        int n3;
        int[] nArray = new int[13];
        for (n3 = 0; n3 < 13; ++n3) {
            nArray[n3] = byArray[n3] & 0xFF;
        }
        n3 = TIMESTAMP.getJavaYear(nArray[0], nArray[1]);
        int n4 = TIMESTAMP.getNanos(byArray, 7);
        OffsetDateTime offsetDateTime = OffsetDateTime.of(n3, nArray[2], nArray[3], nArray[4] - 1, nArray[5] - 1, nArray[6] - 1, n4, ZoneOffset.UTC);
        ZoneOffset zoneOffset = null;
        if ((nArray[11] & REGIONIDBIT) != 0) {
            n2 = TIMESTAMPTZ.getHighOrderbits(nArray[11]);
            String string = ZONEIDMAP.getRegion(n2 += TIMESTAMPTZ.getLowOrderbits(nArray[12]));
            ZoneId zoneId = ZoneId.of(string);
            ZoneRules zoneRules = zoneId.getRules();
            if (!zoneRules.isFixedOffset()) throw new SQLException("Timezone not supported: " + string);
            zoneOffset = zoneRules.getOffset(offsetDateTime.toInstant());
            return offsetDateTime.withOffsetSameInstant(zoneOffset);
        } else {
            n2 = nArray[11] - OFFSET_HOUR;
            int n5 = nArray[12] - OFFSET_MINUTE;
            zoneOffset = ZoneOffset.ofHoursMinutes(n2, n5);
        }
        return offsetDateTime.withOffsetSameInstant(zoneOffset);
    }

    @DisableTrace
    public static final String toString(int n2, int n3, int n4, int n5, int n6, int n7, int n8, String string) {
        String string2 = "" + n2 + "-" + TIMESTAMPTZ.toStr(n3) + "-" + TIMESTAMPTZ.toStr(n4) + " " + TIMESTAMPTZ.toStr(n5) + ":" + TIMESTAMPTZ.toStr(n6) + ":" + TIMESTAMPTZ.toStr(n7);
        if (n8 >= 0) {
            int n9;
            String string3 = String.format("%09d", n8);
            char[] cArray = string3.toCharArray();
            for (n9 = cArray.length; n9 > 1 && cArray[n9 - 1] == '0'; --n9) {
            }
            string3 = string3.substring(0, n9);
            string2 = string2 + "." + string3;
        }
        if (string != null) {
            string2 = string2 + " " + string;
        }
        return string2;
    }

    private static final String toStr(int n2) {
        return n2 < 10 ? "0" + n2 : Integer.toString(n2);
    }

    public Timestamp timestampValue(Connection connection) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$11, this, connection);
            }
            if (((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin().getTimestamptzInGmt()) {
                Timestamp timestamp = TIMESTAMPTZ.toTimestamp2(connection, this.getBytes());
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$11, this, timestamp);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$11, this, null);
                }
                return timestamp;
            }
            Timestamp timestamp = TIMESTAMPTZ.toTimestamp(connection, this.getBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$11, this, timestamp);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$11, this, null);
            }
            return timestamp;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public byte[] toBytes() {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$12, this, new Object[0]);
            }
            byte[] byArray = this.getBytes();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$12, this, byArray);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$12, this, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(Connection connection, Date date) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$13, null, connection, date);
            }
            byte[] byArray = TIMESTAMPTZ.toBytes(connection, date, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$13, null, byArray);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$13, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$13, null, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(Connection connection, Date date, Calendar calendar) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$14, null, connection, date, calendar);
            }
            if (date == null) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$14, null, byArray);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$14, null, null);
                }
                return null;
            }
            byte[] byArray = new byte[13];
            Calendar calendar2 = TIMESTAMPTZ.getWorkCal(connection, calendar);
            calendar2.setTime(date);
            if (OracleDriver.getSystemPropertyDateZeroTime()) {
                calendar2.set(11, 0);
                calendar2.set(12, 0);
                calendar2.set(13, 0);
            }
            Calendar calendar3 = TIMESTAMPTZ.doCalWork(connection, calendar2, byArray);
            int n2 = TIMESTAMP.getOracleYear(calendar3);
            byArray[0] = (byte)(n2 / 100 + 100);
            byArray[1] = (byte)(n2 % 100 + 100);
            byArray[2] = (byte)(calendar3.get(2) + 1);
            byArray[3] = (byte)calendar3.get(5);
            byArray[4] = (byte)(calendar3.get(11) + 1);
            byArray[5] = (byte)(calendar3.get(12) + 1);
            byArray[6] = (byte)(calendar3.get(13) + 1);
            byArray[7] = 0;
            byArray[8] = 0;
            byArray[9] = 0;
            byArray[10] = 0;
            byte[] byArray2 = byArray;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$14, null, byArray2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$14, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$14, null, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(Connection connection, Time time) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$15, null, connection, time);
            }
            byte[] byArray = TIMESTAMPTZ.toBytes(connection, time, (Calendar)null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$15, null, byArray);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$15, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$15, null, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(Connection connection, Time time, Calendar calendar) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$16, null, connection, time, calendar);
            }
            if (time == null) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$16, null, byArray);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$16, null, null);
                }
                return null;
            }
            byte[] byArray = new byte[13];
            Calendar calendar2 = TIMESTAMPTZ.getWorkCal(connection, calendar);
            calendar2.setTime(time);
            int n2 = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin().getUse1900AsYearForTime() ? 1900 : 1970;
            calendar2.set(1, n2);
            calendar2.set(2, 0);
            calendar2.set(5, 1);
            Calendar calendar3 = TIMESTAMPTZ.doCalWork(connection, calendar2, byArray);
            int n3 = TIMESTAMP.getOracleYear(calendar3);
            byArray[0] = (byte)(n3 / 100 + 100);
            byArray[1] = (byte)(n3 % 100 + 100);
            byArray[2] = (byte)(calendar3.get(2) + 1);
            byArray[3] = (byte)calendar3.get(5);
            byArray[4] = (byte)(calendar3.get(11) + 1);
            byArray[5] = (byte)(calendar3.get(12) + 1);
            byArray[6] = (byte)(calendar3.get(13) + 1);
            byArray[7] = 0;
            byArray[8] = 0;
            byArray[9] = 0;
            byArray[10] = 0;
            byte[] byArray2 = byArray;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$16, null, byArray2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$16, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$16, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static byte[] toBytes(Connection connection, Time time, ZoneId zoneId) throws SQLException {
        if (time == null) {
            return null;
        }
        byte[] byArray = new byte[13];
        Calendar calendar = (Calendar)CAL_GMT_US.clone();
        calendar.setTime(time);
        int n2 = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin().getUse1900AsYearForTime() ? 1900 : 1970;
        calendar.set(1, n2);
        calendar.set(2, 0);
        calendar.set(5, 1);
        Calendar calendar2 = TIMESTAMPTZ.doCalWork(connection, calendar, byArray);
        int n3 = TIMESTAMP.getOracleYear(calendar2);
        byArray[0] = (byte)(n3 / 100 + 100);
        byArray[1] = (byte)(n3 % 100 + 100);
        byArray[2] = (byte)(calendar2.get(2) + 1);
        byArray[3] = (byte)calendar2.get(5);
        byArray[4] = (byte)(calendar2.get(11) + 1);
        byArray[5] = (byte)(calendar2.get(12) + 1);
        byArray[6] = (byte)(calendar2.get(13) + 1);
        byArray[7] = 0;
        byArray[8] = 0;
        byArray[9] = 0;
        byArray[10] = 0;
        String string = zoneId.getId();
        int n4 = ZONEIDMAP.getID(string);
        if (!ZONEIDMAP.isValidID(n4)) {
            ZoneRules zoneRules = zoneId.getRules();
            if (!zoneRules.isFixedOffset()) throw new SQLException("Timezone not supported: " + string);
            ZoneOffset zoneOffset = zoneRules.getOffset(time.toInstant());
            int n5 = zoneOffset.getTotalSeconds();
            byArray[11] = (byte)(n5 / HOUR_SECOND + OFFSET_HOUR);
            byArray[12] = (byte)(n5 % HOUR_SECOND / MINUTE_SECOND + OFFSET_MINUTE);
            return byArray;
        } else {
            byArray[11] = (byte)TIMESTAMPTZ.setHighOrderbits(n4);
            byArray[11] = (byte)(byArray[11] | REGIONIDBIT);
            byArray[12] = (byte)TIMESTAMPTZ.setLowOrderbits(n4);
        }
        return byArray;
    }

    public static byte[] toBytes(Connection connection, Timestamp timestamp) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$18, null, connection, timestamp);
            }
            byte[] byArray = TIMESTAMPTZ.toBytes(connection, timestamp, (Calendar)null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$18, null, byArray);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$18, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$18, null, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(Connection connection, Timestamp timestamp, Calendar calendar) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$19, null, connection, timestamp, calendar);
            }
            if (timestamp == null) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$19, null, byArray);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$19, null, null);
                }
                return null;
            }
            byte[] byArray = new byte[13];
            Calendar calendar2 = TIMESTAMPTZ.getWorkCal(connection, calendar);
            calendar2.setTime(timestamp);
            Calendar calendar3 = TIMESTAMPTZ.doCalWork(connection, calendar2, byArray);
            int n2 = TIMESTAMP.getOracleYear(calendar3);
            byArray[0] = (byte)(n2 / 100 + 100);
            byArray[1] = (byte)(n2 % 100 + 100);
            byArray[2] = (byte)(calendar3.get(2) + 1);
            byArray[3] = (byte)calendar3.get(5);
            byArray[4] = (byte)(calendar3.get(11) + 1);
            byArray[5] = (byte)(calendar3.get(12) + 1);
            byArray[6] = (byte)(calendar3.get(13) + 1);
            int n3 = timestamp.getNanos();
            byArray[7] = (byte)(n3 >> 24);
            byArray[8] = (byte)(n3 >> 16 & 0xFF);
            byArray[9] = (byte)(n3 >> 8 & 0xFF);
            byArray[10] = (byte)(n3 & 0xFF);
            byte[] byArray2 = byArray;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$19, null, byArray2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$19, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$19, null, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(Connection connection, Timestamp timestamp, ZoneId zoneId) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$20, null, connection, timestamp, zoneId);
            }
            byte[] byArray = TIMESTAMPTZ.toBytes(timestamp, zoneId, false);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$20, null, byArray);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$20, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$20, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static byte[] toBytes(Timestamp timestamp, ZoneId zoneId, boolean bl) throws SQLException {
        byte[] byArray = new byte[13];
        Calendar calendar = (Calendar)CAL_GMT_US.clone();
        if (bl) {
            Calendar calendar2 = Calendar.getInstance(TimeZone.getTimeZone(zoneId));
            calendar2.setTime(timestamp);
            calendar.setTime(calendar2.getTime());
        } else {
            calendar.setTime(timestamp);
        }
        int n2 = TIMESTAMP.getOracleYear(calendar);
        byArray[0] = (byte)(n2 / 100 + 100);
        byArray[1] = (byte)(n2 % 100 + 100);
        byArray[2] = (byte)(calendar.get(2) + 1);
        byArray[3] = (byte)calendar.get(5);
        byArray[4] = (byte)(calendar.get(11) + 1);
        byArray[5] = (byte)(calendar.get(12) + 1);
        byArray[6] = (byte)(calendar.get(13) + 1);
        byArray[7] = (byte)(timestamp.getNanos() >> 24);
        byArray[8] = (byte)(timestamp.getNanos() >> 16 & 0xFF);
        byArray[9] = (byte)(timestamp.getNanos() >> 8 & 0xFF);
        byArray[10] = (byte)(timestamp.getNanos() & 0xFF);
        String string = zoneId.getId();
        int n3 = ZONEIDMAP.getID(string);
        if (!ZONEIDMAP.isValidID(n3)) {
            ZoneRules zoneRules = zoneId.getRules();
            if (!zoneRules.isFixedOffset()) throw new SQLException("Timezone not supported: " + string);
            ZoneOffset zoneOffset = zoneRules.getOffset(timestamp.toInstant());
            int n4 = zoneOffset.getTotalSeconds();
            byArray[11] = (byte)(n4 / HOUR_SECOND + OFFSET_HOUR);
            byArray[12] = (byte)(n4 % HOUR_SECOND / MINUTE_SECOND + OFFSET_MINUTE);
            return byArray;
        } else {
            byArray[11] = (byte)TIMESTAMPTZ.setHighOrderbits(n3);
            byArray[11] = (byte)(byArray[11] | REGIONIDBIT);
            byArray[12] = (byte)TIMESTAMPTZ.setLowOrderbits(n3);
        }
        return byArray;
    }

    public static byte[] toBytes(Connection connection, DATE dATE) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$22, null, connection, dATE);
            }
            if (dATE == null) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$22, null, byArray);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$22, null, null);
                }
                return null;
            }
            byte[] byArray = new byte[13];
            Calendar calendar = TIMESTAMPTZ.getWorkCal(connection, null);
            calendar.setTime(DATE.toDate(dATE.toBytes()));
            Calendar calendar2 = TIMESTAMPTZ.doCalWork(connection, calendar, byArray);
            int n2 = TIMESTAMP.getOracleYear(calendar2);
            byArray[0] = (byte)(n2 / 100 + 100);
            byArray[1] = (byte)(n2 % 100 + 100);
            byArray[2] = (byte)(calendar2.get(2) + 1);
            byArray[3] = (byte)calendar2.get(5);
            byArray[4] = (byte)(calendar2.get(11) + 1);
            byArray[5] = (byte)(calendar2.get(12) + 1);
            byArray[6] = (byte)(calendar2.get(13) + 1);
            byArray[7] = 0;
            byArray[8] = 0;
            byArray[9] = 0;
            byArray[10] = 0;
            byte[] byArray2 = byArray;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$22, null, byArray2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$22, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$22, null, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(Connection connection, String string) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            byte[] byArray;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$23, null, connection, string);
            }
            try {
                byArray = TIMESTAMPTZ.toBytes(connection, Timestamp.valueOf(string));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                byArray = TIMESTAMPTZ.parseTimestampTz(connection, string);
            }
            byte[] byArray2 = byArray;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$23, null, byArray2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$23, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$23, null, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(Connection connection, String string, Calendar calendar) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$24, null, connection, string, calendar);
            }
            Calendar calendar2 = (Calendar)CAL_GMT_US.clone();
            Timestamp timestamp = TIMESTAMPTZ.parseTimestamp(string);
            calendar2.setTime(timestamp);
            Calendar calendar3 = calendar == null ? Calendar.getInstance() : Calendar.getInstance(calendar.getTimeZone());
            calendar3.set(1, calendar2.get(1));
            calendar3.set(2, calendar2.get(2));
            calendar3.set(5, calendar2.get(5));
            calendar3.set(11, calendar2.get(11));
            calendar3.set(12, calendar2.get(12));
            calendar3.set(13, calendar2.get(13));
            calendar3.set(14, calendar2.get(14));
            int n2 = timestamp.getNanos();
            timestamp = new Timestamp(calendar3.getTime().getTime());
            timestamp.setNanos(n2);
            byte[] byArray = TIMESTAMPTZ.toBytes(connection, timestamp, calendar);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$24, null, byArray);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$24, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$24, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String stringValue(Connection connection) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$25, this, connection);
            }
            String string = TIMESTAMPTZ.toString(connection, this.getBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$25, this, string);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$25, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$25, this, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(OffsetDateTime offsetDateTime) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$26, null, offsetDateTime);
            }
            if (offsetDateTime == null) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$26, null, byArray);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$26, null, null);
                }
                return null;
            }
            byte[] byArray = new byte[13];
            OffsetDateTime offsetDateTime2 = offsetDateTime.withOffsetSameInstant(ZoneOffset.UTC);
            int n2 = offsetDateTime2.getYear();
            int n3 = offsetDateTime2.getMonthValue();
            int n4 = offsetDateTime2.getDayOfMonth();
            int n5 = offsetDateTime2.getHour();
            int n6 = offsetDateTime2.getMinute();
            int n7 = offsetDateTime2.getSecond();
            int n8 = offsetDateTime2.getNano();
            byArray[0] = (byte)(n2 / 100 + 100);
            byArray[1] = (byte)(n2 % 100 + 100);
            byArray[2] = (byte)n3;
            byArray[3] = (byte)n4;
            byArray[4] = (byte)(n5 + 1);
            byArray[5] = (byte)(n6 + 1);
            byArray[6] = (byte)(n7 + 1);
            byArray[7] = (byte)(n8 >> 24);
            byArray[8] = (byte)(n8 >> 16 & 0xFF);
            byArray[9] = (byte)(n8 >> 8 & 0xFF);
            byArray[10] = (byte)(n8 & 0xFF);
            int n9 = offsetDateTime.getOffset().getTotalSeconds();
            byArray[11] = (byte)(n9 / HOUR_SECOND + OFFSET_HOUR);
            byArray[12] = (byte)(n9 % HOUR_SECOND / MINUTE_SECOND + OFFSET_MINUTE);
            byte[] byArray2 = byArray;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$26, null, byArray2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$26, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$26, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] toBytes(ZonedDateTime zonedDateTime) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            byte[] byArray;
            block10: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$27, null, zonedDateTime);
                }
                if (zonedDateTime == null) {
                    byte[] byArray2 = null;
                    if (!bl) return null;
                    ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$27, null, byArray2);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$27, null, null);
                    return null;
                }
                byArray = new byte[13];
                OffsetDateTime offsetDateTime = zonedDateTime.toOffsetDateTime().withOffsetSameInstant(ZoneOffset.UTC);
                int n2 = offsetDateTime.getYear();
                int n3 = offsetDateTime.getMonthValue();
                int n4 = offsetDateTime.getDayOfMonth();
                int n5 = offsetDateTime.getHour();
                int n6 = offsetDateTime.getMinute();
                int n7 = offsetDateTime.getSecond();
                int n8 = offsetDateTime.getNano();
                byArray[0] = (byte)(n2 / 100 + 100);
                byArray[1] = (byte)(n2 % 100 + 100);
                byArray[2] = (byte)n3;
                byArray[3] = (byte)n4;
                byArray[4] = (byte)(n5 + 1);
                byArray[5] = (byte)(n6 + 1);
                byArray[6] = (byte)(n7 + 1);
                byArray[7] = (byte)(n8 >> 24);
                byArray[8] = (byte)(n8 >> 16 & 0xFF);
                byArray[9] = (byte)(n8 >> 8 & 0xFF);
                byArray[10] = (byte)(n8 & 0xFF);
                ZoneId zoneId = zonedDateTime.getZone();
                String string = zoneId.getId();
                int n9 = ZONEIDMAP.getID(string);
                if (!ZONEIDMAP.isValidID(n9)) {
                    ZoneRules zoneRules = zoneId.getRules();
                    if (zoneRules.isFixedOffset()) {
                        ZoneOffset zoneOffset = zoneRules.getOffset(zonedDateTime.toInstant());
                        int n10 = zoneOffset.getTotalSeconds();
                        byArray[11] = (byte)(n10 / HOUR_SECOND + OFFSET_HOUR);
                        byArray[12] = (byte)(n10 % HOUR_SECOND / MINUTE_SECOND + OFFSET_MINUTE);
                        break block10;
                    } else {
                        SQLException sQLException = new SQLException("Timezone not supported: " + string);
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$27, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$27, null, sQLException);
                        }
                        throw sQLException;
                    }
                }
                byArray[11] = (byte)TIMESTAMPTZ.setHighOrderbits(n9);
                byArray[11] = (byte)(byArray[11] | REGIONIDBIT);
                byArray[12] = (byte)TIMESTAMPTZ.setLowOrderbits(n9);
            }
            byte[] byArray3 = byArray;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$27, null, byArray3);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$27, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$27, null, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(Connection connection, LocalDateTime localDateTime) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$28, null, connection, localDateTime);
            }
            if (localDateTime == null) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$28, null, byArray);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$28, null, null);
                }
                return null;
            }
            ZoneId zoneId = null;
            String string = ((oracle.jdbc.OracleConnection)connection).getSessionTimeZone();
            zoneId = string != null ? ZoneId.of(string) : ZoneId.systemDefault();
            byte[] byArray = TIMESTAMPTZ.toBytes(ZonedDateTime.of(localDateTime, zoneId));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$28, null, byArray);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$28, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$28, null, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(OffsetTime offsetTime) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$29, null, offsetTime);
            }
            if (offsetTime == null) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$29, null, byArray);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$29, null, null);
                }
                return null;
            }
            byte[] byArray = TIMESTAMPTZ.toBytes(offsetTime.atDate(LocalDate.of(1970, 1, 1)));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$29, null, byArray);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$29, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$29, null, throwable2);
            }
            throw throwable;
        }
    }

    public OffsetDateTime offsetDateTimeValue(Connection connection) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$30, this, connection);
            }
            OffsetDateTime offsetDateTime = TIMESTAMPTZ.toOffsetDateTime(connection, this.getBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$30, this, offsetDateTime);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$30, this, null);
            }
            return offsetDateTime;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$30, this, throwable2);
            }
            throw throwable;
        }
    }

    public ZonedDateTime zonedDateTimeValue() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$31, this, new Object[0]);
            }
            ZonedDateTime zonedDateTime = TIMESTAMPTZ.toZonedDateTime(this.getBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$31, this, zonedDateTime);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$31, this, null);
            }
            return zonedDateTime;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$31, this, throwable2);
            }
            throw throwable;
        }
    }

    public LocalDateTime localDateTimeValue() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$32, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$32, this, new Object[0]);
            }
            LocalDateTime localDateTime = TIMESTAMPTZ.toLocalDateTime(this.getBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$32, this, localDateTime);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$32, this, null);
            }
            return localDateTime;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$32, this, throwable2);
            }
            throw throwable;
        }
    }

    public Date dateValue(Connection connection) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$33, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$33, this, connection);
            }
            if (((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin().getTimestamptzInGmt()) {
                Date date = TIMESTAMPTZ.toDate2(connection, this.getBytes());
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$33, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$33, this, date);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$33, this, null);
                }
                return date;
            }
            Date date = TIMESTAMPTZ.toDate(connection, this.getBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$33, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$33, this, date);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$33, this, null);
            }
            return date;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$33, this, throwable2);
            }
            throw throwable;
        }
    }

    public Time timeValue(Connection connection) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$34, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$34, this, connection);
            }
            Time time = TIMESTAMPTZ.toTime(connection, this.getBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$34, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$34, this, time);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$34, this, null);
            }
            return time;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$34, this, throwable2);
            }
            throw throwable;
        }
    }

    public TimeZone getTimeZone() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$35, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$35, this, new Object[0]);
            }
            TimeZone timeZone = TIMESTAMPTZ.getTimeZone(this.shareBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$35, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$35, this, timeZone);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$35, this, null);
            }
            return timeZone;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$35, this, throwable2);
            }
            throw throwable;
        }
    }

    private static TimeZone getTimeZone(byte[] byArray) throws SQLException {
        String string;
        if ((byArray[11] & REGIONIDBIT) != 0) {
            int n2 = TIMESTAMPTZ.getHighOrderbits(byArray[11]);
            string = ZONEIDMAP.getRegion(n2 += TIMESTAMPTZ.getLowOrderbits(byArray[12]));
        } else {
            int n3 = byArray[11] - OFFSET_HOUR;
            int n4 = byArray[12] - OFFSET_MINUTE;
            String string2 = n3 + ":";
            string2 = n4 == 0 ? string2 + "00" : string2 + "" + n4;
            string = "GMT" + (n3 >= 0 ? "+" : "") + string2;
        }
        return TimeZone.getTimeZone(string);
    }

    public static TIMESTAMPTZ of(ZonedDateTime zonedDateTime) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$37, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$37, null, zonedDateTime);
            }
            TIMESTAMPTZ tIMESTAMPTZ = new TIMESTAMPTZ(TIMESTAMPTZ.toBytes(zonedDateTime));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$37, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$37, null, tIMESTAMPTZ);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$37, null, null);
            }
            return tIMESTAMPTZ;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$37, null, throwable2);
            }
            throw throwable;
        }
    }

    public ZonedDateTime toZonedDateTime() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$38, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$38, this, new Object[0]);
            }
            ZonedDateTime zonedDateTime = TIMESTAMPTZ.toZonedDateTime(this.getBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$38, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$38, this, zonedDateTime);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$38, this, null);
            }
            return zonedDateTime;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$38, this, throwable2);
            }
            throw throwable;
        }
    }

    public LocalDateTime toLocalDateTime() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$39, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$39, this, new Object[0]);
            }
            LocalDateTime localDateTime = TIMESTAMPTZ.toLocalDateTime(this.getBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$39, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$39, this, localDateTime);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$39, this, null);
            }
            return localDateTime;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$39, this, throwable2);
            }
            throw throwable;
        }
    }

    public static LocalDateTime toLocalDateTime(byte[] byArray) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$40, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$40, null, new Object[]{byArray});
            }
            LocalDateTime localDateTime = TIMESTAMPTZ.toZonedDateTime(byArray).toLocalDateTime();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$40, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$40, null, localDateTime);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$40, null, null);
            }
            return localDateTime;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$40, null, throwable2);
            }
            throw throwable;
        }
    }

    public static ZonedDateTime toZonedDateTime(byte[] byArray) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            ZonedDateTime zonedDateTime;
            int n2;
            int n3;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$41, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$41, null, new Object[]{byArray});
            }
            int[] nArray = new int[13];
            for (n3 = 0; n3 < 13; ++n3) {
                nArray[n3] = byArray[n3] & 0xFF;
            }
            n3 = TIMESTAMP.getJavaYear(nArray[0], nArray[1]);
            int n4 = TIMESTAMP.getNanos(byArray, 7);
            ZonedDateTime zonedDateTime2 = ZonedDateTime.of(n3, nArray[2], nArray[3], nArray[4] - 1, nArray[5] - 1, nArray[6] - 1, n4, ZoneId.of("UTC"));
            ZoneId zoneId = null;
            if ((nArray[11] & REGIONIDBIT) != 0) {
                n2 = TIMESTAMPTZ.getHighOrderbits(nArray[11]);
                zoneId = ZoneId.of(ZONEIDMAP.getRegion(n2 += TIMESTAMPTZ.getLowOrderbits(nArray[12])));
            } else {
                n2 = nArray[11] - OFFSET_HOUR;
                int n5 = nArray[12] - OFFSET_MINUTE;
                zoneId = ZoneId.of(ZoneOffset.ofHoursMinutes(n2, n5).toString());
            }
            ZonedDateTime zonedDateTime3 = zonedDateTime = zonedDateTime2.withZoneSameInstant(zoneId);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$41, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$41, null, zonedDateTime3);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$41, null, null);
            }
            return zonedDateTime3;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$41, null, throwable2);
            }
            throw throwable;
        }
    }

    public OffsetTime toOffsetTime() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$42, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$42, this, new Object[0]);
            }
            OffsetTime offsetTime = TIMESTAMPTZ.toOffsetDateTime(this.getBytes()).toOffsetTime();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$42, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$42, this, offsetTime);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$42, this, null);
            }
            return offsetTime;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$42, this, throwable2);
            }
            throw throwable;
        }
    }

    public static TIMESTAMPTZ of(OffsetDateTime offsetDateTime) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$43, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$43, null, offsetDateTime);
            }
            TIMESTAMPTZ tIMESTAMPTZ = new TIMESTAMPTZ(offsetDateTime);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$43, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$43, null, tIMESTAMPTZ);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$43, null, null);
            }
            return tIMESTAMPTZ;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$43, null, throwable2);
            }
            throw throwable;
        }
    }

    public static TIMESTAMPTZ of(Connection connection, LocalDateTime localDateTime) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$44, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$44, null, connection, localDateTime);
            }
            TIMESTAMPTZ tIMESTAMPTZ = new TIMESTAMPTZ(connection, localDateTime);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$44, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$44, null, tIMESTAMPTZ);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$44, null, null);
            }
            return tIMESTAMPTZ;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$44, null, throwable2);
            }
            throw throwable;
        }
    }

    public OffsetDateTime toOffsetDateTime() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$45, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$45, this, new Object[0]);
            }
            OffsetDateTime offsetDateTime = TIMESTAMPTZ.toOffsetDateTime(this.getBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$45, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$45, this, offsetDateTime);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$45, this, null);
            }
            return offsetDateTime;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$45, this, throwable2);
            }
            throw throwable;
        }
    }

    private static Calendar getWorkCal(Connection connection, Calendar calendar) {
        String string;
        Calendar calendar2 = calendar == null ? ((string = ((oracle.jdbc.OracleConnection)connection).getSessionTimeZone()) != null ? Calendar.getInstance(TimeZone.getTimeZone(string)) : Calendar.getInstance()) : Calendar.getInstance(calendar.getTimeZone());
        return calendar2;
    }

    private static Calendar doCalWork(Connection connection, Calendar calendar, byte[] byArray) throws SQLException {
        Object object;
        int n2;
        if (calendar.getTimeZone().getID() == "Custom") {
            n2 = calendar.getTimeZone().getRawOffset();
            byArray[11] = (byte)(n2 / HOUR_MILLISECOND + OFFSET_HOUR);
            byArray[12] = (byte)(n2 % HOUR_MILLISECOND / MINUTE_MILLISECOND + OFFSET_MINUTE);
        } else {
            object = calendar.getTimeZone().getID();
            int n3 = ZONEIDMAP.getID((String)object);
            if (!ZONEIDMAP.isValidID(n3)) {
                if (calendar.getTimeZone().useDaylightTime()) {
                    throw new SQLException("Timezone not supported: " + (String)object);
                }
                n2 = calendar.getTimeZone().getRawOffset();
                byArray[11] = (byte)(n2 / HOUR_MILLISECOND + OFFSET_HOUR);
                byArray[12] = (byte)(n2 % HOUR_MILLISECOND / MINUTE_MILLISECOND + OFFSET_MINUTE);
            } else {
                TIMEZONETAB tIMEZONETAB = TIMESTAMPTZ.getTIMEZONETAB(connection);
                if (tIMEZONETAB.checkID(n3)) {
                    tIMEZONETAB.updateTable(connection, n3);
                }
                OffsetDST offsetDST = new OffsetDST();
                byte by = tIMEZONETAB.getLocalOffset(calendar, n3, offsetDST);
                n2 = offsetDST.getOFFSET();
                boolean bl = calendar.getTimeZone().inDaylightTime(calendar.getTime());
                if (bl && by == 1) {
                    if (offsetDST.getDSTFLAG() == 0) {
                        n2 += HOUR_MILLISECOND;
                    } else {
                        throw new SQLException();
                    }
                }
                byArray[11] = (byte)TIMESTAMPTZ.setHighOrderbits(n3);
                byArray[11] = (byte)(byArray[11] | REGIONIDBIT);
                byArray[12] = (byte)TIMESTAMPTZ.setLowOrderbits(n3);
            }
        }
        object = (Calendar)CAL_GMT_US.clone();
        ((Calendar)object).set(0, calendar.get(0));
        ((Calendar)object).set(1, calendar.get(1));
        ((Calendar)object).set(2, calendar.get(2));
        ((Calendar)object).set(5, calendar.get(5));
        ((Calendar)object).set(11, calendar.get(11));
        ((Calendar)object).set(12, calendar.get(12));
        ((Calendar)object).set(13, calendar.get(13));
        ((Calendar)object).add(14, -1 * n2);
        return object;
    }

    private static byte[] initTimestamptz() {
        byte[] byArray = new byte[13];
        Calendar calendar = Calendar.getInstance();
        byArray[0] = 119;
        byArray[1] = -86;
        byArray[2] = 1;
        byArray[3] = 1;
        byArray[4] = 1;
        byArray[5] = 1;
        byArray[6] = 1;
        byArray[7] = 0;
        byArray[8] = 0;
        byArray[9] = 0;
        byArray[10] = 0;
        String string = calendar.getTimeZone().getID();
        byArray[11] = (byte)TIMESTAMPTZ.setHighOrderbits(ZONEIDMAP.getID(string));
        byArray[11] = (byte)(byArray[11] | REGIONIDBIT);
        byArray[12] = (byte)TIMESTAMPTZ.setLowOrderbits(ZONEIDMAP.getID(string));
        return byArray;
    }

    @Override
    public Object toJdbc() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$49, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$49, this, new Object[0]);
            }
            TIMESTAMPTZ tIMESTAMPTZ = this;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$49, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$49, this, tIMESTAMPTZ);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$49, this, null);
            }
            return tIMESTAMPTZ;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$49, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Object makeJdbcArray(int n2) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            Timestamp[] timestampArray;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$50, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$50, this, n2);
            }
            Timestamp[] timestampArray2 = timestampArray = new Timestamp[n2];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$50, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$50, this, timestampArray2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$50, this, null);
            }
            return timestampArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$50, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean isConvertibleTo(Class<?> clazz) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$51, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$51, this, clazz);
            }
            if (clazz.getName().compareTo("java.sql.Date") == 0 || clazz.getName().compareTo("java.sql.Time") == 0 || clazz.getName().compareTo("java.sql.Timestamp") == 0 || clazz.getName().compareTo("java.lang.String") == 0) {
                boolean bl2 = true;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$51, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$51, this, bl2);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$51, this, null);
                }
                return true;
            }
            boolean bl3 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$51, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$51, this, bl3);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$51, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$51, this, throwable2);
            }
            throw throwable;
        }
    }

    private static Timestamp parseTimestamp(String string) throws SQLException {
        Object object;
        Object object2;
        int n2;
        String string2;
        if (string == null) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        String string3 = string.trim();
        int n3 = string3.indexOf(32);
        if (n3 == -1) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        String string4 = string3.substring(0, n3).trim();
        if (string4 == null | (string2 = string3.substring(n3 + 1).trim()) == null) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        int n4 = string4.indexOf(45);
        int n5 = string4.indexOf(45, n4 + 1);
        if (n4 < 1 || n5 < 1 || n5 == string4.length()) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        String string5 = string4.substring(0, n4);
        String string6 = string4.substring(n4 + 1, n5);
        String string7 = string4.substring(n5 + 1);
        if (string5.length() != 4 || string6.length() != 2 || string7.length() != 2) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        int n6 = Integer.parseInt(string5);
        int n7 = Integer.parseInt(string6) - 1;
        int n8 = Integer.parseInt(string7);
        int n9 = string2.indexOf(58);
        int n10 = string2.indexOf(58, n9 + 1);
        if (n9 < 1 || n10 < 1 || n10 == string2.length()) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        String string8 = string2.substring(0, n9);
        String string9 = string2.substring(n9 + 1, n10);
        if (string8.length() != 2 || string9.length() != 2) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        int n11 = Integer.parseInt(string8);
        int n12 = Integer.parseInt(string9);
        int n13 = 0;
        int n14 = string2.indexOf(46, n10 + 1);
        if (n14 == -1) {
            n2 = Integer.parseInt(string2.substring(n10 + 1));
        } else if (n14 > 0 && n14 < string2.length() - 1) {
            n2 = Integer.parseInt(string2.substring(n10 + 1, n14));
            object2 = string2.substring(n14 + 1);
            object = "000000000";
            if (((String)object2).length() > ((String)object).length() || !Character.isDigit(((String)object2).charAt(0))) {
                throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
            }
            object2 = (String)object2 + ((String)object).substring(0, ((String)object).length() - ((String)object2).length());
            n13 = Integer.parseInt((String)object2);
        } else {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        object2 = (Calendar)CAL_GMT_US.clone();
        ((Calendar)object2).set(1, n6);
        ((Calendar)object2).set(2, n7);
        ((Calendar)object2).set(5, n8);
        ((Calendar)object2).set(11, n11);
        ((Calendar)object2).set(12, n12);
        ((Calendar)object2).set(13, n2);
        ((Calendar)object2).set(14, 0);
        object = new Timestamp(((Calendar)object2).getTime().getTime());
        ((Timestamp)object).setNanos(n13);
        return object;
    }

    private static byte[] parseTimestampTz(Connection connection, String string) throws SQLException {
        Object object;
        Object object2;
        int n2;
        String string2;
        String string3;
        if (string == null) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        String string4 = string.trim();
        int n3 = string4.indexOf(32);
        if (n3 == -1) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        String string5 = string4.substring(0, n3).trim();
        if (string5 == null | (string3 = string4.substring(n3 + 1).trim()) == null) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        boolean bl = false;
        if (string5.charAt(0) == '-') {
            bl = true;
            if (string5.length() > 1) {
                string5 = string5.substring(1);
            } else {
                throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
            }
        }
        int n4 = string5.indexOf(45);
        int n5 = string5.indexOf(45, n4 + 1);
        if (n4 < 1 || n5 < 1 || n5 == string5.length()) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        String string6 = string5.substring(0, n4);
        String string7 = string5.substring(n4 + 1, n5);
        String string8 = string5.substring(n5 + 1);
        if (string6.length() != 4 || string7.length() != 2 || string8.length() != 2) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        int n6 = Integer.parseInt(string6);
        int n7 = Integer.parseInt(string7) - 1;
        int n8 = Integer.parseInt(string8);
        if (bl) {
            n6 = -n6;
        }
        int n9 = string3.indexOf(58);
        int n10 = string3.indexOf(58, n9 + 1);
        n3 = string3.indexOf(32);
        if (n3 != -1) {
            string2 = string3.substring(n3 + 1).trim();
            string3 = string3.substring(0, n3).trim();
        } else {
            string2 = null;
        }
        if (n9 < 1 || n10 < 1 || n10 == string3.length()) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        String string9 = string3.substring(0, n9);
        String string10 = string3.substring(n9 + 1, n10);
        if (string9.length() != 2 || string10.length() != 2) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        int n11 = Integer.parseInt(string9);
        int n12 = Integer.parseInt(string10);
        int n13 = 0;
        int n14 = string3.indexOf(46, n10 + 1);
        if (n14 == -1) {
            n2 = Integer.parseInt(string3.substring(n10 + 1));
        } else if (n14 > 0 && n14 < string3.length() - 1) {
            n2 = Integer.parseInt(string3.substring(n10 + 1, n14));
            object2 = string3.substring(n14 + 1);
            object = "000000000";
            if (((String)object2).length() > ((String)object).length() || !Character.isDigit(((String)object2).charAt(0))) {
                throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
            }
            object2 = (String)object2 + ((String)object).substring(0, ((String)object).length() - ((String)object2).length());
            n13 = Integer.parseInt((String)object2);
        } else {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        object2 = null;
        if (string2 != null) {
            char c2 = string2.charAt(0);
            if (c2 == '-') {
                string2 = "GMT" + string2;
            } else if (Character.isDigit(c2)) {
                string2 = "GMT+" + string2;
            }
            object2 = Calendar.getInstance(TimeZone.getTimeZone(string2));
        }
        object = object2 == null ? (Calendar)CAL_GMT_US.clone() : object2;
        ((Calendar)object).set(1, n6);
        ((Calendar)object).set(2, n7);
        ((Calendar)object).set(5, n8);
        ((Calendar)object).set(11, n11);
        ((Calendar)object).set(12, n12);
        ((Calendar)object).set(13, n2);
        ((Calendar)object).set(14, 0);
        Timestamp timestamp = new Timestamp(((Calendar)object).getTime().getTime());
        timestamp.setNanos(n13);
        return TIMESTAMPTZ.toBytes(connection, timestamp, (Calendar)object2);
    }

    private static int setHighOrderbits(int n2) {
        return (n2 & 0x1FC0) >> 6;
    }

    private static int setLowOrderbits(int n2) {
        return (n2 & 0x3F) << 2;
    }

    private static int getHighOrderbits(int n2) {
        return (n2 & 0x7F) << 6;
    }

    private static int getLowOrderbits(int n2) {
        return (n2 & 0xFC) >> 2;
    }

    static TIMEZONETAB getTIMEZONETAB(Connection connection) throws SQLException {
        OracleConnection oracleConnection = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin();
        return oracleConnection.getTIMEZONETAB();
    }

    static {
        try {
            $$$methodRef$$$74 = TIMESTAMPTZ.class.getDeclaredConstructor(OffsetTime.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$74 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$73 = TIMESTAMPTZ.class.getDeclaredConstructor(Connection.class, LocalDateTime.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$73 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$72 = TIMESTAMPTZ.class.getDeclaredConstructor(ZonedDateTime.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$72 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$71 = TIMESTAMPTZ.class.getDeclaredConstructor(OffsetDateTime.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$71 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$70 = TIMESTAMPTZ.class.getDeclaredConstructor(Connection.class, String.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$70 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$69 = TIMESTAMPTZ.class.getDeclaredConstructor(Connection.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$69 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$68 = TIMESTAMPTZ.class.getDeclaredConstructor(Connection.class, DATE.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$68 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$67 = TIMESTAMPTZ.class.getDeclaredConstructor(Connection.class, Timestamp.class, ZoneId.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$67 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$66 = TIMESTAMPTZ.class.getDeclaredConstructor(Connection.class, Timestamp.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$66 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$65 = TIMESTAMPTZ.class.getDeclaredConstructor(Connection.class, Timestamp.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$65 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$64 = TIMESTAMPTZ.class.getDeclaredConstructor(Connection.class, Time.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$64 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$63 = TIMESTAMPTZ.class.getDeclaredConstructor(Connection.class, Time.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$63 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$62 = TIMESTAMPTZ.class.getDeclaredConstructor(Connection.class, Date.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$62 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$61 = TIMESTAMPTZ.class.getDeclaredConstructor(Connection.class, Date.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$61 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$60 = TIMESTAMPTZ.class.getDeclaredConstructor(byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$60 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$59 = TIMESTAMPTZ.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$59 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$58 = TIMESTAMPTZ.class.getDeclaredMethod("getTIMEZONETAB", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$58 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$57 = TIMESTAMPTZ.class.getDeclaredMethod("getLowOrderbits", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$56 = TIMESTAMPTZ.class.getDeclaredMethod("getHighOrderbits", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$55 = TIMESTAMPTZ.class.getDeclaredMethod("setLowOrderbits", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$54 = TIMESTAMPTZ.class.getDeclaredMethod("setHighOrderbits", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$53 = TIMESTAMPTZ.class.getDeclaredMethod("parseTimestampTz", Connection.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$52 = TIMESTAMPTZ.class.getDeclaredMethod("parseTimestamp", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$51 = TIMESTAMPTZ.class.getDeclaredMethod("isConvertibleTo", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$50 = TIMESTAMPTZ.class.getDeclaredMethod("makeJdbcArray", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$49 = TIMESTAMPTZ.class.getDeclaredMethod("toJdbc", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$48 = TIMESTAMPTZ.class.getDeclaredMethod("initTimestamptz", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$47 = TIMESTAMPTZ.class.getDeclaredMethod("doCalWork", Connection.class, Calendar.class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$46 = TIMESTAMPTZ.class.getDeclaredMethod("getWorkCal", Connection.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$45 = TIMESTAMPTZ.class.getDeclaredMethod("toOffsetDateTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$44 = TIMESTAMPTZ.class.getDeclaredMethod("of", Connection.class, LocalDateTime.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$43 = TIMESTAMPTZ.class.getDeclaredMethod("of", OffsetDateTime.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$42 = TIMESTAMPTZ.class.getDeclaredMethod("toOffsetTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$41 = TIMESTAMPTZ.class.getDeclaredMethod("toZonedDateTime", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$40 = TIMESTAMPTZ.class.getDeclaredMethod("toLocalDateTime", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$39 = TIMESTAMPTZ.class.getDeclaredMethod("toLocalDateTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$38 = TIMESTAMPTZ.class.getDeclaredMethod("toZonedDateTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$37 = TIMESTAMPTZ.class.getDeclaredMethod("of", ZonedDateTime.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$36 = TIMESTAMPTZ.class.getDeclaredMethod("getTimeZone", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$35 = TIMESTAMPTZ.class.getDeclaredMethod("getTimeZone", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$34 = TIMESTAMPTZ.class.getDeclaredMethod("timeValue", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$33 = TIMESTAMPTZ.class.getDeclaredMethod("dateValue", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$32 = TIMESTAMPTZ.class.getDeclaredMethod("localDateTimeValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$31 = TIMESTAMPTZ.class.getDeclaredMethod("zonedDateTimeValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$30 = TIMESTAMPTZ.class.getDeclaredMethod("offsetDateTimeValue", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$29 = TIMESTAMPTZ.class.getDeclaredMethod("toBytes", OffsetTime.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$28 = TIMESTAMPTZ.class.getDeclaredMethod("toBytes", Connection.class, LocalDateTime.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$27 = TIMESTAMPTZ.class.getDeclaredMethod("toBytes", ZonedDateTime.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$26 = TIMESTAMPTZ.class.getDeclaredMethod("toBytes", OffsetDateTime.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$25 = TIMESTAMPTZ.class.getDeclaredMethod("stringValue", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$24 = TIMESTAMPTZ.class.getDeclaredMethod("toBytes", Connection.class, String.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$23 = TIMESTAMPTZ.class.getDeclaredMethod("toBytes", Connection.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$22 = TIMESTAMPTZ.class.getDeclaredMethod("toBytes", Connection.class, DATE.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$21 = TIMESTAMPTZ.class.getDeclaredMethod("toBytes", Timestamp.class, ZoneId.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$20 = TIMESTAMPTZ.class.getDeclaredMethod("toBytes", Connection.class, Timestamp.class, ZoneId.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$19 = TIMESTAMPTZ.class.getDeclaredMethod("toBytes", Connection.class, Timestamp.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$18 = TIMESTAMPTZ.class.getDeclaredMethod("toBytes", Connection.class, Timestamp.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$17 = TIMESTAMPTZ.class.getDeclaredMethod("toBytes", Connection.class, Time.class, ZoneId.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$16 = TIMESTAMPTZ.class.getDeclaredMethod("toBytes", Connection.class, Time.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$15 = TIMESTAMPTZ.class.getDeclaredMethod("toBytes", Connection.class, Time.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$14 = TIMESTAMPTZ.class.getDeclaredMethod("toBytes", Connection.class, Date.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$13 = TIMESTAMPTZ.class.getDeclaredMethod("toBytes", Connection.class, Date.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$12 = TIMESTAMPTZ.class.getDeclaredMethod("toBytes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$11 = TIMESTAMPTZ.class.getDeclaredMethod("timestampValue", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$10 = TIMESTAMPTZ.class.getDeclaredMethod("toStr", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$9 = TIMESTAMPTZ.class.getDeclaredMethod("toOffsetDateTime", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$8 = TIMESTAMPTZ.class.getDeclaredMethod("toOffsetDateTime", Connection.class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$7 = TIMESTAMPTZ.class.getDeclaredMethod("toTimestampInSessionTimezone", Connection.class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$6 = TIMESTAMPTZ.class.getDeclaredMethod("toTimestamp2", Connection.class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$5 = TIMESTAMPTZ.class.getDeclaredMethod("toTimestamp", Connection.class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$4 = TIMESTAMPTZ.class.getDeclaredMethod("toTIMESTAMP", Connection.class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$3 = TIMESTAMPTZ.class.getDeclaredMethod("toDATE", Connection.class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$2 = TIMESTAMPTZ.class.getDeclaredMethod("toTime", Connection.class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$1 = TIMESTAMPTZ.class.getDeclaredMethod("toDate2", Connection.class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$0 = TIMESTAMPTZ.class.getDeclaredMethod("toDate", Connection.class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        CAL_GMT_US = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.US);
        TIMEZONE_UTC = TimeZone.getTimeZone("UTC");
        HOUR_MILLISECOND = 3600000;
        MINUTE_MILLISECOND = 60000;
        SECOND_MILLISECOND = 1000;
        HOUR_SECOND = 3600;
        MINUTE_SECOND = 60;
        OFFSET_HOUR = 20;
        OFFSET_MINUTE = 60;
        REGIONIDBIT = (byte)-128;
    }
}

