/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql.converter;

import java.lang.reflect.Executable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.converter.InternalCharacterSetMetaData;
import oracle.sql.converter.Orai18nCharacterSetMetaData;

public class CharacterSetMetaData {
    static final short WIDTH_SIZE = 8;
    static final short WIDTH_MASK = 255;
    static final short FLAG_FIXEDWIDTH = 256;
    public static final int ST_BADCODESET = 0;
    private static final HashMap language;
    private static final HashMap territory;
    static InternalCharacterSetMetaData metaDataImpl;
    private static final short[][] m_maxCharWidth;
    private static final String _Copyright_2014_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Tue_Aug_11_01:29:46_PDT_2020";
    public static boolean TRACE;
    private static Logger LOGGER;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void getMapProperties() {
        try {
            String[] stringArray = new String[]{"oracle.jdbc.languageMap", "oracle.jdbc.territoryMap"};
            HashMap[] hashMapArray = new HashMap[]{language, territory};
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                StringTokenizer stringTokenizer;
                final String string = stringArray[i2];
                String string2 = AccessController.doPrivileged(new PrivilegedAction<String>(){
                    private static Executable $$$methodRef$$$0;
                    private static Logger $$$loggerRef$$$0;
                    private static Executable $$$methodRef$$$1;
                    private static Logger $$$loggerRef$$$1;
                    private static Executable $$$methodRef$$$2;
                    private static Logger $$$loggerRef$$$2;

                    @Override
                    public String run() {
                        return System.getProperty(string, null);
                    }

                    static {
                        try {
                            $$$methodRef$$$2 = 1.class.getDeclaredConstructor(String.class);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                        try {
                            $$$methodRef$$$1 = 1.class.getDeclaredMethod("run", new Class[0]);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                        try {
                            $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    }
                });
                if (string2 == null || (stringTokenizer = new StringTokenizer(string2, "=;")).countTokens() % 2 != 0) continue;
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    String string4 = stringTokenizer.nextToken();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            CharacterSetMetaData.logger().log(Level.INFO, "         Public event: Adding from " + string + ": " + string3 + "=" + string4);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    hashMapArray[i2].put(string3, string4);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static HashSet<String> getTerritories() {
        return new HashSet<String>(territory.values());
    }

    public static HashSet<String> getLanguages() {
        return new HashSet<String>(language.values());
    }

    public static String getNLSLanguage(Locale locale) {
        String string = null;
        string = (String)language.get(locale.getLanguage() + "_" + locale.getCountry());
        if (string == null) {
            string = (String)language.get(locale.getLanguage());
        }
        return string;
    }

    public static String getNLSTerritory(Locale locale) {
        String string = null;
        string = (String)territory.get(locale.getLanguage() + "_" + locale.getCountry());
        if (string == null && (string = (String)territory.get(locale.getCountry())) == null) {
            string = (String)territory.get(locale.getLanguage());
        }
        return string;
    }

    public static boolean isFixedWidth(int n2) throws SQLException {
        boolean bl = false;
        try {
            bl = metaDataImpl.isFixedWidth(n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetMetaData.logger().log(Level.SEVERE, "         Throwing SQLException: 56");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(null, 56);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return bl;
    }

    public static int getRatio(int n2, int n3) {
        if (n3 == n2) {
            return 1;
        }
        int n4 = metaDataImpl.getMaxCharLength(n2);
        if (n4 == 0) {
            return 0;
        }
        if (n4 == 1) {
            return 1;
        }
        if (n3 == 1) {
            return n4;
        }
        if (metaDataImpl.isFixedWidth(n3)) {
            return n4;
        }
        int n5 = metaDataImpl.getMaxCharLength(n3);
        if (n5 == 0) {
            return 0;
        }
        int n6 = n4 / n5;
        if (n4 % n5 != 0) {
            ++n6;
        }
        return n6;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql.converter");
        }
        return LOGGER;
    }

    static {
        try {
            $$$methodRef$$$9 = CharacterSetMetaData.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = CharacterSetMetaData.class.getDeclaredMethod("access$000", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = CharacterSetMetaData.class.getDeclaredMethod("logger", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = CharacterSetMetaData.class.getDeclaredMethod("getRatio", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = CharacterSetMetaData.class.getDeclaredMethod("isFixedWidth", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = CharacterSetMetaData.class.getDeclaredMethod("getNLSTerritory", Locale.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = CharacterSetMetaData.class.getDeclaredMethod("getNLSLanguage", Locale.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = CharacterSetMetaData.class.getDeclaredMethod("getLanguages", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = CharacterSetMetaData.class.getDeclaredMethod("getTerritories", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = CharacterSetMetaData.class.getDeclaredMethod("getMapProperties", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        language = new HashMap(58, 1.0f);
        territory = new HashMap(134, 1.0f);
        language.put("", "AMERICAN");
        language.put("am", "AMHARIC");
        language.put("ar_EG", "EGYPTIAN");
        language.put("ar", "ARABIC");
        language.put("as", "ASSAMESE");
        language.put("az", "AZERBAIJANI");
        language.put("be", "BELARUSIAN");
        language.put("bg", "BULGARIAN");
        language.put("bn", "BANGLA");
        language.put("ca", "CATALAN");
        language.put("ckk", "CYRILLIC KAZAKH");
        language.put("cs", "CZECH");
        language.put("csr", "CYRILLIC SERBIAN");
        language.put("cuz", "CYRILLIC UZBEK");
        language.put("d", "GERMAN");
        language.put("da", "DANISH");
        language.put("de", "GERMAN");
        language.put("din", "GERMAN DIN");
        language.put("dk", "DANISH");
        language.put("dv", "DIVEHI");
        language.put("e", "SPANISH");
        language.put("eg", "EGYPTIAN");
        language.put("el", "GREEK");
        language.put("en", "AMERICAN");
        language.put("es", "LATIN AMERICAN SPANISH");
        language.put("esa", "LATIN AMERICAN SPANISH");
        language.put("esm", "MEXICAN SPANISH");
        language.put("es_ES", "SPANISH");
        language.put("es_MX", "MEXICAN SPANISH");
        language.put("et", "ESTONIAN");
        language.put("eu", "BASQUE");
        language.put("f", "FRENCH");
        language.put("fa", "PERSIAN");
        language.put("fi", "FINNISH");
        language.put("fr", "FRENCH");
        language.put("frc", "CANADIAN FRENCH");
        language.put("fr_CA", "CANADIAN FRENCH");
        language.put("ga", "IRISH");
        language.put("gb", "ENGLISH");
        language.put("gu", "GUJARATI");
        language.put("he", "HEBREW");
        language.put("hi", "HINDI");
        language.put("hr", "CROATIAN");
        language.put("hu", "HUNGARIAN");
        language.put("hy", "ARMENIAN");
        language.put("i", "ITALIAN");
        language.put("id", "INDONESIAN");
        language.put("in", "INDONESIAN");
        language.put("is", "ICELANDIC");
        language.put("it", "ITALIAN");
        language.put("iw", "HEBREW");
        language.put("ja", "JAPANESE");
        language.put("kk", "CYRILLIC KAZAKH");
        language.put("kk_KZ", "CYRILLIC KAZAKH");
        language.put("km", "KHMER");
        language.put("kn", "KANNADA");
        language.put("ko", "KOREAN");
        language.put("lbs", "LATIN BOSNIAN");
        language.put("lo", "LAO");
        language.put("lsr", "LATIN SERBIAN");
        language.put("lt", "LITHUANIAN");
        language.put("luz", "LATIN UZBEK");
        language.put("lv", "LATVIAN");
        language.put("mk", "MACEDONIAN");
        language.put("ml", "MALAYALAM");
        language.put("mr", "MARATHI");
        language.put("ms", "MALAY");
        language.put("mt", "MALTESE");
        language.put("n", "NORWEGIAN");
        language.put("nb", "NORWEGIAN");
        language.put("ne", "NEPALI");
        language.put("nl", "DUTCH");
        language.put("no", "NORWEGIAN");
        language.put("or", "ORIYA");
        language.put("pa", "PUNJABI");
        language.put("pl", "POLISH");
        language.put("prs", "DARI");
        language.put("pt", "PORTUGUESE");
        language.put("ptb", "BRAZILIAN PORTUGUESE");
        language.put("pt_BR", "BRAZILIAN PORTUGUESE");
        language.put("ro", "ROMANIAN");
        language.put("ru", "RUSSIAN");
        language.put("s", "SWEDISH");
        language.put("sf", "FINNISH");
        language.put("sh", "LATIN SERBIAN");
        language.put("si", "SINHALA");
        language.put("sk", "SLOVAK");
        language.put("sl", "SLOVENIAN");
        language.put("sq", "ALBANIAN");
        language.put("sr", "CYRILLIC SERBIAN");
        language.put("sv", "SWEDISH");
        language.put("sw", "SWAHILI");
        language.put("ta", "TAMIL");
        language.put("te", "TELUGU");
        language.put("th", "THAI");
        language.put("tk", "TURKMEN");
        language.put("tr", "TURKISH");
        language.put("uk", "UKRAINIAN");
        language.put("ur", "URDU");
        language.put("us", "AMERICAN");
        language.put("vi", "VIETNAMESE");
        language.put("vn", "VIETNAMESE");
        language.put("zh", "SIMPLIFIED CHINESE");
        language.put("zhs", "SIMPLIFIED CHINESE");
        language.put("zht", "TRADITIONAL CHINESE");
        language.put("zh_HK", "TRADITIONAL CHINESE");
        language.put("zh_TW", "TRADITIONAL CHINESE");
        territory.put("AE", "UNITED ARAB EMIRATES");
        territory.put("AF", "AFGHANISTAN");
        territory.put("AG", "ANTIGUA AND BARBUDA");
        territory.put("AL", "ALBANIA");
        territory.put("AM", "ARMENIA");
        territory.put("AO", "ANGOLA");
        territory.put("AR", "ARGENTINA");
        territory.put("AT", "AUSTRIA");
        territory.put("AU", "AUSTRALIA");
        territory.put("AW", "ARUBA");
        territory.put("AZ", "AZERBAIJAN");
        territory.put("BA", "BOSNIA AND HERZEGOVINA");
        territory.put("BB", "BARBADOS");
        territory.put("BD", "BANGLADESH");
        territory.put("BE", "BELGIUM");
        territory.put("BG", "BULGARIA");
        territory.put("BH", "BAHRAIN");
        territory.put("BM", "BERMUDA");
        territory.put("BO", "BOLIVIA");
        territory.put("BR", "BRAZIL");
        territory.put("BS", "BAHAMAS");
        territory.put("BW", "BOTSWANA");
        territory.put("BY", "BELARUS");
        territory.put("BZ", "BELIZE");
        territory.put("CA", "CANADA");
        territory.put("CD", "CONGO KINSHASA");
        territory.put("CG", "CONGO BRAZZAVILLE");
        territory.put("CH", "SWITZERLAND");
        territory.put("CI", "IVORY COAST");
        territory.put("CL", "CHILE");
        territory.put("CM", "CAMEROON");
        territory.put("CN", "CHINA");
        territory.put("CO", "COLOMBIA");
        territory.put("CR", "COSTA RICA");
        territory.put("CW", "CURACAO");
        territory.put("CY", "CYPRUS");
        territory.put("CZ", "CZECH REPUBLIC");
        territory.put("DE", "GERMANY");
        territory.put("DJ", "DJIBOUTI");
        territory.put("DK", "DENMARK");
        territory.put("DM", "DOMINICA");
        territory.put("DO", "DOMINICAN REPUBLIC");
        territory.put("DZ", "ALGERIA");
        territory.put("EC", "ECUADOR");
        territory.put("EE", "ESTONIA");
        territory.put("EG", "EGYPT");
        territory.put("ES", "SPAIN");
        territory.put("ET", "ETHIOPIA");
        territory.put("FI", "FINLAND");
        territory.put("FR", "FRANCE");
        territory.put("GA", "GABON");
        territory.put("GB", "UNITED KINGDOM");
        territory.put("GD", "GRENADA");
        territory.put("GH", "GHANA");
        territory.put("GR", "GREECE");
        territory.put("GT", "GUATEMALA");
        territory.put("GY", "GUYANA");
        territory.put("HK", "HONG KONG");
        territory.put("HN", "HONDURAS");
        territory.put("HR", "CROATIA");
        territory.put("HT", "HAITI");
        territory.put("HU", "HUNGARY");
        territory.put("ID", "INDONESIA");
        territory.put("IE", "IRELAND");
        territory.put("IL", "ISRAEL");
        territory.put("IN", "INDIA");
        territory.put("IQ", "IRAQ");
        territory.put("IR", "IRAN");
        territory.put("IS", "ICELAND");
        territory.put("IT", "ITALY");
        territory.put("JM", "JAMAICA");
        territory.put("JO", "JORDAN");
        territory.put("JP", "JAPAN");
        territory.put("KE", "KENYA");
        territory.put("KH", "CAMBODIA");
        territory.put("KN", "SAINT KITTS AND NEVIS");
        territory.put("KR", "KOREA");
        territory.put("KW", "KUWAIT");
        territory.put("KY", "CAYMAN ISLANDS");
        territory.put("LA", "LAOS");
        territory.put("LB", "LEBANON");
        territory.put("LC", "SAINT LUCIA");
        territory.put("LI", "LIECHTENSTEIN");
        territory.put("LK", "SRI LANKA");
        territory.put("LT", "LITHUANIA");
        territory.put("LU", "LUXEMBOURG");
        territory.put("LV", "LATVIA");
        territory.put("LY", "LIBYA");
        territory.put("MA", "MOROCCO");
        territory.put("MD", "MOLDOVA");
        territory.put("ME", "MONTENEGRO");
        territory.put("MK", "FYR MACEDONIA");
        territory.put("MO", "MACAO");
        territory.put("MR", "MAURITANIA");
        territory.put("MT", "MALTA");
        territory.put("MU", "MAURITIUS");
        territory.put("MV", "MALDIVES");
        territory.put("MW", "MALAWI");
        territory.put("MX", "MEXICO");
        territory.put("MY", "MALAYSIA");
        territory.put("MZ", "MOZAMBIQUE");
        territory.put("NA", "NAMIBIA");
        territory.put("NG", "NIGERIA");
        territory.put("NI", "NICARAGUA");
        territory.put("NL", "THE NETHERLANDS");
        territory.put("NO", "NORWAY");
        territory.put("NP", "NEPAL");
        territory.put("NZ", "NEW ZEALAND");
        territory.put("OM", "OMAN");
        territory.put("PA", "PANAMA");
        territory.put("PE", "PERU");
        territory.put("PH", "PHILIPPINES");
        territory.put("PK", "PAKISTAN");
        territory.put("PL", "POLAND");
        territory.put("PR", "PUERTO RICO");
        territory.put("PT", "PORTUGAL");
        territory.put("PY", "PARAGUAY");
        territory.put("QA", "QATAR");
        territory.put("RO", "ROMANIA");
        territory.put("RS", "SERBIA");
        territory.put("RU", "RUSSIA");
        territory.put("SA", "SAUDI ARABIA");
        territory.put("SD", "SUDAN");
        territory.put("SE", "SWEDEN");
        territory.put("SG", "SINGAPORE");
        territory.put("SI", "SLOVENIA");
        territory.put("SK", "SLOVAKIA");
        territory.put("SL", "SIERRA LEONE");
        territory.put("SN", "SENEGAL");
        territory.put("SO", "SOMALIA");
        territory.put("SR", "SURINAME");
        territory.put("SS", "SOUTH SUDAN");
        territory.put("SV", "EL SALVADOR");
        territory.put("SY", "SYRIA");
        territory.put("SZ", "SWAZILAND");
        territory.put("TH", "THAILAND");
        territory.put("TM", "TURKMENISTAN");
        territory.put("TN", "TUNISIA");
        territory.put("TR", "TURKEY");
        territory.put("TT", "TRINIDAD AND TOBAGO");
        territory.put("TW", "TAIWAN");
        territory.put("TZ", "TANZANIA");
        territory.put("UA", "UKRAINE");
        territory.put("UG", "UGANDA");
        territory.put("US", "AMERICA");
        territory.put("UY", "URUGUAY");
        territory.put("UZ", "UZBEKISTAN");
        territory.put("VE", "VENEZUELA");
        territory.put("VN", "VIETNAM");
        territory.put("YE", "YEMEN");
        territory.put("ZA", "SOUTH AFRICA");
        territory.put("ZM", "ZAMBIA");
        territory.put("ZW", "ZIMBABWE");
        territory.put("ca_ES", "CATALONIA");
        territory.put("ar", "SAUDI ARABIA");
        territory.put("as", "INDIA");
        territory.put("bg", "BULGARIA");
        territory.put("bn", "BANGLADESH");
        territory.put("ca", "CATALONIA");
        territory.put("cs", "CZECH REPUBLIC");
        territory.put("CS", "CZECHOSLOVAKIA");
        territory.put("da", "DENMARK");
        territory.put("de", "GERMANY");
        territory.put("el", "GREECE");
        territory.put("en", "AMERICA");
        territory.put("es", "AMERICA");
        territory.put("et", "ESTONIA");
        territory.put("fi", "FINLAND");
        territory.put("fr", "FRANCE");
        territory.put("gu", "INDIA");
        territory.put("he", "ISRAEL");
        territory.put("hi", "INDIA");
        territory.put("hr", "CROATIA");
        territory.put("hu", "HUNGARY");
        territory.put("id", "INDONESIA");
        territory.put("in", "INDONESIA");
        territory.put("is", "ICELAND");
        territory.put("it", "ITALY");
        territory.put("iw", "ISRAEL");
        territory.put("ja", "JAPAN");
        territory.put("kn", "INDIA");
        territory.put("ko", "KOREA");
        territory.put("kk", "KAZAKHSTAN");
        territory.put("kk_KZ", "KAZAKHSTAN");
        territory.put("lt", "LITHUANIA");
        territory.put("lv", "LATVIA");
        territory.put("mk", "FYR MACEDONIA");
        territory.put("ml", "INDIA");
        territory.put("mr", "INDIA");
        territory.put("ms", "MALAYSIA");
        territory.put("nl", "THE NETHERLANDS");
        territory.put("no", "NORWAY");
        territory.put("or", "INDIA");
        territory.put("pa", "INDIA");
        territory.put("pl", "POLAND");
        territory.put("pt", "PORTUGAL");
        territory.put("ro", "ROMANIA");
        territory.put("ru", "CIS");
        territory.put("sk", "SLOVAKIA");
        territory.put("sl", "SLOVENIA");
        territory.put("sq", "ALBANIA");
        territory.put("sr", "SERBIA AND MONTENEGRO");
        territory.put("sh", "SERBIA AND MONTENEGRO");
        territory.put("sv", "SWEDEN");
        territory.put("ta", "INDIA");
        territory.put("te", "INDIA");
        territory.put("th", "THAILAND");
        territory.put("tr", "TURKEY");
        territory.put("uk", "UKRAINE");
        territory.put("vi", "VIETNAM");
        territory.put("YU", "YUGOSLAVIA");
        territory.put("zh", "CHINA");
        metaDataImpl = null;
        Orai18nCharacterSetMetaData orai18nCharacterSetMetaData = null;
        try {
            Class.forName("oracle.i18n.text.OraBoot");
            orai18nCharacterSetMetaData = new Orai18nCharacterSetMetaData();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        metaDataImpl = orai18nCharacterSetMetaData != null && orai18nCharacterSetMetaData.oraBoot != null ? orai18nCharacterSetMetaData : new JdbcCharacterSetMetaData();
        m_maxCharWidth = new short[][]{{1, 1}, {2, 1}, {3, 1}, {4, 1}, {5, 1}, {6, 1}, {7, 1}, {8, 1}, {9, 1}, {10, 1}, {11, 1}, {12, 1}, {13, 1}, {14, 1}, {15, 1}, {16, 1}, {17, 1}, {18, 1}, {19, 1}, {20, 1}, {21, 1}, {22, 1}, {23, 1}, {25, 1}, {27, 1}, {28, 1}, {31, 1}, {32, 1}, {33, 1}, {34, 1}, {35, 1}, {36, 1}, {37, 1}, {38, 1}, {39, 1}, {40, 1}, {41, 1}, {42, 1}, {43, 1}, {44, 1}, {45, 1}, {46, 1}, {47, 1}, {48, 1}, {49, 1}, {50, 1}, {51, 1}, {61, 1}, {70, 1}, {72, 1}, {81, 1}, {82, 1}, {90, 1}, {91, 1}, {92, 1}, {93, 1}, {94, 1}, {95, 1}, {96, 1}, {97, 1}, {98, 1}, {99, 1}, {100, 1}, {101, 1}, {110, 1}, {113, 1}, {114, 1}, {140, 1}, {150, 1}, {152, 1}, {153, 1}, {154, 1}, {155, 1}, {156, 1}, {158, 1}, {159, 1}, {160, 1}, {161, 1}, {162, 1}, {163, 1}, {164, 1}, {165, 1}, {166, 1}, {167, 1}, {170, 1}, {171, 1}, {172, 1}, {173, 1}, {174, 1}, {175, 1}, {176, 1}, {177, 1}, {178, 1}, {179, 1}, {180, 1}, {181, 1}, {182, 1}, {183, 1}, {184, 1}, {185, 1}, {186, 1}, {187, 1}, {188, 1}, {189, 1}, {190, 1}, {191, 1}, {192, 1}, {193, 1}, {194, 1}, {195, 1}, {196, 1}, {197, 1}, {198, 1}, {199, 1}, {200, 1}, {201, 1}, {202, 1}, {203, 1}, {204, 1}, {205, 1}, {206, 1}, {207, 1}, {208, 1}, {210, 1}, {211, 1}, {221, 1}, {222, 1}, {223, 1}, {224, 1}, {225, 1}, {226, 1}, {230, 1}, {231, 1}, {232, 1}, {233, 1}, {235, 1}, {239, 1}, {241, 1}, {251, 1}, {261, 1}, {262, 1}, {263, 1}, {264, 1}, {265, 1}, {266, 1}, {267, 1}, {277, 1}, {278, 1}, {279, 1}, {301, 1}, {311, 1}, {312, 1}, {314, 1}, {315, 1}, {316, 1}, {317, 1}, {319, 1}, {320, 1}, {322, 1}, {323, 1}, {324, 1}, {351, 1}, {352, 1}, {353, 1}, {354, 1}, {368, 1}, {380, 1}, {381, 1}, {382, 1}, {383, 1}, {384, 1}, {385, 1}, {386, 1}, {390, 1}, {401, 1}, {500, 1}, {504, 1}, {505, 1}, {506, 1}, {507, 1}, {508, 1}, {509, 1}, {511, 1}, {514, 1}, {554, 1}, {555, 1}, {556, 1}, {557, 1}, {558, 1}, {559, 1}, {560, 1}, {561, 1}, {563, 1}, {565, 1}, {566, 1}, {567, 1}, {590, 1}, {798, 1}, {799, 258}, {829, 2}, {830, 3}, {831, 3}, {832, 2}, {833, 3}, {834, 2}, {835, 3}, {836, 2}, {837, 3}, {838, 2}, {840, 2}, {842, 3}, {845, 2}, {846, 2}, {850, 2}, {851, 2}, {852, 2}, {853, 3}, {854, 4}, {860, 4}, {861, 4}, {862, 2}, {863, 4}, {864, 3}, {865, 2}, {866, 2}, {867, 2}, {868, 2}, {870, 3}, {871, 3}, {872, 4}, {873, 4}, {992, 2}, {994, 2}, {995, 2}, {996, 3}, {997, 2}, {998, 3}, {1001, 258}, {1830, 258}, {1832, 258}, {1833, 258}, {1840, 258}, {1842, 258}, {1850, 258}, {1852, 258}, {1853, 258}, {1860, 258}, {1863, 260}, {1864, 258}, {1865, 258}, {2000, 258}, {2002, 258}, {9996, 3}, {9997, 3}, {9998, 3}, {9999, 3}};
        _Copyright_2014_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.converter.CharacterSetMetaData"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        CharacterSetMetaData.getMapProperties();
    }

    static class JdbcCharacterSetMetaData
    implements InternalCharacterSetMetaData {
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        JdbcCharacterSetMetaData() {
        }

        @Override
        public boolean isFixedWidth(int n2) {
            if (n2 == 0) {
                return false;
            }
            int n3 = -1;
            int n4 = 0;
            int n5 = m_maxCharWidth.length - 1;
            int n6 = -1;
            while (n4 <= n5) {
                n6 = (n4 + n5) / 2;
                if (n2 < m_maxCharWidth[n6][0]) {
                    n5 = n6 - 1;
                    continue;
                }
                if (n2 > m_maxCharWidth[n6][0]) {
                    n4 = n6 + 1;
                    continue;
                }
                n3 = n6;
                break;
            }
            return (m_maxCharWidth[n3][1] & 0x100) != 0;
        }

        @Override
        public int getMaxCharLength(int n2) {
            int n3 = -1;
            int n4 = 0;
            int n5 = m_maxCharWidth.length - 1;
            while (n4 <= n5) {
                int n6 = (n4 + n5) / 2;
                if (n2 < m_maxCharWidth[n6][0]) {
                    n5 = n6 - 1;
                    continue;
                }
                if (n2 > m_maxCharWidth[n6][0]) {
                    n4 = n6 + 1;
                    continue;
                }
                n3 = n6;
                break;
            }
            if (n3 < 0) {
                return 0;
            }
            return m_maxCharWidth[n3][1] & 0xFF;
        }

        static {
            try {
                $$$methodRef$$$2 = JdbcCharacterSetMetaData.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = JdbcCharacterSetMetaData.class.getDeclaredMethod("getMaxCharLength", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = JdbcCharacterSetMetaData.class.getDeclaredMethod("isFixedWidth", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

