/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.lang.reflect.Executable;
import java.sql.SQLType;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class ShardingMetadata {
    public static final int SUPER_SHARDING_KEY_LEVEL = 0;
    public static final int SHARDING_KEY_LEVEL = 1;
    private final int version;
    private final ShardingType shardingType;
    private final ShardingType superShardingType;
    private final List<SubKeyMetadata> shardingKeyColumns;
    private final List<SubKeyMetadata> superShardingKeyColumns;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;

    public ShardingMetadata(int n2, ShardingType shardingType, ShardingType shardingType2, List<SubKeyMetadata> list, List<SubKeyMetadata> list2) {
        this.version = n2;
        this.shardingType = shardingType;
        this.superShardingType = shardingType2;
        if (list != null) {
            Collections.sort(list);
            this.shardingKeyColumns = Collections.unmodifiableList(list);
        } else {
            this.shardingKeyColumns = null;
        }
        if (list2 != null) {
            Collections.sort(list2);
            this.superShardingKeyColumns = Collections.unmodifiableList(list2);
        } else {
            this.superShardingKeyColumns = null;
        }
    }

    public int getVersion() {
        return this.version;
    }

    public ShardingType getShardingType() {
        return this.shardingType;
    }

    public ShardingType getSuperShardingType() {
        return this.superShardingType;
    }

    public List<SubKeyMetadata> getShardingKeyColumns() {
        return this.shardingKeyColumns;
    }

    public List<SubKeyMetadata> getSuperShardingKeyColumns() {
        return this.superShardingKeyColumns;
    }

    static {
        try {
            $$$methodRef$$$5 = ShardingMetadata.class.getDeclaredConstructor(Integer.TYPE, ShardingType.class, ShardingType.class, List.class, List.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = ShardingMetadata.class.getDeclaredMethod("getSuperShardingKeyColumns", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = ShardingMetadata.class.getDeclaredMethod("getShardingKeyColumns", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = ShardingMetadata.class.getDeclaredMethod("getSuperShardingType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = ShardingMetadata.class.getDeclaredMethod("getShardingType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = ShardingMetadata.class.getDeclaredMethod("getVersion", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }

    public static class SubKeyMetadata
    implements Comparable<SubKeyMetadata> {
        private final int colIndex;
        private final SQLType dataType;
        private final int charSet;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;

        public SubKeyMetadata(int n2, SQLType sQLType, int n3) {
            this.dataType = sQLType;
            this.charSet = n3;
            this.colIndex = n2;
        }

        SQLType getDataType() {
            return this.dataType;
        }

        int getCharSet() {
            return this.charSet;
        }

        @Override
        public int compareTo(SubKeyMetadata subKeyMetadata) {
            if (this == subKeyMetadata) {
                return 0;
            }
            if (this.colIndex == subKeyMetadata.colIndex) {
                throw new IllegalStateException("Illegal Shard Column index in Metadata");
            }
            if (this.colIndex < subKeyMetadata.colIndex) {
                return -1;
            }
            return 1;
        }

        static {
            try {
                $$$methodRef$$$4 = SubKeyMetadata.class.getDeclaredConstructor(Integer.TYPE, SQLType.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = SubKeyMetadata.class.getDeclaredMethod("compareTo", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = SubKeyMetadata.class.getDeclaredMethod("compareTo", SubKeyMetadata.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = SubKeyMetadata.class.getDeclaredMethod("getCharSet", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = SubKeyMetadata.class.getDeclaredMethod("getDataType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    public static final class ShardingType
    extends Enum<ShardingType> {
        public static final /* enum */ ShardingType HASH;
        public static final /* enum */ ShardingType LIST;
        public static final /* enum */ ShardingType RANGE;
        public static final /* enum */ ShardingType NONE;
        String typeStr;
        private static final /* synthetic */ ShardingType[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;

        public static ShardingType[] values() {
            return (ShardingType[])$VALUES.clone();
        }

        public static ShardingType valueOf(String string) {
            return Enum.valueOf(ShardingType.class, string);
        }

        private ShardingType(String string2) {
            this.typeStr = string2;
        }

        static ShardingType toShardType(String string) {
            if (string == null) {
                return NONE;
            }
            for (ShardingType shardingType : ShardingType.values()) {
                if (!shardingType.typeStr.equals(string)) continue;
                return shardingType;
            }
            return NONE;
        }

        static {
            try {
                $$$methodRef$$$3 = ShardingType.class.getDeclaredConstructor(String.class, Integer.TYPE, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = ShardingType.class.getDeclaredMethod("toShardType", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = ShardingType.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = ShardingType.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            HASH = new ShardingType("HASH");
            LIST = new ShardingType("LIST");
            RANGE = new ShardingType("RANGE");
            NONE = new ShardingType("NONE");
            $VALUES = new ShardingType[]{HASH, LIST, RANGE, NONE};
        }
    }
}

