/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import javax.crypto.Cipher;
import javax.net.ssl.SSLContext;
import oracle.jdbc.AccessToken;
import oracle.jdbc.LogicalTransactionId;
import oracle.jdbc.LogicalTransactionIdEventListener;
import oracle.jdbc.NotificationRegistration;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.aq.AQDequeueOptions;
import oracle.jdbc.aq.AQEnqueueOptions;
import oracle.jdbc.driver.AQMessagePropertiesI;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DatabaseSessionState;
import oracle.jdbc.driver.DirectPathBufferMarshaler;
import oracle.jdbc.driver.GeneratedPhysicalConnection;
import oracle.jdbc.driver.JMSMessagePropertiesI;
import oracle.jdbc.driver.JsonWebToken;
import oracle.jdbc.driver.NTFAQRegistration;
import oracle.jdbc.driver.NTFDCNConnection;
import oracle.jdbc.driver.NTFDCNConnectionGroup;
import oracle.jdbc.driver.NTFDCNRegistration;
import oracle.jdbc.driver.NTFEventListener;
import oracle.jdbc.driver.NTFJMSConnection;
import oracle.jdbc.driver.NTFJMSConnectionGroup;
import oracle.jdbc.driver.NTFJMSRegistration;
import oracle.jdbc.driver.NTFLTXIDEvent;
import oracle.jdbc.driver.NTFPDBChangeEvent;
import oracle.jdbc.driver.NTFRegistration;
import oracle.jdbc.driver.NTFXSEvent;
import oracle.jdbc.driver.Namespace;
import oracle.jdbc.driver.OracleBlobInputStream;
import oracle.jdbc.driver.OracleBlobOutputStream;
import oracle.jdbc.driver.OracleClobInputStream;
import oracle.jdbc.driver.OracleClobOutputStream;
import oracle.jdbc.driver.OracleClobReader;
import oracle.jdbc.driver.OracleClobWriter;
import oracle.jdbc.driver.OracleConversionInputStream;
import oracle.jdbc.driver.OracleConversionReader;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.ReplayContext;
import oracle.jdbc.driver.ResultSetCache;
import oracle.jdbc.driver.StateSignatures;
import oracle.jdbc.driver.T4C7Ocommoncall;
import oracle.jdbc.driver.T4C7Oversion;
import oracle.jdbc.driver.T4C8Kpcdsc;
import oracle.jdbc.driver.T4C8Oall;
import oracle.jdbc.driver.T4C8Oclose;
import oracle.jdbc.driver.T4C8Odscrarr;
import oracle.jdbc.driver.T4C8Odsy;
import oracle.jdbc.driver.T4C8TTIBfile;
import oracle.jdbc.driver.T4C8TTIBlob;
import oracle.jdbc.driver.T4C8TTIClob;
import oracle.jdbc.driver.T4C8TTIdty;
import oracle.jdbc.driver.T4C8TTIpro;
import oracle.jdbc.driver.T4CDirectPathPreparedStatement;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CMAREngineNIO;
import oracle.jdbc.driver.T4CMAREngineStream;
import oracle.jdbc.driver.T4CStatement;
import oracle.jdbc.driver.T4CTTIOqcsta;
import oracle.jdbc.driver.T4CTTIOtxen;
import oracle.jdbc.driver.T4CTTIOtxse;
import oracle.jdbc.driver.T4CTTIk2rpc;
import oracle.jdbc.driver.T4CTTIkpdnrdeq;
import oracle.jdbc.driver.T4CTTIkscn;
import oracle.jdbc.driver.T4CTTIkscn8;
import oracle.jdbc.driver.T4CTTIoappcontreplay;
import oracle.jdbc.driver.T4CTTIoaqdeq;
import oracle.jdbc.driver.T4CTTIoaqenq;
import oracle.jdbc.driver.T4CTTIoauthenticate;
import oracle.jdbc.driver.T4CTTIochunkinfo;
import oracle.jdbc.driver.T4CTTIocsessret;
import oracle.jdbc.driver.T4CTTIodpls;
import oracle.jdbc.driver.T4CTTIodpmop;
import oracle.jdbc.driver.T4CTTIodpp;
import oracle.jdbc.driver.T4CTTIoer;
import oracle.jdbc.driver.T4CTTIoer11;
import oracle.jdbc.driver.T4CTTIokeyval;
import oracle.jdbc.driver.T4CTTIokpn;
import oracle.jdbc.driver.T4CTTIoping;
import oracle.jdbc.driver.T4CTTIoqcid;
import oracle.jdbc.driver.T4CTTIoscid;
import oracle.jdbc.driver.T4CTTIoses;
import oracle.jdbc.driver.T4CTTIosessget;
import oracle.jdbc.driver.T4CTTIosessrls;
import oracle.jdbc.driver.T4CTTIosesstate;
import oracle.jdbc.driver.T4CTTIosesstemplate;
import oracle.jdbc.driver.T4CTTIoxsatt;
import oracle.jdbc.driver.T4CTTIoxscre;
import oracle.jdbc.driver.T4CTTIoxsdes;
import oracle.jdbc.driver.T4CTTIoxsdet;
import oracle.jdbc.driver.T4CTTIoxsns;
import oracle.jdbc.driver.T4CTTIoxsscs;
import oracle.jdbc.driver.T4CTTIoxsset;
import oracle.jdbc.driver.T4CTTIoxsspo;
import oracle.jdbc.driver.T4CTTIoxssro;
import oracle.jdbc.driver.T4CTTIrxd;
import oracle.jdbc.driver.T4CTTIspfp;
import oracle.jdbc.driver.T4CTTIsto;
import oracle.jdbc.driver.T4CTTIxsnsop;
import oracle.jdbc.driver.T4CXAResource;
import oracle.jdbc.driver.T4Caqdq;
import oracle.jdbc.driver.T4Caqe;
import oracle.jdbc.driver.TemplateOverflow;
import oracle.jdbc.driver.XSSessionParametersI;
import oracle.jdbc.internal.JMSDequeueOptions;
import oracle.jdbc.internal.JMSEnqueueOptions;
import oracle.jdbc.internal.JMSMessageProperties;
import oracle.jdbc.internal.JMSNotificationRegistration;
import oracle.jdbc.internal.KeywordValue;
import oracle.jdbc.internal.KeywordValueLong;
import oracle.jdbc.internal.NetStat;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.internal.OracleBfile;
import oracle.jdbc.internal.OracleBlob;
import oracle.jdbc.internal.OracleClob;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleLargeObject;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.internal.XSEventListener;
import oracle.jdbc.internal.XSKeyval;
import oracle.jdbc.internal.XSNamespace;
import oracle.jdbc.internal.XSPrincipal;
import oracle.jdbc.internal.XSSecureId;
import oracle.jdbc.internal.XSSessionParameters;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.jdbc.pool.OracleShardingKeyImpl;
import oracle.net.ns.Communication;
import oracle.net.ns.NSProtocol;
import oracle.net.ns.NSProtocolNIO;
import oracle.net.ns.NSProtocolStream;
import oracle.net.ns.NetException;
import oracle.net.ns.SessionAtts;
import oracle.net.nt.CustomSSLSocketFactory;
import oracle.net.nt.NTAdapter;
import oracle.net.nt.TcpNTAdapter;
import oracle.net.resolver.TimeUnitSuffixUtility;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.BfileDBAccess;
import oracle.sql.BlobDBAccess;
import oracle.sql.CLOB;
import oracle.sql.ClobDBAccess;
import oracle.sql.Datum;
import oracle.sql.LobPlsqlUtil;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.ZONEIDMAP;
import org.ietf.jgss.GSSCredential;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CConnection
extends PhysicalConnection
implements BfileDBAccess,
BlobDBAccess,
ClobDBAccess {
    static final short MIN_TTCVER_SUPPORTED = 4;
    static final short V8_TTCVER_SUPPORTED = 5;
    static final short MAX_TTCVER_SUPPORTED = 6;
    static final long RESULTSET_CACHE_BLOCK_SIZE_FOR_STAT = 512L;
    static final int DEFAULT_LONG_PREFETCH_SIZE = 4080;
    static final String DEFAULT_CONNECT_STRING = "localhost:1521:orcl";
    static final int REFCURSOR_SIZE = 5;
    static final byte[] EMPTY_BYTE;
    long LOGON_MODE = 0L;
    boolean isLoggedOn;
    private boolean useZeroCopyIO;
    boolean useLobPrefetch;
    private boolean svrSupportsRequests;
    private OpaqueString password;
    Communication net;
    int eocs;
    private NTFEventListener[] ltxidListeners = new NTFEventListener[0];
    private NTFEventListener[] xsListeners = new NTFEventListener[0];
    boolean readAsNonStream;
    T4CTTIoer11 oer;
    T4CMAREngine mare;
    T4C8TTIpro pro;
    T4CTTIrxd rxd;
    T4CTTIsto sto;
    T4CTTIspfp spfp;
    T4CTTIoauthenticate auth;
    T4C8Odscrarr describe;
    T4C8Odsy describeTbl;
    T4C8Oall all8;
    T4C8Oclose close8;
    T4C7Ocommoncall commoncall;
    T4Caqe aqe;
    T4Caqdq aqdq;
    T4CTTIoaqenq oaqenq;
    T4CTTIoaqdeq oaqdeq;
    T4CTTIkpdnrdeq kpdnrdeq;
    T4C8TTIBfile bfileMsg;
    T4C8TTIBlob blobMsg;
    T4C8TTIClob clobMsg;
    T4C8TTIBlob lobMsg;
    T4CTTIoses oses;
    T4CTTIoping oping;
    T4CTTIokpn okpn;
    T4CTTIOtxen otxen;
    T4CTTIOtxse otxse;
    T4CTTIk2rpc k2rpc;
    T4CTTIoscid oscid;
    T4CTTIokeyval okeyval;
    T4CTTIoxsscs oxsscs;
    T4CTTIoxssro oxssro;
    T4CTTIoxsspo oxsspo;
    T4CTTIxsnsop xsnsop;
    T4CTTIosesstate osesstate;
    T4CTTIoappcontreplay oappcontreplay;
    T4CTTIosesstemplate osesstemplate;
    T4CTTIoxsns xsnsop2;
    T4CTTIoxscre oxscre;
    T4CTTIoxsdes oxsdes;
    T4CTTIoxsdet oxsdet;
    T4CTTIoxsatt oxsatt;
    T4CTTIoxsset oxsset;
    T4CTTIosessrls osessrls;
    T4CTTIosessget osessget;
    T4CTTIocsessret ocsessret;
    T4CTTIoqcid oqcid;
    T4CTTIkscn kpdqidcscn;
    T4CTTIOqcsta oqcsta;
    T4CTTIochunkinfo ochunkinfo;
    T4CTTIochunkinfo piggyBackOchunkinfo;
    T4CTTIodpp odpp;
    T4CTTIodpmop odpmop;
    T4CTTIodpls odpls;
    int[] cursorToClose;
    int cursorToCloseOffset = 0;
    int lastCursorToCloseOffset;
    int[] queryToClose;
    int queryToCloseOffset = 0;
    byte[] tempLobsToFree;
    int tempLobFreeOffset = 0;
    int[] lusFunctionId2;
    byte[][] lusSessionId2;
    KeywordValueLong[][] lusInKeyVal2;
    int[] lusInFlags2;
    int lusOffset2 = 0;
    private long osessstateFlags = -1L;
    static final int DIRECTIVE_REPLAY_ENABLED = 4;
    EnumSet<ReplayMode> replayModes;
    OracleConnection.EndReplayCallback endReplayCallback = null;
    oracle.jdbc.internal.ReplayContext[] oappcontreplayContextsArr = null;
    int oappcontreplayOffset = 0;
    DatabaseSessionState sessionState = null;
    DatabaseSessionState sessionStateOut = null;
    int sessionId;
    int serialNumber;
    byte negotiatedTTCversion;
    byte[] serverRuntimeCapabilities;
    private byte[] serverCompileTimeCapabilities;
    Hashtable namespaces;
    byte[] internalName;
    byte[] externalName;
    static final int FREE = -1;
    static final int SEND = 1;
    static final int RECEIVE = 2;
    int pipeState = -1;
    boolean sentCancel = false;
    String currentSchema;
    int maxNonStreamBindByteSize;
    boolean statementCancel = true;
    String databaseUniqueIdentifier;
    static final Map<String, String[]> cachedVersionTable;
    byte currentTTCSeqNumber = 0;
    byte lastPiggyBackCursorCloseSeqNumber = 0;
    short[] ttiList;
    final byte[] tmpBytes128 = new byte[128];
    boolean isO7L_MRExposed = true;
    short executingRPCFunctionCode = 0;
    String shardingKey = null;
    String superShardingKey = null;
    String chunkName = null;
    int releasedSessID;
    int releasedSerial;
    boolean writeBufferIsDirty;
    T4CDirectPathPreparedStatement dppstmt = null;
    private static final boolean isUnlimitedCryptoAvailable;
    String executingRPCSQL;
    private static final String ONS_WALLET_CONFIG = "\nwalletfile=";
    private static final String ONS_WALLET_PASSWD_CONFIG = "\nwalletpassword=";
    private final CRC32 checksumEngine = new CRC32();
    private final Hashtable<Long, Integer> tempLobRefCount = new Hashtable();
    private boolean needsToBeClosed;
    static final int MAX_SIZE_VSESSION_OSUSER = 30;
    static final int MAX_SIZE_VSESSION_PROCESS = 24;
    static final int MAX_SIZE_VSESSION_MACHINE = 64;
    static final int MAX_SIZE_VSESSION_TERMINAL = 30;
    static final int MAX_SIZE_VSESSION_PROGRAM = 48;
    private ResultSetCache resultSetCache;
    private ArrayList<Long> resultSetCacheLocalInvalidations;
    boolean isServerBigSCN = false;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;
    private static Executable $$$methodRef$$$58;
    private static Logger $$$loggerRef$$$58;
    private static Executable $$$methodRef$$$59;
    private static Logger $$$loggerRef$$$59;
    private static Executable $$$methodRef$$$60;
    private static Logger $$$loggerRef$$$60;
    private static Executable $$$methodRef$$$61;
    private static Logger $$$loggerRef$$$61;
    private static Executable $$$methodRef$$$62;
    private static Logger $$$loggerRef$$$62;
    private static Executable $$$methodRef$$$63;
    private static Logger $$$loggerRef$$$63;
    private static Executable $$$methodRef$$$64;
    private static Logger $$$loggerRef$$$64;
    private static Executable $$$methodRef$$$65;
    private static Logger $$$loggerRef$$$65;
    private static Executable $$$methodRef$$$66;
    private static Logger $$$loggerRef$$$66;
    private static Executable $$$methodRef$$$67;
    private static Logger $$$loggerRef$$$67;
    private static Executable $$$methodRef$$$68;
    private static Logger $$$loggerRef$$$68;
    private static Executable $$$methodRef$$$69;
    private static Logger $$$loggerRef$$$69;
    private static Executable $$$methodRef$$$70;
    private static Logger $$$loggerRef$$$70;
    private static Executable $$$methodRef$$$71;
    private static Logger $$$loggerRef$$$71;
    private static Executable $$$methodRef$$$72;
    private static Logger $$$loggerRef$$$72;
    private static Executable $$$methodRef$$$73;
    private static Logger $$$loggerRef$$$73;
    private static Executable $$$methodRef$$$74;
    private static Logger $$$loggerRef$$$74;
    private static Executable $$$methodRef$$$75;
    private static Logger $$$loggerRef$$$75;
    private static Executable $$$methodRef$$$76;
    private static Logger $$$loggerRef$$$76;
    private static Executable $$$methodRef$$$77;
    private static Logger $$$loggerRef$$$77;
    private static Executable $$$methodRef$$$78;
    private static Logger $$$loggerRef$$$78;
    private static Executable $$$methodRef$$$79;
    private static Logger $$$loggerRef$$$79;
    private static Executable $$$methodRef$$$80;
    private static Logger $$$loggerRef$$$80;
    private static Executable $$$methodRef$$$81;
    private static Logger $$$loggerRef$$$81;
    private static Executable $$$methodRef$$$82;
    private static Logger $$$loggerRef$$$82;
    private static Executable $$$methodRef$$$83;
    private static Logger $$$loggerRef$$$83;
    private static Executable $$$methodRef$$$84;
    private static Logger $$$loggerRef$$$84;
    private static Executable $$$methodRef$$$85;
    private static Logger $$$loggerRef$$$85;
    private static Executable $$$methodRef$$$86;
    private static Logger $$$loggerRef$$$86;
    private static Executable $$$methodRef$$$87;
    private static Logger $$$loggerRef$$$87;
    private static Executable $$$methodRef$$$88;
    private static Logger $$$loggerRef$$$88;
    private static Executable $$$methodRef$$$89;
    private static Logger $$$loggerRef$$$89;
    private static Executable $$$methodRef$$$90;
    private static Logger $$$loggerRef$$$90;
    private static Executable $$$methodRef$$$91;
    private static Logger $$$loggerRef$$$91;
    private static Executable $$$methodRef$$$92;
    private static Logger $$$loggerRef$$$92;
    private static Executable $$$methodRef$$$93;
    private static Logger $$$loggerRef$$$93;
    private static Executable $$$methodRef$$$94;
    private static Logger $$$loggerRef$$$94;
    private static Executable $$$methodRef$$$95;
    private static Logger $$$loggerRef$$$95;
    private static Executable $$$methodRef$$$96;
    private static Logger $$$loggerRef$$$96;
    private static Executable $$$methodRef$$$97;
    private static Logger $$$loggerRef$$$97;
    private static Executable $$$methodRef$$$98;
    private static Logger $$$loggerRef$$$98;
    private static Executable $$$methodRef$$$99;
    private static Logger $$$loggerRef$$$99;
    private static Executable $$$methodRef$$$100;
    private static Logger $$$loggerRef$$$100;
    private static Executable $$$methodRef$$$101;
    private static Logger $$$loggerRef$$$101;
    private static Executable $$$methodRef$$$102;
    private static Logger $$$loggerRef$$$102;
    private static Executable $$$methodRef$$$103;
    private static Logger $$$loggerRef$$$103;
    private static Executable $$$methodRef$$$104;
    private static Logger $$$loggerRef$$$104;
    private static Executable $$$methodRef$$$105;
    private static Logger $$$loggerRef$$$105;
    private static Executable $$$methodRef$$$106;
    private static Logger $$$loggerRef$$$106;
    private static Executable $$$methodRef$$$107;
    private static Logger $$$loggerRef$$$107;
    private static Executable $$$methodRef$$$108;
    private static Logger $$$loggerRef$$$108;
    private static Executable $$$methodRef$$$109;
    private static Logger $$$loggerRef$$$109;
    private static Executable $$$methodRef$$$110;
    private static Logger $$$loggerRef$$$110;
    private static Executable $$$methodRef$$$111;
    private static Logger $$$loggerRef$$$111;
    private static Executable $$$methodRef$$$112;
    private static Logger $$$loggerRef$$$112;
    private static Executable $$$methodRef$$$113;
    private static Logger $$$loggerRef$$$113;
    private static Executable $$$methodRef$$$114;
    private static Logger $$$loggerRef$$$114;
    private static Executable $$$methodRef$$$115;
    private static Logger $$$loggerRef$$$115;
    private static Executable $$$methodRef$$$116;
    private static Logger $$$loggerRef$$$116;
    private static Executable $$$methodRef$$$117;
    private static Logger $$$loggerRef$$$117;
    private static Executable $$$methodRef$$$118;
    private static Logger $$$loggerRef$$$118;
    private static Executable $$$methodRef$$$119;
    private static Logger $$$loggerRef$$$119;
    private static Executable $$$methodRef$$$120;
    private static Logger $$$loggerRef$$$120;
    private static Executable $$$methodRef$$$121;
    private static Logger $$$loggerRef$$$121;
    private static Executable $$$methodRef$$$122;
    private static Logger $$$loggerRef$$$122;
    private static Executable $$$methodRef$$$123;
    private static Logger $$$loggerRef$$$123;
    private static Executable $$$methodRef$$$124;
    private static Logger $$$loggerRef$$$124;
    private static Executable $$$methodRef$$$125;
    private static Logger $$$loggerRef$$$125;
    private static Executable $$$methodRef$$$126;
    private static Logger $$$loggerRef$$$126;
    private static Executable $$$methodRef$$$127;
    private static Logger $$$loggerRef$$$127;
    private static Executable $$$methodRef$$$128;
    private static Logger $$$loggerRef$$$128;
    private static Executable $$$methodRef$$$129;
    private static Logger $$$loggerRef$$$129;
    private static Executable $$$methodRef$$$130;
    private static Logger $$$loggerRef$$$130;
    private static Executable $$$methodRef$$$131;
    private static Logger $$$loggerRef$$$131;
    private static Executable $$$methodRef$$$132;
    private static Logger $$$loggerRef$$$132;
    private static Executable $$$methodRef$$$133;
    private static Logger $$$loggerRef$$$133;
    private static Executable $$$methodRef$$$134;
    private static Logger $$$loggerRef$$$134;
    private static Executable $$$methodRef$$$135;
    private static Logger $$$loggerRef$$$135;
    private static Executable $$$methodRef$$$136;
    private static Logger $$$loggerRef$$$136;
    private static Executable $$$methodRef$$$137;
    private static Logger $$$loggerRef$$$137;
    private static Executable $$$methodRef$$$138;
    private static Logger $$$loggerRef$$$138;
    private static Executable $$$methodRef$$$139;
    private static Logger $$$loggerRef$$$139;
    private static Executable $$$methodRef$$$140;
    private static Logger $$$loggerRef$$$140;
    private static Executable $$$methodRef$$$141;
    private static Logger $$$loggerRef$$$141;
    private static Executable $$$methodRef$$$142;
    private static Logger $$$loggerRef$$$142;
    private static Executable $$$methodRef$$$143;
    private static Logger $$$loggerRef$$$143;
    private static Executable $$$methodRef$$$144;
    private static Logger $$$loggerRef$$$144;
    private static Executable $$$methodRef$$$145;
    private static Logger $$$loggerRef$$$145;
    private static Executable $$$methodRef$$$146;
    private static Logger $$$loggerRef$$$146;
    private static Executable $$$methodRef$$$147;
    private static Logger $$$loggerRef$$$147;
    private static Executable $$$methodRef$$$148;
    private static Logger $$$loggerRef$$$148;
    private static Executable $$$methodRef$$$149;
    private static Logger $$$loggerRef$$$149;
    private static Executable $$$methodRef$$$150;
    private static Logger $$$loggerRef$$$150;
    private static Executable $$$methodRef$$$151;
    private static Logger $$$loggerRef$$$151;
    private static Executable $$$methodRef$$$152;
    private static Logger $$$loggerRef$$$152;
    private static Executable $$$methodRef$$$153;
    private static Logger $$$loggerRef$$$153;
    private static Executable $$$methodRef$$$154;
    private static Logger $$$loggerRef$$$154;
    private static Executable $$$methodRef$$$155;
    private static Logger $$$loggerRef$$$155;
    private static Executable $$$methodRef$$$156;
    private static Logger $$$loggerRef$$$156;
    private static Executable $$$methodRef$$$157;
    private static Logger $$$loggerRef$$$157;
    private static Executable $$$methodRef$$$158;
    private static Logger $$$loggerRef$$$158;
    private static Executable $$$methodRef$$$159;
    private static Logger $$$loggerRef$$$159;
    private static Executable $$$methodRef$$$160;
    private static Logger $$$loggerRef$$$160;
    private static Executable $$$methodRef$$$161;
    private static Logger $$$loggerRef$$$161;
    private static Executable $$$methodRef$$$162;
    private static Logger $$$loggerRef$$$162;
    private static Executable $$$methodRef$$$163;
    private static Logger $$$loggerRef$$$163;
    private static Executable $$$methodRef$$$164;
    private static Logger $$$loggerRef$$$164;
    private static Executable $$$methodRef$$$165;
    private static Logger $$$loggerRef$$$165;
    private static Executable $$$methodRef$$$166;
    private static Logger $$$loggerRef$$$166;
    private static Executable $$$methodRef$$$167;
    private static Logger $$$loggerRef$$$167;
    private static Executable $$$methodRef$$$168;
    private static Logger $$$loggerRef$$$168;
    private static Executable $$$methodRef$$$169;
    private static Logger $$$loggerRef$$$169;
    private static Executable $$$methodRef$$$170;
    private static Logger $$$loggerRef$$$170;
    private static Executable $$$methodRef$$$171;
    private static Logger $$$loggerRef$$$171;
    private static Executable $$$methodRef$$$172;
    private static Logger $$$loggerRef$$$172;
    private static Executable $$$methodRef$$$173;
    private static Logger $$$loggerRef$$$173;
    private static Executable $$$methodRef$$$174;
    private static Logger $$$loggerRef$$$174;
    private static Executable $$$methodRef$$$175;
    private static Logger $$$loggerRef$$$175;
    private static Executable $$$methodRef$$$176;
    private static Logger $$$loggerRef$$$176;
    private static Executable $$$methodRef$$$177;
    private static Logger $$$loggerRef$$$177;
    private static Executable $$$methodRef$$$178;
    private static Logger $$$loggerRef$$$178;
    private static Executable $$$methodRef$$$179;
    private static Logger $$$loggerRef$$$179;
    private static Executable $$$methodRef$$$180;
    private static Logger $$$loggerRef$$$180;
    private static Executable $$$methodRef$$$181;
    private static Logger $$$loggerRef$$$181;
    private static Executable $$$methodRef$$$182;
    private static Logger $$$loggerRef$$$182;
    private static Executable $$$methodRef$$$183;
    private static Logger $$$loggerRef$$$183;
    private static Executable $$$methodRef$$$184;
    private static Logger $$$loggerRef$$$184;
    private static Executable $$$methodRef$$$185;
    private static Logger $$$loggerRef$$$185;
    private static Executable $$$methodRef$$$186;
    private static Logger $$$loggerRef$$$186;
    private static Executable $$$methodRef$$$187;
    private static Logger $$$loggerRef$$$187;
    private static Executable $$$methodRef$$$188;
    private static Logger $$$loggerRef$$$188;
    private static Executable $$$methodRef$$$189;
    private static Logger $$$loggerRef$$$189;
    private static Executable $$$methodRef$$$190;
    private static Logger $$$loggerRef$$$190;
    private static Executable $$$methodRef$$$191;
    private static Logger $$$loggerRef$$$191;
    private static Executable $$$methodRef$$$192;
    private static Logger $$$loggerRef$$$192;
    private static Executable $$$methodRef$$$193;
    private static Logger $$$loggerRef$$$193;
    private static Executable $$$methodRef$$$194;
    private static Logger $$$loggerRef$$$194;
    private static Executable $$$methodRef$$$195;
    private static Logger $$$loggerRef$$$195;
    private static Executable $$$methodRef$$$196;
    private static Logger $$$loggerRef$$$196;
    private static Executable $$$methodRef$$$197;
    private static Logger $$$loggerRef$$$197;
    private static Executable $$$methodRef$$$198;
    private static Logger $$$loggerRef$$$198;
    private static Executable $$$methodRef$$$199;
    private static Logger $$$loggerRef$$$199;
    private static Executable $$$methodRef$$$200;
    private static Logger $$$loggerRef$$$200;
    private static Executable $$$methodRef$$$201;
    private static Logger $$$loggerRef$$$201;
    private static Executable $$$methodRef$$$202;
    private static Logger $$$loggerRef$$$202;
    private static Executable $$$methodRef$$$203;
    private static Logger $$$loggerRef$$$203;
    private static Executable $$$methodRef$$$204;
    private static Logger $$$loggerRef$$$204;
    private static Executable $$$methodRef$$$205;
    private static Logger $$$loggerRef$$$205;
    private static Executable $$$methodRef$$$206;
    private static Logger $$$loggerRef$$$206;
    private static Executable $$$methodRef$$$207;
    private static Logger $$$loggerRef$$$207;
    private static Executable $$$methodRef$$$208;
    private static Logger $$$loggerRef$$$208;
    private static Executable $$$methodRef$$$209;
    private static Logger $$$loggerRef$$$209;
    private static Executable $$$methodRef$$$210;
    private static Logger $$$loggerRef$$$210;
    private static Executable $$$methodRef$$$211;
    private static Logger $$$loggerRef$$$211;
    private static Executable $$$methodRef$$$212;
    private static Logger $$$loggerRef$$$212;
    private static Executable $$$methodRef$$$213;
    private static Logger $$$loggerRef$$$213;
    private static Executable $$$methodRef$$$214;
    private static Logger $$$loggerRef$$$214;
    private static Executable $$$methodRef$$$215;
    private static Logger $$$loggerRef$$$215;
    private static Executable $$$methodRef$$$216;
    private static Logger $$$loggerRef$$$216;
    private static Executable $$$methodRef$$$217;
    private static Logger $$$loggerRef$$$217;
    private static Executable $$$methodRef$$$218;
    private static Logger $$$loggerRef$$$218;
    private static Executable $$$methodRef$$$219;
    private static Logger $$$loggerRef$$$219;
    private static Executable $$$methodRef$$$220;
    private static Logger $$$loggerRef$$$220;
    private static Executable $$$methodRef$$$221;
    private static Logger $$$loggerRef$$$221;
    private static Executable $$$methodRef$$$222;
    private static Logger $$$loggerRef$$$222;
    private static Executable $$$methodRef$$$223;
    private static Logger $$$loggerRef$$$223;
    private static Executable $$$methodRef$$$224;
    private static Logger $$$loggerRef$$$224;
    private static Executable $$$methodRef$$$225;
    private static Logger $$$loggerRef$$$225;
    private static Executable $$$methodRef$$$226;
    private static Logger $$$loggerRef$$$226;
    private static Executable $$$methodRef$$$227;
    private static Logger $$$loggerRef$$$227;
    private static Executable $$$methodRef$$$228;
    private static Logger $$$loggerRef$$$228;
    private static Executable $$$methodRef$$$229;
    private static Logger $$$loggerRef$$$229;
    private static Executable $$$methodRef$$$230;
    private static Logger $$$loggerRef$$$230;
    private static Executable $$$methodRef$$$231;
    private static Logger $$$loggerRef$$$231;
    private static Executable $$$methodRef$$$232;
    private static Logger $$$loggerRef$$$232;
    private static Executable $$$methodRef$$$233;
    private static Logger $$$loggerRef$$$233;
    private static Executable $$$methodRef$$$234;
    private static Logger $$$loggerRef$$$234;
    private static Executable $$$methodRef$$$235;
    private static Logger $$$loggerRef$$$235;
    private static Executable $$$methodRef$$$236;
    private static Logger $$$loggerRef$$$236;
    private static Executable $$$methodRef$$$237;
    private static Logger $$$loggerRef$$$237;
    private static Executable $$$methodRef$$$238;
    private static Logger $$$loggerRef$$$238;
    private static Executable $$$methodRef$$$239;
    private static Logger $$$loggerRef$$$239;
    private static Executable $$$methodRef$$$240;
    private static Logger $$$loggerRef$$$240;
    private static Executable $$$methodRef$$$241;
    private static Logger $$$loggerRef$$$241;
    private static Executable $$$methodRef$$$242;
    private static Logger $$$loggerRef$$$242;
    private static Executable $$$methodRef$$$243;
    private static Logger $$$loggerRef$$$243;
    private static Executable $$$methodRef$$$244;
    private static Logger $$$loggerRef$$$244;
    private static Executable $$$methodRef$$$245;
    private static Logger $$$loggerRef$$$245;
    private static Executable $$$methodRef$$$246;
    private static Logger $$$loggerRef$$$246;
    private static Executable $$$methodRef$$$247;
    private static Logger $$$loggerRef$$$247;
    private static Executable $$$methodRef$$$248;
    private static Logger $$$loggerRef$$$248;
    private static Executable $$$methodRef$$$249;
    private static Logger $$$loggerRef$$$249;
    private static Executable $$$methodRef$$$250;
    private static Logger $$$loggerRef$$$250;
    private static Executable $$$methodRef$$$251;
    private static Logger $$$loggerRef$$$251;
    private static Executable $$$methodRef$$$252;
    private static Logger $$$loggerRef$$$252;
    private static Executable $$$methodRef$$$253;
    private static Logger $$$loggerRef$$$253;
    private static Executable $$$methodRef$$$254;
    private static Logger $$$loggerRef$$$254;
    private static Executable $$$methodRef$$$255;
    private static Logger $$$loggerRef$$$255;
    private static Executable $$$methodRef$$$256;
    private static Logger $$$loggerRef$$$256;
    private static Executable $$$methodRef$$$257;
    private static Logger $$$loggerRef$$$257;
    private static Executable $$$methodRef$$$258;
    private static Logger $$$loggerRef$$$258;
    private static Executable $$$methodRef$$$259;
    private static Logger $$$loggerRef$$$259;
    private static Executable $$$methodRef$$$260;
    private static Logger $$$loggerRef$$$260;
    private static Executable $$$methodRef$$$261;
    private static Logger $$$loggerRef$$$261;
    private static Executable $$$methodRef$$$262;
    private static Logger $$$loggerRef$$$262;
    private static Executable $$$methodRef$$$263;
    private static Logger $$$loggerRef$$$263;
    private static Executable $$$methodRef$$$264;
    private static Logger $$$loggerRef$$$264;
    private static Executable $$$methodRef$$$265;
    private static Logger $$$loggerRef$$$265;
    private static Executable $$$methodRef$$$266;
    private static Logger $$$loggerRef$$$266;
    private static Executable $$$methodRef$$$267;
    private static Logger $$$loggerRef$$$267;
    private static Executable $$$methodRef$$$268;
    private static Logger $$$loggerRef$$$268;
    private static Executable $$$methodRef$$$269;
    private static Logger $$$loggerRef$$$269;
    private static Executable $$$methodRef$$$270;
    private static Logger $$$loggerRef$$$270;

    @Override
    public short getExecutingRPCFunctionCode() {
        return this.executingRPCFunctionCode;
    }

    void setExecutingRPCFunctionCode(short s2) {
        this.executingRPCFunctionCode = s2;
    }

    void setExecutingRPCSQL(String string) {
        this.executingRPCSQL = string;
    }

    @Override
    public String getExecutingRPCSQL() {
        return this.executingRPCSQL;
    }

    T4CConnection(String string, Properties properties, OracleDriverExtension oracleDriverExtension) throws SQLException {
        super(string, properties, oracleDriverExtension);
        this.cursorToClose = new int[4];
        this.queryToClose = new int[10];
        this.tempLobsToFree = new byte[2048];
        this.lusFunctionId2 = new int[10];
        this.lusSessionId2 = new byte[10][];
        this.lusInKeyVal2 = new KeywordValueLong[10][];
        this.lusInFlags2 = new int[10];
        this.replayModes = EnumSet.noneOf(ReplayMode.class);
        this.minVcsBindSize = 0;
        this.namespaces = new Hashtable(5);
        this.currentSchema = null;
        this.ttiList = new short[128];
    }

    @Override
    final void initializePassword(OpaqueString opaqueString) {
        this.password = opaqueString;
    }

    /*
     * Exception decompiling
     */
    @Override
    void logon(GSSCredential var1_1, SSLContext var2_2, Supplier<? extends AccessToken> var3_3) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 1 out of bounds for length 1
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.NegativeJumps.rewriteNegativeJumps(NegativeJumps.java:63)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteNegativeJumps(Op03Rewriters.java:32)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:632)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    T4CTTIkscn kscnForByteLength() {
        T4CTTIkscn t4CTTIkscn = null;
        t4CTTIkscn = this.isServerBigSCN ? new T4CTTIkscn8(this) : new T4CTTIkscn(this);
        return t4CTTIkscn;
    }

    void handleIOException(IOException iOException) throws SQLException {
        if (iOException instanceof NetException && ((NetException)iOException).getErrorNumber() == 56611) {
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(298).fillInStackTrace();
            sQLException.initCause(iOException);
            throw sQLException;
        }
        try {
            this.pipeState = -1;
            this.net.disconnect();
            this.net = null;
        }
        catch (Exception exception) {
        }
        this.isLoggedOn = false;
        this.lifecycle = 4;
    }

    @Override
    synchronized void logoff() throws SQLException {
        try {
            this.assertLoggedOn("T4CConnection.logoff");
            if (this.lifecycle == 8) {
                return;
            }
            this.commoncall.doOLOGOFF();
            this.net.disconnect();
            this.net = null;
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            if (this.lifecycle != 8) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
            }
        }
        finally {
            try {
                if (this.net != null) {
                    this.net.disconnect();
                }
            }
            catch (Exception exception) {
            }
            this.isLoggedOn = false;
        }
    }

    T4CMAREngine getMarshalEngine() {
        return this.mare;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    synchronized void doCommit(int n2) throws SQLException {
        this.assertLoggedOn("T4CConnection.do_commit");
        try {
            if (this.dppstmt != null) {
                this.directPathFinish();
                return;
            }
            if (n2 == 0) {
                this.commoncall.doOCOMMIT();
                return;
            }
            int n3 = 0;
            if ((n2 & OracleConnection.CommitOption.WRITEBATCH.getCode()) != 0) {
                n3 = n3 | 2 | 1;
            } else if ((n2 & OracleConnection.CommitOption.WRITEIMMED.getCode()) != 0) {
                n3 |= 2;
            }
            if ((n2 & OracleConnection.CommitOption.NOWAIT.getCode()) != 0) {
                n3 = n3 | 8 | 4;
            } else if ((n2 & OracleConnection.CommitOption.WAIT.getCode()) != 0) {
                n3 |= 8;
            }
            this.otxen.doOTXEN(1, null, null, 0, 0, 0, 0, 4, n3);
            int n4 = this.otxen.getOutStateFromServer();
            if (n4 == 2) return;
            if (n4 == 4) return;
            return;
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    @Override
    synchronized void doRollback() throws SQLException {
        try {
            this.assertLoggedOn("T4CConnection.do_rollback");
            if (this.dppstmt == null) {
                this.commoncall.doOROLLBACK();
            } else {
                this.directPathAbort();
            }
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    @Override
    synchronized void doSetAutoCommit(boolean bl) throws SQLException {
        if (this.autoCommitSpecCompliant && bl && this.getTransactionState().contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED)) {
            this.commit();
        }
        this.autocommit = bl;
    }

    @Override
    synchronized void open(OracleStatement oracleStatement) throws SQLException {
        this.assertLoggedOn("T4CConnection.open");
        oracleStatement.setCursorId(0);
    }

    @Override
    synchronized String doGetDatabaseProductVersion() throws SQLException {
        this.assertLoggedOn("T4CConnection.do_getDatabaseProductVersion");
        T4C7Oversion t4C7Oversion = new T4C7Oversion(this);
        try {
            t4C7Oversion.doOVERSION();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
        String string = null;
        byte[] byArray = t4C7Oversion.getVersion();
        try {
            string = new String(byArray, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), unsupportedEncodingException).fillInStackTrace();
        }
        return string;
    }

    @Override
    synchronized short doGetVersionNumber() throws SQLException {
        this.assertLoggedOn("T4CConnection.do_getVersionNumber");
        T4C7Oversion t4C7Oversion = new T4C7Oversion(this);
        try {
            t4C7Oversion.doOVERSION();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
        return t4C7Oversion.getVersionNumber();
    }

    @Override
    OracleStatement RefCursorBytesToStatement(byte[] byArray, OracleStatement oracleStatement) throws SQLException {
        Properties properties = new Properties();
        properties.setProperty("use_long_fetch", oracleStatement.isFetchStreams ? "true" : "false");
        properties.setProperty("execute_batch", "1");
        properties.setProperty("row_prefetch", Integer.toString(this.defaultRowPrefetch));
        T4CStatement t4CStatement = new T4CStatement(this, properties);
        try {
            int n2 = this.mare.unmarshalRefCursor(byArray);
            t4CStatement.setCursorId(n2);
            t4CStatement.isOpen = true;
            t4CStatement.sqlObject = oracleStatement.sqlObject;
            t4CStatement.serverCursor = true;
            oracleStatement.addChild(t4CStatement);
            t4CStatement.prepareForNewResults(true, false, true);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
        t4CStatement.needToParse = false;
        return t4CStatement;
    }

    @Override
    OracleStatement createImplicitResultSetStatement(OracleStatement oracleStatement) throws SQLException {
        Properties properties = new Properties();
        properties.setProperty("use_long_fetch", oracleStatement.isFetchStreams ? "true" : "false");
        properties.setProperty("execute_batch", Integer.toString(oracleStatement.batch));
        properties.setProperty("row_prefetch", Integer.toString(oracleStatement.defaultRowPrefetch));
        T4CStatement t4CStatement = new T4CStatement(this, properties);
        t4CStatement.sqlObject = oracleStatement.sqlObject;
        t4CStatement.sqlKind = OracleStatement.SqlKind.SELECT;
        t4CStatement.numberOfDefinePositions = oracleStatement.numberOfDefinePositions;
        t4CStatement.isOpen = oracleStatement.isOpen;
        t4CStatement.prepareForNewResults(true, false, true);
        oracleStatement.addImplicitResultSetStmt(t4CStatement);
        return t4CStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void cancelOperationOnServer(boolean bl) throws SQLException {
        Object object = this.cancelInProgressLockForThin;
        synchronized (object) {
            if (!this.cancelInProgressFlag) {
                try {
                    switch (this.pipeState) {
                        case -1: {
                            return;
                        }
                        case 1: {
                            this.net.sendBreak();
                            break;
                        }
                        case 2: {
                            this.net.sendInterrupt();
                        }
                    }
                    this.sentCancel = true;
                }
                catch (NetException netException) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), netException).fillInStackTrace();
                }
                catch (IOException iOException) {
                    this.handleIOException(iOException);
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
                }
                this.cancelInProgressFlag = true;
                this.statementCancel = bl;
            }
        }
    }

    void connect(String string, GSSCredential gSSCredential, SSLContext sSLContext, Supplier<? extends AccessToken> supplier) throws IOException, SQLException {
        if (string == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 433).fillInStackTrace();
        }
        Properties properties = new Properties();
        if (this.isUseTcpFastOpen) {
            properties.setProperty("oracle.net.useTcpFastOpen", "true");
        }
        if (this.thinNetProfile != null) {
            properties.setProperty("oracle.net.profile", this.thinNetProfile);
        }
        if (this.thinNetSetFIPSMode != null) {
            properties.setProperty("oracle.net.setFIPSMode", this.thinNetSetFIPSMode);
        }
        if (this.thinNetAuthenticationServices != null) {
            properties.setProperty("oracle.net.authentication_services", this.thinNetAuthenticationServices);
        }
        if (this.thinNetAuthenticationKrb5Mutual != null) {
            properties.setProperty("oracle.net.kerberos5_mutual_authentication", this.thinNetAuthenticationKrb5Mutual);
        }
        if (this.thinNetAuthenticationKrb5CcName != null) {
            properties.setProperty("oracle.net.kerberos5_cc_name", this.thinNetAuthenticationKrb5CcName);
        }
        if (this.thinNetAuthenticationKrbJaasLoginModule != null) {
            properties.setProperty("oracle.net.KerberosJaasLoginModule", this.thinNetAuthenticationKrbJaasLoginModule);
        }
        if (this.thinNetAllowWeakCrypto != Boolean.valueOf("true")) {
            properties.setProperty("oracle.net.allow_weak_crypto", Boolean.toString(this.thinNetAllowWeakCrypto));
        }
        if (this.thinNetEncryptionLevel != null) {
            properties.setProperty("oracle.net.encryption_client", this.thinNetEncryptionLevel);
        }
        if (this.thinNetEncryptionTypes != null) {
            properties.setProperty("oracle.net.encryption_types_client", this.thinNetEncryptionTypes);
        }
        if (this.thinNetChecksumLevel != null) {
            properties.setProperty("oracle.net.crypto_checksum_client", this.thinNetChecksumLevel);
        }
        if (this.thinNetChecksumTypes != null) {
            properties.setProperty("oracle.net.crypto_checksum_types_client", this.thinNetChecksumTypes);
        }
        if (this.thinNetCryptoSeed != null) {
            properties.setProperty("oracle.net.crypto_seed", this.thinNetCryptoSeed);
        }
        if (this.thinNetAuthenticationKrbRealm != null) {
            properties.setProperty("oracle.net.KerberosRealm", this.thinNetAuthenticationKrbRealm);
        }
        if (this.thinTcpNoDelay) {
            properties.setProperty("TCP.NODELAY", "YES");
        }
        if (this.thinReadTimeout != null) {
            properties.setProperty("oracle.net.READ_TIMEOUT", String.valueOf(TimeUnitSuffixUtility.getTimeInMilliseconds(this.thinReadTimeout, false, 0)));
        }
        if (this.thinNetConnectTimeout != null) {
            properties.setProperty("oracle.net.CONNECT_TIMEOUT", this.thinNetConnectTimeout);
        }
        if (this.thinSslServerDnMatch != null) {
            properties.setProperty("oracle.net.ssl_server_dn_match", this.thinSslServerDnMatch);
        }
        if (this.thinSslAllowWeakDnMatch != null) {
            properties.setProperty("oracle.net.ssl_allow_weak_dn_match", this.thinSslAllowWeakDnMatch);
        }
        if (this.thinSslServerCertDn != null) {
            properties.setProperty("oracle.net.ssl_server_cert_dn", this.thinSslServerCertDn);
        }
        if (this.walletLocation != null) {
            properties.setProperty("oracle.net.wallet_location", this.walletLocation);
        }
        if (this.walletPassword != null) {
            properties.setProperty("oracle.net.wallet_password", this.walletPassword);
        }
        if (this.thinSslVersion != null) {
            properties.setProperty("oracle.net.ssl_version", this.thinSslVersion);
        }
        if (this.thinSslCipherSuites != null) {
            properties.setProperty("oracle.net.ssl_cipher_suites", this.thinSslCipherSuites);
        }
        if (this.thinSslCertificateAlias != null) {
            properties.setProperty("oracle.net.ssl_certificate_alias", this.thinSslCertificateAlias);
        }
        if (this.thinJavaxNetSslKeystore != null) {
            properties.setProperty("javax.net.ssl.keyStore", this.thinJavaxNetSslKeystore);
        }
        if (this.thinJavaxNetSslKeystoretype != null) {
            properties.setProperty("javax.net.ssl.keyStoreType", this.thinJavaxNetSslKeystoretype);
        }
        if (this.thinJavaxNetSslKeystorepassword != null) {
            properties.setProperty("javax.net.ssl.keyStorePassword", this.thinJavaxNetSslKeystorepassword);
        }
        if (this.thinJavaxNetSslTruststore != null) {
            properties.setProperty("javax.net.ssl.trustStore", this.thinJavaxNetSslTruststore);
        }
        if (this.thinJavaxNetSslTruststoretype != null) {
            properties.setProperty("javax.net.ssl.trustStoreType", this.thinJavaxNetSslTruststoretype);
        }
        if (this.thinJavaxNetSslTruststorepassword != null) {
            properties.setProperty("javax.net.ssl.trustStorePassword", this.thinJavaxNetSslTruststorepassword);
        }
        if (this.thinSslKeymanagerfactoryAlgorithm != null) {
            properties.setProperty("ssl.keyManagerFactory.algorithm", this.thinSslKeymanagerfactoryAlgorithm);
        }
        if (this.thinSslTrustmanagerfactoryAlgorithm != null) {
            properties.setProperty("ssl.trustManagerFactory.algorithm", this.thinSslTrustmanagerfactoryAlgorithm);
        }
        if (this.thinNetOldsyntax != null) {
            properties.setProperty("oracle.net.oldSyntax", this.thinNetOldsyntax);
        }
        if (this.thinJndiLdapConnectTimeout != null) {
            properties.setProperty("com.sun.jndi.ldap.connect.timeout", this.thinJndiLdapConnectTimeout);
        }
        if (this.thinJndiLdapReadTimeout != null) {
            properties.setProperty("com.sun.jndi.ldap.read.timeout", this.thinJndiLdapReadTimeout);
        }
        if (this.thinLdapSslCipherSuites != null) {
            properties.setProperty("oracle.net.ldap.ssl.supportedCiphers", this.thinLdapSslCipherSuites);
        }
        if (this.thinLdapSslVersions != null) {
            properties.setProperty("oracle.net.ldap.ssl.supportedVersions", this.thinLdapSslVersions);
        }
        if (this.thinLdapSslKeyStore != null) {
            properties.setProperty("oracle.net.ldap.ssl.keyStore", this.thinLdapSslKeyStore);
        }
        if (this.thinLdapSslKeyStoreType != null) {
            properties.setProperty("oracle.net.ldap.ssl.keyStoreType", this.thinLdapSslKeyStoreType);
        }
        if (this.thinLdapSslKeyStorePwd != null) {
            properties.setProperty("oracle.net.ldap.ssl.keyStorePassword", this.thinLdapSslKeyStorePwd);
        }
        if (this.thinLdapSslKeyManagerFactoryAlgo != null) {
            properties.setProperty("oracle.net.ldap.ssl.keyManagerFactory.algorithm", this.thinLdapSslKeyManagerFactoryAlgo);
        }
        if (this.thinLdapSslTrustStore != null) {
            properties.setProperty("oracle.net.ldap.ssl.trustStore", this.thinLdapSslTrustStore);
        }
        if (this.thinLdapSslTrustStoreType != null) {
            properties.setProperty("oracle.net.ldap.ssl.trustStoreType", this.thinLdapSslTrustStoreType);
        }
        if (this.thinLdapSslTrustStorePassword != null) {
            properties.setProperty("oracle.net.ldap.ssl.trustStorePassword", this.thinLdapSslTrustStorePassword);
        }
        if (this.thinLdapSslTrustManagerFactoryAlgo != null) {
            properties.setProperty("oracle.net.ldap.ssl.trustManagerFactory.algorithm", this.thinLdapSslTrustManagerFactoryAlgo);
        }
        if (this.thinLdapSslWalletLocation != null) {
            properties.setProperty("oracle.net.ldap.ssl.walletLocation", this.thinLdapSslWalletLocation);
        }
        if (this.thinLdapSslWalletPassword != null) {
            properties.setProperty("oracle.net.ldap.ssl.walletPassword", this.thinLdapSslWalletPassword);
        }
        if (this.tnsAdmin != null) {
            properties.setProperty("oracle.net.tns_admin", this.tnsAdmin);
        }
        if (this.thinNetDisableOutOfBandBreak) {
            properties.setProperty("DISABLE_OOB", "" + this.thinNetDisableOutOfBandBreak);
        }
        properties.setProperty("USE_ZERO_COPY_IO", "" + this.thinNetUseZeroCopyIO);
        properties.setProperty("FORCE_DNS_LOAD_BALANCING", "" + this.thinForceDnsLoadBalancing);
        if (this.thinOutboundConnectTimeout != null) {
            properties.setProperty("oracle.net.OUTBOUND_CONNECT_TIMEOUT", this.thinOutboundConnectTimeout);
        }
        properties.setProperty("oracle.jdbc.v$session.osuser", this.thinVsessionOsuser);
        properties.setProperty("oracle.jdbc.v$session.program", this.thinVsessionProgram);
        properties.setProperty("T4CConnection.hashCode", Integer.toHexString(this.hashCode()).toUpperCase());
        properties.setProperty("oracle.net.useJCEAPI", Boolean.toString(this.thinUseJCEAPI));
        properties.setProperty("oracle.net.keepAlive", Boolean.toString(this.keepAlive));
        properties.setProperty("oracle.jdbc.useNio", Boolean.toString(this.javaNetNio));
        if (this.javaNetLocalIPForMsgq != null) {
            properties.setProperty("oracle.jdbc.javaNetLocalIPForMsgq", this.javaNetLocalIPForMsgq);
        }
        if (this.javaNetMsgqTransport != null) {
            properties.setProperty("oracle.jdbc.javaNetMsgqTransport", this.javaNetMsgqTransport);
        }
        properties.setProperty("oracle.jdbc.javaNetMsgqBusyWait", "" + this.javaNetMsgqBusyWait);
        properties.setProperty("oracle.jdbc.javaNetMsgqKernelWait", "" + this.javaNetMsgqKernelWait);
        properties.setProperty("oracle.net.DOWN_HOSTS_TIMEOUT", "" + this.downHostsTimeout);
        if (this.targetInstanceName != null) {
            properties.setProperty("oracle.jdbc.targetInstanceName", this.targetInstanceName);
        }
        if (this.targetServiceName != null) {
            properties.setProperty("oracle.jdbc.targetServiceName", this.targetServiceName);
        }
        if (this.targetShardingKey != null) {
            properties.setProperty("oracle.jdbc.targetShardingKey", this.targetShardingKey);
        }
        if (this.targetSuperShardingKey != null) {
            properties.setProperty("oracle.jdbc.targetSuperShardingKey", this.targetSuperShardingKey);
        }
        if (this.websocketUser != null) {
            properties.setProperty("oracle.net.websocketUser", this.websocketUser);
            if (this.websocketPassword != null) {
                properties.setProperty("oracle.net.websocketPassword", this.websocketPassword);
            } else {
                properties.setProperty("oracle.net.websocketPassword", "");
            }
        }
        properties.setProperty("oracle.net.networkCompression", this.networkCompression);
        properties.setProperty("oracle.net.networkCompressionLevels", this.networkCompressionLevels);
        properties.setProperty("oracle.net.networkCompressionThreshold", Integer.toString(this.networkCompressionThreshold));
        properties.setProperty("oracle.net.ssl_server_dn_match_default", Boolean.toString(supplier != null || "OCI_TOKEN".equals(this.tokenAuthentication) || "OAUTH".equals(this.tokenAuthentication) || "OCI_TOKEN".equals(this.passwordAuthentication) || this.accessToken != null && !this.accessToken.isNull()));
        properties.setProperty("oracle.net.ssl_context_protocol", this.sslContextProtocol == null ? "TLS" : this.sslContextProtocol);
        this.net = this.javaNetNio ? new NSProtocolNIO(this.nsDirectBuffer) : new NSProtocolStream();
        this.net.connect(string, properties, gSSCredential, sSLContext, this.dmsParent);
        this.mare = this.javaNetNio ? new T4CMAREngineNIO(this.net) : new T4CMAREngineStream(this.net);
        this.mare.setConnectionDuringExceptionHandling(this);
        this.pro = new T4C8TTIpro(this);
        this.pro.marshal();
        this.serverCompileTimeCapabilities = this.pro.receive();
        this.serverRuntimeCapabilities = this.pro.getServerRuntimeCapabilities();
        if (this.allowedLogonVersion.equals("12a")) {
            if (!this.hasServerCompileTimeCapability(4, 32)) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 292).fillInStackTrace();
            }
        } else {
            try {
                int n2 = Integer.parseInt(this.allowedLogonVersion);
                switch (n2) {
                    case 8: 
                    case 9: {
                        break;
                    }
                    case 10: 
                    case 11: {
                        if (!this.hasServerCompileTimeCapability(4, 8)) {
                            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 292).fillInStackTrace();
                        }
                        break;
                    }
                    case 12: {
                        if (!this.hasServerCompileTimeCapability(4, 2)) {
                            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 292).fillInStackTrace();
                        }
                        break;
                    }
                    default: {
                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 293).fillInStackTrace();
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 293).fillInStackTrace();
            }
        }
        this.doCharSetNegotiation();
        if (this.hasServerCompileTimeCapability(37, 32)) {
            this.mare.setUseCLRBigChunks(true);
        }
        T4C8TTIdty t4C8TTIdty = new T4C8TTIdty(this, this.serverRuntimeCapabilities, this.logonCap != null && this.logonCap.trim().equals("o3"), this.thinNetUseZeroCopyIO);
        t4C8TTIdty.doRPC();
        this.negotiatedTTCversion = this.serverCompileTimeCapabilities[7];
        this.oer = this.negotiatedTTCversion >= 7 ? new T4CTTIoer(this) : new T4CTTIoer11(this);
        if (t4C8TTIdty.jdbcThinCompileTimeCapabilities[7] < this.serverCompileTimeCapabilities[7]) {
            this.negotiatedTTCversion = t4C8TTIdty.jdbcThinCompileTimeCapabilities[7];
        }
        this.useZeroCopyIO = this.serverRuntimeCapabilities != null && this.serverRuntimeCapabilities.length > 6 && (this.serverRuntimeCapabilities[6] & T4C8TTIdty.KPCCAP_RTB_TTC_ZCPY) != 0 && this.thinNetUseZeroCopyIO && (this.net.getSessionAttributes().getNegotiatedOptions() & 0x40) != 0 && this.getDataIntegrityAlgorithmName().equals("") && this.getEncryptionAlgorithmName().equals("");
        this.useLobPrefetch = this.hasServerCompileTimeCapability(23, 64) && T4CConnection.bit(t4C8TTIdty.jdbcThinCompileTimeCapabilities[23], 64);
        if (this.serverRuntimeCapabilities != null && this.serverRuntimeCapabilities.length > T4C8TTIdty.KPCCAP_RTB_TTC && T4CConnection.bit(this.serverRuntimeCapabilities[T4C8TTIdty.KPCCAP_RTB_TTC], T4C8TTIdty.KPCCAP_RTB_TTC_32K)) {
            this.maxNonStreamBindByteSize = Short.MAX_VALUE;
            this.varTypeMaxLenCompat = 2;
        } else {
            this.maxNonStreamBindByteSize = 4000;
            this.varTypeMaxLenCompat = 1;
        }
        this.svrSupportsRequests = this.serverRuntimeCapabilities != null && this.serverRuntimeCapabilities.length > T4C8TTIdty.KPCCAP_RTB_TTC && T4CConnection.bit(this.serverRuntimeCapabilities[T4C8TTIdty.KPCCAP_RTB_TTC], T4C8TTIdty.KPCCAP_RTB_TTC_SESSSTATEOPS);
    }

    private void doCharSetNegotiation() throws SQLException {
        short s2 = this.pro.getOracleVersion();
        short s3 = this.pro.getCharacterSet();
        short s4 = DBConversion.findDriverCharSet(s3, s2);
        this.conversion = new DBConversion(s3, s4, this.pro.getncharCHARSET(), this.isStrictAsciiConversion, this.isQuickAsciiConversion, this::getByteBufferSync, this::cacheBufferSync, this::getCharBufferSync, this::cacheBufferSync);
        this.mare.types.setServerConversion(s4 != s3);
        if (DBConversion.isCharSetMultibyte(s4)) {
            if (DBConversion.isCharSetMultibyte(this.pro.getCharacterSet())) {
                this.mare.types.setFlags((byte)1);
            } else {
                this.mare.types.setFlags((byte)2);
            }
        } else {
            this.mare.types.setFlags(this.pro.getFlags());
        }
        this.mare.conv = this.conversion;
    }

    void reNegotiateTTCProDty() throws SQLException, IOException {
        this.serverCompileTimeCapabilities = this.pro.receive();
        this.serverRuntimeCapabilities = this.pro.getServerRuntimeCapabilities();
        this.doCharSetNegotiation();
        T4C8TTIdty t4C8TTIdty = new T4C8TTIdty(this, this.serverRuntimeCapabilities, this.logonCap != null && this.logonCap.trim().equals("o3"), this.thinNetUseZeroCopyIO);
        t4C8TTIdty.doRPC();
    }

    boolean isZeroCopyIOEnabled() {
        return this.useZeroCopyIO;
    }

    final T4CTTIoer11 getT4CTTIoer() {
        return this.oer;
    }

    final byte getTTCVersion() {
        return this.negotiatedTTCversion;
    }

    @Override
    void doStartup(int n2) throws SQLException {
        try {
            int n3 = 0;
            if (n2 == OracleConnection.DatabaseStartupMode.FORCE.getMode()) {
                n3 = 16;
            } else if (n2 == OracleConnection.DatabaseStartupMode.RESTRICT.getMode()) {
                n3 = 1;
            }
            this.spfp.doOSPFPPUT();
            this.sto.doOV6STRT(n3);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    @Override
    void doShutdown(int n2) throws SQLException {
        try {
            int n3 = 4;
            if (n2 == OracleConnection.DatabaseShutdownMode.TRANSACTIONAL.getMode()) {
                n3 = 128;
            } else if (n2 == OracleConnection.DatabaseShutdownMode.TRANSACTIONAL_LOCAL.getMode()) {
                n3 = 256;
            } else if (n2 == OracleConnection.DatabaseShutdownMode.IMMEDIATE.getMode()) {
                n3 = 2;
            } else if (n2 == OracleConnection.DatabaseShutdownMode.FINAL.getMode()) {
                n3 = 8;
            } else if (n2 == OracleConnection.DatabaseShutdownMode.ABORT.getMode()) {
                n3 = 64;
            }
            this.sto.doOV6STOP(n3);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkEndReplayCallback() throws SQLException {
        if (this.endReplayCallback != null && this.oappcontreplayContextsArr == null) {
            boolean bl = this.replayModes.contains((Object)ReplayMode.NONREQUEST);
            if (bl) {
                this.replayModes.remove((Object)ReplayMode.NONREQUEST);
            }
            OracleConnection.EndReplayCallback endReplayCallback = this.endReplayCallback;
            this.endReplayCallback = null;
            T4C8Oall t4C8Oall = new T4C8Oall(this);
            T4C8Oall t4C8Oall2 = this.all8;
            this.all8 = t4C8Oall;
            try {
                endReplayCallback.executeCallback();
            }
            finally {
                this.all8 = t4C8Oall2;
                if (bl) {
                    this.replayModes.add(ReplayMode.NONREQUEST);
                }
            }
        }
    }

    void redoCursorClose() {
        if (this.cursorToCloseOffset == 0 && this.lastCursorToCloseOffset != 0) {
            this.cursorToCloseOffset = this.lastCursorToCloseOffset;
            this.lastCursorToCloseOffset = 0;
        }
    }

    void sendPiggyBackedMessages() throws SQLException, IOException {
        ResultSetCache.ResultSetCacheState resultSetCacheState;
        ResultSetCache resultSetCache;
        int n2;
        if (this.queryToCloseOffset > 0) {
            this.close8.doOCANA(this.queryToClose, this.queryToCloseOffset);
            this.queryToCloseOffset = 0;
        }
        if (this.cursorToCloseOffset > 0 && this.canSendCursorIds()) {
            this.close8.doOCCA(this.cursorToClose, this.cursorToCloseOffset);
            this.lastCursorToCloseOffset = this.cursorToCloseOffset;
            this.cursorToCloseOffset = 0;
        }
        if (this.endToEndAnyChanged && this.getTTCVersion() >= 3) {
            this.oscid.doOSCID(this.endToEndHasChanged, endToEndValues, this.endToEndECIDSequenceNumber);
            for (n2 = 0; n2 < 5; ++n2) {
                if (!this.endToEndHasChanged[n2]) continue;
                this.endToEndHasChanged[n2] = false;
            }
        }
        this.endToEndAnyChanged = false;
        if (!this.namespaces.isEmpty()) {
            if (this.getTTCVersion() >= 4) {
                Object[] objectArray = this.namespaces.values().toArray();
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    this.okeyval.doOKEYVAL((Namespace)objectArray[i2]);
                }
            }
            this.namespaces.clear();
        }
        if (this.lusOffset2 > 0) {
            for (n2 = 0; n2 < this.lusOffset2; ++n2) {
                this.oxsspo.doOXSSPO(this.lusFunctionId2[n2], this.lusSessionId2[n2], this.lusInKeyVal2[n2], this.lusInFlags2[n2]);
            }
            this.lusOffset2 = 0;
        }
        if (this.isResultSetCacheEnabled && this.oqcsta != null && (resultSetCache = this.getResultSetCacheInternal()) != null && resultSetCache.needToSendStatsResetIfTrue()) {
            long l2 = 512L;
            long l3 = resultSetCache.getCurrentCacheSize();
            long l4 = l3 / l2;
            if (l3 % l2 > 0L) {
                ++l4;
            }
            this.oqcsta.doOQCSTA(this, this.mare, l2, l4, l4, 0L, resultSetCache.getNumberOfCacheEntries(), resultSetCache.getInvalidatedBeforeCompletion(), resultSetCache.getCacheHits(), resultSetCache.getInvalidationCount(), resultSetCache.getInvalidatedQueryCount(), resultSetCache.getValidQueriesPurged());
            this.oqcsta.connection = null;
            this.oqcsta.meg = null;
        }
        this.sendOsesssstateFlags();
        if (!this.replayModes.contains((Object)ReplayMode.NONREQUEST) && this.oappcontreplayContextsArr != null) {
            while (this.oappcontreplayOffset < this.oappcontreplayContextsArr.length - 1 && this.oappcontreplayContextsArr[this.oappcontreplayOffset] == null) {
                ++this.oappcontreplayOffset;
            }
            if (this.oappcontreplayContextsArr[this.oappcontreplayOffset] != null && this.oappcontreplayContextsArr[this.oappcontreplayOffset].getContext() != null) {
                this.oappcontreplay.doOAPPCONTREPLAY(this.oappcontreplayContextsArr[this.oappcontreplayOffset]);
            }
            if (this.oappcontreplayOffset == this.oappcontreplayContextsArr.length - 1) {
                this.oappcontreplayContextsArr = null;
            } else {
                ++this.oappcontreplayOffset;
            }
        }
        if (!this.replayModes.contains((Object)ReplayMode.NONREQUEST) && this.sessionStateOut != null) {
            this.osesstemplate.doOSESSTEMPLATE(this.sessionStateOut);
            this.sessionStateOut = null;
        }
        if (this.isResultSetCacheEnabled && this.resultSetCache != null && (resultSetCacheState = this.resultSetCache.getState()) == ResultSetCache.ResultSetCacheState.STARTING && this.resultSetCache.getRegistrationId() != -1L) {
            byte[] byArray = this.resultSetCache.getCacheId();
            long l5 = this.resultSetCache.getRegistrationId();
            this.oqcid.doOQCID(byArray, l5);
        }
        if (this.shardingKey != null || this.superShardingKey != null || this.chunkName != null) {
            this.piggyBackOchunkinfo.doOCHUNKINFO(this.shardingKey, this.superShardingKey, this.chunkName, true);
            this.shardingKey = null;
            this.superShardingKey = null;
            this.chunkName = null;
        }
        this.lobMsg.doFreeLobPiggyback();
    }

    synchronized void sendOsesssstateFlags() throws IOException, SQLException {
        assert (!this.replayModes.contains((Object)ReplayMode.RUNTIME_REPLAY_ENABLED) || !this.replayModes.contains((Object)ReplayMode.REPLAYING)) : "RUNTIME_REPLAY_ENABLED and REPLAYING modes cannot bet set at the same time";
        if (this.replayModes.contains((Object)ReplayMode.NONREQUEST)) {
            if (this.replayModes.contains((Object)ReplayMode.RUNTIME_REPLAY_ENABLED)) {
                if (this.osessstateFlags == -1L) {
                    this.osessstateFlags = 0L;
                }
                this.osessstateFlags |= OracleConnection.ReplayOperation.KPDSS_SESSSTATE_NONREQUEST_CALL.getCode() | OracleConnection.ReplayOperation.KPDSS_SESSSTATE_APPCONT_ENABLED.getCode();
            } else if (this.replayModes.contains((Object)ReplayMode.REPLAYING)) {
                this.osessstateFlags = OracleConnection.ReplayOperation.KPDSS_SESSSTATE_NONREQUEST_CALL.getCode();
            }
            if (this.replayModes.contains((Object)ReplayMode.RUNTIME_OR_REPLAYING_STATIC)) {
                this.osessstateFlags |= OracleConnection.ReplayOperation.KPDSS_SESSSTATE_STATIC.getCode();
            }
        }
        if (this.osessstateFlags >= 0L) {
            this.osesstate.doOSESSSTATE(this.osessstateFlags, false);
        }
        this.osessstateFlags = -1L;
    }

    synchronized void closeCursor(int n2) throws SQLException {
        if (this.cursorToCloseOffset == this.cursorToClose.length) {
            int[] nArray = new int[this.cursorToClose.length * 2];
            System.arraycopy(this.cursorToClose, 0, nArray, 0, this.cursorToClose.length);
            this.cursorToClose = nArray;
        }
        this.cursorToClose[this.cursorToCloseOffset++] = n2;
    }

    synchronized void closeQuery(int n2) throws SQLException {
        if (this.queryToCloseOffset == this.queryToClose.length) {
            int[] nArray = new int[this.queryToClose.length * 2];
            System.arraycopy(this.queryToClose, 0, nArray, 0, this.queryToClose.length);
            this.queryToClose = nArray;
        }
        this.queryToClose[this.queryToCloseOffset++] = n2;
    }

    @Override
    void doProxySession(int n2, Properties properties) throws SQLException {
        try {
            String string;
            if (n2 == 1 && (string = properties.getProperty("PROXY_USER_PASSWORD")) != null && string.length() != 0) {
                String string2 = properties.getProperty("PROXY_USER_NAME");
                this.auth.doOSESSKEY(string2, 0L);
            }
            this.auth.doOAUTH(n2, properties, this.sessionId, this.serialNumber);
            int n3 = this.getSessionId();
            int n4 = this.getSerialNumber();
            this.oses.doO80SES(n3, n4, 1);
            this.savedUser = this.userName;
            this.userName = n2 == 1 ? properties.getProperty("PROXY_USER_NAME") : null;
            this.isProxy = true;
        }
        catch (IOException iOException) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    @Override
    void closeProxySession() throws SQLException {
        try {
            this.commoncall.doOLOGOFF();
            this.oses.doO80SES(this.sessionId, this.serialNumber, 1);
            this.userName = this.savedUser;
        }
        catch (IOException iOException) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    void updateSessionProperties(KeywordValue[] keywordValueArray) throws SQLException {
        for (int i2 = 0; i2 < keywordValueArray.length; ++i2) {
            String string;
            String string2;
            int n2 = keywordValueArray[i2].getKeyword();
            byte[] byArray = keywordValueArray[i2].getBinaryValue();
            if (n2 < T4C8Oall.NLS_KEYS.length) {
                String string3 = T4C8Oall.NLS_KEYS[n2];
                if (string3 == null) continue;
                if (byArray != null) {
                    this.sessionProperties.setProperty(string3, this.mare.conv.CharBytesToString(byArray, byArray.length));
                    continue;
                }
                if (keywordValueArray[i2].getTextValue() == null) continue;
                this.sessionProperties.setProperty(string3, keywordValueArray[i2].getTextValue().trim());
                continue;
            }
            if (n2 == 163) {
                int n3;
                int n4;
                if (byArray == null) continue;
                string2 = null;
                if ((byArray[2] & 0xFF) > 120) {
                    int n5 = (byArray[2] & 0x7F) << 6;
                    string2 = ZONEIDMAP.getRegion(n5 += (byArray[3] & 0xFC) >> 2);
                    n4 = (byArray[4] & 0xFF) - 181;
                    n3 = (byArray[5] & 0xFF) - 60;
                } else {
                    n4 = (byArray[4] & 0xFF) - 60;
                    n3 = (byArray[5] & 0xFF) - 60;
                }
                string = string2 != null && !string2.equals("") ? string2 : "GMT" + (n4 > 0 ? "+" : "") + n4 + (n3 <= 9 ? ":0" : ":") + n3;
                this.sessionProperties.setProperty("SESSION_TIME_ZONE", string);
                this.sessionTimeZone = string;
                continue;
            }
            if (n2 == 165 || n2 == 166 || n2 == 167) continue;
            if (n2 == 168) {
                String string4 = keywordValueArray[i2].getTextValue();
                if (string4 == null) continue;
                this.currentSchema = string4.trim();
                this.sessionProperties.setProperty("AL8KW_SCHEMA_NAME", this.currentSchema);
                continue;
            }
            if (n2 == 169) continue;
            if (n2 == 199) {
                String string5 = keywordValueArray[i2].getTextValue();
                if (string5 == null) continue;
                this.sessionProperties.setProperty("AL8KW_ENABLED_ROLE_NAMES", string5.trim());
                continue;
            }
            if (n2 == 171) {
                if (byArray == null) continue;
                this.sessionProperties.setProperty("AL8KW_AUX_SESSSTATE", this.mare.conv.CharBytesToString(byArray, byArray.length));
                continue;
            }
            if (n2 == 175 || n2 == 176) continue;
            if (n2 == 177) {
                long l2 = 0L;
                for (int i3 = 3; i3 >= 0; --i3) {
                    l2 |= ((long)byArray[3 - i3] & 0xFFL) << 8 * i3;
                }
                string2 = String.valueOf(l2);
                string = this.sessionProperties.getProperty("AUTH_DB_ID");
                if (string.equals(string2)) continue;
                this.isPDBChanged = true;
                this.sessionProperties.setProperty("AUTH_DB_ID", string2);
                continue;
            }
            if (n2 == 178) continue;
            if (n2 == 179) {
                if (keywordValueArray[i2].getTextValue() == null) continue;
                this.dbName = keywordValueArray[i2].getTextValue();
                this.sessionProperties.setProperty("AUTH_DBNAME", this.dbName);
                continue;
            }
            if (n2 == 164) {
                if (byArray == null || byArray.length != 1) continue;
                String string6 = byArray[0] > 0 ? "TRUE" : "FALSE";
                this.sessionProperties.setProperty("AL8KW_ERR_OVLAP", string6);
                continue;
            }
            if (n2 == 172) {
                if (keywordValueArray[i2].getTextValue() == null) continue;
                String string7 = keywordValueArray[i2].getTextValue();
                this.sessionProperties.setProperty("AUTH_ORA_EDITION", string7);
                continue;
            }
            if (n2 == 197) {
                if (keywordValueArray[i2].getTextValue() == null) continue;
                String string8 = keywordValueArray[i2].getTextValue();
                this.sessionProperties.setProperty("CONTAINER_NAME", string8.trim());
                continue;
            }
            if (n2 == 183) {
                if (keywordValueArray[i2].getTextValue() == null) continue;
                String string9 = keywordValueArray[i2].getTextValue();
                this.sessionProperties.setProperty("SERVICE_NAME", string9.trim());
                continue;
            }
            if (n2 == 173) {
                if (keywordValueArray[i2].getTextValue() == null) continue;
                String string10 = keywordValueArray[i2].getTextValue();
                this.sessionProperties.setProperty("AL8KW_SQL_TXLP", string10);
                continue;
            }
            if (n2 == 174) {
                if (keywordValueArray[i2].getTextValue() == null) continue;
                String string11 = keywordValueArray[i2].getTextValue();
                this.sessionProperties.setProperty("AL8KW_FSQL_SNTX", string11);
                continue;
            }
            if (n2 == 187) {
                if (keywordValueArray[i2].getTextValue() == null) continue;
                String string12 = keywordValueArray[i2].getTextValue();
                this.sessionProperties.setProperty("AL8KW_ROW_ARCHIVAL", string12);
                continue;
            }
            if (n2 != 186 || keywordValueArray[i2].getTextValue() == null) continue;
            String string13 = keywordValueArray[i2].getTextValue();
            this.sessionProperties.setProperty("AL8KW_CLIENT_INFO", string13);
        }
    }

    @Override
    void onPDBChange(OracleStatement oracleStatement) throws SQLException {
        super.onPDBChange(oracleStatement);
        this.databaseUniqueIdentifier = this.sessionProperties.getProperty("AUTH_DB_ID");
        this.notify(new NTFPDBChangeEvent(this));
    }

    @Override
    public synchronized PreparedStatement getStatementWithKey(String string) throws SQLException {
        PreparedStatement preparedStatement = super.getStatementWithKey(string);
        if (preparedStatement instanceof T4CDirectPathPreparedStatement) {
            this.setDirectPathState((T4CDirectPathPreparedStatement)preparedStatement);
        }
        return preparedStatement;
    }

    @Override
    public synchronized PreparedStatement prepareDirectPath(String string, String string2, String[] stringArray) throws SQLException {
        return this.prepareDirectPathInternal(string, string2, stringArray, null, null);
    }

    @Override
    public synchronized PreparedStatement prepareDirectPath(String string, String string2, String[] stringArray, Properties properties) throws SQLException {
        return this.prepareDirectPathInternal(string, string2, stringArray, null, properties);
    }

    @Override
    public synchronized PreparedStatement prepareDirectPath(String string, String string2, String[] stringArray, String string3) throws SQLException {
        if (string3 == null || string3.length() == 0) {
            throw new IllegalArgumentException("Table partition name argument cannot be null or empty");
        }
        return this.prepareDirectPathInternal(string, string2, stringArray, string3, null);
    }

    @Override
    public synchronized PreparedStatement prepareDirectPath(String string, String string2, String[] stringArray, String string3, Properties properties) throws SQLException {
        if (string3 == null || string3.length() == 0) {
            throw new IllegalArgumentException("Table partition name argument cannot be null or empty");
        }
        return this.prepareDirectPathInternal(string, string2, stringArray, string3, properties);
    }

    private PreparedStatement prepareDirectPathInternal(String string, String string2, String[] stringArray, String string3, Properties properties) throws SQLException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("Table name argument cannot be null or empty");
        }
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("Column name list argument cannot be null or empty");
        }
        if (this.dppstmt != null && !this.dppstmt.isDirectPathCommitted()) {
            throw new IllegalStateException("Multiple Direct Path statements are not allowed");
        }
        if (this.getAutoCommit()) {
            throw new IllegalStateException("Auto commit should be turn OFF");
        }
        if (this.dppstmt != null && !this.dppstmt.isDirectPathClosed()) {
            this.dppstmt.close();
        }
        this.dppstmt = null;
        try {
            Properties properties2 = new Properties();
            properties2.setProperty("result_set_type", Integer.toString(1003));
            properties2.setProperty("result_set_concurrency", Integer.toString(1007));
            String string4 = T4CDirectPathPreparedStatement.getSQLStatement(string, string2, stringArray, string3, this);
            if (this.statementCache != null) {
                this.dppstmt = (T4CDirectPathPreparedStatement)this.statementCache.searchImplicitCache(string4, 1, OracleResultSet.ResultSetType.FORWARD_READ_ONLY.ordinal(), this);
                if (this.dppstmt != null) {
                    this.dppstmt.dpStmtProps = properties;
                }
            }
            if (this.dppstmt == null) {
                this.dppstmt = new T4CDirectPathPreparedStatement(this, string, string2, stringArray, string3, properties2, properties, string4);
            }
            this.odpp.doODPP(string, string2, stringArray, string3, properties);
            this.setTxnMode(0);
        }
        catch (IOException iOException) {
            this.dppstmt = null;
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
        catch (SQLException sQLException) {
            this.dppstmt = null;
            throw sQLException;
        }
        this.dppstmt.setDirectPathCursor((int)this.odpp.getO4Value(3));
        this.dppstmt.setSDBAOfBits((int)this.odpp.getO4Value(5));
        this.dppstmt.setSDBABits((int)this.odpp.getO4Value(7));
        this.dppstmt.setDBABBits((int)this.odpp.getO4Value(8));
        this.dppstmt.updateAccessors(this.odpp.getDescribedAccessors());
        this.dppstmt.setDirectPathStatus(1);
        return this.dppstmt;
    }

    void directPathLoadStream(DirectPathBufferMarshaler.BufferPlanner bufferPlanner, int n2, int[] nArray) throws SQLException {
        try {
            this.odpls.doODPLS(n2, bufferPlanner);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
        catch (SQLException sQLException) {
            if (nArray != null) {
                nArray[0] = this.odpls.startErrorOffset;
                nArray[1] = this.odpls.endErrorOffset;
            }
            throw sQLException;
        }
    }

    void directPathFinish() throws SQLException {
        if (this.dppstmt == null || !this.dppstmt.isDirectPathUncommitted()) {
            throw new IllegalStateException("Cannot finish direct path load before calling prepare!");
        }
        try {
            this.odpmop.doDPMOP(2, this.dppstmt.getDirectPathCursor(), null);
            this.dppstmt.setDirectPathStatus(3);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    void directPathAbort() throws SQLException {
        if (this.dppstmt == null || !this.dppstmt.isDirectPathUncommitted()) {
            throw new IllegalStateException("Cannot abort direct path load before calling prepare!");
        }
        try {
            this.odpmop.doDPMOP(1, this.dppstmt.getDirectPathCursor(), null);
            this.dppstmt.setDirectPathStatus(4);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    void clearDirectPathState() {
        this.dppstmt = null;
    }

    void setDirectPathState(T4CDirectPathPreparedStatement t4CDirectPathPreparedStatement) {
        this.dppstmt = t4CDirectPathPreparedStatement;
        if (this.dppstmt != null && this.dppstmt.isDirectPathClosed()) {
            this.dppstmt.setDirectPathStatus(3);
        }
    }

    @Override
    public String getCurrentSchema() throws SQLException {
        if (this.lifecycle != 1) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8).fillInStackTrace();
        }
        if (this.currentSchema == null || this.getVersionNumber() < 11100) {
            this.currentSchema = super.getCurrentSchema();
        }
        return this.currentSchema;
    }

    @Override
    public Properties getServerSessionInfo() throws SQLException {
        if (this.getVersionNumber() >= 10000 && this.getVersionNumber() < 10200) {
            this.queryFCFProperties(this.sessionProperties);
        }
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.sessionProperties);
        this.updateAutoONSConfig(properties);
        return properties;
    }

    private final void updateAutoONSConfig(Properties properties) {
        String string = properties.getProperty("AUTH_ONS_CONFIG");
        if (string != null && !"".equals(string)) {
            StringBuilder stringBuilder = new StringBuilder(string);
            String string2 = null;
            String string3 = null;
            if (this.onsWalletFile != null && !"".equals(this.onsWalletFile)) {
                string2 = this.onsWalletFile;
                if (this.onsWalletPassword != null && !"".equals(this.onsWalletPassword)) {
                    string3 = this.onsWalletPassword;
                }
            } else if (this.onsProtocol != null && "TCPS".equalsIgnoreCase(this.onsProtocol) && this.walletLocation != null && !"".equals(this.walletLocation)) {
                string2 = this.walletLocation;
                if (this.walletPassword != null && !"".equals(this.walletPassword)) {
                    string3 = this.walletPassword;
                }
            }
            if (string2 != null) {
                if (string2.startsWith("(")) {
                    try {
                        string2 = "file:" + CustomSSLSocketFactory.processWalletLocation(string2);
                    }
                    catch (NetException netException) {
                        string2 = null;
                    }
                }
                if (string2 != null) {
                    stringBuilder.append(ONS_WALLET_CONFIG).append(string2);
                    if (string3 != null) {
                        stringBuilder.append(ONS_WALLET_PASSWD_CONFIG).append(string3);
                    }
                }
            }
            properties.setProperty("AUTH_ONS_CONFIG", stringBuilder.toString());
        }
    }

    @Override
    public String getSessionTimeZoneOffset() throws SQLException {
        String string = this.getServerSessionInfo().getProperty("SESSION_TIME_ZONE");
        string = string == null ? super.getSessionTimeZoneOffset() : this.tzToOffset(string);
        return string;
    }

    int getSessionId() {
        int n2 = -1;
        String string = this.sessionProperties.getProperty("AUTH_SESSION_ID");
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n2;
    }

    int getSerialNumber() {
        int n2 = -1;
        String string = this.sessionProperties.getProperty("AUTH_SERIAL_NUM");
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n2;
    }

    @Override
    public byte getInstanceProperty(OracleConnection.InstanceProperty instanceProperty) throws SQLException {
        byte by = 0;
        if (instanceProperty == OracleConnection.InstanceProperty.ASM_VOLUME_SUPPORTED) {
            if (this.serverRuntimeCapabilities == null || this.serverRuntimeCapabilities.length < 6) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 256).fillInStackTrace();
            }
            by = this.serverRuntimeCapabilities[5];
        } else if (instanceProperty == OracleConnection.InstanceProperty.INSTANCE_TYPE) {
            if (this.serverRuntimeCapabilities == null || this.serverRuntimeCapabilities.length < 4) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 256).fillInStackTrace();
            }
            by = this.serverRuntimeCapabilities[3];
        }
        return by;
    }

    @Override
    public synchronized BlobDBAccess createBlobDBAccess() throws SQLException {
        return this;
    }

    @Override
    public synchronized ClobDBAccess createClobDBAccess() throws SQLException {
        return this;
    }

    @Override
    public synchronized BfileDBAccess createBfileDBAccess() throws SQLException {
        return this;
    }

    @Override
    public synchronized long length(OracleBfile oracleBfile) throws SQLException {
        this.assertLoggedOn("length");
        this.assertNotNull(oracleBfile.shareBytes(), "length");
        this.needLine();
        long l2 = 0L;
        try {
            l2 = this.bfileMsg.getLength(oracleBfile.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
        return l2;
    }

    @Override
    public synchronized long position(OracleBfile oracleBfile, Datum datum, byte[] byArray, long l2) throws SQLException {
        this.assertNotNull(oracleBfile.shareBytes(), "position");
        if (l2 < 1L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()").fillInStackTrace();
        }
        long l3 = LobPlsqlUtil.hasPattern(oracleBfile, datum, byArray, l2);
        l3 = l3 == 0L ? -1L : l3;
        return l3;
    }

    @Override
    public long position(OracleBfile oracleBfile, Datum datum, Datum datum2, long l2) throws SQLException {
        this.assertNotNull(oracleBfile.shareBytes(), "position");
        if (l2 < 1L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()").fillInStackTrace();
        }
        long l3 = LobPlsqlUtil.isSubLob(oracleBfile, datum, datum2, l2);
        l3 = l3 == 0L ? -1L : l3;
        return l3;
    }

    @Override
    public synchronized int getBytes(OracleBfile oracleBfile, long l2, int n2, byte[] byArray) throws SQLException {
        this.assertLoggedOn("getBytes");
        this.assertNotNull(oracleBfile.shareBytes(), "getBytes");
        if (l2 < 1L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getBytes()").fillInStackTrace();
        }
        if (n2 <= 0 || byArray == null) {
            return 0;
        }
        if (this.pipeState != -1) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 453, "getBytes()").fillInStackTrace();
        }
        this.needLine();
        long l3 = 0L;
        if (n2 != 0) {
            try {
                l3 = this.bfileMsg.read(oracleBfile.shareBytes(), l2, n2, byArray, 0);
            }
            catch (IOException iOException) {
                this.handleIOException(iOException);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
            }
        }
        return (int)l3;
    }

    @Override
    public String getName(OracleBfile oracleBfile) throws SQLException {
        this.assertLoggedOn("getName");
        this.assertNotNull(oracleBfile.shareBytes(), "getName");
        String string = LobPlsqlUtil.fileGetName(oracleBfile);
        return string;
    }

    @Override
    public String getDirAlias(OracleBfile oracleBfile) throws SQLException {
        this.assertLoggedOn("getDirAlias");
        this.assertNotNull(oracleBfile.shareBytes(), "getDirAlias");
        String string = LobPlsqlUtil.fileGetDirAlias(oracleBfile);
        return string;
    }

    @Override
    public synchronized void openFile(OracleBfile oracleBfile) throws SQLException {
        this.assertLoggedOn("openFile");
        this.assertNotNull(oracleBfile.shareBytes(), "openFile");
        this.needLine();
        try {
            this.bfileMsg.open(oracleBfile.shareBytes(), 11);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    @Override
    public synchronized boolean isFileOpen(OracleBfile oracleBfile) throws SQLException {
        this.assertLoggedOn("openFile");
        this.assertNotNull(oracleBfile.shareBytes(), "openFile");
        this.needLine();
        boolean bl = false;
        try {
            bl = this.bfileMsg.isOpen(oracleBfile.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
        return bl;
    }

    @Override
    public synchronized boolean fileExists(OracleBfile oracleBfile) throws SQLException {
        this.assertLoggedOn("fileExists");
        this.assertNotNull(oracleBfile.shareBytes(), "fileExists");
        this.needLine();
        boolean bl = false;
        try {
            bl = this.bfileMsg.doesExist(oracleBfile.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
        return bl;
    }

    @Override
    public synchronized void closeFile(OracleBfile oracleBfile) throws SQLException {
        this.assertLoggedOn("closeFile");
        this.assertNotNull(oracleBfile.shareBytes(), "closeFile");
        this.needLine();
        try {
            this.bfileMsg.close(oracleBfile.shareBytes());
            this.removeBfile(oracleBfile);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    @Override
    public synchronized void open(OracleBfile oracleBfile, int n2) throws SQLException {
        this.assertLoggedOn("open");
        this.assertNotNull(oracleBfile.shareBytes(), "open");
        this.needLine();
        try {
            this.bfileMsg.open(oracleBfile.shareBytes(), n2);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    @Override
    public synchronized void close(OracleBfile oracleBfile) throws SQLException {
        this.assertLoggedOn("close");
        this.assertNotNull(oracleBfile.shareBytes(), "close");
        this.needLine();
        try {
            this.bfileMsg.close(oracleBfile.shareBytes());
            this.removeBfile(oracleBfile);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    @Override
    public synchronized boolean isOpen(OracleBfile oracleBfile) throws SQLException {
        this.assertLoggedOn("isOpen");
        this.assertNotNull(oracleBfile.shareBytes(), "isOpen");
        this.needLine();
        boolean bl = false;
        try {
            bl = this.bfileMsg.isOpen(oracleBfile.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
        return bl;
    }

    @Override
    public InputStream newInputStream(BFILE bFILE, int n2, long l2) throws SQLException {
        return this.newInputStream((OracleBfile)bFILE, n2, l2);
    }

    @Override
    public InputStream newInputStream(OracleBfile oracleBfile, int n2, long l2) throws SQLException {
        if (l2 == 0L) {
            return new OracleBlobInputStream(oracleBfile, n2);
        }
        return new OracleBlobInputStream(oracleBfile, n2, l2);
    }

    @Override
    public InputStream newConversionInputStream(BFILE bFILE, int n2) throws SQLException {
        return this.newConversionInputStream((OracleBfile)bFILE, n2);
    }

    @Override
    public InputStream newConversionInputStream(OracleBfile oracleBfile, int n2) throws SQLException {
        this.assertNotNull(oracleBfile.shareBytes(), "newConversionInputStream");
        OracleConversionInputStream oracleConversionInputStream = new OracleConversionInputStream(this.conversion, oracleBfile.getBinaryStream(), n2);
        return oracleConversionInputStream;
    }

    @Override
    public Reader newConversionReader(BFILE bFILE, int n2) throws SQLException {
        return this.newConversionReader((OracleBfile)bFILE, n2);
    }

    @Override
    public Reader newConversionReader(OracleBfile oracleBfile, int n2) throws SQLException {
        this.assertNotNull(oracleBfile.shareBytes(), "newConversionReader");
        OracleConversionReader oracleConversionReader = new OracleConversionReader(this.conversion, oracleBfile.getBinaryStream(), n2);
        return oracleConversionReader;
    }

    @Override
    public synchronized long length(OracleBlob oracleBlob) throws SQLException {
        this.assertLoggedOn("length");
        this.assertNotNull(oracleBlob.shareBytes(), "length");
        this.needLine();
        long l2 = 0L;
        try {
            l2 = this.blobMsg.getLength(oracleBlob.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
        return l2;
    }

    @Override
    public long position(OracleBlob oracleBlob, Datum datum, byte[] byArray, long l2) throws SQLException {
        this.assertLoggedOn("position");
        this.assertNotNull(oracleBlob.shareBytes(), "position");
        if (l2 < 1L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()").fillInStackTrace();
        }
        long l3 = LobPlsqlUtil.hasPattern(oracleBlob, datum, byArray, l2);
        l3 = l3 == 0L ? -1L : l3;
        return l3;
    }

    @Override
    public long position(OracleBlob oracleBlob, Datum datum, Datum datum2, long l2) throws SQLException {
        this.assertLoggedOn("position");
        this.assertNotNull(oracleBlob.shareBytes(), "position");
        this.assertNotNull(datum2.shareBytes(), "position");
        if (l2 < 1L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()").fillInStackTrace();
        }
        long l3 = LobPlsqlUtil.isSubLob(oracleBlob, datum, datum2, l2);
        l3 = l3 == 0L ? -1L : l3;
        return l3;
    }

    @Override
    public synchronized int getBytes(OracleBlob oracleBlob, long l2, int n2, byte[] byArray) throws SQLException {
        this.assertLoggedOn("getBytes");
        this.assertNotNull(oracleBlob.shareBytes(), "getBytes");
        if (l2 < 1L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getBytes()").fillInStackTrace();
        }
        if (this.pipeState != -1) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 453, "getBytes()").fillInStackTrace();
        }
        if (n2 <= 0 || byArray == null) {
            return 0;
        }
        long l3 = 0L;
        long l4 = -1L;
        if (oracleBlob.isActivePrefetch()) {
            l3 += (long)this.copyPrefetchedBlobBytes(oracleBlob, l2, n2, byArray);
            l4 = oracleBlob.length();
        }
        if (l3 < (long)n2 && (l4 == -1L || l2 - 1L + l3 < l4)) {
            this.needLine();
            try {
                l3 += this.blobMsg.read(oracleBlob.shareBytes(), l2 + l3, (long)n2 - l3, byArray, (int)l3);
            }
            catch (IOException iOException) {
                this.handleIOException(iOException);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
            }
        }
        return (int)l3;
    }

    private final int copyPrefetchedBlobBytes(OracleBlob oracleBlob, long l2, int n2, byte[] byArray) {
        OracleLargeObject.PrefetchData<byte[]> prefetchData = oracleBlob.getPrefetchData();
        if (prefetchData != null && l2 <= (long)prefetchData.length()) {
            return prefetchData.copy((int)(l2 - 1L), byArray, 0, n2);
        }
        return 0;
    }

    @Override
    public synchronized int putBytes(OracleBlob oracleBlob, long l2, byte[] byArray, int n2, int n3) throws SQLException {
        this.assertLoggedOn("putBytes");
        this.assertNotNull(oracleBlob.shareBytes(), "putBytes");
        if (l2 < 1L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "putBytes()").fillInStackTrace();
        }
        if (byArray == null || n3 <= 0) {
            return 0;
        }
        if (n2 < 0 || n2 + n3 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.needLine();
        long l3 = 0L;
        if (n3 != 0) {
            try {
                oracleBlob.setActivePrefetch(false);
                oracleBlob.clearCachedData();
                l3 = this.blobMsg.write(oracleBlob.shareBytes(), l2, byArray, n2, n3);
            }
            catch (IOException iOException) {
                this.handleIOException(iOException);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
            }
        }
        return (int)l3;
    }

    @Override
    public synchronized int getChunkSize(OracleBlob oracleBlob) throws SQLException {
        this.assertLoggedOn("getChunkSize");
        this.assertNotNull(oracleBlob.shareBytes(), "getChunkSize");
        this.needLine();
        long l2 = 0L;
        try {
            l2 = this.blobMsg.getChunkSize(oracleBlob.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
        return (int)l2;
    }

    @Override
    public synchronized void trim(OracleBlob oracleBlob, long l2) throws SQLException {
        this.assertLoggedOn("trim");
        this.assertNotNull(oracleBlob.shareBytes(), "trim");
        if (l2 < 0L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "trim()").fillInStackTrace();
        }
        this.needLine();
        try {
            oracleBlob.setActivePrefetch(false);
            oracleBlob.clearCachedData();
            this.blobMsg.trim(oracleBlob.shareBytes(), l2);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    @Override
    public synchronized BLOB createTemporaryBlob(Connection connection, boolean bl, int n2) throws SQLException {
        this.assertLoggedOn("createTemporaryBlob");
        this.needLine();
        BLOB bLOB = null;
        try {
            bLOB = (BLOB)this.blobMsg.createTemporaryLob(this, bl, n2);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
        this.addTemporaryLob(bLOB);
        return bLOB;
    }

    private final synchronized Long getLocatorHash(byte[] byArray) {
        this.checksumEngine.reset();
        this.checksumEngine.update(byArray, 10, 10);
        long l2 = this.checksumEngine.getValue();
        Long l3 = l2;
        return l3;
    }

    @Override
    public final synchronized int decrementTempLobReferenceCount(byte[] byArray) {
        int n2;
        block2: {
            Long l2;
            Integer n3;
            n2 = 0;
            if (!this.enableTempLobRefCnt || byArray == null || (byArray[7] & 1) <= 0 && (byArray[4] & 0x40) <= 0 || (n3 = this.tempLobRefCount.get(l2 = this.getLocatorHash(byArray))) == null) break block2;
            n2 = n3 - 1;
            if (n2 == 0) {
                this.tempLobRefCount.remove(l2);
            } else {
                this.tempLobRefCount.put(l2, n2);
            }
        }
        return n2;
    }

    @Override
    public final synchronized void incrementTempLobReferenceCount(byte[] byArray) {
        if (this.enableTempLobRefCnt && byArray != null && ((byArray[7] & 1) > 0 || (byArray[4] & 0x40) > 0)) {
            Long l2 = this.getLocatorHash(byArray);
            Integer n2 = this.tempLobRefCount.get(l2);
            if (n2 != null) {
                int n3 = n2;
                this.tempLobRefCount.put(l2, n3 + 1);
            } else {
                this.tempLobRefCount.put(l2, 1);
            }
        }
    }

    @Override
    public synchronized void freeTemporary(OracleBlob oracleBlob, Datum datum, boolean bl) throws SQLException {
        this.assertLoggedOn("freeTemporary");
        this.assertNotNull(oracleBlob.shareBytes(), "freeTemporary");
        this.needLine();
        try {
            this.blobMsg.freeTemporaryLob(oracleBlob.shareBytes());
            this.removeFromTemporaryLobs(oracleBlob);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    @Override
    public boolean isTemporary(OracleBlob oracleBlob) throws SQLException {
        this.assertNotNull(oracleBlob.shareBytes(), "isTemporary");
        boolean bl = false;
        byte[] byArray = oracleBlob.shareBytes();
        if ((byArray[7] & 1) > 0 || (byArray[4] & 0x40) > 0) {
            bl = true;
        }
        return bl;
    }

    @Override
    public short getDuration(OracleBlob oracleBlob) throws SQLException {
        this.assertNotNull(oracleBlob.shareBytes(), "getDuration");
        byte[] byArray = oracleBlob.shareBytes();
        short s2 = -1;
        if ((byArray[7] & 1) > 0 || (byArray[4] & 0x40) > 0) {
            s2 = (short)(byArray[22] << 8 | byArray[23] & 0xFF);
        }
        return s2;
    }

    @Override
    public synchronized void open(OracleBlob oracleBlob, int n2) throws SQLException {
        this.assertLoggedOn("open");
        this.assertNotNull(oracleBlob.shareBytes(), "open");
        this.needLine();
        try {
            this.blobMsg.open(oracleBlob.shareBytes(), n2);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    @Override
    public synchronized void close(OracleBlob oracleBlob) throws SQLException {
        this.assertLoggedOn("close");
        this.assertNotNull(oracleBlob.shareBytes(), "close");
        this.needLine();
        try {
            this.blobMsg.close(oracleBlob.shareBytes());
            this.removeLargeObject(oracleBlob);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    @Override
    public synchronized boolean isOpen(OracleBlob oracleBlob) throws SQLException {
        this.assertLoggedOn("isOpen");
        this.assertNotNull(oracleBlob.shareBytes(), "isOpen");
        this.needLine();
        boolean bl = false;
        try {
            bl = this.blobMsg.isOpen(oracleBlob.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
        return bl;
    }

    @Override
    public InputStream newInputStream(BLOB bLOB, int n2, long l2) throws SQLException {
        return this.newInputStream(bLOB, n2, l2, false);
    }

    @Override
    public InputStream newInputStream(BLOB bLOB, int n2, long l2, boolean bl) throws SQLException {
        return this.newInputStream((OracleBlob)bLOB, n2, l2, bl);
    }

    @Override
    public InputStream newInputStream(OracleBlob oracleBlob, int n2, long l2) throws SQLException {
        return this.newInputStream(oracleBlob, n2, l2, false);
    }

    @Override
    public InputStream newInputStream(OracleBlob oracleBlob, int n2, long l2, boolean bl) throws SQLException {
        if (l2 == 0L) {
            return new OracleBlobInputStream(oracleBlob, n2, bl);
        }
        return new OracleBlobInputStream(oracleBlob, n2, l2, bl);
    }

    @Override
    public InputStream newInputStream(BLOB bLOB, int n2, long l2, long l3) throws SQLException {
        return this.newInputStream(bLOB, n2, l2, l3, false);
    }

    @Override
    public InputStream newInputStream(BLOB bLOB, int n2, long l2, long l3, boolean bl) throws SQLException {
        return this.newInputStream((OracleBlob)bLOB, n2, l2, l3, bl);
    }

    @Override
    public InputStream newInputStream(OracleBlob oracleBlob, int n2, long l2, long l3) throws SQLException {
        return this.newInputStream(oracleBlob, n2, l2, l3, false);
    }

    @Override
    public InputStream newInputStream(OracleBlob oracleBlob, int n2, long l2, long l3, boolean bl) throws SQLException {
        return new OracleBlobInputStream(oracleBlob, n2, l2, l3, bl);
    }

    @Override
    public OutputStream newOutputStream(BLOB bLOB, int n2, long l2, boolean bl) throws SQLException {
        return this.newOutputStream((OracleBlob)bLOB, n2, l2, bl);
    }

    @Override
    public OutputStream newOutputStream(OracleBlob oracleBlob, int n2, long l2, boolean bl) throws SQLException {
        if (l2 == 0L) {
            if (bl & this.lobStreamPosStandardCompliant) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            return new OracleBlobOutputStream(oracleBlob, n2);
        }
        return new OracleBlobOutputStream(oracleBlob, n2, l2);
    }

    @Override
    public InputStream newConversionInputStream(BLOB bLOB, int n2) throws SQLException {
        return this.newConversionInputStream(bLOB, n2, false);
    }

    @Override
    public InputStream newConversionInputStream(BLOB bLOB, int n2, boolean bl) throws SQLException {
        return this.newConversionInputStream((OracleBlob)bLOB, n2, bl);
    }

    @Override
    public InputStream newConversionInputStream(OracleBlob oracleBlob, int n2) throws SQLException {
        return this.newConversionInputStream(oracleBlob, n2, false);
    }

    @Override
    public InputStream newConversionInputStream(OracleBlob oracleBlob, int n2, boolean bl) throws SQLException {
        this.assertNotNull(oracleBlob.shareBytes(), "newConversionInputStream");
        OracleConversionInputStream oracleConversionInputStream = new OracleConversionInputStream(this.conversion, oracleBlob.binaryStreamValue(bl), n2);
        return oracleConversionInputStream;
    }

    @Override
    public Reader newConversionReader(BLOB bLOB, int n2) throws SQLException {
        return this.newConversionReader(bLOB, n2, false);
    }

    @Override
    public Reader newConversionReader(BLOB bLOB, int n2, boolean bl) throws SQLException {
        return this.newConversionReader((OracleBlob)bLOB, n2, bl);
    }

    @Override
    public Reader newConversionReader(OracleBlob oracleBlob, int n2) throws SQLException {
        return this.newConversionReader(oracleBlob, n2, false);
    }

    @Override
    public Reader newConversionReader(OracleBlob oracleBlob, int n2, boolean bl) throws SQLException {
        this.assertNotNull(oracleBlob.shareBytes(), "newConversionReader");
        OracleConversionReader oracleConversionReader = new OracleConversionReader(this.conversion, oracleBlob.binaryStreamValue(bl), n2);
        return oracleConversionReader;
    }

    @Override
    public synchronized long length(OracleClob oracleClob) throws SQLException {
        this.assertLoggedOn("length");
        this.assertNotNull(oracleClob.shareBytes(), "length");
        this.needLine();
        long l2 = 0L;
        try {
            l2 = this.clobMsg.getLength(oracleClob.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
        return l2;
    }

    @Override
    public long position(OracleClob oracleClob, String string, long l2) throws SQLException {
        if (string == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()").fillInStackTrace();
        }
        this.assertLoggedOn("position");
        this.assertNotNull(oracleClob.shareBytes(), "position");
        if (l2 < 1L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()").fillInStackTrace();
        }
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        long l3 = LobPlsqlUtil.hasPattern(oracleClob, cArray, l2);
        l3 = l3 == 0L ? -1L : l3;
        return l3;
    }

    @Override
    public long position(OracleClob oracleClob, OracleClob oracleClob2, long l2) throws SQLException {
        if (oracleClob2 == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()").fillInStackTrace();
        }
        this.assertLoggedOn("position");
        this.assertNotNull(oracleClob.shareBytes(), "position");
        this.assertNotNull(oracleClob2.shareBytes(), "position");
        if (l2 < 1L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()").fillInStackTrace();
        }
        long l3 = LobPlsqlUtil.isSubLob(oracleClob, oracleClob2, l2);
        l3 = l3 == 0L ? -1L : l3;
        return l3;
    }

    @Override
    public synchronized int getChars(OracleClob oracleClob, long l2, int n2, char[] cArray) throws SQLException {
        this.assertLoggedOn("getChars");
        this.assertNotNull(oracleClob.shareBytes(), "getChars");
        if (l2 < 1L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getChars()").fillInStackTrace();
        }
        if (this.pipeState != -1) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 453, "getChars()").fillInStackTrace();
        }
        if (n2 <= 0 || cArray == null) {
            return 0;
        }
        long l3 = 0L;
        long l4 = -1L;
        if (oracleClob.isActivePrefetch()) {
            l4 = oracleClob.length();
            l3 += (long)this.copyPrefetchedClobChars(oracleClob, l2, n2, cArray);
        }
        if (l3 < (long)n2 && (l4 == -1L || l2 - 1L + l3 < l4)) {
            this.needLine();
            try {
                boolean bl = oracleClob.isNCLOB();
                l3 += this.clobMsg.read(oracleClob.shareBytes(), l2 + l3, (long)n2 - l3, bl, cArray, (int)l3);
            }
            catch (IOException iOException) {
                this.handleIOException(iOException);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
            }
        }
        return (int)l3;
    }

    private final int copyPrefetchedClobChars(OracleClob oracleClob, long l2, int n2, char[] cArray) {
        OracleLargeObject.PrefetchData<char[]> prefetchData = oracleClob.getPrefetchData();
        if (prefetchData != null && l2 <= (long)prefetchData.length()) {
            return prefetchData.copy((int)l2 - 1, cArray, 0, n2);
        }
        return 0;
    }

    @Override
    public synchronized int putChars(OracleClob oracleClob, long l2, char[] cArray, int n2, int n3) throws SQLException {
        this.assertLoggedOn("putChars");
        this.assertNotNull(oracleClob.shareBytes(), "putChars");
        if (l2 < 1L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "putChars()").fillInStackTrace();
        }
        if (cArray == null || n3 <= 0) {
            return 0;
        }
        this.needLine();
        long l3 = 0L;
        if (n3 != 0) {
            try {
                boolean bl = oracleClob.isNCLOB();
                oracleClob.setActivePrefetch(false);
                oracleClob.clearCachedData();
                l3 = this.clobMsg.write(oracleClob.shareBytes(), l2, bl, cArray, n2, n3);
            }
            catch (IOException iOException) {
                this.handleIOException(iOException);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
            }
        }
        return (int)l3;
    }

    @Override
    public synchronized int getChunkSize(OracleClob oracleClob) throws SQLException {
        this.assertLoggedOn("getChunkSize");
        this.assertNotNull(oracleClob.shareBytes(), "getChunkSize");
        this.needLine();
        long l2 = 0L;
        try {
            l2 = this.clobMsg.getChunkSize(oracleClob.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
        return (int)l2;
    }

    @Override
    public synchronized void trim(OracleClob oracleClob, long l2) throws SQLException {
        this.assertLoggedOn("trim");
        this.assertNotNull(oracleClob.shareBytes(), "trim");
        if (l2 < 0L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "trim()").fillInStackTrace();
        }
        this.needLine();
        try {
            oracleClob.setActivePrefetch(false);
            oracleClob.clearCachedData();
            this.clobMsg.trim(oracleClob.shareBytes(), l2);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    @Override
    public synchronized CLOB createTemporaryClob(Connection connection, boolean bl, int n2, short s2) throws SQLException {
        this.assertLoggedOn("createTemporaryClob");
        if (s2 != 2 && s2 != 1) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 184).fillInStackTrace();
        }
        this.needLine();
        CLOB cLOB = null;
        try {
            cLOB = (CLOB)this.clobMsg.createTemporaryLob(this, bl, n2, s2);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
        this.addTemporaryLob(cLOB);
        return cLOB;
    }

    @Override
    public synchronized void freeTemporary(OracleClob oracleClob, Datum datum, boolean bl) throws SQLException {
        this.assertLoggedOn("freeTemporary");
        this.assertNotNull(oracleClob.shareBytes(), "freeTemporary");
        this.needLine();
        try {
            this.clobMsg.freeTemporaryLob(oracleClob.shareBytes());
            this.removeFromTemporaryLobs(oracleClob);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    @Override
    public boolean isTemporary(OracleClob oracleClob) throws SQLException {
        boolean bl = false;
        byte[] byArray = oracleClob.shareBytes();
        if ((byArray[7] & 1) > 0 || (byArray[4] & 0x40) > 0) {
            bl = true;
        }
        return bl;
    }

    @Override
    public short getDuration(OracleClob oracleClob) throws SQLException {
        this.assertNotNull(oracleClob.shareBytes(), "getDuration");
        byte[] byArray = oracleClob.shareBytes();
        short s2 = -1;
        if ((byArray[7] & 1) > 0 || (byArray[4] & 0x40) > 0) {
            s2 = (short)(byArray[22] << 8 | byArray[23] & 0xFF);
        }
        return s2;
    }

    @Override
    public synchronized void open(OracleClob oracleClob, int n2) throws SQLException {
        this.assertLoggedOn("open");
        this.assertNotNull(oracleClob.shareBytes(), "open");
        this.needLine();
        try {
            this.clobMsg.open(oracleClob.shareBytes(), n2);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    @Override
    public synchronized void close(OracleClob oracleClob) throws SQLException {
        this.assertLoggedOn("close");
        this.assertNotNull(oracleClob.shareBytes(), "close");
        this.needLine();
        try {
            this.clobMsg.close(oracleClob.shareBytes());
            this.removeLargeObject(oracleClob);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    @Override
    public synchronized boolean isOpen(OracleClob oracleClob) throws SQLException {
        this.assertLoggedOn("isOpen");
        this.assertNotNull(oracleClob.shareBytes(), "isOpen");
        boolean bl = false;
        this.needLine();
        try {
            bl = this.clobMsg.isOpen(oracleClob.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
        return bl;
    }

    @Override
    public InputStream newInputStream(CLOB cLOB, int n2, long l2) throws SQLException {
        return this.newInputStream(cLOB, n2, l2, false);
    }

    @Override
    public InputStream newInputStream(CLOB cLOB, int n2, long l2, boolean bl) throws SQLException {
        return this.newInputStream((OracleClob)cLOB, n2, l2, bl);
    }

    @Override
    public InputStream newInputStream(OracleClob oracleClob, int n2, long l2) throws SQLException {
        return this.newInputStream(oracleClob, n2, l2, false);
    }

    @Override
    public InputStream newInputStream(OracleClob oracleClob, int n2, long l2, boolean bl) throws SQLException {
        if (l2 == 0L) {
            return new OracleClobInputStream(oracleClob, n2, bl);
        }
        return new OracleClobInputStream(oracleClob, n2, l2, bl);
    }

    @Override
    public OutputStream newOutputStream(CLOB cLOB, int n2, long l2, boolean bl) throws SQLException {
        return this.newOutputStream((OracleClob)cLOB, n2, l2, bl);
    }

    @Override
    public OutputStream newOutputStream(OracleClob oracleClob, int n2, long l2, boolean bl) throws SQLException {
        if (l2 == 0L) {
            if (bl & this.lobStreamPosStandardCompliant) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            return new OracleClobOutputStream(oracleClob, n2);
        }
        return new OracleClobOutputStream(oracleClob, n2, l2);
    }

    @Override
    public Reader newReader(CLOB cLOB, int n2, long l2) throws SQLException {
        return this.newReader((OracleClob)cLOB, n2, l2);
    }

    @Override
    public Reader newReader(OracleClob oracleClob, int n2, long l2) throws SQLException {
        if (l2 == 0L) {
            return new OracleClobReader(oracleClob, n2);
        }
        return new OracleClobReader(oracleClob, n2, l2);
    }

    @Override
    public Reader newReader(CLOB cLOB, int n2, long l2, long l3) throws SQLException {
        return this.newReader((OracleClob)cLOB, n2, l2, l3);
    }

    @Override
    public Reader newReader(OracleClob oracleClob, int n2, long l2, long l3) throws SQLException {
        return new OracleClobReader(oracleClob, n2, l2, l3);
    }

    @Override
    public Writer newWriter(CLOB cLOB, int n2, long l2, boolean bl) throws SQLException {
        return this.newWriter((OracleClob)cLOB, n2, l2, bl);
    }

    @Override
    public Writer newWriter(OracleClob oracleClob, int n2, long l2, boolean bl) throws SQLException {
        if (l2 == 0L) {
            if (bl & this.lobStreamPosStandardCompliant) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            return new OracleClobWriter(oracleClob, n2);
        }
        return new OracleClobWriter(oracleClob, n2, l2);
    }

    void assertLoggedOn(String string) throws SQLException {
        if (!this.isLoggedOn) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 430).fillInStackTrace();
        }
    }

    boolean isLoggedOn() {
        return this.isLoggedOn;
    }

    void assertNotNull(byte[] byArray, String string) throws NullPointerException {
        if (byArray == null) {
            throw new NullPointerException("bytes are null");
        }
    }

    @Override
    void internalClose() throws SQLException {
        super.internalClose();
        if (this.all8 != null) {
            this.all8.definesAccessors = null;
        }
        this.isLoggedOn = false;
        try {
            if (this.net != null) {
                this.net.disconnect();
            }
        }
        catch (Exception exception) {
        }
    }

    @Override
    void doAbort() throws SQLException {
        try {
            this.net.abort();
        }
        catch (NetException netException) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), netException).fillInStackTrace();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    @Override
    protected void doDescribeTable(AutoKeyInfo autoKeyInfo) throws SQLException {
        String string = autoKeyInfo.getTableName();
        T4C8Kpcdsc[] t4C8KpcdscArray = null;
        try {
            t4C8KpcdscArray = this.describeTbl.doODSYTable(string);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
        int n2 = t4C8KpcdscArray.length;
        autoKeyInfo.allocateSpaceForDescribedData(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            T4C8Kpcdsc t4C8Kpcdsc = t4C8KpcdscArray[i2];
            String string2 = t4C8Kpcdsc.name_kpcdsc;
            int n3 = t4C8Kpcdsc.dty_kpcdsc;
            int n4 = t4C8Kpcdsc.size_kpcdsc;
            boolean bl = t4C8Kpcdsc.isnull_kpcdsc;
            short s2 = t4C8Kpcdsc.charsetform_kpcdsc;
            int n5 = t4C8Kpcdsc.precision_kpcdsc;
            int n6 = t4C8Kpcdsc.scale_kpcdsc;
            String string3 = t4C8Kpcdsc.typnm_kpcdsc;
            autoKeyInfo.fillDescribedData(i2, string2, n3, n4, bl, s2, n5, n6, string3);
        }
    }

    @Override
    void doSetApplicationContext(String string, String string2, String string3) throws SQLException {
        Namespace namespace = (Namespace)this.namespaces.get(string);
        if (namespace == null) {
            namespace = new Namespace(string);
            this.namespaces.put(string, namespace);
        }
        namespace.setAttribute(string2, string3);
    }

    @Override
    void doClearAllApplicationContext(String string) throws SQLException {
        Namespace namespace = new Namespace(string);
        namespace.clear();
        this.namespaces.put(string, namespace);
    }

    @Override
    public void getPropertyForPooledConnection(OraclePooledConnection oraclePooledConnection) throws SQLException {
        super.getPropertyForPooledConnection(oraclePooledConnection, this.password.get());
    }

    final void getPasswordInternal(T4CXAResource t4CXAResource) throws SQLException {
        t4CXAResource.setPasswordInternal(this.password);
    }

    @Override
    synchronized void doEnqueue(String string, AQEnqueueOptions aQEnqueueOptions, AQMessagePropertiesI aQMessagePropertiesI, byte[] byArray, int n2, byte[] byArray2, byte[][] byArray3, boolean bl) throws SQLException {
        try {
            this.needLine();
            this.aqe.doOAQEQ(string, aQEnqueueOptions, aQMessagePropertiesI, byArray2, byArray, n2, bl);
            if (aQEnqueueOptions.getRetrieveMessageId()) {
                byArray3[0] = this.aqe.getMessageId();
            }
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    @Override
    synchronized boolean doDequeue(String string, AQDequeueOptions aQDequeueOptions, AQMessagePropertiesI aQMessagePropertiesI, byte[] byArray, int n2, byte[][] byArray2, byte[][] byArray3, boolean bl) throws SQLException {
        boolean bl2 = false;
        try {
            this.needLine();
            this.aqdq.doOAQDQ(string, aQDequeueOptions, byArray, n2, bl, aQMessagePropertiesI);
            byArray2[0] = this.aqdq.getPayload();
            byArray3[0] = this.aqdq.getDequeuedMessageId();
            bl2 = this.aqdq.hasAMessageBeenDequeued();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
        return bl2;
    }

    @Override
    synchronized void doJMSEnqueue(String string, JMSEnqueueOptions jMSEnqueueOptions, AQMessagePropertiesI aQMessagePropertiesI, JMSMessageProperties jMSMessageProperties, byte[] byArray, byte[] byArray2, byte[][] byArray3) throws SQLException {
        try {
            this.needLine();
            this.oaqenq.doJMSEnq(string, jMSEnqueueOptions, aQMessagePropertiesI, jMSMessageProperties, byArray, byArray2);
            if (jMSEnqueueOptions.isRetrieveMessageId()) {
                byArray3[0] = this.oaqenq.getMsgId();
            }
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    @Override
    synchronized void doJMSEnqueue(String string, JMSEnqueueOptions jMSEnqueueOptions, AQMessagePropertiesI aQMessagePropertiesI, JMSMessageProperties jMSMessageProperties, byte[] byArray, InputStream inputStream, byte[][] byArray2, int n2) throws SQLException {
        try {
            this.needLine();
            this.oaqenq.doJMSEnq(string, jMSEnqueueOptions, aQMessagePropertiesI, jMSMessageProperties, byArray, inputStream, n2);
            if (jMSEnqueueOptions.isRetrieveMessageId()) {
                byArray2[0] = this.oaqenq.getMsgId();
            }
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    @Override
    synchronized boolean doJmsDequeue(String string, JMSDequeueOptions jMSDequeueOptions, AQMessagePropertiesI aQMessagePropertiesI, JMSMessagePropertiesI jMSMessagePropertiesI, byte[] byArray, OutputStream outputStream, byte[][] byArray2) throws SQLException {
        boolean bl = false;
        try {
            this.needLine();
            this.oaqdeq.doJMSDeq(string, jMSDequeueOptions, byArray, aQMessagePropertiesI, jMSMessagePropertiesI, outputStream);
            byArray2[0] = this.oaqdeq.getDequeuedMessageId();
            bl = this.oaqdeq.isHasAMessageBeenDequeued();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
        return bl;
    }

    @Override
    synchronized boolean doJmsDequeue(String string, JMSDequeueOptions jMSDequeueOptions, AQMessagePropertiesI aQMessagePropertiesI, JMSMessagePropertiesI jMSMessagePropertiesI, byte[] byArray, byte[][] byArray2, byte[][] byArray3) throws SQLException {
        boolean bl = false;
        try {
            this.needLine();
            this.oaqdeq.doJMSDeq(string, jMSDequeueOptions, byArray, aQMessagePropertiesI, jMSMessagePropertiesI);
            byArray2[0] = this.oaqdeq.getPayload();
            byArray3[0] = this.oaqdeq.getDequeuedMessageId();
            bl = this.oaqdeq.isHasAMessageBeenDequeued();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
        return bl;
    }

    @Override
    synchronized int doPingDatabase() throws SQLException {
        if (this.versionNumber >= 10102) {
            this.beginNonRequestCalls();
            try {
                this.needLine();
                this.oping.doOPING();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                int n2 = -3;
                return n2;
            }
            catch (InterruptedIOException interruptedIOException) {
                this.handleIOException(interruptedIOException);
                int n3 = -1;
                return n3;
            }
            catch (IOException iOException) {
                int n4 = -1;
                return n4;
            }
            catch (SQLException sQLException) {
                int n5 = -1;
                return n5;
            }
            finally {
                this.endNonRequestCalls();
            }
            return 0;
        }
        return super.doPingDatabase();
    }

    @Override
    synchronized boolean isValidLight(int n2) throws SQLException {
        if (this.checkAndDrain()) {
            return false;
        }
        try {
            this.net.sendZDP();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    void setNeedsToBeClosed(boolean bl) {
        this.needsToBeClosed = bl;
    }

    @Override
    synchronized boolean drainOnInbandNotification() throws SQLException {
        if (this.needsToBeClosed) {
            this.closeConnectionSafely();
            return true;
        }
        this.net.readInbandNotification();
        if (this.net.needsToBeClosed()) {
            this.closeConnectionSafely();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized Map<String, JMSNotificationRegistration> doRegisterJMSNotification(String[] stringArray, Map<String, Properties> map, String string) throws SQLException {
        Object object;
        Object object2;
        String string2 = null;
        int n2 = stringArray.length;
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        int[] nArray4 = new int[n2];
        int[] nArray5 = new int[n2];
        byte[][] byArrayArray = new byte[n2][];
        int n3 = 16;
        if (map != null && (object2 = map.get("NOTIFICATION")) != null) {
            object = ((Properties)object2).getProperty("MAX_NTF_CONNECTIONS", n3 + "");
            try {
                n3 = Integer.parseInt((String)object);
            }
            catch (Exception exception) {
                n3 = 16;
            }
        }
        NTFJMSConnectionGroup.setMaxNtfConnection(n3);
        object2 = PhysicalConnection.ntfManager.getJMSConnectionGroup(this.userName + this.instanceName);
        object = new HashMap();
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray2[i2] = 1;
            nArray3[i2] = 0;
            nArray[i2] = PhysicalConnection.ntfManager.getNextJdbcRegId();
            byArrayArray[i2] = new byte[4];
            byArrayArray[i2][0] = (byte)((nArray[i2] & 0xFF000000) >> 24);
            byArrayArray[i2][1] = (byte)((nArray[i2] & 0xFF0000) >> 16);
            byArrayArray[i2][2] = (byte)((nArray[i2] & 0xFF00) >> 8);
            byArrayArray[i2][3] = (byte)(nArray[i2] & 0xFF);
            Properties properties = map.get(stringArray[i2]);
            if (properties == null) continue;
            if (properties.getProperty("NTF_QOS_RELIABLE", "false").equalsIgnoreCase("true")) {
                int n4 = i2;
                nArray4[n4] = nArray4[n4] | 1;
            }
            if (properties.getProperty("NTF_QOS_PURGE_ON_NTFN", "false").equalsIgnoreCase("true")) {
                int n5 = i2;
                nArray4[n5] = nArray4[n5] | 0x10;
            }
            if (properties.getProperty("NTF_AQ_PAYLOAD", "false").equalsIgnoreCase("true")) {
                int n6 = i2;
                nArray4[n6] = nArray4[n6] | 2;
            }
            if (properties.getProperty("NTF_ASYNC_DEQ", "false").equalsIgnoreCase("true")) {
                int n7 = i2;
                nArray4[n7] = nArray4[n7] | 0x200;
            }
            if (properties.getProperty("NTF_QOS_SECURE", "false").equalsIgnoreCase("true")) {
                int n8 = i2;
                nArray4[n8] = nArray4[n8] | 8;
            }
            if (properties.getProperty("NTF_QOS_TX_ACK", "false").equalsIgnoreCase("true")) {
                int n9 = i2;
                nArray4[n9] = nArray4[n9] | 0x800;
            }
            if (properties.getProperty("NTF_QOS_AUTO_ACK", "false").equalsIgnoreCase("true")) {
                int n10 = i2;
                nArray4[n10] = nArray4[n10] | 0x400;
            }
            nArray5[i2] = this.readNTFtimeout(properties);
        }
        Object object3 = object2;
        synchronized (object3) {
            Object object4;
            Object object5;
            boolean bl = false;
            NTFJMSConnection nTFJMSConnection = ((NTFJMSConnectionGroup)object2).getNTFJMSConnection(n2);
            if (nTFJMSConnection != null) {
                string2 = nTFJMSConnection.getJMSConnectionId();
            } else {
                string2 = null;
                bl = true;
            }
            try {
                this.okpn.doOKPN(1, 4, this.userName, string2, n2, nArray2, stringArray, byArrayArray, nArray3, nArray4, nArray5, null, null, null, null, null, null, null, null, null, string);
            }
            catch (IOException iOException) {
                ((NTFJMSConnectionGroup)object2).resetRegistrationNumbers(n2, nTFJMSConnection);
                this.handleIOException(iOException);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
            }
            long[] lArray = this.okpn.getRegistrationIdArray();
            assert (lArray.length == nArray.length) : "jmsRegIdArr.length = " + lArray.length + ", jdbcRegIdArr.length = " + nArray.length;
            if (bl) {
                string2 = this.okpn.getJMSConnectionId();
                if (string2 == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 287, "clientID returned by server is null").fillInStackTrace();
                }
                ArrayList<String> arrayList = this.okpn.getListenerAddresses();
                if (arrayList == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 287, "listenerAddress returned by server is null").fillInStackTrace();
                }
                object5 = this.net.getSessionAttributes().getcOption().service_name;
                if (object5 == null) {
                    object5 = this.net.getSessionAttributes().getcOption().getOriginalConnOption().service_name;
                }
                if (object5 == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 287, "No service name found, please use a service name format URL to create a connection").fillInStackTrace();
                }
                object4 = this.getConnectionPropsforListenerConnection();
                ((NTFJMSConnectionGroup)object2).startJMSListenerConnection(this.instanceName, (String)object5, this.userName, this.password.get(), (Properties)object4, arrayList, string2, n2);
            }
            for (int i3 = 0; i3 < n2; ++i3) {
                object5 = map.get(stringArray[i3]);
                if (object5 == null) {
                    object5 = new Properties();
                }
                object4 = new NTFJMSRegistration(nArray[i3], true, this.instanceName, this.userName, (Properties)object5, stringArray[i3], this.versionNumber, string2);
                ((NTFRegistration)object4).setState(NotificationRegistration.RegistrationState.DISABLED);
                ((NTFJMSRegistration)object4).setJMSRegistrationId(lArray[i3]);
                ((NTFJMSRegistration)object4).setQOSFlag(nArray4[i3]);
                object.put(stringArray[i3], object4);
                PhysicalConnection.ntfManager.addRegistration((NTFRegistration)object4);
                PhysicalConnection.ntfManager.mapJMSRegIdToJDBCRegId(lArray[i3], nArray[i3]);
                ((NTFJMSConnectionGroup)object2).addNtfRegistrationByRegId(lArray[i3], (NTFJMSRegistration)object4);
            }
            return object;
        }
    }

    @Override
    void doStartJMSNotification(NTFJMSRegistration nTFJMSRegistration) throws SQLException {
        if (nTFJMSRegistration.getState() != NotificationRegistration.RegistrationState.ACTIVE) {
            this.startOrStopJMSNotification(nTFJMSRegistration, JMSNotificationRegistration.Directive.ENABLE);
            nTFJMSRegistration.setState(NotificationRegistration.RegistrationState.ACTIVE);
        }
    }

    @Override
    void doStopJMSNotification(NTFJMSRegistration nTFJMSRegistration) throws SQLException {
        if (nTFJMSRegistration.getState() != NotificationRegistration.RegistrationState.DISABLED) {
            this.startOrStopJMSNotification(nTFJMSRegistration, JMSNotificationRegistration.Directive.DISABLE);
        }
    }

    void startOrStopJMSNotification(NTFJMSRegistration nTFJMSRegistration, JMSNotificationRegistration.Directive directive) throws SQLException {
        Long l2 = nTFJMSRegistration.getJMSRegistrationId();
        nTFJMSRegistration.setState(NotificationRegistration.RegistrationState.ACTIVE);
        NTFJMSConnectionGroup nTFJMSConnectionGroup = PhysicalConnection.ntfManager.getJMSConnectionGroup(this.userName + this.instanceName);
        assert (nTFJMSConnectionGroup != null) : "jmsConnectionGroup is null";
        String string = nTFJMSRegistration.getJMSConnectionId();
        int[] nArray = new int[]{1};
        String[] stringArray = new String[]{nTFJMSRegistration.getQueueName()};
        int[] nArray2 = new int[]{0};
        int n2 = nTFJMSRegistration.getQOSFlag();
        int[] nArray3 = new int[]{n2};
        int[] nArray4 = new int[]{0};
        long[] lArray = new long[]{l2};
        int n3 = directive == JMSNotificationRegistration.Directive.DISABLE ? 5 : 4;
        try {
            this.okpn.doOKPN(n3, 4, this.userName, string, 1, nArray, stringArray, null, nArray2, nArray3, nArray4, null, null, null, null, null, null, null, null, lArray);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    @Override
    synchronized void doUnregisterJMSNotification(NTFJMSRegistration nTFJMSRegistration) throws SQLException {
        PhysicalConnection.ntfManager.removeRegistration(nTFJMSRegistration);
        PhysicalConnection.ntfManager.freeJdbcRegId(nTFJMSRegistration.getJdbcRegId());
        Long l2 = nTFJMSRegistration.getJMSRegistrationId();
        PhysicalConnection.ntfManager.removeJMSRegistrationId(l2);
        nTFJMSRegistration.setState(NotificationRegistration.RegistrationState.CLOSED);
        NTFJMSConnectionGroup nTFJMSConnectionGroup = PhysicalConnection.ntfManager.getJMSConnectionGroup(this.userName + this.instanceName);
        assert (nTFJMSConnectionGroup != null) : "jmsConnectionGroup is null";
        nTFJMSConnectionGroup.decrementNumberOfRegistrations();
        String string = nTFJMSRegistration.getJMSConnectionId();
        nTFJMSConnectionGroup.stopNTFJMSConnection(string);
        nTFJMSConnectionGroup.checkForActiveRegistrations();
        int[] nArray = new int[]{1};
        String[] stringArray = new String[]{nTFJMSRegistration.getQueueName()};
        int[] nArray2 = new int[]{0};
        int n2 = nTFJMSRegistration.getQOSFlag();
        int[] nArray3 = new int[]{n2};
        int[] nArray4 = new int[]{0};
        long[] lArray = new long[]{l2};
        try {
            this.okpn.doOKPN(2, 4, this.userName, string, 1, nArray, stringArray, null, nArray2, nArray3, nArray4, null, null, null, null, null, null, null, null, lArray);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    @Override
    void doAckJMSNtfn(ArrayList<JMSNotificationRegistration> arrayList, byte[][] byArray, short s2) throws SQLException {
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        try {
            long[] lArray = new long[arrayList.size()];
            String[] stringArray = new String[arrayList.size()];
            Iterator<JMSNotificationRegistration> iterator = arrayList.iterator();
            NTFJMSRegistration nTFJMSRegistration = null;
            int n2 = 0;
            while (iterator.hasNext()) {
                nTFJMSRegistration = (NTFJMSRegistration)iterator.next();
                lArray[n2] = nTFJMSRegistration.getJMSRegistrationId();
                stringArray[n2] = nTFJMSRegistration.getQueueName();
                ++n2;
            }
            String string = nTFJMSRegistration.getJMSConnectionId();
            this.kpdnrdeq.doOAQEMNDEQ(string, s2, byArray, lArray, stringArray);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    @Override
    synchronized NTFAQRegistration[] doRegisterAQNotification(String[] stringArray, String string, int n2, boolean bl, Properties[] propertiesArray) throws SQLException {
        int n3;
        int n4 = stringArray.length;
        int[] nArray = new int[n4];
        byte[][] byArrayArray = new byte[n4][];
        int[] nArray2 = new int[n4];
        int[] nArray3 = new int[n4];
        int[] nArray4 = new int[n4];
        int[] nArray5 = new int[n4];
        int[] nArray6 = new int[n4];
        int[] nArray7 = new int[n4];
        long[] lArray = new long[n4];
        byte[] byArray = new byte[n4];
        int[] nArray8 = new int[n4];
        byte[] byArray2 = new byte[n4];
        TIMESTAMPTZ[] tIMESTAMPTZArray = new TIMESTAMPTZ[n4];
        int[] nArray9 = new int[n4];
        boolean bl2 = false;
        if (n2 == 0) {
            bl2 = true;
            n2 = 47632;
        }
        for (int i2 = 0; i2 < n4; ++i2) {
            nArray[i2] = PhysicalConnection.ntfManager.getNextJdbcRegId();
            byArrayArray[i2] = new byte[4];
            byArrayArray[i2][0] = (byte)((nArray[i2] & 0xFF000000) >> 24);
            byArrayArray[i2][1] = (byte)((nArray[i2] & 0xFF0000) >> 16);
            byArrayArray[i2][2] = (byte)((nArray[i2] & 0xFF00) >> 8);
            byArrayArray[i2][3] = (byte)(nArray[i2] & 0xFF);
            nArray2[i2] = 1;
            nArray3[i2] = 23;
            if (propertiesArray.length <= i2 || propertiesArray[i2] == null) continue;
            if (propertiesArray[i2].getProperty("NTF_QOS_RELIABLE", "false").compareToIgnoreCase("true") == 0) {
                int n5 = i2;
                nArray4[n5] = nArray4[n5] | 1;
            }
            if (propertiesArray[i2].getProperty("NTF_QOS_PURGE_ON_NTFN", "false").compareToIgnoreCase("true") == 0) {
                int n6 = i2;
                nArray4[n6] = nArray4[n6] | 0x10;
            }
            if (propertiesArray[i2].getProperty("NTF_AQ_PAYLOAD", "false").compareToIgnoreCase("true") == 0) {
                int n7 = i2;
                nArray4[n7] = nArray4[n7] | 2;
            }
            nArray5[i2] = this.readNTFtimeout(propertiesArray[i2]);
        }
        this.setNtfGroupingOptions(byArray, nArray8, byArray2, tIMESTAMPTZArray, nArray9, propertiesArray);
        int[] nArray10 = new int[]{n2};
        Exception[] exceptionArray = new Exception[1];
        Properties properties = null;
        if (bl) {
            properties = ((NSProtocol)this.net).getSocketOptions();
        }
        boolean bl3 = PhysicalConnection.ntfManager.listenOnPortT4C(nArray10, bl2, properties, exceptionArray);
        n2 = nArray10[0];
        String string2 = "(ADDRESS=(PROTOCOL=" + (bl ? "tcps" : "tcp") + " )(HOST=" + string + ")(PORT=" + n2 + "))?PR=0";
        try {
            try {
                int n8 = bl3 ? 1 : 0;
                this.okpn.doOKPN(1, n8, this.userName, string2, n4, nArray2, stringArray, byArrayArray, nArray3, nArray4, nArray5, nArray6, nArray7, lArray, byArray, nArray8, byArray2, tIMESTAMPTZArray, nArray9, lArray);
            }
            catch (IOException iOException) {
                this.handleIOException(iOException);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
            }
        }
        catch (SQLException sQLException) {
            if (bl3) {
                PhysicalConnection.ntfManager.cleanListenersT4C(n2);
            }
            throw sQLException;
        }
        NTFAQRegistration[] nTFAQRegistrationArray = new NTFAQRegistration[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            nTFAQRegistrationArray[n3] = new NTFAQRegistration(nArray[n3], bl, true, this.instanceName, this.userName, string, n2, propertiesArray[n3], stringArray[n3], this.versionNumber, exceptionArray);
        }
        for (n3 = 0; n3 < nTFAQRegistrationArray.length; ++n3) {
            PhysicalConnection.ntfManager.addRegistration(nTFAQRegistrationArray[n3]);
        }
        return nTFAQRegistrationArray;
    }

    private void setNtfGroupingOptions(byte[] byArray, int[] nArray, byte[] byArray2, TIMESTAMPTZ[] tIMESTAMPTZArray, int[] nArray2, Properties[] propertiesArray) throws SQLException {
        for (int i2 = 0; i2 < propertiesArray.length; ++i2) {
            String string = propertiesArray[i2].getProperty("NTF_GROUPING_CLASS", "NTF_GROUPING_CLASS_NONE");
            String string2 = propertiesArray[i2].getProperty("NTF_GROUPING_VALUE");
            String string3 = propertiesArray[i2].getProperty("NTF_GROUPING_TYPE");
            TIMESTAMPTZ tIMESTAMPTZ = null;
            if (propertiesArray[i2].get("NTF_GROUPING_START_TIME") != null) {
                tIMESTAMPTZ = (TIMESTAMPTZ)propertiesArray[i2].get("NTF_GROUPING_START_TIME");
            }
            String string4 = propertiesArray[i2].getProperty("NTF_GROUPING_REPEAT_TIME", "NTF_GROUPING_REPEAT_FOREVER");
            if (string.compareTo("NTF_GROUPING_CLASS_TIME") != 0 && string.compareTo("NTF_GROUPING_CLASS_NONE") != 0) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            if (string.compareTo("NTF_GROUPING_CLASS_NONE") != 0 && this.getTTCVersion() < 5) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23).fillInStackTrace();
            }
            if (string.compareTo("NTF_GROUPING_CLASS_TIME") != 0) continue;
            byArray[i2] = 1;
            nArray[i2] = 600;
            if (string2 != null) {
                nArray[i2] = Integer.parseInt(string2);
            }
            byArray2[i2] = 1;
            if (string3 != null) {
                if (string3.compareTo("NTF_GROUPING_TYPE_SUMMARY") == 0) {
                    byArray2[i2] = 1;
                } else if (string3.compareTo("NTF_GROUPING_TYPE_LAST") == 0) {
                    byArray2[i2] = 2;
                } else {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
                }
            }
            tIMESTAMPTZArray[i2] = tIMESTAMPTZ;
            nArray2[i2] = string4.compareTo("NTF_GROUPING_REPEAT_FOREVER") == 0 ? 0 : Integer.parseInt(string4);
        }
    }

    @Override
    synchronized void doUnregisterAQNotification(NTFAQRegistration nTFAQRegistration) throws SQLException {
        String string = nTFAQRegistration.getClientHost();
        int n2 = nTFAQRegistration.getClientTCPPort();
        if (string == null) {
            return;
        }
        PhysicalConnection.ntfManager.removeRegistration(nTFAQRegistration);
        PhysicalConnection.ntfManager.freeJdbcRegId(nTFAQRegistration.getJdbcRegId());
        PhysicalConnection.ntfManager.cleanListenersT4C(nTFAQRegistration.getClientTCPPort());
        nTFAQRegistration.setState(NotificationRegistration.RegistrationState.CLOSED);
        String string2 = "(ADDRESS=(PROTOCOL=" + (nTFAQRegistration.getUseSSL() ? "tcps" : "tcp") + " )(HOST=" + string + ")(PORT=" + n2 + "))?PR=0";
        int[] nArray = new int[]{1};
        String[] stringArray = new String[]{nTFAQRegistration.getQueueName()};
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{0};
        int[] nArray4 = new int[]{0};
        int[] nArray5 = new int[]{0};
        int[] nArray6 = new int[]{0};
        long[] lArray = new long[]{0L};
        byte[] byArray = new byte[]{0};
        int[] nArray7 = new int[]{0};
        byte[] byArray2 = new byte[]{0};
        TIMESTAMPTZ[] tIMESTAMPTZArray = new TIMESTAMPTZ[]{null};
        int[] nArray8 = new int[]{0};
        byte[][] byArrayArray = new byte[1][];
        int n3 = nTFAQRegistration.getJdbcRegId();
        byArrayArray[0] = new byte[4];
        byArrayArray[0][0] = (byte)((n3 & 0xFF000000) >> 24);
        byArrayArray[0][1] = (byte)((n3 & 0xFF0000) >> 16);
        byArrayArray[0][2] = (byte)((n3 & 0xFF00) >> 8);
        byArrayArray[0][3] = (byte)(n3 & 0xFF);
        try {
            this.okpn.doOKPN(2, 0, this.userName, string2, 1, nArray, stringArray, byArrayArray, nArray2, nArray3, nArray4, nArray5, nArray6, lArray, byArray, nArray7, byArray2, tIMESTAMPTZArray, nArray8, lArray);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    synchronized long registerInbandNotification(int n2) throws SQLException {
        long l2 = 0L;
        int[] nArray = new int[]{2};
        String[] stringArray = new String[1];
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{0};
        int[] nArray4 = new int[]{0};
        int[] nArray5 = new int[]{128};
        int[] nArray6 = new int[]{n2};
        long[] lArray = new long[]{0L};
        int n3 = PhysicalConnection.ntfManager.getNextJdbcRegId();
        byte[][] byArrayArray = new byte[][]{new byte[4]};
        byArrayArray[0][0] = (byte)((n3 & 0xFF000000) >> 24);
        byArrayArray[0][1] = (byte)((n3 & 0xFF0000) >> 16);
        byArrayArray[0][2] = (byte)((n3 & 0xFF00) >> 8);
        byArrayArray[0][3] = (byte)(n3 & 0xFF);
        byte[] byArray = new byte[1];
        int[] nArray7 = new int[1];
        byte[] byArray2 = new byte[1];
        TIMESTAMPTZ[] tIMESTAMPTZArray = new TIMESTAMPTZ[1];
        int[] nArray8 = new int[1];
        try {
            boolean bl = false;
            this.okpn.doOKPN(1, 0, this.userName, "net8://?PR=0", 1, nArray, stringArray, byArrayArray, nArray2, nArray3, nArray4, nArray5, nArray6, lArray, byArray, nArray7, byArray2, tIMESTAMPTZArray, nArray8, lArray);
            l2 = this.okpn.getRegistrationId();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
        return l2;
    }

    @Override
    synchronized NTFDCNRegistration doRegisterDatabaseChangeNotification(String string, int n2, Properties properties, int n3, int n4) throws SQLException {
        ArrayList<String> arrayList;
        Object object;
        boolean bl = Boolean.parseBoolean(properties.getProperty("DCN_CLIENT_INIT_CONNECTION", "false"));
        String string2 = null;
        int n5 = 0;
        int n6 = 0;
        boolean bl2 = false;
        if (n2 == 0) {
            bl2 = true;
            n2 = 47632;
        }
        if (properties.getProperty("NTF_QOS_RELIABLE", "false").compareToIgnoreCase("true") == 0) {
            n6 |= 1;
        }
        if (properties.getProperty("NTF_QOS_PURGE_ON_NTFN", "false").compareToIgnoreCase("true") == 0) {
            n6 |= 0x10;
        }
        if (properties.getProperty("DCN_NOTIFY_ROWIDS", "false").compareToIgnoreCase("true") == 0) {
            n5 |= 0x10;
        }
        if (properties.getProperty("DCN_QUERY_CHANGE_NOTIFICATION", "false").compareToIgnoreCase("true") == 0) {
            n5 |= 0x20;
        }
        if (properties.getProperty("DCN_BEST_EFFORT", "false").compareToIgnoreCase("true") == 0) {
            n5 |= 0x40;
        }
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (properties.getProperty("DCN_IGNORE_INSERTOP", "false").compareToIgnoreCase("true") == 0) {
            bl3 = true;
        }
        if (properties.getProperty("DCN_IGNORE_UPDATEOP", "false").compareToIgnoreCase("true") == 0) {
            bl4 = true;
        }
        if (properties.getProperty("DCN_IGNORE_DELETEOP", "false").compareToIgnoreCase("true") == 0) {
            bl5 = true;
        }
        if (bl3 || bl4 || bl5) {
            n5 |= 0xF;
            if (bl3) {
                n5 -= 2;
            }
            if (bl4) {
                n5 -= 4;
            }
            if (bl5) {
                n5 -= 8;
            }
        }
        byte[] byArray = new byte[1];
        int[] nArray = new int[1];
        byte[] byArray2 = new byte[1];
        TIMESTAMPTZ[] tIMESTAMPTZArray = new TIMESTAMPTZ[1];
        int[] nArray2 = new int[1];
        Properties[] propertiesArray = new Properties[]{properties};
        this.setNtfGroupingOptions(byArray, nArray, byArray2, tIMESTAMPTZArray, nArray2, propertiesArray);
        int[] nArray3 = new int[]{n2};
        Exception[] exceptionArray = new Exception[1];
        boolean bl6 = false;
        int n7 = 1;
        String string3 = null;
        int n8 = 1;
        NTFDCNConnectionGroup nTFDCNConnectionGroup = null;
        if (bl) {
            n7 = 4;
            n6 |= 8;
            nTFDCNConnectionGroup = PhysicalConnection.ntfManager.getDCNConnectionGroup(this.userName + this.instanceName);
            object = nTFDCNConnectionGroup.getNTFDCNConnection();
            boolean bl7 = bl6 = object == null;
            if (!bl6) {
                string2 = string3 = ((NTFDCNConnection)object).getClientId();
            }
        } else {
            bl6 = PhysicalConnection.ntfManager.listenOnPortT4C(nArray3, bl2, null, exceptionArray);
            n2 = nArray3[0];
            if (!bl6) {
                n7 = 0;
            }
            string3 = "(ADDRESS=(PROTOCOL=tcp)(HOST=" + string + ")(PORT=" + n2 + "))?PR=0";
        }
        object = new int[]{2};
        String[] stringArray = new String[1];
        int[] nArray4 = new int[]{23};
        int[] nArray5 = new int[]{n6};
        int[] nArray6 = new int[]{n3};
        int[] nArray7 = new int[]{n5};
        int[] nArray8 = new int[]{n4};
        long[] lArray = new long[]{0L};
        int n9 = PhysicalConnection.ntfManager.getNextJdbcRegId();
        byte[][] byArrayArray = new byte[][]{new byte[4]};
        byArrayArray[0][0] = (byte)((n9 & 0xFF000000) >> 24);
        byArrayArray[0][1] = (byte)((n9 & 0xFF0000) >> 16);
        byArrayArray[0][2] = (byte)((n9 & 0xFF00) >> 8);
        byArrayArray[0][3] = (byte)(n9 & 0xFF);
        long l2 = 0L;
        try {
            try {
                this.okpn.doOKPN(1, n7, this.userName, string3, n8, (int[])object, stringArray, byArrayArray, nArray4, nArray5, nArray6, nArray7, nArray8, lArray, byArray, nArray, byArray2, tIMESTAMPTZArray, nArray2, lArray, null);
                l2 = this.okpn.getRegistrationId();
                if (bl && bl6) {
                    string2 = this.okpn.getJMSConnectionId();
                    if (string2 == null) {
                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 287, "clientID returned by server is null").fillInStackTrace();
                    }
                    arrayList = this.getListenerAddressForDCN(properties);
                    if (arrayList == null) {
                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 287, "listenerAddress returned by server is null").fillInStackTrace();
                    }
                    String string4 = this.net.getSessionAttributes().getcOption().service_name;
                    if (string4 == null) {
                        string4 = this.net.getSessionAttributes().getcOption().getOriginalConnOption().service_name;
                    }
                    if (string4 == null) {
                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 287, "No service name found, please use a service name format URL to create a connection").fillInStackTrace();
                    }
                    Properties properties2 = this.getConnectionPropsforListenerConnection();
                    nTFDCNConnectionGroup.startDCNListenerConnection(this.instanceName, string4, this.userName, this.password.get(), properties2, arrayList, string2, 1);
                }
            }
            catch (IOException iOException) {
                this.handleIOException(iOException);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
            }
        }
        catch (SQLException sQLException) {
            if (bl6 && !bl) {
                PhysicalConnection.ntfManager.cleanListenersT4C(n2);
            }
            throw sQLException;
        }
        arrayList = new NTFDCNRegistration(n9, true, this.dbName, l2, this.userName, string, n2, properties, this.versionNumber, exceptionArray, byArrayArray, string2, bl);
        PhysicalConnection.ntfManager.addDCNRegistration((NTFDCNRegistration)((Object)arrayList));
        return arrayList;
    }

    private ArrayList<String> getListenerAddressForDCN(Properties properties) {
        boolean bl = Boolean.parseBoolean(properties.getProperty("DCN_USE_HOST_CONNECTION_ADDR_INFO", "true"));
        NTAdapter nTAdapter = this.net.getSessionAttributes().getNTAdapter();
        if (bl && (nTAdapter.getNetworkAdapterType() == NTAdapter.NetworkAdapterType.TCP || nTAdapter.getNetworkAdapterType() == NTAdapter.NetworkAdapterType.TCPS)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(((TcpNTAdapter)nTAdapter).getAddressInfo());
            return arrayList;
        }
        return this.okpn.getListenerAddresses();
    }

    @Override
    synchronized void doUnregisterDatabaseChangeNotification(long l2, String string) throws SQLException {
        int[] nArray = new int[]{2};
        String[] stringArray = new String[1];
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{0};
        int[] nArray4 = new int[]{0};
        int[] nArray5 = new int[]{0};
        int[] nArray6 = new int[]{0};
        byte[] byArray = new byte[]{0};
        int[] nArray7 = new int[]{0};
        byte[] byArray2 = new byte[]{0};
        TIMESTAMPTZ[] tIMESTAMPTZArray = new TIMESTAMPTZ[]{null};
        int[] nArray8 = new int[]{0};
        long[] lArray = new long[]{l2};
        byte[][] byArrayArray = new byte[1][];
        try {
            this.okpn.doOKPN(2, 0, null, string, 1, nArray, stringArray, byArrayArray, nArray2, nArray3, nArray4, nArray5, nArray6, lArray, byArray, nArray7, byArray2, tIMESTAMPTZArray, nArray8, lArray);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    @Override
    synchronized void doUnregisterDatabaseChangeNotification(NTFDCNRegistration nTFDCNRegistration) throws SQLException {
        PhysicalConnection.ntfManager.removeRegistration(nTFDCNRegistration);
        PhysicalConnection.ntfManager.freeJdbcRegId(nTFDCNRegistration.getJdbcRegId());
        if (nTFDCNRegistration.isClientInitiated()) {
            NTFDCNConnectionGroup nTFDCNConnectionGroup = PhysicalConnection.ntfManager.getDCNConnectionGroup(this.userName + this.instanceName);
            nTFDCNConnectionGroup.stopNTFDCNConnection(nTFDCNRegistration.getClientId());
            this.doUnregisterClientInitiatedDCN(nTFDCNRegistration);
        } else {
            PhysicalConnection.ntfManager.cleanListenersT4C(nTFDCNRegistration.getClientTCPPort());
            nTFDCNRegistration.setState(NotificationRegistration.RegistrationState.CLOSED);
            this.doUnregisterDatabaseChangeNotification(nTFDCNRegistration.getRegId(), "(ADDRESS=(PROTOCOL=tcp)(HOST=" + nTFDCNRegistration.getClientHost() + ")(PORT=" + nTFDCNRegistration.getClientTCPPort() + "))?PR=0");
        }
    }

    private synchronized void doUnregisterClientInitiatedDCN(NTFDCNRegistration nTFDCNRegistration) throws SQLException {
        try {
            int[] nArray = new int[]{0};
            byte[] byArray = new byte[]{0};
            TIMESTAMPTZ[] tIMESTAMPTZArray = new TIMESTAMPTZ[]{null};
            long[] lArray = new long[]{nTFDCNRegistration.getRegId()};
            this.okpn.doOKPN(2, 4, this.userName, nTFDCNRegistration.getClientId(), 1, new int[]{2}, new String[1], nTFDCNRegistration.getContext(), nArray, nArray, nArray, nArray, nArray, lArray, byArray, nArray, byArray, tIMESTAMPTZArray, nArray, lArray);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    @Override
    public String getDataIntegrityAlgorithmName() throws SQLException {
        return this.net.getDataIntegrityName();
    }

    @Override
    public String getEncryptionAlgorithmName() throws SQLException {
        return this.net.getEncryptionName();
    }

    @Override
    public String getAuthenticationAdaptorName() throws SQLException {
        return this.net.getAuthenticationAdaptorName();
    }

    @Override
    void validateConnectionProperties() throws SQLException {
        super.validateConnectionProperties();
        String string = ".*[\\00\\(\\)].*";
        if (this.thinVsessionOsuser != null && (this.thinVsessionOsuser.matches(string) || this.thinVsessionOsuser.length() > 30)) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'v$session.osuser' and value is '" + this.thinVsessionOsuser + "'").fillInStackTrace();
        }
        if (this.thinVsessionTerminal != null && (this.thinVsessionTerminal.matches(string) || this.thinVsessionTerminal.length() > 30)) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'v$session.terminal' and value is '" + this.thinVsessionTerminal + "'").fillInStackTrace();
        }
        if (this.thinVsessionMachine != null && (this.thinVsessionMachine.matches(string) || this.thinVsessionMachine.length() > 64)) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'v$session.machine' and value is '" + this.thinVsessionMachine + "'").fillInStackTrace();
        }
        if (this.thinVsessionProgram != null && (this.thinVsessionProgram.matches(string) || this.thinVsessionProgram.length() > 48)) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'v$session.program' and value is '" + this.thinVsessionProgram + "'").fillInStackTrace();
        }
        if (this.thinVsessionProcess != null && (this.thinVsessionProcess.matches(string) || this.thinVsessionProcess.length() > 24)) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'v$session.process' and value is '" + this.thinVsessionProcess + "'").fillInStackTrace();
        }
        if (this.thinVsessionIname != null && this.thinVsessionIname.matches(string)) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'v$session.iname' and value is '" + this.thinVsessionIname + "'").fillInStackTrace();
        }
        if (this.thinVsessionEname != null && this.thinVsessionEname.matches(string)) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'v$session.ename' and value is '" + this.thinVsessionEname + "'").fillInStackTrace();
        }
        if (!(this.networkCompression.equals("off") || this.networkCompression.equals("on") || this.networkCompression.equals("auto"))) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'oracle.net.networkCompression' and value is '" + this.networkCompression + "'").fillInStackTrace();
        }
        if (this.networkCompressionThreshold < 200) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'oracle.net.networkCompressionThreshold' and value is '" + this.networkCompressionThreshold + "'").fillInStackTrace();
        }
        if (!this.networkCompressionLevels.equalsIgnoreCase("(high)")) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'oracle.net.networkCompressionLevels' and value is '" + this.networkCompressionLevels + "'. Only (high) is supported.").fillInStackTrace();
        }
        if (this.thinUseJCEAPI) {
            this.thinUseJCEAPI = isUnlimitedCryptoAvailable;
        }
    }

    @Override
    public synchronized byte[] createLightweightSession(String string, KeywordValueLong[] keywordValueLongArray, int n2, KeywordValueLong[][] keywordValueLongArray2, int[] nArray) throws SQLException {
        if (keywordValueLongArray2.length != 1 || nArray.length != 1) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        byte[] byArray = null;
        try {
            this.oxsscs.doOXSSCS(string, keywordValueLongArray, n2);
            byArray = this.oxsscs.getSessionId();
            keywordValueLongArray2[0] = this.oxsscs.getOutKV();
            nArray[0] = this.oxsscs.getOutFlags();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
        return byArray;
    }

    private synchronized void doXSNamespaceOp(OracleConnection.XSOperationCode xSOperationCode, byte[] byArray, XSNamespace[] xSNamespaceArray, XSNamespace[][] xSNamespaceArray2, XSSecureId xSSecureId, boolean bl) throws SQLException {
        XSNamespace[] xSNamespaceArray3 = null;
        try {
            this.xsnsop2.doOXSNS(xSOperationCode, byArray, xSNamespaceArray, xSSecureId, bl);
            if (bl) {
                xSNamespaceArray3 = this.xsnsop2.getNamespaces();
            }
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
        if (xSNamespaceArray2 != null && xSNamespaceArray2.length > 0) {
            xSNamespaceArray2[0] = xSNamespaceArray3;
        }
    }

    @Override
    public synchronized void doXSSessionDetachOp(int n2, byte[] byArray, XSSecureId xSSecureId, boolean bl) throws SQLException {
        try {
            this.oxsdet.doOXSDET(n2, byArray, xSSecureId, bl);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    @Override
    public void doXSNamespaceOp(OracleConnection.XSOperationCode xSOperationCode, byte[] byArray, XSNamespace[] xSNamespaceArray, XSNamespace[][] xSNamespaceArray2, XSSecureId xSSecureId) throws SQLException {
        this.doXSNamespaceOp(xSOperationCode, byArray, xSNamespaceArray, xSNamespaceArray2, xSSecureId, true);
    }

    @Override
    public void doXSNamespaceOp(OracleConnection.XSOperationCode xSOperationCode, byte[] byArray, XSNamespace[] xSNamespaceArray, XSSecureId xSSecureId) throws SQLException {
        this.doXSNamespaceOp(xSOperationCode, byArray, xSNamespaceArray, null, xSSecureId, false);
    }

    @Override
    public synchronized byte[] doXSSessionCreateOp(OracleConnection.XSSessionOperationCode xSSessionOperationCode, XSSecureId xSSecureId, byte[] byArray, XSPrincipal xSPrincipal, String string, XSNamespace[] xSNamespaceArray, OracleConnection.XSSessionModeFlag xSSessionModeFlag, XSKeyval xSKeyval) throws SQLException {
        byte[] byArray2 = null;
        try {
            this.oxscre.doOXSCRE(xSSessionOperationCode, xSSecureId, byArray, xSPrincipal, string, xSNamespaceArray, xSSessionModeFlag, xSKeyval);
            byArray2 = this.oxscre.getSessionId();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
        return byArray2;
    }

    @Override
    public synchronized void doXSSessionDestroyOp(byte[] byArray, XSSecureId xSSecureId, byte[] byArray2) throws SQLException {
        try {
            this.oxsdes.doOXSDES(byArray, xSSecureId, byArray2);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    @Override
    public synchronized void doXSSessionAttachOp(int n2, byte[] byArray, XSSecureId xSSecureId, byte[] byArray2, XSPrincipal xSPrincipal, String[] stringArray, String[] stringArray2, String[] stringArray3, XSNamespace[] xSNamespaceArray, XSNamespace[] xSNamespaceArray2, XSNamespace[] xSNamespaceArray3, TIMESTAMPTZ tIMESTAMPTZ, TIMESTAMPTZ tIMESTAMPTZ2, int n3, long l2, XSKeyval xSKeyval, int[] nArray) throws SQLException {
        try {
            this.oxsatt.doOXSATT(n2, byArray, xSSecureId, byArray2, xSPrincipal, stringArray, stringArray2, stringArray3, xSNamespaceArray, xSNamespaceArray2, xSNamespaceArray3, tIMESTAMPTZ, tIMESTAMPTZ2, n3, l2, xSKeyval, nArray);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    @Override
    public synchronized void doXSSessionChangeOp(OracleConnection.XSSessionSetOperationCode xSSessionSetOperationCode, byte[] byArray, XSSecureId xSSecureId, XSSessionParameters xSSessionParameters) throws SQLException {
        try {
            this.oxsset.doOXSSET(xSSessionSetOperationCode, byArray, xSSecureId, (XSSessionParametersI)xSSessionParameters);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLogicalTransactionIdEventListener(LogicalTransactionIdEventListener logicalTransactionIdEventListener, Executor executor) throws SQLException {
        if (this.lifecycle != 1) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8).fillInStackTrace();
        }
        NTFEventListener nTFEventListener = new NTFEventListener(logicalTransactionIdEventListener);
        nTFEventListener.setExecutor(executor);
        NTFEventListener[] nTFEventListenerArray = this.ltxidListeners;
        synchronized (this.ltxidListeners) {
            int n2 = this.ltxidListeners.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.ltxidListeners[i2].getLogicalTransactionIdEventListener() != logicalTransactionIdEventListener) continue;
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 248).fillInStackTrace();
            }
            NTFEventListener[] nTFEventListenerArray2 = new NTFEventListener[n2 + 1];
            System.arraycopy(this.ltxidListeners, 0, nTFEventListenerArray2, 0, n2);
            nTFEventListenerArray2[n2] = nTFEventListener;
            this.ltxidListeners = nTFEventListenerArray2;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void addLogicalTransactionIdEventListener(LogicalTransactionIdEventListener logicalTransactionIdEventListener) throws SQLException {
        this.addLogicalTransactionIdEventListener(logicalTransactionIdEventListener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLogicalTransactionIdEventListener(LogicalTransactionIdEventListener logicalTransactionIdEventListener) throws SQLException {
        NTFEventListener[] nTFEventListenerArray = this.ltxidListeners;
        synchronized (this.ltxidListeners) {
            int n2 = 0;
            int n3 = this.ltxidListeners.length;
            for (n2 = 0; n2 < n3 && this.ltxidListeners[n2].getLogicalTransactionIdEventListener() != logicalTransactionIdEventListener; ++n2) {
            }
            if (n2 == n3) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 249).fillInStackTrace();
            }
            NTFEventListener[] nTFEventListenerArray2 = new NTFEventListener[n3 - 1];
            int n4 = 0;
            for (n2 = 0; n2 < n3; ++n2) {
                if (this.ltxidListeners[n2].getLogicalTransactionIdEventListener() == logicalTransactionIdEventListener) continue;
                nTFEventListenerArray2[n4++] = this.ltxidListeners[n2];
            }
            this.ltxidListeners = nTFEventListenerArray2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public LogicalTransactionId getLogicalTransactionId() throws SQLException {
        return this.thinACCurrentLTXID;
    }

    boolean notify(final NTFLTXIDEvent nTFLTXIDEvent) {
        boolean bl = false;
        if (this.ltxidListeners != null) {
            NTFEventListener[] nTFEventListenerArray = this.ltxidListeners;
            int n2 = nTFEventListenerArray.length;
            if (n2 > 0) {
                bl = true;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                Executor executor = nTFEventListenerArray[i2].getExecutor();
                if (executor != null) {
                    final LogicalTransactionIdEventListener logicalTransactionIdEventListener = nTFEventListenerArray[i2].getLogicalTransactionIdEventListener();
                    executor.execute(new Runnable(){
                        private static Executable $$$methodRef$$$0;
                        private static Logger $$$loggerRef$$$0;
                        private static Executable $$$methodRef$$$1;
                        private static Logger $$$loggerRef$$$1;

                        @Override
                        public void run() {
                            logicalTransactionIdEventListener.onLogicalTransactionIdEvent(nTFLTXIDEvent);
                        }

                        static {
                            try {
                                $$$methodRef$$$1 = 1.class.getDeclaredConstructor(T4CConnection.class, LogicalTransactionIdEventListener.class, NTFLTXIDEvent.class);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                            try {
                                $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                        }
                    });
                    continue;
                }
                nTFEventListenerArray[i2].getLogicalTransactionIdEventListener().onLogicalTransactionIdEvent(nTFLTXIDEvent);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addXSEventListener(XSEventListener xSEventListener, Executor executor) throws SQLException {
        if (this.lifecycle != 1) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8).fillInStackTrace();
        }
        NTFEventListener nTFEventListener = new NTFEventListener(xSEventListener);
        nTFEventListener.setExecutor(executor);
        NTFEventListener[] nTFEventListenerArray = this.xsListeners;
        synchronized (this.xsListeners) {
            int n2 = this.xsListeners.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.xsListeners[i2].getXSEventListener() != xSEventListener) continue;
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 248).fillInStackTrace();
            }
            NTFEventListener[] nTFEventListenerArray2 = new NTFEventListener[n2 + 1];
            System.arraycopy(this.xsListeners, 0, nTFEventListenerArray2, 0, n2);
            nTFEventListenerArray2[n2] = nTFEventListener;
            this.xsListeners = nTFEventListenerArray2;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void addXSEventListener(XSEventListener xSEventListener) throws SQLException {
        this.addXSEventListener(xSEventListener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeXSEventListener(XSEventListener xSEventListener) throws SQLException {
        NTFEventListener[] nTFEventListenerArray = this.xsListeners;
        synchronized (this.xsListeners) {
            int n2 = 0;
            int n3 = this.xsListeners.length;
            for (n2 = 0; n2 < n3 && this.xsListeners[n2].getXSEventListener() != xSEventListener; ++n2) {
            }
            if (n2 == n3) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 249).fillInStackTrace();
            }
            NTFEventListener[] nTFEventListenerArray2 = new NTFEventListener[n3 - 1];
            int n4 = 0;
            for (n2 = 0; n2 < n3; ++n2) {
                if (this.xsListeners[n2].getXSEventListener() == xSEventListener) continue;
                nTFEventListenerArray2[n4++] = this.xsListeners[n2];
            }
            this.xsListeners = nTFEventListenerArray2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllXSEventListener() throws SQLException {
        NTFEventListener[] nTFEventListenerArray = this.xsListeners;
        synchronized (this.xsListeners) {
            NTFEventListener[] nTFEventListenerArray2 = new NTFEventListener[]{};
            this.xsListeners = nTFEventListenerArray2;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    void notify(final NTFXSEvent nTFXSEvent) {
        NTFEventListener[] nTFEventListenerArray = this.xsListeners;
        int n2 = nTFEventListenerArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Executor executor = nTFEventListenerArray[i2].getExecutor();
            if (executor != null) {
                final XSEventListener xSEventListener = nTFEventListenerArray[i2].getXSEventListener();
                executor.execute(new Runnable(){
                    private static Executable $$$methodRef$$$0;
                    private static Logger $$$loggerRef$$$0;
                    private static Executable $$$methodRef$$$1;
                    private static Logger $$$loggerRef$$$1;

                    @Override
                    public void run() {
                        xSEventListener.onXSEvent(nTFXSEvent);
                    }

                    static {
                        try {
                            $$$methodRef$$$1 = 2.class.getDeclaredConstructor(T4CConnection.class, XSEventListener.class, NTFXSEvent.class);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                        try {
                            $$$methodRef$$$0 = 2.class.getDeclaredMethod("run", new Class[0]);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    }
                });
                continue;
            }
            nTFEventListenerArray[i2].getXSEventListener().onXSEvent(nTFXSEvent);
        }
    }

    final boolean hasServerCompileTimeCapability(int n2, int n3) {
        boolean bl = false;
        if (this.serverCompileTimeCapabilities != null && this.serverCompileTimeCapabilities.length > n2 && (this.serverCompileTimeCapabilities[n2] & n3) != 0) {
            bl = true;
        }
        return bl;
    }

    final byte getServerCompileTimeCapability(int n2) {
        byte by = this.serverCompileTimeCapabilities == null || this.serverCompileTimeCapabilities.length <= n2 ? (byte)0 : this.serverCompileTimeCapabilities[n2];
        return by;
    }

    @Override
    long doGetCurrentSCN() throws SQLException {
        return this.outScn;
    }

    @Override
    EnumSet<OracleConnection.TransactionState> doGetTransactionState() throws SQLException {
        EnumSet<OracleConnection.TransactionState> enumSet = EnumSet.noneOf(OracleConnection.TransactionState.class);
        if ((this.eocs & 1) != 0) {
            enumSet.add(OracleConnection.TransactionState.TRANSACTION_READONLY);
        }
        if ((this.eocs & 2) != 0) {
            enumSet.add(OracleConnection.TransactionState.TRANSACTION_STARTED);
        }
        if ((this.eocs & 4) != 0) {
            enumSet.add(OracleConnection.TransactionState.TRANSACTION_ENDED);
        }
        if ((this.eocs & 0x400) != 0) {
            enumSet.add(OracleConnection.TransactionState.TRANSACTION_INTENTION);
        }
        return enumSet;
    }

    @Override
    public boolean isConnectionSocketKeepAlive() throws SocketException {
        return this.net.isConnectionSocketKeepAlive();
    }

    @Override
    public int getEOC() throws SQLException {
        return this.eocs;
    }

    @Override
    public synchronized void setReplayOperations(EnumSet<OracleConnection.ReplayOperation> enumSet) throws SQLException {
        if (this.osessstateFlags == OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_END.getCode() && enumSet.size() == 0) {
            return;
        }
        if (this.osessstateFlags != OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_END.getCode()) {
            this.osessstateFlags = 0L;
        }
        Iterator iterator = enumSet.iterator();
        while (iterator.hasNext()) {
            this.osessstateFlags |= ((OracleConnection.ReplayOperation)((Object)iterator.next())).getCode();
        }
        if ((this.osessstateFlags & OracleConnection.ReplayOperation.KPDSS_SESSSTATE_APPCONT_ENABLED.getCode()) != 0L) {
            this.replayModes.add(ReplayMode.RUNTIME_REPLAY_ENABLED);
        } else {
            this.replayModes.remove((Object)ReplayMode.RUNTIME_REPLAY_ENABLED);
        }
        if ((this.osessstateFlags & OracleConnection.ReplayOperation.KPDSS_SESSSTATE_STATIC.getCode()) != 0L) {
            this.replayModes.add(ReplayMode.RUNTIME_OR_REPLAYING_STATIC);
        } else {
            this.replayModes.remove((Object)ReplayMode.RUNTIME_OR_REPLAYING_STATIC);
        }
    }

    @Override
    public synchronized void setReplayingMode(boolean bl) throws SQLException {
        if (bl) {
            this.replayModes.remove((Object)ReplayMode.RUNTIME_REPLAY_ENABLED);
            this.replayModes.add(ReplayMode.REPLAYING);
        } else {
            this.replayModes.remove((Object)ReplayMode.REPLAYING);
        }
    }

    @Override
    public synchronized void beginNonRequestCalls() throws SQLException {
        this.replayModes.add(ReplayMode.NONREQUEST);
    }

    @Override
    public synchronized void endNonRequestCalls() throws SQLException {
        this.replayModes.remove((Object)ReplayMode.NONREQUEST);
    }

    @Override
    public synchronized void setReplayContext(oracle.jdbc.internal.ReplayContext[] replayContextArray) throws SQLException {
        if (replayContextArray != null) {
            this.oappcontreplayContextsArr = replayContextArray;
            this.oappcontreplayOffset = 0;
        }
    }

    @Override
    public synchronized oracle.jdbc.internal.ReplayContext[] getReplayContext() throws SQLException {
        if (this.thinACReplayContextReceivedCurrent == 0) {
            return null;
        }
        oracle.jdbc.internal.ReplayContext[] replayContextArray = new oracle.jdbc.internal.ReplayContext[this.thinACReplayContextReceivedCurrent];
        System.arraycopy(this.thinACReplayContextReceived, 0, replayContextArray, 0, this.thinACReplayContextReceivedCurrent);
        this.thinACReplayContextReceivedCurrent = 0;
        return replayContextArray;
    }

    @Override
    public oracle.jdbc.internal.ReplayContext getLastReplayContext() throws SQLException {
        return this.thinACLastReplayContextReceived;
    }

    @Override
    public void setLastReplayContext(oracle.jdbc.internal.ReplayContext replayContext) throws SQLException {
        this.thinACLastReplayContextReceived = (ReplayContext)replayContext;
    }

    @Override
    public void registerEndReplayCallback(OracleConnection.EndReplayCallback endReplayCallback) throws SQLException {
        this.endReplayCallback = endReplayCallback;
    }

    @Override
    public byte[] getDerivedKeyInternal(byte[] byArray, int n2) throws NoSuchAlgorithmException, InvalidKeySpecException, SQLException {
        return this.auth.getDerivedKeyJdbc(byArray, n2);
    }

    @Override
    synchronized void releaseConnectionToPool() throws SQLException {
        block6: {
            if (this.drcpState == OracleConnection.DRCPState.DETACHED) {
                return;
            }
            this.closeStatements(true, false);
            this.releasedSessID = this.getSessionId();
            this.releasedSerial = this.getSerialNumber();
            try {
                if (this.currentlyInTransaction) {
                    this.osessrls.setTTCCode((byte)3);
                    this.osessrls.doRPC();
                } else {
                    this.osessrls.setTTCCode((byte)26);
                    this.osessrls.doOneWayRPC();
                }
                this.drcpState = OracleConnection.DRCPState.DETACHED;
            }
            catch (IOException iOException) {
                this.handleIOException(iOException);
            }
            catch (SQLException sQLException) {
                if (!this.currentlyInTransaction) break block6;
                throw sQLException;
            }
        }
    }

    @Override
    synchronized boolean reusePooledConnection() throws SQLException {
        if (this.drcpState == OracleConnection.DRCPState.DETACHED) {
            try {
                if (this.drcpTagName == null) {
                    return true;
                }
                this.osessget.doRPC();
                this.drcpState = OracleConnection.DRCPState.ATTACHED_EXPLICIT;
            }
            catch (IOException iOException) {
                this.handleIOException(iOException);
            }
        }
        if (this.getTTCVersion() >= 8) {
            return this.osessget.returnTag != null && !T4CConnection.bit(this.osessget.sessgetflags, 1L);
        }
        return !T4CConnection.bit(this.osessget.sessgetflags, 1L);
    }

    @Override
    public boolean isDRCPMultitagEnabled() throws SQLException {
        return this.drcpEnabled && this.useDRCPMultipletag;
    }

    @Override
    public String getDRCPReturnTag() throws SQLException {
        return this.osessget.returnTag;
    }

    @Override
    public boolean needToPurgeStatementCache() throws SQLException {
        if (this.lifecycle != 1) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8).fillInStackTrace();
        }
        if (!this.drcpEnabled) {
            return false;
        }
        return T4CConnection.bit(this.ocsessret.sessretflags, 4L) || T4CConnection.bit(this.ocsessret.sessretflags, 8L) || this.getSessionId() != this.releasedSessID || this.getSerialNumber() != this.releasedSerial;
    }

    @Override
    void resetAfterReusePooledConnection() throws SQLException {
        OracleStatement oracleStatement;
        if (!this.drcpEnabled) {
            return;
        }
        if (this.isPDBChanged && (oracleStatement = this.getExecutingStatement()) == null) {
            this.onPDBChange(null);
            this.isPDBChanged = false;
        }
        if (this.needToPurgeStatementCache()) {
            this.clearCursorIds();
        }
        this.drcpState = OracleConnection.DRCPState.ATTACHED_IMPLICIT;
    }

    protected void clearCursorIds() {
        this.cleanStatementCache();
        OracleStatement oracleStatement = this.statements;
        while (oracleStatement != null) {
            if (!oracleStatement.serverCursor) {
                oracleStatement.clearCursorId();
            }
            oracleStatement = oracleStatement.next;
        }
        this.cursorToClose = new int[4];
        this.cursorToCloseOffset = 0;
        this.lastCursorToCloseOffset = 0;
    }

    protected boolean canSendCursorIds() {
        boolean bl = true;
        if (this.drcpEnabled && this.drcpState == OracleConnection.DRCPState.DETACHED) {
            bl = false;
        }
        return bl;
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        if (this.net == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8).fillInStackTrace();
        }
        try {
            return this.net.getSocketReadTimeout();
        }
        catch (NetException netException) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), netException).fillInStackTrace();
        }
        catch (IOException iOException) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    @Override
    protected void doSetNetworkTimeout(int n2) throws SQLException {
        if (this.net == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8).fillInStackTrace();
        }
        try {
            this.net.setSocketReadTimeout(n2);
        }
        catch (NetException netException) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), netException).fillInStackTrace();
        }
        catch (IOException iOException) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    static final String dumpObject(Object object, String string) {
        return T4CConnection.dumpObject(object, string, new StringBuilder());
    }

    static final String dumpObject(Object object, String string, StringBuilder stringBuilder) {
        Class<?> clazz = object.getClass();
        Field[] fieldArray = clazz.getDeclaredFields();
        stringBuilder.append(string + clazz.getName() + " { \n");
        for (Field field : fieldArray) {
            if ((field.getModifiers() & 8) != 0) continue;
            field.setAccessible(true);
            try {
                stringBuilder.append(string + "  " + field.getName() + " = ");
                Object object2 = field.get(object);
                if (object2 == null) {
                    stringBuilder.append("null");
                } else {
                    stringBuilder.append(object2);
                }
                stringBuilder.append("\n");
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        stringBuilder.append(string + "}\n");
        return stringBuilder.toString();
    }

    byte getNextSeqNumber() {
        if (this.currentTTCSeqNumber == 127) {
            this.currentTTCSeqNumber = 1;
            return this.currentTTCSeqNumber;
        }
        this.currentTTCSeqNumber = (byte)(this.currentTTCSeqNumber + 1);
        return this.currentTTCSeqNumber;
    }

    @Override
    public int getNegotiatedSDU() throws SQLException {
        try {
            return this.net.getNegotiatedSDU();
        }
        catch (NetException netException) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), netException).fillInStackTrace();
        }
    }

    @Override
    public byte getNegotiatedTTCVersion() throws SQLException {
        return this.negotiatedTTCversion;
    }

    @Override
    String getAuditBanner() throws SQLException {
        if (this.lifecycle != 1) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8).fillInStackTrace();
        }
        String string = this.sessionProperties.getProperty("AUTH_AUDIT_BANNER");
        return string;
    }

    @Override
    String getAccessBanner() throws SQLException {
        if (this.lifecycle != 1) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8).fillInStackTrace();
        }
        String string = this.net.getAccessBanner();
        return string;
    }

    @Override
    ResultSetCache getResultSetCacheInternal() throws SQLException {
        return this.resultSetCache;
    }

    @Override
    ArrayList<Long> getResultSetCacheLocalInvalidations() {
        return this.resultSetCacheLocalInvalidations;
    }

    @Override
    public oracle.jdbc.internal.ResultSetCache getResultSetCache() throws SQLException {
        return this.resultSetCache;
    }

    final boolean isResultSetCacheActive() {
        return this.isResultSetCacheEnabled && this.resultSetCache != null && this.resultSetCache.getState() == ResultSetCache.ResultSetCacheState.STARTED;
    }

    @Override
    public boolean isServerBigSCN() throws SQLException {
        return this.isServerBigSCN;
    }

    final long getResultSetCacheVisibleSCN() {
        return this.resultSetCache.getVisibleSCN();
    }

    final void setResultSetCacheVisibleSCN(long l2) {
        this.resultSetCache.setVisibleSCN(l2);
    }

    final byte[] getResultSetCacheId() {
        return this.resultSetCache.getCacheId();
    }

    final byte[] getResultSetCacheIdAsNibbles() {
        return this.resultSetCache.getCacheIdAsNibbles();
    }

    final long getResultSetCacheRegistrationId() {
        return this.resultSetCache.getRegistrationId();
    }

    @Override
    public synchronized void setChunkInfo(OracleShardingKey oracleShardingKey, OracleShardingKey oracleShardingKey2, String string) throws SQLException {
        if (oracleShardingKey != null) {
            this.shardingKey = ((OracleShardingKeyImpl)oracleShardingKey).encodeKeyinB64Format();
        }
        if (oracleShardingKey2 != null) {
            this.superShardingKey = ((OracleShardingKeyImpl)oracleShardingKey2).encodeKeyinB64Format();
        }
        if (string != null) {
            this.chunkName = string;
        }
    }

    @Override
    public synchronized void setShardingKey(OracleShardingKey oracleShardingKey, OracleShardingKey oracleShardingKey2) throws SQLException {
        try {
            String string = null;
            String string2 = null;
            if (oracleShardingKey != null) {
                string = ((OracleShardingKeyImpl)oracleShardingKey).encodeKeyinB64Format();
            }
            if (oracleShardingKey2 != null) {
                string2 = ((OracleShardingKeyImpl)oracleShardingKey2).encodeKeyinB64Format();
            }
            this.ochunkinfo.doOCHUNKINFO(string, string2, null, false);
        }
        catch (IOException iOException) {
            throw (SQLException)DatabaseError.createSqlException(iOException).fillInStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean setShardingKeyIfValid(OracleShardingKey oracleShardingKey, OracleShardingKey oracleShardingKey2, int n2) throws SQLException {
        boolean bl;
        block30: {
            if (n2 < 0) {
                throw new SQLException("isValid timeout cannot be negative.");
            }
            if (this.lifecycle != 1) {
                return false;
            }
            int n3 = -1;
            int n4 = n2 * 1000;
            bl = false;
            try {
                n3 = this.net.getSocketReadTimeout();
                if (n4 > 0 && (n4 < n3 || n3 == 0)) {
                    this.net.setSocketReadTimeout(n4);
                }
                String string = null;
                String string2 = null;
                if (oracleShardingKey == null) {
                    throw new IllegalArgumentException("Shard key argument cannot be null");
                }
                string = ((OracleShardingKeyImpl)oracleShardingKey).encodeKeyinB64Format();
                if (oracleShardingKey2 != null) {
                    string2 = ((OracleShardingKeyImpl)oracleShardingKey2).encodeKeyinB64Format();
                }
                this.ochunkinfo.doOCHUNKINFO(string, string2, null, false);
                bl = true;
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() == 45582) {
                    bl = false;
                    break block30;
                }
                throw sQLException;
            }
            catch (SocketTimeoutException socketTimeoutException) {
                bl = false;
            }
            catch (InterruptedIOException interruptedIOException) {
                this.handleIOException(interruptedIOException);
                bl = false;
            }
            catch (IOException iOException) {
                bl = false;
            }
            finally {
                try {
                    if (n3 >= 0) {
                        this.net.setSocketReadTimeout(n3);
                    }
                }
                catch (IOException iOException) {
                    bl = false;
                }
            }
        }
        return bl;
    }

    @Override
    public synchronized void setShardingKey(OracleShardingKey oracleShardingKey) throws SQLException {
        this.setShardingKey(oracleShardingKey, (OracleShardingKey)null);
    }

    @Override
    public synchronized boolean setShardingKeyIfValid(OracleShardingKey oracleShardingKey, int n2) throws SQLException {
        return this.setShardingKeyIfValid(oracleShardingKey, (OracleShardingKey)null, n2);
    }

    private OracleStatement getExecutingStatement() {
        if (this.getExecutingRPCFunctionCode() != 94) {
            return null;
        }
        return this.all8.oracleStatement;
    }

    @Override
    public NetStat getNetworkStat() {
        return this.net.getNetworkStat();
    }

    @Override
    public boolean isNetworkCompressionEnabled() {
        return this.net.isNetworkCompressionEnabled();
    }

    @Override
    public void beginRequest() throws SQLException {
        if (this.svrSupportsRequests) {
            this.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_BEGIN));
        }
        super.beginRequest();
    }

    @Override
    public void endRequest(boolean bl) throws SQLException {
        if (this.net != null) {
            this.net.cancelTimeout();
        }
        if (this.svrSupportsRequests) {
            this.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_END));
        }
        super.endRequest(bl);
    }

    @Override
    public boolean hasNoOpenHandles() throws SQLException {
        block9: {
            if (!this.enableImplicitRequests) {
                return false;
            }
            int n2 = this.getTxnMode();
            if (n2 == 1) {
                return false;
            }
            EnumSet<OracleConnection.TransactionState> enumSet = this.getTransactionState();
            if (enumSet.contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED)) {
                return false;
            }
            if (this.statements == null) break block9;
            OracleStatement oracleStatement = this.statements;
            while (oracleStatement != null) {
                block11: {
                    block10: {
                        if (oracleStatement.cacheState == 3) break block10;
                        if (oracleStatement.cacheState != 1) break block11;
                    }
                    return false;
                }
                oracleStatement = oracleStatement.next;
            }
        }
        if (this.lobCount.get() > 0L) {
            return false;
        }
        if (this.bfileCount.get() > 0L) {
            return false;
        }
        return true;
    }

    @Override
    public oracle.jdbc.internal.DatabaseSessionState getDatabaseSessionState() {
        return this.sessionState.copy();
    }

    @Override
    public void setDatabaseSessionState(oracle.jdbc.internal.DatabaseSessionState databaseSessionState) {
        this.sessionStateOut = (DatabaseSessionState)databaseSessionState;
    }

    final void updateSessionState(StateSignatures stateSignatures, TemplateOverflow templateOverflow) {
        if (this.sessionState == null) {
            this.sessionState = new DatabaseSessionState();
        }
        this.sessionState.update(stateSignatures, templateOverflow);
    }

    @Override
    public void addLargeObject(OracleLargeObject oracleLargeObject) throws SQLException {
        this.lobCount.incrementAndGet();
    }

    @Override
    public void removeLargeObject(OracleLargeObject oracleLargeObject) throws SQLException {
        this.lobCount.decrementAndGet();
    }

    @Override
    public void addBfile(OracleBfile oracleBfile) throws SQLException {
        this.bfileCount.incrementAndGet();
    }

    @Override
    public void removeBfile(OracleBfile oracleBfile) throws SQLException {
        this.bfileCount.decrementAndGet();
    }

    void enterMarshalling() throws NetException {
        if (!this.net.getSessionAttributes().isConnected()) {
            throw new NetException(200);
        }
        if (this.writeBufferIsDirty) {
            this.mare.clearWriteBuffer();
        }
        this.writeBufferIsDirty = true;
    }

    void exitMarshalling() {
        this.writeBufferIsDirty = false;
    }

    @Override
    public String getEncryptionProviderName() throws SQLException {
        if (this.net.getSessionAttributes().isEncryptionActive) {
            return this.net.getSessionAttributes().ano.getEncryptionProvider();
        }
        return null;
    }

    @Override
    public String getChecksumProviderName() throws SQLException {
        if (this.net.getSessionAttributes().isChecksumActive) {
            return this.net.getSessionAttributes().ano.getChecksumProvider();
        }
        return null;
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    @Blind
    private AccessToken getAccessToken(Supplier<? extends AccessToken> supplier) throws SQLException {
        String string;
        if (this.isSepsCredentials || this.userName == null && (this.password == null || this.password.isNull())) {
            AccessToken accessToken;
            if (supplier != null) {
                return this.getSuppliedAccessToken(supplier);
            }
            if (this.accessToken != null && !this.accessToken.isNull()) {
                char[] cArray = this.accessToken.get().toCharArray();
                try {
                    AccessToken accessToken2 = AccessToken.createJsonWebToken(cArray);
                    return accessToken2;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 25707, "The invalid token was configured by connection property oracle.jdbc.accessToken. See cause for more details.", (Throwable)illegalArgumentException).fillInStackTrace();
                }
                finally {
                    Arrays.fill(cArray, '\u0000');
                }
            }
            string = this.net.getSessionAttributes().getNetProperty("oracle.jdbc.tokenAuthentication");
            if (string == null) {
                string = this.tokenAuthentication;
            }
            if (string != null && (accessToken = this.getAccessTokenFromFile(string)) != null) {
                return accessToken;
            }
        }
        if (this.userName != null || this.password != null && !this.password.isNull()) {
            string = this.net.getSessionAttributes().getNetProperty("oracle.jdbc.passwordAuthentication");
            if (string == null) {
                string = this.passwordAuthentication;
            }
            if ("PASSWORD_VERIFIER".equals(string)) {
                return null;
            }
            if ("OCI_TOKEN".equals(string)) {
                return this.getAccessTokenFromIam();
            }
            throw (SQLException)DatabaseError.formatSqlException(this.getConnectionDuringExceptionHandling(), 1721, null, null, string, "oracle.jdbc.passwordAuthentication").fillInStackTrace();
        }
        return null;
    }

    @Blind
    private AccessToken getAccessTokenFromIam() throws SQLException {
        Properties properties;
        String string;
        SessionAtts sessionAtts = this.net.getSessionAttributes();
        String string2 = sessionAtts.getNetProperty("oracle.jdbc.ociIamUrl");
        if (string2 == null && (string2 = this.ociIamUrl) == null) {
            throw (SQLException)DatabaseError.formatSqlException(this.getConnectionDuringExceptionHandling(), 1722, "This property must be set when oracle.jdbc.passwordAuthentication=OCI_TOKEN", null, "oracle.jdbc.ociIamUrl").fillInStackTrace();
        }
        String string3 = sessionAtts.getNetProperty("oracle.jdbc.ociTenancy");
        if (string3 == null && (string3 = this.ociTenancy) == null) {
            throw (SQLException)DatabaseError.formatSqlException(this.getConnectionDuringExceptionHandling(), 1722, "This property must be set when oracle.jdbc.passwordAuthentication=OCI_TOKEN", null, "oracle.jdbc.ociTenancy").fillInStackTrace();
        }
        String string4 = sessionAtts.getNetProperty("oracle.jdbc.ociCompartment");
        if (string4 == null) {
            string4 = this.ociCompartment;
        }
        if ((string = sessionAtts.getNetProperty("oracle.jdbc.ociDatabase")) == null) {
            string = this.ociDatabase;
        }
        if (string != null && string4 == null) {
            throw (SQLException)DatabaseError.formatSqlException(this.getConnectionDuringExceptionHandling(), 1722, "This property must be set when oracle.jdbc.ociDatabase is set.", null, "oracle.jdbc.ociCompartment").fillInStackTrace();
        }
        if (this.userName == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1718, "A user name must be provided when connection property oracle.jdbc.passwordAuthentication=OCI_TOKEN").fillInStackTrace();
        }
        if (this.password == null || this.password.isNull()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1718, "A password must be provided when connection property oracle.jdbc.passwordAuthentication=OCI_TOKEN").fillInStackTrace();
        }
        try {
            properties = this.net.getSessionAttributes().getNTAdapter().getSqlNetOptions();
            properties.put((Object)41, "true");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1718, "Unsupported network transport type: " + (Object)((Object)this.net.getSessionAttributes().getNTAdapter().getNetworkAdapterType()), (Throwable)unsupportedOperationException);
        }
        try {
            return JsonWebToken.requestBuilder().endPoint(string2).tenancy(string3).compartment(string4).database(string).user(this.userName).password(this.password).sqlNetOptions(properties).build();
        }
        catch (IOException iOException) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1718, "Failed to authenticate with IAM endpoint: " + string2 + ", with tenant OCID: " + string3 + (string4 == null ? "" : ", with compartment OCID: " + string4) + (string == null ? "" : ", with database OCID: " + string) + ". See cause for more details.", (Throwable)iOException).fillInStackTrace();
        }
    }

    @Blind
    private AccessToken getSuppliedAccessToken(Supplier<? extends AccessToken> supplier) throws SQLException {
        try {
            AccessToken accessToken = supplier.get();
            if (accessToken != null) {
                return accessToken;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1718, "A null value was output by the Supplier configured with  OracleDataSource.setTokenSupplier(Supplier)").fillInStackTrace();
        }
        catch (RuntimeException runtimeException) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1718, "An exception was thrown by the Supplier configured with  OracleDataSource.setTokenSupplier(Supplier). See cause for more details.", (Throwable)runtimeException).fillInStackTrace();
        }
    }

    @Blind
    private AccessToken getAccessTokenFromFile(String string) throws SQLException {
        Path path;
        boolean bl = "OCI_TOKEN".equals(string);
        if (!bl && !"OAUTH".equals(string)) {
            throw (SQLException)DatabaseError.formatSqlException(this.getConnectionDuringExceptionHandling(), 1721, null, null, string, "oracle.jdbc.tokenAuthentication").fillInStackTrace();
        }
        SessionAtts sessionAtts = this.net.getSessionAttributes();
        String string2 = this.net.getSessionAttributes().getNetProperty("oracle.jdbc.tokenLocation");
        if (string2 == null) {
            string2 = this.tokenLocation;
        }
        if (string2 != null) {
            path = Paths.get(string2, new String[0]);
        } else if (bl) {
            String string3 = GeneratedPhysicalConnection.getSystemPropertyUserHome(null);
            if (string3 == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), "System property \"user.home\" is not set. The default token location can not be resolved", 1718).fillInStackTrace();
            }
            path = Paths.get(string3, ".oci", "db-token");
        } else {
            throw (SQLException)DatabaseError.formatSqlException(this.getConnectionDuringExceptionHandling(), 1722, "This property must be set when oracle.jdbc.tokenAuthentication=" + string, null, "oracle.jdbc.tokenLocation").fillInStackTrace();
        }
        try {
            return bl ? JsonWebToken.fromOciFile(path) : JsonWebToken.fromFile(path);
        }
        catch (IOException iOException) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1718, "Connection property oracle.jdbc.tokenLocation locates a token file or private key file that can not be read. See cause for more details.", (Throwable)iOException).fillInStackTrace();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1718, "Connection property oracle.jdbc.tokenLocation locates a private key file that can not be read. See cause for more details.", (Throwable)generalSecurityException).fillInStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 25707, "An invalid token was configured by connection property oracle.jdbc.tokenLocation. See cause for more details.", (Throwable)illegalArgumentException).fillInStackTrace();
        }
    }

    boolean isTLSEnabled() {
        return this.net != null && this.net.isTLSEnabled();
    }

    boolean isDnMatchingEnabled() {
        return this.net != null && this.net.isDnMatchingEnabled();
    }

    private Properties getConnectionPropsforListenerConnection() {
        Properties properties = new Properties();
        if (this.thinNetAuthenticationServices != null) {
            properties.setProperty("oracle.net.authentication_services", this.thinNetAuthenticationServices);
        }
        if (this.thinNetAuthenticationKrb5Mutual != null) {
            properties.setProperty("oracle.net.kerberos5_mutual_authentication", this.thinNetAuthenticationKrb5Mutual);
        }
        if (this.thinNetAuthenticationKrb5CcName != null) {
            properties.setProperty("oracle.net.kerberos5_cc_name", this.thinNetAuthenticationKrb5CcName);
        }
        if (this.walletLocation != null) {
            properties.setProperty("oracle.net.wallet_location", this.walletLocation);
        }
        if (this.walletPassword != null) {
            properties.setProperty("oracle.net.wallet_password", this.walletPassword);
        }
        if (this.tnsAdmin != null) {
            properties.setProperty("oracle.net.tns_admin", this.tnsAdmin);
        }
        if (this.thinJavaxNetSslTruststore != null) {
            properties.setProperty("javax.net.ssl.trustStore", this.thinJavaxNetSslTruststore);
        }
        if (this.thinJavaxNetSslTruststoretype != null) {
            properties.setProperty("javax.net.ssl.trustStoreType", this.thinJavaxNetSslTruststoretype);
        }
        if (this.thinJavaxNetSslTruststorepassword != null) {
            properties.setProperty("javax.net.ssl.trustStorePassword", this.thinJavaxNetSslTruststorepassword);
        }
        if (this.thinJavaxNetSslKeystore != null) {
            properties.setProperty("javax.net.ssl.keyStore", this.thinJavaxNetSslKeystore);
        }
        if (this.thinJavaxNetSslKeystoretype != null) {
            properties.setProperty("javax.net.ssl.keyStoreType", this.thinJavaxNetSslKeystoretype);
        }
        if (this.thinJavaxNetSslKeystorepassword != null) {
            properties.setProperty("javax.net.ssl.keyStorePassword", this.thinJavaxNetSslKeystorepassword);
        }
        return properties;
    }

    static {
        try {
            $$$methodRef$$$270 = T4CConnection.class.getDeclaredConstructor(String.class, Properties.class, OracleDriverExtension.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$270 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$269 = T4CConnection.class.getDeclaredMethod("getConnectionPropsforListenerConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$269 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$268 = T4CConnection.class.getDeclaredMethod("isDnMatchingEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$268 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$267 = T4CConnection.class.getDeclaredMethod("isTLSEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$267 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$266 = T4CConnection.class.getDeclaredMethod("getAccessTokenFromFile", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$266 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$265 = T4CConnection.class.getDeclaredMethod("getSuppliedAccessToken", Supplier.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$265 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$264 = T4CConnection.class.getDeclaredMethod("getAccessTokenFromIam", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$264 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$263 = T4CConnection.class.getDeclaredMethod("getAccessToken", Supplier.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$263 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$262 = T4CConnection.class.getDeclaredMethod("getChecksumProviderName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$262 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$261 = T4CConnection.class.getDeclaredMethod("getEncryptionProviderName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$261 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$260 = T4CConnection.class.getDeclaredMethod("exitMarshalling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$260 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$259 = T4CConnection.class.getDeclaredMethod("enterMarshalling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$259 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$258 = T4CConnection.class.getDeclaredMethod("removeBfile", OracleBfile.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$258 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$257 = T4CConnection.class.getDeclaredMethod("addBfile", OracleBfile.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$257 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$256 = T4CConnection.class.getDeclaredMethod("removeLargeObject", OracleLargeObject.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$256 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$255 = T4CConnection.class.getDeclaredMethod("addLargeObject", OracleLargeObject.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$255 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$254 = T4CConnection.class.getDeclaredMethod("updateSessionState", StateSignatures.class, TemplateOverflow.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$254 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$253 = T4CConnection.class.getDeclaredMethod("setDatabaseSessionState", oracle.jdbc.internal.DatabaseSessionState.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$253 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$252 = T4CConnection.class.getDeclaredMethod("getDatabaseSessionState", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$252 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$251 = T4CConnection.class.getDeclaredMethod("hasNoOpenHandles", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$251 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$250 = T4CConnection.class.getDeclaredMethod("endRequest", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$250 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$249 = T4CConnection.class.getDeclaredMethod("beginRequest", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$249 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$248 = T4CConnection.class.getDeclaredMethod("isNetworkCompressionEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$248 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$247 = T4CConnection.class.getDeclaredMethod("getNetworkStat", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$247 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$246 = T4CConnection.class.getDeclaredMethod("getExecutingStatement", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$246 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$245 = T4CConnection.class.getDeclaredMethod("setShardingKeyIfValid", OracleShardingKey.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$245 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$244 = T4CConnection.class.getDeclaredMethod("setShardingKey", OracleShardingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$244 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$243 = T4CConnection.class.getDeclaredMethod("setShardingKeyIfValid", OracleShardingKey.class, OracleShardingKey.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$243 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$242 = T4CConnection.class.getDeclaredMethod("setShardingKey", OracleShardingKey.class, OracleShardingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$242 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$241 = T4CConnection.class.getDeclaredMethod("setChunkInfo", OracleShardingKey.class, OracleShardingKey.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$241 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$240 = T4CConnection.class.getDeclaredMethod("getResultSetCacheRegistrationId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$240 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$239 = T4CConnection.class.getDeclaredMethod("getResultSetCacheIdAsNibbles", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$239 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$238 = T4CConnection.class.getDeclaredMethod("getResultSetCacheId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$238 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$237 = T4CConnection.class.getDeclaredMethod("setResultSetCacheVisibleSCN", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$237 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$236 = T4CConnection.class.getDeclaredMethod("getResultSetCacheVisibleSCN", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$236 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$235 = T4CConnection.class.getDeclaredMethod("isServerBigSCN", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$235 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$234 = T4CConnection.class.getDeclaredMethod("isResultSetCacheActive", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$234 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$233 = T4CConnection.class.getDeclaredMethod("getResultSetCache", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$233 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$232 = T4CConnection.class.getDeclaredMethod("getResultSetCacheLocalInvalidations", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$232 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$231 = T4CConnection.class.getDeclaredMethod("getResultSetCacheInternal", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$231 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$230 = T4CConnection.class.getDeclaredMethod("getAccessBanner", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$230 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$229 = T4CConnection.class.getDeclaredMethod("getAuditBanner", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$229 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$228 = T4CConnection.class.getDeclaredMethod("getNegotiatedTTCVersion", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$228 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$227 = T4CConnection.class.getDeclaredMethod("getNegotiatedSDU", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$227 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$226 = T4CConnection.class.getDeclaredMethod("getNextSeqNumber", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$226 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$225 = T4CConnection.class.getDeclaredMethod("dumpObject", Object.class, String.class, StringBuilder.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$225 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$224 = T4CConnection.class.getDeclaredMethod("dumpObject", Object.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$224 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$223 = T4CConnection.class.getDeclaredMethod("doSetNetworkTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$223 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$222 = T4CConnection.class.getDeclaredMethod("getNetworkTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$222 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$221 = T4CConnection.class.getDeclaredMethod("canSendCursorIds", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$221 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$220 = T4CConnection.class.getDeclaredMethod("clearCursorIds", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$220 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$219 = T4CConnection.class.getDeclaredMethod("resetAfterReusePooledConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$219 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$218 = T4CConnection.class.getDeclaredMethod("needToPurgeStatementCache", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$218 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$217 = T4CConnection.class.getDeclaredMethod("getDRCPReturnTag", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$217 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$216 = T4CConnection.class.getDeclaredMethod("isDRCPMultitagEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$216 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$215 = T4CConnection.class.getDeclaredMethod("reusePooledConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$215 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$214 = T4CConnection.class.getDeclaredMethod("releaseConnectionToPool", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$214 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$213 = T4CConnection.class.getDeclaredMethod("getDerivedKeyInternal", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$213 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$212 = T4CConnection.class.getDeclaredMethod("registerEndReplayCallback", OracleConnection.EndReplayCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$212 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$211 = T4CConnection.class.getDeclaredMethod("setLastReplayContext", oracle.jdbc.internal.ReplayContext.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$211 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$210 = T4CConnection.class.getDeclaredMethod("getLastReplayContext", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$210 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$209 = T4CConnection.class.getDeclaredMethod("getReplayContext", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$209 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$208 = T4CConnection.class.getDeclaredMethod("setReplayContext", oracle.jdbc.internal.ReplayContext[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$208 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$207 = T4CConnection.class.getDeclaredMethod("endNonRequestCalls", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$207 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$206 = T4CConnection.class.getDeclaredMethod("beginNonRequestCalls", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$206 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$205 = T4CConnection.class.getDeclaredMethod("setReplayingMode", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$205 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$204 = T4CConnection.class.getDeclaredMethod("setReplayOperations", EnumSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$204 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$203 = T4CConnection.class.getDeclaredMethod("getEOC", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$203 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$202 = T4CConnection.class.getDeclaredMethod("isConnectionSocketKeepAlive", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$202 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$201 = T4CConnection.class.getDeclaredMethod("doGetTransactionState", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$201 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$200 = T4CConnection.class.getDeclaredMethod("doGetCurrentSCN", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$200 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$199 = T4CConnection.class.getDeclaredMethod("getServerCompileTimeCapability", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$199 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$198 = T4CConnection.class.getDeclaredMethod("hasServerCompileTimeCapability", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$198 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$197 = T4CConnection.class.getDeclaredMethod("notify", NTFXSEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$197 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$196 = T4CConnection.class.getDeclaredMethod("removeAllXSEventListener", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$196 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$195 = T4CConnection.class.getDeclaredMethod("removeXSEventListener", XSEventListener.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$195 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$194 = T4CConnection.class.getDeclaredMethod("addXSEventListener", XSEventListener.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$194 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$193 = T4CConnection.class.getDeclaredMethod("addXSEventListener", XSEventListener.class, Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$193 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$192 = T4CConnection.class.getDeclaredMethod("notify", NTFLTXIDEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$192 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$191 = T4CConnection.class.getDeclaredMethod("getLogicalTransactionId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$191 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$190 = T4CConnection.class.getDeclaredMethod("removeLogicalTransactionIdEventListener", LogicalTransactionIdEventListener.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$190 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$189 = T4CConnection.class.getDeclaredMethod("addLogicalTransactionIdEventListener", LogicalTransactionIdEventListener.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$189 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$188 = T4CConnection.class.getDeclaredMethod("addLogicalTransactionIdEventListener", LogicalTransactionIdEventListener.class, Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$188 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$187 = T4CConnection.class.getDeclaredMethod("doXSSessionChangeOp", OracleConnection.XSSessionSetOperationCode.class, byte[].class, XSSecureId.class, XSSessionParameters.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$187 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$186 = T4CConnection.class.getDeclaredMethod("doXSSessionAttachOp", Integer.TYPE, byte[].class, XSSecureId.class, byte[].class, XSPrincipal.class, String[].class, String[].class, String[].class, XSNamespace[].class, XSNamespace[].class, XSNamespace[].class, TIMESTAMPTZ.class, TIMESTAMPTZ.class, Integer.TYPE, Long.TYPE, XSKeyval.class, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$186 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$185 = T4CConnection.class.getDeclaredMethod("doXSSessionDestroyOp", byte[].class, XSSecureId.class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$185 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$184 = T4CConnection.class.getDeclaredMethod("doXSSessionCreateOp", OracleConnection.XSSessionOperationCode.class, XSSecureId.class, byte[].class, XSPrincipal.class, String.class, XSNamespace[].class, OracleConnection.XSSessionModeFlag.class, XSKeyval.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$184 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$183 = T4CConnection.class.getDeclaredMethod("doXSNamespaceOp", OracleConnection.XSOperationCode.class, byte[].class, XSNamespace[].class, XSSecureId.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$183 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$182 = T4CConnection.class.getDeclaredMethod("doXSNamespaceOp", OracleConnection.XSOperationCode.class, byte[].class, XSNamespace[].class, XSNamespace[][].class, XSSecureId.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$182 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$181 = T4CConnection.class.getDeclaredMethod("doXSSessionDetachOp", Integer.TYPE, byte[].class, XSSecureId.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$181 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$180 = T4CConnection.class.getDeclaredMethod("doXSNamespaceOp", OracleConnection.XSOperationCode.class, byte[].class, XSNamespace[].class, XSNamespace[][].class, XSSecureId.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$180 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$179 = T4CConnection.class.getDeclaredMethod("createLightweightSession", String.class, KeywordValueLong[].class, Integer.TYPE, KeywordValueLong[][].class, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$179 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$178 = T4CConnection.class.getDeclaredMethod("validateConnectionProperties", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$178 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$177 = T4CConnection.class.getDeclaredMethod("getAuthenticationAdaptorName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$177 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$176 = T4CConnection.class.getDeclaredMethod("getEncryptionAlgorithmName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$176 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$175 = T4CConnection.class.getDeclaredMethod("getDataIntegrityAlgorithmName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$175 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$174 = T4CConnection.class.getDeclaredMethod("doUnregisterClientInitiatedDCN", NTFDCNRegistration.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$174 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$173 = T4CConnection.class.getDeclaredMethod("doUnregisterDatabaseChangeNotification", NTFDCNRegistration.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$173 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$172 = T4CConnection.class.getDeclaredMethod("doUnregisterDatabaseChangeNotification", Long.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$172 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$171 = T4CConnection.class.getDeclaredMethod("getListenerAddressForDCN", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$171 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$170 = T4CConnection.class.getDeclaredMethod("doRegisterDatabaseChangeNotification", String.class, Integer.TYPE, Properties.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$170 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$169 = T4CConnection.class.getDeclaredMethod("registerInbandNotification", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$169 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$168 = T4CConnection.class.getDeclaredMethod("doUnregisterAQNotification", NTFAQRegistration.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$168 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$167 = T4CConnection.class.getDeclaredMethod("setNtfGroupingOptions", byte[].class, int[].class, byte[].class, TIMESTAMPTZ[].class, int[].class, Properties[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$167 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$166 = T4CConnection.class.getDeclaredMethod("doRegisterAQNotification", String[].class, String.class, Integer.TYPE, Boolean.TYPE, Properties[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$166 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$165 = T4CConnection.class.getDeclaredMethod("doAckJMSNtfn", ArrayList.class, byte[][].class, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$165 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$164 = T4CConnection.class.getDeclaredMethod("doUnregisterJMSNotification", NTFJMSRegistration.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$164 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$163 = T4CConnection.class.getDeclaredMethod("startOrStopJMSNotification", NTFJMSRegistration.class, JMSNotificationRegistration.Directive.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$163 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$162 = T4CConnection.class.getDeclaredMethod("doStopJMSNotification", NTFJMSRegistration.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$162 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$161 = T4CConnection.class.getDeclaredMethod("doStartJMSNotification", NTFJMSRegistration.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$161 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$160 = T4CConnection.class.getDeclaredMethod("doRegisterJMSNotification", String[].class, Map.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$160 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$159 = T4CConnection.class.getDeclaredMethod("drainOnInbandNotification", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$159 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$158 = T4CConnection.class.getDeclaredMethod("setNeedsToBeClosed", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$158 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$157 = T4CConnection.class.getDeclaredMethod("isValidLight", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$157 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$156 = T4CConnection.class.getDeclaredMethod("doPingDatabase", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$156 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$155 = T4CConnection.class.getDeclaredMethod("doJmsDequeue", String.class, JMSDequeueOptions.class, AQMessagePropertiesI.class, JMSMessagePropertiesI.class, byte[].class, byte[][].class, byte[][].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$155 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$154 = T4CConnection.class.getDeclaredMethod("doJmsDequeue", String.class, JMSDequeueOptions.class, AQMessagePropertiesI.class, JMSMessagePropertiesI.class, byte[].class, OutputStream.class, byte[][].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$154 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$153 = T4CConnection.class.getDeclaredMethod("doJMSEnqueue", String.class, JMSEnqueueOptions.class, AQMessagePropertiesI.class, JMSMessageProperties.class, byte[].class, InputStream.class, byte[][].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$153 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$152 = T4CConnection.class.getDeclaredMethod("doJMSEnqueue", String.class, JMSEnqueueOptions.class, AQMessagePropertiesI.class, JMSMessageProperties.class, byte[].class, byte[].class, byte[][].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$152 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$151 = T4CConnection.class.getDeclaredMethod("doDequeue", String.class, AQDequeueOptions.class, AQMessagePropertiesI.class, byte[].class, Integer.TYPE, byte[][].class, byte[][].class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$151 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$150 = T4CConnection.class.getDeclaredMethod("doEnqueue", String.class, AQEnqueueOptions.class, AQMessagePropertiesI.class, byte[].class, Integer.TYPE, byte[].class, byte[][].class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$150 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$149 = T4CConnection.class.getDeclaredMethod("getPasswordInternal", T4CXAResource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$149 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$148 = T4CConnection.class.getDeclaredMethod("getPropertyForPooledConnection", OraclePooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$148 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$147 = T4CConnection.class.getDeclaredMethod("doClearAllApplicationContext", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$147 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$146 = T4CConnection.class.getDeclaredMethod("doSetApplicationContext", String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$146 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$145 = T4CConnection.class.getDeclaredMethod("doDescribeTable", AutoKeyInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$145 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$144 = T4CConnection.class.getDeclaredMethod("doAbort", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$144 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$143 = T4CConnection.class.getDeclaredMethod("internalClose", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$143 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$142 = T4CConnection.class.getDeclaredMethod("assertNotNull", byte[].class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$142 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$141 = T4CConnection.class.getDeclaredMethod("isLoggedOn", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$141 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$140 = T4CConnection.class.getDeclaredMethod("assertLoggedOn", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$140 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$139 = T4CConnection.class.getDeclaredMethod("newWriter", OracleClob.class, Integer.TYPE, Long.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$139 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$138 = T4CConnection.class.getDeclaredMethod("newWriter", CLOB.class, Integer.TYPE, Long.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$138 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$137 = T4CConnection.class.getDeclaredMethod("newReader", OracleClob.class, Integer.TYPE, Long.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$137 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$136 = T4CConnection.class.getDeclaredMethod("newReader", CLOB.class, Integer.TYPE, Long.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$136 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$135 = T4CConnection.class.getDeclaredMethod("newReader", OracleClob.class, Integer.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$135 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$134 = T4CConnection.class.getDeclaredMethod("newReader", CLOB.class, Integer.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$134 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$133 = T4CConnection.class.getDeclaredMethod("newOutputStream", OracleClob.class, Integer.TYPE, Long.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$133 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$132 = T4CConnection.class.getDeclaredMethod("newOutputStream", CLOB.class, Integer.TYPE, Long.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$132 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$131 = T4CConnection.class.getDeclaredMethod("newInputStream", OracleClob.class, Integer.TYPE, Long.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$131 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$130 = T4CConnection.class.getDeclaredMethod("newInputStream", OracleClob.class, Integer.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$130 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$129 = T4CConnection.class.getDeclaredMethod("newInputStream", CLOB.class, Integer.TYPE, Long.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$129 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$128 = T4CConnection.class.getDeclaredMethod("newInputStream", CLOB.class, Integer.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$128 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$127 = T4CConnection.class.getDeclaredMethod("isOpen", OracleClob.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$127 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$126 = T4CConnection.class.getDeclaredMethod("close", OracleClob.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$126 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$125 = T4CConnection.class.getDeclaredMethod("open", OracleClob.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$125 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$124 = T4CConnection.class.getDeclaredMethod("getDuration", OracleClob.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$124 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$123 = T4CConnection.class.getDeclaredMethod("isTemporary", OracleClob.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$123 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$122 = T4CConnection.class.getDeclaredMethod("freeTemporary", OracleClob.class, Datum.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$122 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$121 = T4CConnection.class.getDeclaredMethod("createTemporaryClob", Connection.class, Boolean.TYPE, Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$121 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$120 = T4CConnection.class.getDeclaredMethod("trim", OracleClob.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$120 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$119 = T4CConnection.class.getDeclaredMethod("getChunkSize", OracleClob.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$119 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$118 = T4CConnection.class.getDeclaredMethod("putChars", OracleClob.class, Long.TYPE, char[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$118 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$117 = T4CConnection.class.getDeclaredMethod("copyPrefetchedClobChars", OracleClob.class, Long.TYPE, Integer.TYPE, char[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$117 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$116 = T4CConnection.class.getDeclaredMethod("getChars", OracleClob.class, Long.TYPE, Integer.TYPE, char[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$116 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$115 = T4CConnection.class.getDeclaredMethod("position", OracleClob.class, OracleClob.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$115 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$114 = T4CConnection.class.getDeclaredMethod("position", OracleClob.class, String.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$114 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$113 = T4CConnection.class.getDeclaredMethod("length", OracleClob.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$113 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$112 = T4CConnection.class.getDeclaredMethod("newConversionReader", OracleBlob.class, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$112 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$111 = T4CConnection.class.getDeclaredMethod("newConversionReader", OracleBlob.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$111 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$110 = T4CConnection.class.getDeclaredMethod("newConversionReader", BLOB.class, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$110 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$109 = T4CConnection.class.getDeclaredMethod("newConversionReader", BLOB.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$109 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$108 = T4CConnection.class.getDeclaredMethod("newConversionInputStream", OracleBlob.class, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$108 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$107 = T4CConnection.class.getDeclaredMethod("newConversionInputStream", OracleBlob.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$107 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$106 = T4CConnection.class.getDeclaredMethod("newConversionInputStream", BLOB.class, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$106 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$105 = T4CConnection.class.getDeclaredMethod("newConversionInputStream", BLOB.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$105 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$104 = T4CConnection.class.getDeclaredMethod("newOutputStream", OracleBlob.class, Integer.TYPE, Long.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$104 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$103 = T4CConnection.class.getDeclaredMethod("newOutputStream", BLOB.class, Integer.TYPE, Long.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$103 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$102 = T4CConnection.class.getDeclaredMethod("newInputStream", OracleBlob.class, Integer.TYPE, Long.TYPE, Long.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$102 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$101 = T4CConnection.class.getDeclaredMethod("newInputStream", OracleBlob.class, Integer.TYPE, Long.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$101 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$100 = T4CConnection.class.getDeclaredMethod("newInputStream", BLOB.class, Integer.TYPE, Long.TYPE, Long.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$100 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$99 = T4CConnection.class.getDeclaredMethod("newInputStream", BLOB.class, Integer.TYPE, Long.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$99 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$98 = T4CConnection.class.getDeclaredMethod("newInputStream", OracleBlob.class, Integer.TYPE, Long.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$98 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$97 = T4CConnection.class.getDeclaredMethod("newInputStream", OracleBlob.class, Integer.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$97 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$96 = T4CConnection.class.getDeclaredMethod("newInputStream", BLOB.class, Integer.TYPE, Long.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$96 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$95 = T4CConnection.class.getDeclaredMethod("newInputStream", BLOB.class, Integer.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$95 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$94 = T4CConnection.class.getDeclaredMethod("isOpen", OracleBlob.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$94 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$93 = T4CConnection.class.getDeclaredMethod("close", OracleBlob.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$93 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$92 = T4CConnection.class.getDeclaredMethod("open", OracleBlob.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$92 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$91 = T4CConnection.class.getDeclaredMethod("getDuration", OracleBlob.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$91 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$90 = T4CConnection.class.getDeclaredMethod("isTemporary", OracleBlob.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$90 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$89 = T4CConnection.class.getDeclaredMethod("freeTemporary", OracleBlob.class, Datum.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$89 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$88 = T4CConnection.class.getDeclaredMethod("incrementTempLobReferenceCount", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$88 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$87 = T4CConnection.class.getDeclaredMethod("decrementTempLobReferenceCount", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$87 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$86 = T4CConnection.class.getDeclaredMethod("getLocatorHash", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$86 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$85 = T4CConnection.class.getDeclaredMethod("createTemporaryBlob", Connection.class, Boolean.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$85 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$84 = T4CConnection.class.getDeclaredMethod("trim", OracleBlob.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$84 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$83 = T4CConnection.class.getDeclaredMethod("getChunkSize", OracleBlob.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$83 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$82 = T4CConnection.class.getDeclaredMethod("putBytes", OracleBlob.class, Long.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$82 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$81 = T4CConnection.class.getDeclaredMethod("copyPrefetchedBlobBytes", OracleBlob.class, Long.TYPE, Integer.TYPE, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$81 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$80 = T4CConnection.class.getDeclaredMethod("getBytes", OracleBlob.class, Long.TYPE, Integer.TYPE, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$80 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$79 = T4CConnection.class.getDeclaredMethod("position", OracleBlob.class, Datum.class, Datum.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$79 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$78 = T4CConnection.class.getDeclaredMethod("position", OracleBlob.class, Datum.class, byte[].class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$78 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$77 = T4CConnection.class.getDeclaredMethod("length", OracleBlob.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$77 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$76 = T4CConnection.class.getDeclaredMethod("newConversionReader", OracleBfile.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$76 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$75 = T4CConnection.class.getDeclaredMethod("newConversionReader", BFILE.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$75 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$74 = T4CConnection.class.getDeclaredMethod("newConversionInputStream", OracleBfile.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$74 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$73 = T4CConnection.class.getDeclaredMethod("newConversionInputStream", BFILE.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$73 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$72 = T4CConnection.class.getDeclaredMethod("newInputStream", OracleBfile.class, Integer.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$72 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$71 = T4CConnection.class.getDeclaredMethod("newInputStream", BFILE.class, Integer.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$71 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$70 = T4CConnection.class.getDeclaredMethod("isOpen", OracleBfile.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$70 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$69 = T4CConnection.class.getDeclaredMethod("close", OracleBfile.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$69 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$68 = T4CConnection.class.getDeclaredMethod("open", OracleBfile.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$68 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$67 = T4CConnection.class.getDeclaredMethod("closeFile", OracleBfile.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$67 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$66 = T4CConnection.class.getDeclaredMethod("fileExists", OracleBfile.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$66 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$65 = T4CConnection.class.getDeclaredMethod("isFileOpen", OracleBfile.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$65 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$64 = T4CConnection.class.getDeclaredMethod("openFile", OracleBfile.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$64 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$63 = T4CConnection.class.getDeclaredMethod("getDirAlias", OracleBfile.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$63 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$62 = T4CConnection.class.getDeclaredMethod("getName", OracleBfile.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$62 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$61 = T4CConnection.class.getDeclaredMethod("getBytes", OracleBfile.class, Long.TYPE, Integer.TYPE, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$61 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$60 = T4CConnection.class.getDeclaredMethod("position", OracleBfile.class, Datum.class, Datum.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$60 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$59 = T4CConnection.class.getDeclaredMethod("position", OracleBfile.class, Datum.class, byte[].class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$59 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$58 = T4CConnection.class.getDeclaredMethod("length", OracleBfile.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$58 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$57 = T4CConnection.class.getDeclaredMethod("createBfileDBAccess", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$56 = T4CConnection.class.getDeclaredMethod("createClobDBAccess", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$55 = T4CConnection.class.getDeclaredMethod("createBlobDBAccess", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$54 = T4CConnection.class.getDeclaredMethod("getInstanceProperty", OracleConnection.InstanceProperty.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$53 = T4CConnection.class.getDeclaredMethod("getSerialNumber", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$52 = T4CConnection.class.getDeclaredMethod("getSessionId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$51 = T4CConnection.class.getDeclaredMethod("getSessionTimeZoneOffset", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$50 = T4CConnection.class.getDeclaredMethod("updateAutoONSConfig", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$49 = T4CConnection.class.getDeclaredMethod("getServerSessionInfo", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$48 = T4CConnection.class.getDeclaredMethod("getCurrentSchema", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$47 = T4CConnection.class.getDeclaredMethod("setDirectPathState", T4CDirectPathPreparedStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$46 = T4CConnection.class.getDeclaredMethod("clearDirectPathState", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$45 = T4CConnection.class.getDeclaredMethod("directPathAbort", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$44 = T4CConnection.class.getDeclaredMethod("directPathFinish", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$43 = T4CConnection.class.getDeclaredMethod("directPathLoadStream", DirectPathBufferMarshaler.BufferPlanner.class, Integer.TYPE, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$42 = T4CConnection.class.getDeclaredMethod("prepareDirectPathInternal", String.class, String.class, String[].class, String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$41 = T4CConnection.class.getDeclaredMethod("prepareDirectPath", String.class, String.class, String[].class, String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$40 = T4CConnection.class.getDeclaredMethod("prepareDirectPath", String.class, String.class, String[].class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = T4CConnection.class.getDeclaredMethod("prepareDirectPath", String.class, String.class, String[].class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = T4CConnection.class.getDeclaredMethod("prepareDirectPath", String.class, String.class, String[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = T4CConnection.class.getDeclaredMethod("getStatementWithKey", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = T4CConnection.class.getDeclaredMethod("onPDBChange", OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = T4CConnection.class.getDeclaredMethod("updateSessionProperties", KeywordValue[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = T4CConnection.class.getDeclaredMethod("closeProxySession", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = T4CConnection.class.getDeclaredMethod("doProxySession", Integer.TYPE, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = T4CConnection.class.getDeclaredMethod("closeQuery", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = T4CConnection.class.getDeclaredMethod("closeCursor", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = T4CConnection.class.getDeclaredMethod("sendOsesssstateFlags", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = T4CConnection.class.getDeclaredMethod("sendPiggyBackedMessages", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = T4CConnection.class.getDeclaredMethod("redoCursorClose", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = T4CConnection.class.getDeclaredMethod("checkEndReplayCallback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = T4CConnection.class.getDeclaredMethod("doShutdown", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = T4CConnection.class.getDeclaredMethod("doStartup", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = T4CConnection.class.getDeclaredMethod("getTTCVersion", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = T4CConnection.class.getDeclaredMethod("getT4CTTIoer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = T4CConnection.class.getDeclaredMethod("isZeroCopyIOEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = T4CConnection.class.getDeclaredMethod("reNegotiateTTCProDty", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = T4CConnection.class.getDeclaredMethod("doCharSetNegotiation", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = T4CConnection.class.getDeclaredMethod("connect", String.class, GSSCredential.class, SSLContext.class, Supplier.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = T4CConnection.class.getDeclaredMethod("cancelOperationOnServer", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = T4CConnection.class.getDeclaredMethod("createImplicitResultSetStatement", OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = T4CConnection.class.getDeclaredMethod("RefCursorBytesToStatement", byte[].class, OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = T4CConnection.class.getDeclaredMethod("doGetVersionNumber", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = T4CConnection.class.getDeclaredMethod("doGetDatabaseProductVersion", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = T4CConnection.class.getDeclaredMethod("open", OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = T4CConnection.class.getDeclaredMethod("doSetAutoCommit", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = T4CConnection.class.getDeclaredMethod("doRollback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = T4CConnection.class.getDeclaredMethod("doCommit", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = T4CConnection.class.getDeclaredMethod("getMarshalEngine", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = T4CConnection.class.getDeclaredMethod("logoff", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = T4CConnection.class.getDeclaredMethod("handleIOException", IOException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = T4CConnection.class.getDeclaredMethod("kscnForByteLength", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T4CConnection.class.getDeclaredMethod("logon", GSSCredential.class, SSLContext.class, Supplier.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4CConnection.class.getDeclaredMethod("initializePassword", OpaqueString.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4CConnection.class.getDeclaredMethod("getExecutingRPCSQL", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4CConnection.class.getDeclaredMethod("setExecutingRPCSQL", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CConnection.class.getDeclaredMethod("setExecutingRPCFunctionCode", Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CConnection.class.getDeclaredMethod("getExecutingRPCFunctionCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        EMPTY_BYTE = new byte[0];
        cachedVersionTable = new Hashtable<String, String[]>();
        int n2 = 0;
        try {
            n2 = Cipher.getMaxAllowedKeyLength("AES");
        }
        catch (Exception exception) {
            // empty catch block
        }
        isUnlimitedCryptoAvailable = n2 >= 256;
    }

    static final class ReplayMode
    extends Enum<ReplayMode> {
        public static final /* enum */ ReplayMode RUNTIME_REPLAY_ENABLED;
        public static final /* enum */ ReplayMode RUNTIME_OR_REPLAYING_STATIC;
        public static final /* enum */ ReplayMode NONREQUEST;
        public static final /* enum */ ReplayMode REPLAYING;
        private static final /* synthetic */ ReplayMode[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        public static ReplayMode[] values() {
            return (ReplayMode[])$VALUES.clone();
        }

        public static ReplayMode valueOf(String string) {
            return Enum.valueOf(ReplayMode.class, string);
        }

        static {
            try {
                $$$methodRef$$$2 = ReplayMode.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = ReplayMode.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = ReplayMode.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            RUNTIME_REPLAY_ENABLED = new ReplayMode();
            RUNTIME_OR_REPLAYING_STATIC = new ReplayMode();
            NONREQUEST = new ReplayMode();
            REPLAYING = new ReplayMode();
            $VALUES = new ReplayMode[]{RUNTIME_REPLAY_ENABLED, RUNTIME_OR_REPLAYING_STATIC, NONREQUEST, REPLAYING};
        }
    }
}

