/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import javax.sql.RowSet;
import javax.sql.RowSetMetaData;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.rowset.OracleRow;
import oracle.jdbc.rowset.OracleRowSetMetaData;
import oracle.jdbc.rowset.OracleSerialBlob;
import oracle.jdbc.rowset.OracleSerialClob;
import oracle.jdbc.rowset.OracleWebRowSet;
import oracle.xml.util.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.ROWSET})
class OracleWebRowSetXmlReaderContHandler
extends DefaultHandler {
    private OracleWebRowSet wrset;
    private RowSetMetaData rsetMetaData;
    private Vector updatesToRowSet;
    private Vector keyCols;
    private String columnValue;
    private String propertyValue;
    private String metadataValue;
    private boolean isNullValue;
    private int columnIndex;
    private Hashtable propertyNameTagMap;
    private Hashtable metadataNameTagMap;
    private Hashtable dataNameTagMap;
    protected static final String WEBROWSET_ELEMENT_NAME = "webRowSet";
    protected static final String PROPERTIES_ELEMENT_NAME = "properties";
    protected static final String METADATA_ELEMENT_NAME = "metadata";
    protected static final String DATA_ELEMENT_NAME = "data";
    private int state;
    private static final int INITIAL_STATE = 0;
    private static final int PROPERTIES_STATE = 1;
    private static final int METADATA_STATE = 2;
    private static final int DATA_STATE = 3;
    private int tag;
    private static final int NO_TAG = -1;
    private String[] propertyNames = new String[]{"command", "concurrency", "datasource", "escape-processing", "fetch-direction", "fetch-size", "isolation-level", "key-columns", "map", "max-field-size", "max-rows", "query-timeout", "read-only", "rowset-type", "show-deleted", "table-name", "url", "sync-provider", "null", "column", "type", "class", "sync-provider-name", "sync-provider-vendor", "sync-provider-version", "sync-provider-grade", "data-source-lock"};
    private boolean readReadOnlyValue;
    private static final int PROPERTY_COMMAND_TAG = 0;
    private static final int PROPERTY_CONCURRENCY_TAG = 1;
    private static final int PROPERTY_DATASOURCETAG = 2;
    private static final int PROPERTY_ESCAPEPROCESSING_TAG = 3;
    private static final int PROPERTY_FETCHDIRECTION_TAG = 4;
    private static final int PROPERTY_FETCHSIZE_TAG = 5;
    private static final int PROPERTY_ISOLATIONLEVEL_TAG = 6;
    private static final int PROPERTY_KEYCOLUMNS_TAG = 7;
    private static final int PROPERTY_MAP_TAG = 8;
    private static final int PROPERTY_MAXFIELDSIZE_TAG = 9;
    private static final int PROPERTY_MAXROWS_TAG = 10;
    private static final int PROPERTY_QUERYTIMEOUT_TAG = 11;
    private static final int PROPERTY_READONLY_TAG = 12;
    private static final int PROPERTY_ROWSETTYPE_TAG = 13;
    private static final int PROPERTY_SHOWDELETED_TAG = 14;
    private static final int PROPERTY_TABLENAME_TAG = 15;
    private static final int PROPERTY_URL_TAG = 16;
    private static final int PROPERTY_SYNCPROVIDER_TAG = 17;
    private static final int PROPERTY_NULL_TAG = 18;
    private static final int PROPERTY_COLUMN_TAG = 19;
    private static final int PROPERTY_TYPE_TAG = 20;
    private static final int PROPERTY_CLASS_TAG = 21;
    private static final int PROPERTY_SYNCPROVIDERNAME_TAG = 22;
    private static final int PROPERTY_SYNCPROVIDERVENDOR_TAG = 23;
    private static final int PROPERTY_SYNCPROVIDERVERSION_TAG = 24;
    private static final int PROPERTY_SYNCPROVIDERGRADE_TAG = 25;
    private static final int PROPERTY_DATASOURCELOCK_TAG = 26;
    private String[] metadataNames = new String[]{"column-count", "column-definition", "column-index", "auto-increment", "case-sensitive", "currency", "nullable", "signed", "searchable", "column-display-size", "column-label", "column-name", "schema-name", "column-precision", "column-scale", "table-name", "catalog-name", "column-type", "column-type-name", "null"};
    private static final int METADATA_COLUMNCOUNT_TAG = 0;
    private static final int METADATA_COLUMNDEFINITION_TAG = 1;
    private static final int METADATA_COLUMNINDEX_TAG = 2;
    private static final int METADATA_AUTOINCREMENT_TAG = 3;
    private static final int METADATA_CASESENSITIVE_TAG = 4;
    private static final int METADATA_CURRENCY_TAG = 5;
    private static final int METADATA_NULLABLE_TAG = 6;
    private static final int METADATA_SIGNED_TAG = 7;
    private static final int METADATA_SEARCHABLE_TAG = 8;
    private static final int METADATA_COLUMNDISPLAYSIZE_TAG = 9;
    private static final int METADATA_COLUMNLABEL_TAG = 10;
    private static final int METADATA_COLUMNNAME_TAG = 11;
    private static final int METADATA_SCHEMANAME_TAG = 12;
    private static final int METADATA_COLUMNPRECISION_TAG = 13;
    private static final int METADATA_COLUMNSCALE_TAG = 14;
    private static final int METADATA_TABLENAME_TAG = 15;
    private static final int METADATA_CATALOGNAME_TAG = 16;
    private static final int METADATA_COLUMNTYPE_TAG = 17;
    private static final int METADATA_COLUMNTYPENAME_TAG = 18;
    private static final int METADATA_NULL_TAG = 19;
    private String[] dataNames = new String[]{"currentRow", "insertRow", "deleteRow", "modifyRow", "columnValue", "updateValue", "null"};
    private static final int DATA_CURRENTROW_TAG = 0;
    private static final int DATA_INSERTROW_TAG = 1;
    private static final int DATA_DELETEROW_TAG = 2;
    private static final int DATA_MODIFYROW_TAG = 3;
    private static final int DATA_COLUMNVALUE_TAG = 4;
    private static final int DATA_UPDATEVALUE_TAG = 5;
    private static final int DATA_NULL_TAG = 6;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;

    OracleWebRowSetXmlReaderContHandler(RowSet rowSet) {
        this.wrset = (OracleWebRowSet)rowSet;
        this.initialize();
    }

    @Override
    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        String string = new String(cArray, n2, n3);
        this.processElement(string);
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            if (this.readReadOnlyValue) {
                this.wrset.setReadOnly(this.readReadOnlyValue);
            }
        }
        catch (SQLException sQLException) {
            throw new SAXException(sQLException.getMessage());
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = string2 == null || string2.equals("") ? string3 : string2;
        block8 : switch (this.getState()) {
            case 1: {
                if (string4.equals(PROPERTIES_ELEMENT_NAME)) {
                    this.state = 0;
                    break;
                }
                try {
                    int n2 = (Integer)this.propertyNameTagMap.get(string4);
                    switch (n2) {
                        case 7: {
                            if (this.keyCols == null) break;
                            int[] nArray = new int[this.keyCols.size()];
                            for (int i2 = 0; i2 < nArray.length; ++i2) {
                                nArray[i2] = Integer.parseInt((String)this.keyCols.elementAt(i2));
                            }
                            this.wrset.setKeyColumns(nArray);
                        }
                    }
                    this.setPropertyValue(this.propertyValue);
                }
                catch (SQLException sQLException) {
                    throw new SAXException(sQLException.getMessage());
                }
                this.propertyValue = "";
                this.setNullValue(false);
                this.setTag(-1);
                break;
            }
            case 2: {
                if (string4.equals(METADATA_ELEMENT_NAME)) {
                    try {
                        this.wrset.setMetaData(this.rsetMetaData);
                        this.state = 0;
                        break;
                    }
                    catch (SQLException sQLException) {
                        throw new SAXException("Error setting metadata in WebRowSet: " + sQLException.getMessage());
                    }
                }
                try {
                    this.setMetaDataValue(this.metadataValue);
                }
                catch (SQLException sQLException) {
                    throw new SAXException("Error setting metadata value: " + sQLException.getMessage());
                }
                this.metadataValue = "";
                this.setNullValue(false);
                this.setTag(-1);
                break;
            }
            case 3: {
                if (string4.equals(DATA_ELEMENT_NAME)) {
                    this.state = 0;
                    return;
                }
                int n3 = (Integer)this.dataNameTagMap.get(string4);
                switch (n3) {
                    default: {
                        break block8;
                    }
                    case 4: {
                        try {
                            ++this.columnIndex;
                            this.insertValue(this.columnValue);
                            this.columnValue = "";
                            this.setNullValue(false);
                            this.setTag(-1);
                            break block8;
                        }
                        catch (SQLException sQLException) {
                            throw new SAXException("Error inserting column values: " + sQLException.getMessage());
                        }
                    }
                    case 0: {
                        try {
                            this.wrset.insertRow();
                            this.wrset.moveToCurrentRow();
                            this.wrset.next();
                            OracleRow oracleRow = this.wrset.getCurrentRow();
                            oracleRow.setInsertedFlag(false);
                            this.applyUpdates();
                            break block8;
                        }
                        catch (SQLException sQLException) {
                            throw new SAXException("Error constructing current row: " + sQLException.getMessage());
                        }
                    }
                    case 2: {
                        try {
                            this.wrset.insertRow();
                            this.wrset.moveToCurrentRow();
                            this.wrset.next();
                            OracleRow oracleRow = this.wrset.getCurrentRow();
                            oracleRow.setInsertedFlag(false);
                            oracleRow.setRowDeleted(true);
                            this.applyUpdates();
                            break block8;
                        }
                        catch (SQLException sQLException) {
                            throw new SAXException("Error constructing deleted row: " + sQLException.getMessage());
                        }
                    }
                    case 1: {
                        try {
                            this.wrset.insertRow();
                            this.wrset.moveToCurrentRow();
                            this.wrset.next();
                            this.applyUpdates();
                            break block8;
                        }
                        catch (SQLException sQLException) {
                            throw new SAXException("Error constructing inserted row: " + sQLException.getMessage());
                        }
                    }
                    case 3: 
                }
                try {
                    this.wrset.insertRow();
                    this.wrset.moveToCurrentRow();
                    this.wrset.next();
                    OracleRow oracleRow = this.wrset.getCurrentRow();
                    oracleRow.setRowDeleted(true);
                    this.applyUpdates();
                    break;
                }
                catch (SQLException sQLException) {
                    throw new SAXException("Error constructing modified row: " + sQLException.getMessage());
                }
            }
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string2 == null || string2.equals("") ? string3 : string2;
        switch (this.getState()) {
            case 1: {
                int n2 = (Integer)this.propertyNameTagMap.get(string4);
                if (n2 == 18) {
                    this.setNullValue(true);
                    this.propertyValue = null;
                    break;
                }
                this.setTag(n2);
                break;
            }
            case 2: {
                int n3 = (Integer)this.metadataNameTagMap.get(string4);
                if (n3 == 19) {
                    this.setNullValue(true);
                    this.metadataValue = null;
                    break;
                }
                this.setTag(n3);
                break;
            }
            case 3: {
                int n4 = (Integer)this.dataNameTagMap.get(string4);
                if (n4 == 6) {
                    this.setNullValue(true);
                    this.columnValue = null;
                    break;
                }
                this.setTag(n4);
                if (n4 != 0 && n4 != 1 && n4 != 2 && n4 != 3) break;
                this.columnIndex = 0;
                try {
                    this.wrset.moveToInsertRow();
                }
                catch (SQLException sQLException) {}
                break;
            }
            default: {
                this.setState(string4);
            }
        }
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXParseException {
        throw sAXParseException;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        System.out.println("** Warning, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
        System.out.println("   " + sAXParseException.getMessage());
    }

    private void initialize() {
        int n2;
        this.propertyNameTagMap = new Hashtable(30);
        int n3 = this.propertyNames.length;
        for (n2 = 0; n2 < n3; ++n2) {
            this.propertyNameTagMap.put(this.propertyNames[n2], n2);
        }
        this.metadataNameTagMap = new Hashtable(30);
        n3 = this.metadataNames.length;
        for (n2 = 0; n2 < n3; ++n2) {
            this.metadataNameTagMap.put(this.metadataNames[n2], n2);
        }
        this.dataNameTagMap = new Hashtable(10);
        n3 = this.dataNames.length;
        for (n2 = 0; n2 < n3; ++n2) {
            this.dataNameTagMap.put(this.dataNames[n2], n2);
        }
        this.updatesToRowSet = new Vector();
        this.columnValue = "";
        this.propertyValue = "";
        this.metadataValue = "";
        this.isNullValue = false;
        this.columnIndex = 0;
        this.readReadOnlyValue = false;
    }

    protected void processElement(String string) throws SAXException {
        try {
            switch (this.getState()) {
                case 1: {
                    this.propertyValue = string;
                    break;
                }
                case 2: {
                    this.metadataValue = string;
                    break;
                }
                case 3: {
                    this.setDataValue(string);
                }
            }
        }
        catch (SQLException sQLException) {
            throw new SAXException("processElement: " + sQLException.getMessage());
        }
    }

    private BigDecimal getBigDecimalValue(String string) {
        return new BigDecimal(string);
    }

    private byte[] getBinaryValue(String string) throws SQLException {
        byte[] byArray = XMLUtil.parseBase64Binary((String)string);
        return byArray;
    }

    private boolean getBooleanValue(String string) {
        return Boolean.valueOf(string);
    }

    private byte getByteValue(String string) {
        return Byte.parseByte(string);
    }

    private Date getDateValue(String string) {
        return new Date(this.getLongValue(string));
    }

    private double getDoubleValue(String string) {
        return Double.parseDouble(string);
    }

    private float getFloatValue(String string) {
        return Float.parseFloat(string);
    }

    private int getIntegerValue(String string) {
        return Integer.parseInt(string);
    }

    private long getLongValue(String string) {
        return Long.parseLong(string);
    }

    private boolean getNullValue() {
        return this.isNullValue;
    }

    private short getShortValue(String string) {
        return Short.parseShort(string);
    }

    private String getStringValue(String string) {
        return string;
    }

    private Time getTimeValue(String string) {
        return new Time(this.getLongValue(string));
    }

    private Timestamp getTimestampValue(String string) {
        return new Timestamp(this.getLongValue(string));
    }

    private Blob getBlobValue(String string) throws SQLException {
        byte[] byArray = XMLUtil.parseBase64Binary((String)string);
        return new OracleSerialBlob(byArray);
    }

    private Clob getClobValue(String string) throws SQLException {
        return new OracleSerialClob(string.toCharArray());
    }

    private void applyUpdates() throws SAXException {
        if (this.updatesToRowSet.size() > 0) {
            try {
                for (Object[] objectArray : this.updatesToRowSet) {
                    this.columnIndex = (Integer)objectArray[0];
                    this.insertValue((String)objectArray[1]);
                }
                this.wrset.updateRow();
            }
            catch (SQLException sQLException) {
                throw new SAXException("Error updating row: " + sQLException.getMessage());
            }
            this.updatesToRowSet.removeAllElements();
        }
    }

    private void insertValue(String string) throws SQLException {
        if (this.getNullValue() || string == null) {
            this.wrset.updateNull(this.columnIndex);
            return;
        }
        int n2 = this.wrset.getMetaData().getColumnType(this.columnIndex);
        switch (n2) {
            case -7: {
                this.wrset.updateByte(this.columnIndex, this.getByteValue(string));
                break;
            }
            case 5: {
                this.wrset.updateShort(this.columnIndex, this.getShortValue(string));
                break;
            }
            case 4: {
                this.wrset.updateInt(this.columnIndex, this.getIntegerValue(string));
                break;
            }
            case -5: {
                this.wrset.updateLong(this.columnIndex, this.getLongValue(string));
                break;
            }
            case 6: 
            case 7: {
                this.wrset.updateFloat(this.columnIndex, this.getFloatValue(string));
                break;
            }
            case 8: {
                this.wrset.updateDouble(this.columnIndex, this.getDoubleValue(string));
                break;
            }
            case 2: 
            case 3: {
                this.wrset.updateObject(this.columnIndex, (Object)this.getBigDecimalValue(string));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.wrset.updateBytes(this.columnIndex, this.getBinaryValue(string));
                break;
            }
            case 91: {
                this.wrset.updateDate(this.columnIndex, this.getDateValue(string));
                break;
            }
            case 92: {
                this.wrset.updateTime(this.columnIndex, this.getTimeValue(string));
                break;
            }
            case 93: {
                this.wrset.updateTimestamp(this.columnIndex, this.getTimestampValue(string));
                break;
            }
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                this.wrset.updateString(this.columnIndex, this.getStringValue(string));
                break;
            }
            case 2004: {
                this.wrset.updateBlob(this.columnIndex, this.getBlobValue(string));
                break;
            }
            case 2005: {
                this.wrset.updateClob(this.columnIndex, this.getClobValue(string));
                break;
            }
            case 2011: {
                this.wrset.updateNClob(this.columnIndex, (NClob)this.getClobValue(string));
                break;
            }
            default: {
                throw new SQLException("The type " + n2 + " is not supported currently.");
            }
        }
    }

    private void setPropertyValue(String string) throws SQLException {
        boolean bl = this.getNullValue();
        switch (this.getTag()) {
            default: {
                break;
            }
            case 0: {
                if (bl) {
                    this.wrset.setCommand(null);
                    break;
                }
                this.wrset.setCommand(string);
                break;
            }
            case 1: {
                if (bl) {
                    throw (SQLException)DatabaseError.createSqlException(357).fillInStackTrace();
                }
                this.wrset.setConcurrency(this.getIntegerValue(string));
                break;
            }
            case 2: {
                if (bl) {
                    this.wrset.setDataSourceName(null);
                    break;
                }
                this.wrset.setDataSourceName(string);
                break;
            }
            case 3: {
                if (bl) {
                    throw (SQLException)DatabaseError.createSqlException(357).fillInStackTrace();
                }
                this.wrset.setEscapeProcessing(this.getBooleanValue(string));
                break;
            }
            case 4: {
                if (bl) {
                    throw (SQLException)DatabaseError.createSqlException(357).fillInStackTrace();
                }
                int n2 = this.wrset.getType();
                if (n2 == 1005) break;
                this.wrset.setFetchDirection(this.getIntegerValue(string));
                break;
            }
            case 5: {
                if (bl) {
                    throw (SQLException)DatabaseError.createSqlException(357).fillInStackTrace();
                }
                this.wrset.setFetchSize(this.getIntegerValue(string));
                break;
            }
            case 6: {
                if (bl) {
                    throw (SQLException)DatabaseError.createSqlException(357).fillInStackTrace();
                }
                this.wrset.setTransactionIsolation(this.getIntegerValue(string));
                break;
            }
            case 19: {
                if (this.keyCols == null) {
                    this.keyCols = new Vector();
                }
                this.keyCols.add(string);
                break;
            }
            case 9: {
                if (bl) {
                    throw (SQLException)DatabaseError.createSqlException(357).fillInStackTrace();
                }
                this.wrset.setMaxFieldSize(this.getIntegerValue(string));
                break;
            }
            case 10: {
                if (bl) {
                    throw (SQLException)DatabaseError.createSqlException(357).fillInStackTrace();
                }
                this.wrset.setMaxRows(this.getIntegerValue(string));
                break;
            }
            case 11: {
                if (bl) {
                    throw (SQLException)DatabaseError.createSqlException(357).fillInStackTrace();
                }
                this.wrset.setQueryTimeout(this.getIntegerValue(string));
                break;
            }
            case 12: {
                if (bl) {
                    throw (SQLException)DatabaseError.createSqlException(357).fillInStackTrace();
                }
                this.readReadOnlyValue = this.getBooleanValue(string);
                break;
            }
            case 13: {
                if (bl) {
                    throw (SQLException)DatabaseError.createSqlException(357).fillInStackTrace();
                }
                this.wrset.setType(this.getIntegerValue(string));
                break;
            }
            case 14: {
                if (bl) {
                    throw (SQLException)DatabaseError.createSqlException(357).fillInStackTrace();
                }
                this.wrset.setShowDeleted(this.getBooleanValue(string));
                break;
            }
            case 15: {
                if (bl) {
                    this.wrset.setTableName(null);
                    break;
                }
                this.wrset.setTableName(string);
                break;
            }
            case 16: {
                if (bl) {
                    this.wrset.setUrl(null);
                    break;
                }
                this.wrset.setUrl(string);
                break;
            }
            case 22: {
                if (bl) {
                    this.wrset.setSyncProvider(null);
                    break;
                }
                this.wrset.setSyncProvider(string);
            }
        }
    }

    private void setMetaDataValue(String string) throws SQLException {
        boolean bl = this.getNullValue();
        switch (this.getTag()) {
            default: {
                break;
            }
            case 0: {
                if (bl) {
                    throw (SQLException)DatabaseError.createSqlException(358).fillInStackTrace();
                }
                int n2 = this.getIntegerValue(string);
                this.rsetMetaData = new OracleRowSetMetaData(n2);
                this.columnIndex = 0;
                break;
            }
            case 2: {
                ++this.columnIndex;
                break;
            }
            case 3: {
                if (bl) {
                    throw (SQLException)DatabaseError.createSqlException(358).fillInStackTrace();
                }
                this.rsetMetaData.setAutoIncrement(this.columnIndex, this.getBooleanValue(string));
                break;
            }
            case 4: {
                if (bl) {
                    throw (SQLException)DatabaseError.createSqlException(358).fillInStackTrace();
                }
                this.rsetMetaData.setCaseSensitive(this.columnIndex, this.getBooleanValue(string));
                break;
            }
            case 5: {
                if (bl) {
                    throw (SQLException)DatabaseError.createSqlException(358).fillInStackTrace();
                }
                this.rsetMetaData.setCurrency(this.columnIndex, this.getBooleanValue(string));
                break;
            }
            case 6: {
                if (bl) {
                    throw (SQLException)DatabaseError.createSqlException(358).fillInStackTrace();
                }
                this.rsetMetaData.setNullable(this.columnIndex, this.getIntegerValue(string));
                break;
            }
            case 7: {
                if (bl) {
                    throw (SQLException)DatabaseError.createSqlException(358).fillInStackTrace();
                }
                this.rsetMetaData.setSigned(this.columnIndex, this.getBooleanValue(string));
                break;
            }
            case 8: {
                if (bl) {
                    throw (SQLException)DatabaseError.createSqlException(358).fillInStackTrace();
                }
                this.rsetMetaData.setSearchable(this.columnIndex, this.getBooleanValue(string));
                break;
            }
            case 9: {
                if (bl) {
                    throw (SQLException)DatabaseError.createSqlException(358).fillInStackTrace();
                }
                this.rsetMetaData.setColumnDisplaySize(this.columnIndex, this.getIntegerValue(string));
                break;
            }
            case 10: {
                if (bl) {
                    this.rsetMetaData.setColumnLabel(this.columnIndex, null);
                    break;
                }
                this.rsetMetaData.setColumnLabel(this.columnIndex, string);
                break;
            }
            case 11: {
                if (bl) {
                    this.rsetMetaData.setColumnName(this.columnIndex, null);
                    break;
                }
                this.rsetMetaData.setColumnName(this.columnIndex, string);
                break;
            }
            case 12: {
                if (bl) {
                    this.rsetMetaData.setSchemaName(this.columnIndex, null);
                    break;
                }
                this.rsetMetaData.setSchemaName(this.columnIndex, string);
                break;
            }
            case 13: {
                if (bl) {
                    throw (SQLException)DatabaseError.createSqlException(358).fillInStackTrace();
                }
                this.rsetMetaData.setPrecision(this.columnIndex, this.getIntegerValue(string));
                break;
            }
            case 14: {
                if (bl) {
                    throw (SQLException)DatabaseError.createSqlException(358).fillInStackTrace();
                }
                this.rsetMetaData.setScale(this.columnIndex, this.getIntegerValue(string));
                break;
            }
            case 15: {
                if (bl) {
                    this.rsetMetaData.setTableName(this.columnIndex, null);
                    break;
                }
                this.rsetMetaData.setTableName(this.columnIndex, string);
                break;
            }
            case 16: {
                if (bl) {
                    this.rsetMetaData.setCatalogName(this.columnIndex, null);
                    break;
                }
                this.rsetMetaData.setCatalogName(this.columnIndex, string);
                break;
            }
            case 17: {
                if (bl) {
                    throw (SQLException)DatabaseError.createSqlException(358).fillInStackTrace();
                }
                this.rsetMetaData.setColumnType(this.columnIndex, this.getIntegerValue(string));
                break;
            }
            case 18: {
                if (bl) {
                    this.rsetMetaData.setColumnTypeName(this.columnIndex, null);
                    break;
                }
                this.rsetMetaData.setColumnTypeName(this.columnIndex, string);
            }
        }
    }

    private void setDataValue(String string) throws SQLException {
        switch (this.getTag()) {
            default: {
                break;
            }
            case 4: {
                this.columnValue = string;
                break;
            }
            case 5: {
                Object[] objectArray = new Object[2];
                objectArray[1] = string;
                objectArray[0] = this.columnIndex;
                this.updatesToRowSet.add(objectArray);
            }
        }
    }

    protected void setNullValue(boolean bl) {
        this.isNullValue = bl;
    }

    private int getState() {
        return this.state;
    }

    private int getTag() {
        return this.tag;
    }

    private void setState(String string) throws SAXException {
        if (string.equals(WEBROWSET_ELEMENT_NAME)) {
            this.state = 0;
        } else if (string.equals(PROPERTIES_ELEMENT_NAME)) {
            this.state = this.state != 1 ? 1 : 0;
        } else if (string.equals(METADATA_ELEMENT_NAME)) {
            this.state = this.state != 2 ? 2 : 0;
        } else if (string.equals(DATA_ELEMENT_NAME)) {
            this.state = this.state != 3 ? 3 : 0;
        }
    }

    private void setTag(int n2) {
        this.tag = n2;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    static {
        try {
            $$$methodRef$$$35 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredConstructor(RowSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("setTag", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("setState", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("getTag", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("getState", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("setNullValue", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("setDataValue", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("setMetaDataValue", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("setPropertyValue", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("insertValue", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("applyUpdates", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("getClobValue", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("getBlobValue", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("getTimestampValue", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("getTimeValue", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("getStringValue", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("getShortValue", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("getNullValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("getLongValue", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("getIntegerValue", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("getFloatValue", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("getDoubleValue", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("getDateValue", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("getByteValue", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("getBooleanValue", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("getBinaryValue", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("getBigDecimalValue", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("processElement", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("initialize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("warning", SAXParseException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("error", SAXParseException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("startElement", String.class, String.class, String.class, Attributes.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("endElement", String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("endDocument", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleWebRowSetXmlReaderContHandler.class.getDeclaredMethod("characters", char[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

