/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class ResultSetAccessor
extends Accessor {
    static final int MAXLENGTH = 16;
    OracleStatement currentStmt;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;

    ResultSetAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl) throws SQLException {
        super(Representation.RESULT_SET, oracleStatement, 16, bl);
        this.init(oracleStatement, 102, 116, s2, bl);
        this.initForDataAccess(n3, n2, null);
    }

    ResultSetAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, long l2, int n6, short s2) throws SQLException {
        super(Representation.RESULT_SET, oracleStatement, 16, false);
        this.init(oracleStatement, 102, 116, s2, false);
        this.initForDescribe(102, n2, bl, n3, n4, n5, l2, n6, s2, null);
        this.initForDataAccess(0, n2, null);
    }

    @Override
    ResultSet getCursor(int n2) throws SQLException {
        OracleResultSet oracleResultSet = null;
        if (this.currentStmt != null && this.currentStmt.refCursorRowNumber == n2 && !this.currentStmt.isClosed()) {
            oracleResultSet = this.currentStmt.createResultSet();
        } else {
            byte[] byArray = this.getBytes(n2);
            if (byArray != null) {
                OracleStatement oracleStatement = this.statement.connection.RefCursorBytesToStatement(byArray, this.statement);
                oracleStatement.refCursorRowNumber = n2;
                oracleStatement.doDescribe(false);
                if (oracleStatement.numberOfDefinePositions > 0) {
                    oracleStatement.prepareAccessors();
                }
                oracleStatement.setPrefetchInternal(this.statement.getFetchSize(), false, false);
                oracleStatement.closeOnCompletion();
                oracleStatement.currentResultSet = oracleResultSet = oracleStatement.createResultSet();
                this.currentStmt = oracleStatement;
            }
        }
        return oracleResultSet;
    }

    @Override
    Object getObject(int n2) throws SQLException {
        return this.getCursor(n2);
    }

    static {
        try {
            $$$methodRef$$$3 = ResultSetAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = ResultSetAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Short.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = ResultSetAccessor.class.getDeclaredMethod("getObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = ResultSetAccessor.class.getDeclaredMethod("getCursor", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

