/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import oracle.jdbc.driver.NoSupportHAManager;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.ServiceMember;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.simplefan.FanEventListener;
import oracle.simplefan.FanManager;
import oracle.simplefan.FanSubscription;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.HIGH_AVAILABILITY})
public class HAManager {
    private ConcurrentHashMap<String, Map<String, ServiceMember>> services;
    private ConcurrentHashMap<String, Map<String, ServiceMember>> hosts;
    private Map<String, Integer> cardinalities = new HashMap<String, Integer>();
    private static final String FAN_SERVICE_NAME_PROPERTY = "serviceName";
    private FanManager fanMngr = null;
    private FanSubscription fanSubscription = null;
    static final ConcurrentHashMap<String, HAManager> allManagers;
    static final String FAN_CONFIG_PROPERTY = "oracle.jdbc.fanONSConfig";
    private Timer timer = null;
    private int drainIntervals = 0;
    private final AtomicInteger remainingIntervals = new AtomicInteger();
    private int targetDrainCountTotal = 0;
    private int targetDrainCountPerInterval = 0;
    private final AtomicInteger currentDrainTarget = new AtomicInteger();
    private final AtomicInteger currentDrainCount = new AtomicInteger();
    private TimerTask drainingTimerTask = null;
    private TimerTask delayedDrainingTimerTask = null;
    private static AtomicBoolean dependentJarsChecked;
    private static boolean allDependentJarsPresent;
    private static final String _Copyright_2014_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Fri_Jun_10_14:12:40_PDT_2022";
    public static boolean TRACE;
    private static Logger LOGGER;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;

    HAManager() {
        this.services = new ConcurrentHashMap();
        this.hosts = new ConcurrentHashMap();
    }

    HAManager(boolean bl) {
        this();
        if (bl) {
            this.timer = new Timer(true);
        }
    }

    HAManager(String string) throws SQLException {
        this(true);
        this.configure(string);
    }

    static HAManager getInstance(String string) throws SQLException {
        return new HAManager(string);
    }

    private void configure(String string) throws SQLException {
        block2: {
            assert (string != null && !"".equals(string)) : "onsConfigStr: " + string;
            if (this.fanMngr != null) break block2;
            this.fanMngr = FanManager.getInstance();
            if (string != null && !"".equals(string)) {
                Properties properties = new Properties();
                properties.setProperty("onsRemoteConfig", string);
                this.fanMngr.configure(properties);
            }
        }
    }

    private void addService(String string) throws SQLException {
        block3: {
            assert (string != null && !"".equals(string)) : "currentServiceName: " + string;
            if (this.fanMngr == null) break block3;
            Properties properties = new Properties();
            properties.setProperty(FAN_SERVICE_NAME_PROPERTY, string);
            this.fanSubscription = this.fanMngr.subscribe(properties);
            FanEventListener fanEventListener = null;
            try {
                Class<?> clazz = Class.forName("oracle.jdbc.driver.HAFanListener");
                Constructor<?> constructor = clazz.getDeclaredConstructor(HAManager.class);
                fanEventListener = (FanEventListener)constructor.newInstance(this);
            }
            catch (Throwable throwable) {
                throw new SQLException("Metadata error: error while creating FAN listener");
            }
            this.fanSubscription.addListener(fanEventListener);
        }
    }

    void addConnection(OracleConnection oracleConnection) throws SQLException {
        Properties properties = oracleConnection.getServerSessionInfo();
        String string = HAManager.toLowerCase(properties.getProperty("SERVICE_NAME"));
        String string2 = HAManager.toLowerCase(properties.getProperty("INSTANCE_NAME"));
        String string3 = HAManager.toLowerCase(properties.getProperty("DATABASE_NAME"));
        String string4 = HAManager.toLowerCase(properties.getProperty("SERVER_HOST"));
        String string5 = string + "###" + string2 + "###" + string3 + "###" + string4;
        ConcurrentHashMap<String, ServiceMember> concurrentHashMap = new ConcurrentHashMap<String, ServiceMember>();
        Map map = this.services.putIfAbsent(string, concurrentHashMap);
        if (map == null) {
            this.addService(string);
            ServiceMember serviceMember = new ServiceMember(string, string2, string3, string4);
            serviceMember.up();
            serviceMember.addConnection(oracleConnection);
            concurrentHashMap.put(string5, serviceMember);
        } else {
            ServiceMember serviceMember = (ServiceMember)map.get(string5);
            if (serviceMember != null) {
                serviceMember.up();
                serviceMember.addConnection(oracleConnection);
            } else {
                serviceMember = new ServiceMember(string, string2, string3, string4);
                serviceMember.up();
                serviceMember.addConnection(oracleConnection);
                map.put(string5, serviceMember);
            }
        }
        oracleConnection.setHAManager(this);
    }

    public void dropConnection(OracleConnection oracleConnection) throws SQLException {
        Properties properties = oracleConnection.getServerSessionInfo();
        String string = HAManager.toLowerCase(properties.getProperty("SERVICE_NAME"));
        String string2 = HAManager.toLowerCase(properties.getProperty("INSTANCE_NAME"));
        String string3 = HAManager.toLowerCase(properties.getProperty("DATABASE_NAME"));
        String string4 = HAManager.toLowerCase(properties.getProperty("SERVER_HOST"));
        String string5 = string + "###" + string2 + "###" + string3 + "###" + string4;
        Map<String, ServiceMember> map = this.services.get(string);
        if (map == null) {
            throw new SQLException("Metadata error: no member instances for service");
        }
        ServiceMember serviceMember = map.get(string5);
        if (serviceMember == null) {
            throw new SQLException("Metadata error: no member instance for service");
        }
        serviceMember.dropConnection(oracleConnection);
    }

    void plannedDown(String string, String string2, String string3, String string4, int n2) {
        try {
            Map<String, ServiceMember> map = this.services.get(string);
            if (map == null) {
                return;
            }
            if (string2 == null) {
                for (ServiceMember serviceMember : map.values()) {
                    if (!serviceMember.getDatabase().equalsIgnoreCase(string3)) continue;
                    serviceMember.down();
                }
            } else {
                String string5 = string + "###" + string2 + "###" + string3 + "###" + string4;
                ServiceMember serviceMember = map.get(string5);
                if (serviceMember != null) {
                    serviceMember.down();
                    this.drainGracefully(serviceMember, map, n2);
                }
            }
        }
        catch (Throwable throwable) {
        }
    }

    private void drainGracefully(ServiceMember serviceMember, Map<String, ServiceMember> map, int n2) {
        if (n2 > 0) {
            this.drainIntervals = (n2 + 10 - 1) / 10;
            this.remainingIntervals.set(this.drainIntervals);
            this.targetDrainCountTotal = serviceMember.connCount;
            this.targetDrainCountPerInterval = (this.targetDrainCountTotal + this.drainIntervals - 1) / this.drainIntervals;
            this.currentDrainCount.set(0);
            this.currentDrainTarget.set(0);
            this.drainingTimerTask = new TimerTask(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                public void run() {
                    if (HAManager.this.remainingIntervals.get() > 0) {
                        int n2 = HAManager.this.targetDrainCountTotal - HAManager.this.currentDrainCount.get();
                        int n3 = Math.min(HAManager.this.targetDrainCountPerInterval, n2);
                        HAManager.this.currentDrainTarget.addAndGet(n3);
                        HAManager.this.remainingIntervals.decrementAndGet();
                    }
                }

                static {
                    try {
                        $$$methodRef$$$1 = 1.class.getDeclaredConstructor(HAManager.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
            boolean bl = true;
            for (ServiceMember serviceMember2 : map.values()) {
                if (!serviceMember2.isUp()) continue;
                bl = false;
                break;
            }
            if (bl) {
                this.delayedDrainingTimerTask = this.drainingTimerTask;
            } else {
                this.scheduleTimerTask(this.drainingTimerTask, this.drainIntervals);
            }
        }
    }

    private void scheduleTimerTask(TimerTask timerTask, int n2) {
        if (n2 > 0) {
            this.timer.schedule(timerTask, 0L, (long)n2 * 1000L);
        } else {
            this.timer.schedule(timerTask, 0L);
        }
    }

    void unplannedDown(String string, String string2, String string3, String string4) {
        try {
            Map<String, ServiceMember> map = this.services.get(string);
            if (map == null) {
                return;
            }
            if (string2 == null) {
                for (ServiceMember serviceMember : map.values()) {
                    if (!serviceMember.getDatabase().equalsIgnoreCase(string3)) continue;
                    serviceMember.down();
                    serviceMember.cleanupConnections();
                }
            } else {
                String string5 = string + "###" + string2 + "###" + string3 + "###" + string4;
                ServiceMember serviceMember = map.get(string5);
                if (serviceMember != null) {
                    serviceMember.down();
                    serviceMember.cleanupConnections();
                }
            }
        }
        catch (Throwable throwable) {
        }
    }

    void nodeDown(String string) {
        try {
            Map<String, ServiceMember> map = this.hosts.get(string);
            if (map == null) {
                return;
            }
            for (ServiceMember serviceMember : map.values()) {
                serviceMember.down();
                serviceMember.cleanupConnections();
            }
        }
        catch (Throwable throwable) {
        }
    }

    void serviceUp(String string, String string2, String string3, String string4, int n2) {
        try {
            String string5;
            if (!this.services.containsKey(string)) {
                return;
            }
            if (string2 == null) {
                this.cardinalities.put(string, n2);
                return;
            }
            Map<String, ServiceMember> map = this.services.get(string);
            ServiceMember serviceMember = map.get(string5 = string + "###" + string2 + "###" + string3 + "###" + string4);
            if (serviceMember != null) {
                serviceMember.up();
                this.cardinalities.put(string, n2);
                if (this.delayedDrainingTimerTask != null) {
                    this.scheduleTimerTask(this.drainingTimerTask, this.drainIntervals);
                }
            }
        }
        catch (Throwable throwable) {
        }
    }

    public boolean isServiceMemberDown(OracleConnection oracleConnection) throws SQLException {
        Properties properties = oracleConnection.getServerSessionInfo();
        String string = HAManager.toLowerCase(properties.getProperty("SERVICE_NAME"));
        String string2 = HAManager.toLowerCase(properties.getProperty("INSTANCE_NAME"));
        String string3 = HAManager.toLowerCase(properties.getProperty("DATABASE_NAME"));
        String string4 = HAManager.toLowerCase(properties.getProperty("SERVER_HOST"));
        String string5 = string + "###" + string2 + "###" + string3 + "###" + string4;
        Map<String, ServiceMember> map = this.services.get(string);
        if (map != null) {
            ServiceMember serviceMember = map.get(string5);
            return serviceMember.isDown();
        }
        return false;
    }

    public boolean checkAndDrain(OracleConnection oracleConnection) throws SQLException {
        boolean bl = false;
        if (this.drainIntervals > 0) {
            if (this.remainingIntervals.get() == 0) {
                if (this.drainingTimerTask != null) {
                    this.drainingTimerTask.cancel();
                    this.drainingTimerTask = null;
                }
                if (this.delayedDrainingTimerTask != null) {
                    this.delayedDrainingTimerTask.cancel();
                    this.delayedDrainingTimerTask = null;
                }
                this.drainIntervals = 0;
                bl = true;
            } else {
                bl = false;
            }
        } else {
            bl = true;
        }
        if (this.isServiceMemberDown(oracleConnection) && (bl || this.currentDrainCount.get() < this.currentDrainTarget.get())) {
            ((PhysicalConnection)oracleConnection).closeConnectionSafely();
            this.currentDrainCount.incrementAndGet();
            return true;
        }
        return false;
    }

    public static void enableHAIfNecessary(String string, OracleConnection oracleConnection) throws SQLException {
        Object object;
        boolean bl = true;
        if (dependentJarsChecked.compareAndSet(false, true)) {
            try {
                object = oracleConnection.getClass().getClassLoader();
                Class.forName("oracle.simplefan.FanManager", false, (ClassLoader)object);
                Class.forName("oracle.ons.ONS", false, (ClassLoader)object);
                allDependentJarsPresent = true;
            }
            catch (Throwable throwable) {
                allDependentJarsPresent = false;
                bl = false;
            }
        }
        if (!allDependentJarsPresent) {
        } else {
            object = allManagers.get(string);
            if (object == null) {
                String string2 = System.getProperty(FAN_CONFIG_PROPERTY);
                short s2 = oracleConnection.getVersionNumber();
                String string3 = null;
                if (s2 < 11100) {
                    bl = false;
                } else if (string2 != null && !"".equals(string2)) {
                    bl = true;
                    string3 = string2;
                } else {
                    Properties properties = oracleConnection.getServerSessionInfo();
                    String string4 = properties.getProperty("AUTH_ONS_CONFIG");
                    if (s2 >= 12101) {
                        if (string4 == null) {
                            bl = false;
                        } else {
                            bl = true;
                            string3 = string4;
                        }
                    } else {
                        bl = false;
                    }
                }
                if (bl) {
                    try {
                        object = HAManager.getInstance(string3);
                    }
                    catch (Throwable throwable) {
                        bl = false;
                        object = NoSupportHAManager.getInstance();
                    }
                } else {
                    object = NoSupportHAManager.getInstance();
                }
                allManagers.putIfAbsent(string, (HAManager)object);
            }
            ((HAManager)object).addConnection(oracleConnection);
        }
    }

    public static void shutdownAll() {
        for (HAManager hAManager : allManagers.values()) {
            if (hAManager == null) continue;
            hAManager.close();
        }
    }

    public void close() {
        if (this.fanSubscription != null) {
            this.fanSubscription.close();
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    final String getStackTraceString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter(1024);
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return ((Object)stringWriter).toString();
    }

    private static String toLowerCase(String string) {
        return null == string ? null : string.toLowerCase();
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            $$$methodRef$$$26 = HAManager.class.getDeclaredConstructor(String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = HAManager.class.getDeclaredConstructor(Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = HAManager.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = HAManager.class.getDeclaredMethod("access$400", HAManager.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = HAManager.class.getDeclaredMethod("access$300", HAManager.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = HAManager.class.getDeclaredMethod("access$200", HAManager.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = HAManager.class.getDeclaredMethod("access$100", HAManager.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = HAManager.class.getDeclaredMethod("access$000", HAManager.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = HAManager.class.getDeclaredMethod("logger", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = HAManager.class.getDeclaredMethod("toLowerCase", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = HAManager.class.getDeclaredMethod("getStackTraceString", Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = HAManager.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = HAManager.class.getDeclaredMethod("shutdownAll", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = HAManager.class.getDeclaredMethod("enableHAIfNecessary", String.class, OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = HAManager.class.getDeclaredMethod("checkAndDrain", OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = HAManager.class.getDeclaredMethod("isServiceMemberDown", OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = HAManager.class.getDeclaredMethod("serviceUp", String.class, String.class, String.class, String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = HAManager.class.getDeclaredMethod("nodeDown", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = HAManager.class.getDeclaredMethod("unplannedDown", String.class, String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = HAManager.class.getDeclaredMethod("scheduleTimerTask", TimerTask.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = HAManager.class.getDeclaredMethod("drainGracefully", ServiceMember.class, Map.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = HAManager.class.getDeclaredMethod("plannedDown", String.class, String.class, String.class, String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = HAManager.class.getDeclaredMethod("dropConnection", OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = HAManager.class.getDeclaredMethod("addConnection", OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = HAManager.class.getDeclaredMethod("addService", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = HAManager.class.getDeclaredMethod("configure", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = HAManager.class.getDeclaredMethod("getInstance", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        allManagers = new ConcurrentHashMap();
        dependentJarsChecked = new AtomicBoolean(false);
        allDependentJarsPresent = true;
        _Copyright_2014_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.HAManager"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

