/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.lang.reflect.Executable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.pool.OracleConnectionCacheManager;
import oracle.ons.Notification;
import oracle.ons.ONSException;
import oracle.ons.Subscriber;
import oracle.ons.SubscriptionException;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.CONN_POOL})
class OracleRuntimeLoadBalancingEventHandlerThread
extends Thread {
    private Notification event = null;
    private OracleConnectionCacheManager cacheManager = null;
    String m_service;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;

    OracleRuntimeLoadBalancingEventHandlerThread(String string) throws SQLException {
        this.m_service = string;
        this.cacheManager = OracleConnectionCacheManager.getConnectionCacheManagerInstance();
    }

    @Override
    public void run() {
        Subscriber subscriber = null;
        final String string = "%\"eventType=database/event/servicemetrics/" + this.m_service + "\"";
        while (this.cacheManager.failoverEnabledCacheExists()) {
            try {
                subscriber = (Subscriber)AccessController.doPrivileged(new PrivilegedExceptionAction(){
                    private static Executable $$$methodRef$$$0;
                    private static Logger $$$loggerRef$$$0;
                    private static Executable $$$methodRef$$$1;
                    private static Logger $$$loggerRef$$$1;

                    public Object run() {
                        try {
                            return new Subscriber(string, "", 30000L);
                        }
                        catch (SubscriptionException subscriptionException) {
                            return null;
                        }
                    }

                    static {
                        try {
                            $$$methodRef$$$1 = 1.class.getDeclaredConstructor(OracleRuntimeLoadBalancingEventHandlerThread.class, String.class);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                        try {
                            $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
            }
            if (subscriber != null) {
                try {
                    while (this.cacheManager.failoverEnabledCacheExists()) {
                        this.event = subscriber.receive(300000L);
                        if (this.event == null) continue;
                        this.handleEvent(this.event);
                    }
                }
                catch (ONSException oNSException) {
                    subscriber.close();
                }
            }
            try {
                Thread.currentThread();
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    void handleEvent(Notification notification) {
        try {
            this.cacheManager.parseRuntimeLoadBalancingEvent(this.m_service, notification == null ? null : notification.body());
        }
        catch (SQLException sQLException) {
        }
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    static {
        try {
            $$$methodRef$$$2 = OracleRuntimeLoadBalancingEventHandlerThread.class.getDeclaredConstructor(String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleRuntimeLoadBalancingEventHandlerThread.class.getDeclaredMethod("handleEvent", Notification.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleRuntimeLoadBalancingEventHandlerThread.class.getDeclaredMethod("run", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

