/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pooling;

import java.lang.reflect.Executable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import oracle.jdbc.pooling.PoolIterator;

final class PoolIteratorQueue<T> {
    private final AtomicReference<Element> listHead = new AtomicReference<Element>(new Element(null));
    private final AtomicReference<Element> listTail = new AtomicReference<Element>(this.listHead.get());
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;

    PoolIteratorQueue() {
    }

    void enqueue(PoolIterator<T> poolIterator) {
        this.skipToFirstActive();
        if (poolIterator == null) {
            throw new IllegalArgumentException("poolIterator is null");
        }
        Element element = new Element(poolIterator);
        Element element2 = this.listTail.get();
        while (true) {
            if (element2.next.compareAndSet(null, element)) {
                this.listTail.set(element);
                return;
            }
            element2 = element2.next.get();
        }
    }

    boolean peek(PoolIterator<T> poolIterator) {
        if (poolIterator == null) {
            throw new IllegalArgumentException("poolIterator is null");
        }
        Element element = this.skipToFirstActive();
        PoolIterator poolIterator2 = element.poolIterator.get();
        if (null == poolIterator2) {
            return true;
        }
        return poolIterator == poolIterator2;
    }

    void disable(PoolIterator<T> poolIterator) {
        Element element = this.listHead.get();
        while (null != element) {
            if (element.poolIterator.compareAndSet(poolIterator, null)) {
                return;
            }
            element = element.next.get();
        }
        throw new IllegalArgumentException("no poolIterator in a queue");
    }

    private Element skipToFirstActive() {
        Element element;
        PoolIterator poolIterator;
        Element element2 = this.listHead.get();
        while (true) {
            if ((poolIterator = element2.poolIterator.get()) != null) {
                if (poolIterator.isAlive()) break;
                element2.poolIterator.set(null);
            }
            if ((element = element2.next.get()) == null) break;
            element2 = element;
        }
        this.listHead.set(element2);
        while (((poolIterator = element2.poolIterator.get()) == null || poolIterator.isSleeping()) && (element = element2.next.get()) != null) {
            element2 = element;
        }
        return element2;
    }

    static {
        try {
            $$$methodRef$$$4 = PoolIteratorQueue.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = PoolIteratorQueue.class.getDeclaredMethod("skipToFirstActive", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = PoolIteratorQueue.class.getDeclaredMethod("disable", PoolIterator.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = PoolIteratorQueue.class.getDeclaredMethod("peek", PoolIterator.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = PoolIteratorQueue.class.getDeclaredMethod("enqueue", PoolIterator.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }

    private final class Element {
        final AtomicReference<PoolIterator<T>> poolIterator;
        final AtomicReference<Element> next = new AtomicReference<Object>(null);
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;

        Element(PoolIterator<T> poolIterator) {
            this.poolIterator = new AtomicReference(poolIterator);
        }

        static {
            try {
                $$$methodRef$$$0 = Element.class.getDeclaredConstructor(PoolIteratorQueue.class, PoolIterator.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

