/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.internal.OracleTimestamp;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMPTZ;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.PRIMITIVE_DATUM})
public class TIMESTAMP
extends Datum
implements Serializable,
OracleTimestamp {
    static final int CENTURY_DEFAULT = 119;
    static final int DECADE_DEFAULT = 100;
    static final int MONTH_DEFAULT = 1;
    static final int DAY_DEFAULT = 1;
    static final int DECADE_INIT = 170;
    static final int JAVA_YEAR = 1970;
    static final int JAVA_MONTH = 0;
    static final int JAVA_DATE = 1;
    public static final int SIZE_DATE = 7;
    public static final int SIZE_TIMESTAMP = 11;
    public static final int SIZE_TIMESTAMP_NOFRAC = 7;
    static final int SIZE_TIMESTAMPTZ = 13;
    static final int MINYEAR = -4712;
    static final int MAXYEAR = 9999;
    static final int JANMONTH = 1;
    static final int DECMONTH = 12;
    static final int MINDAYS = 1;
    static final int MAXDAYS = 31;
    static final int MINHOURS = 1;
    static final int MAXHOURS = 24;
    static final int MINMINUTES = 1;
    static final int MAXMINUTES = 60;
    static final int MINSECONDS = 1;
    static final int MAXSECONDS = 60;
    static final int[] daysInMonth;
    static final long serialVersionUID = -7964732752952728545L;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;

    public TIMESTAMP() {
        super(TIMESTAMP.initTimestamp());
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$30, null, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$30, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$30, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$30, null, throwable2);
            }
            throw throwable;
        }
    }

    public TIMESTAMP(byte[] byArray) {
        super(byArray);
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$31, null, new Object[]{byArray});
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$31, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$31, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$31, null, throwable2);
            }
            throw throwable;
        }
    }

    public TIMESTAMP(Time time) {
        super(TIMESTAMP.toBytes(time));
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$32, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$32, null, time);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$32, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$32, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$32, null, throwable2);
            }
            throw throwable;
        }
    }

    public TIMESTAMP(Date date) {
        super(TIMESTAMP.toBytes(date));
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$33, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$33, null, date);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$33, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$33, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$33, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$33, null, throwable2);
            }
            throw throwable;
        }
    }

    public TIMESTAMP(Timestamp timestamp) {
        super(TIMESTAMP.toBytes(timestamp));
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$34, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$34, null, timestamp);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$34, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$34, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$34, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$34, null, throwable2);
            }
            throw throwable;
        }
    }

    public TIMESTAMP(Timestamp timestamp, Calendar calendar) {
        super(TIMESTAMP.toBytes(timestamp, calendar));
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$35, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$35, null, timestamp, calendar);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$35, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$35, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$35, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$35, null, throwable2);
            }
            throw throwable;
        }
    }

    public TIMESTAMP(DATE dATE) {
        super(TIMESTAMP.toBytes(dATE));
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$36, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$36, null, dATE);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$36, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$36, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$36, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$36, null, throwable2);
            }
            throw throwable;
        }
    }

    public static final int getNanos(byte[] byArray, int n2) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$0, null, byArray, n2);
            }
            int n3 = (byArray[n2] & 0xFF) << 24;
            n3 |= (byArray[n2 + 1] & 0xFF) << 16;
            n3 |= (byArray[n2 + 2] & 0xFF) << 8;
            int n4 = n3 |= byArray[n2 + 3] & 0xFF & 0xFF;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$0, null, n4);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$0, null, null);
            }
            return n4;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$0, null, throwable2);
            }
            throw throwable;
        }
    }

    public TIMESTAMP(String string) {
        super(TIMESTAMP.toBytes(string));
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$37, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$37, null, string);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$37, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$37, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$37, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$37, null, throwable2);
            }
            throw throwable;
        }
    }

    public static Date toDate(byte[] byArray) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            int n3;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$1, null, new Object[]{byArray});
            }
            int[] nArray = (n3 = byArray.length) == 11 ? new int[11] : new int[7];
            for (n2 = 0; n2 < byArray.length; ++n2) {
                nArray[n2] = byArray[n2] & 0xFF;
            }
            n2 = TIMESTAMP.getJavaYear(nArray[0], nArray[1]);
            Calendar calendar = Calendar.getInstance();
            calendar.set(1, n2);
            calendar.set(2, nArray[2] - 1);
            calendar.set(5, nArray[3]);
            calendar.set(11, nArray[4] - 1);
            calendar.set(12, nArray[5] - 1);
            calendar.set(13, nArray[6] - 1);
            int n4 = 0;
            if (n3 == 11) {
                n4 = TIMESTAMP.getNanos(byArray, 7) / 1000000;
            }
            calendar.set(14, n4);
            long l2 = calendar.getTimeInMillis();
            Date date = new Date(l2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$1, null, date);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$1, null, null);
            }
            return date;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$1, null, throwable2);
            }
            throw throwable;
        }
    }

    public static Time toTime(byte[] byArray) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$2, null, new Object[]{byArray});
            }
            int n2 = byArray[4] & 0xFF;
            int n3 = byArray[5] & 0xFF;
            int n4 = byArray[6] & 0xFF;
            Calendar calendar = Calendar.getInstance();
            calendar.set(1, 1970);
            calendar.set(2, 0);
            calendar.set(5, 1);
            calendar.set(11, n2 - 1);
            calendar.set(12, n3 - 1);
            calendar.set(13, n4 - 1);
            calendar.set(14, 0);
            Time time = new Time(calendar.getTime().getTime());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$2, null, time);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$2, null, null);
            }
            return time;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$2, null, throwable2);
            }
            throw throwable;
        }
    }

    public static Timestamp toTimestamp(byte[] byArray) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$3, null, new Object[]{byArray});
            }
            Timestamp timestamp = TIMESTAMP.toTimestamp(byArray, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$3, null, timestamp);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$3, null, null);
            }
            return timestamp;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$3, null, throwable2);
            }
            throw throwable;
        }
    }

    public static Timestamp toTimestamp(byte[] byArray, Calendar calendar) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            int n3;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$4, null, byArray, calendar);
            }
            int[] nArray = (n3 = byArray.length) == 11 ? new int[11] : new int[7];
            for (n2 = 0; n2 < byArray.length; ++n2) {
                nArray[n2] = byArray[n2] & 0xFF;
            }
            n2 = TIMESTAMP.getJavaYear(nArray[0], nArray[1]);
            Calendar calendar2 = calendar == null ? Calendar.getInstance() : Calendar.getInstance(calendar.getTimeZone());
            calendar2.clear();
            calendar2.set(1, n2);
            calendar2.set(2, nArray[2] - 1);
            calendar2.set(5, nArray[3]);
            calendar2.set(11, nArray[4] - 1);
            calendar2.set(12, nArray[5] - 1);
            calendar2.set(13, nArray[6] - 1);
            calendar2.set(14, 0);
            long l2 = calendar2.getTime().getTime();
            Timestamp timestamp = new Timestamp(l2);
            int n4 = 0;
            if (n3 == 11) {
                n4 = TIMESTAMP.getNanos(byArray, 7);
            }
            timestamp.setNanos(n4);
            Timestamp timestamp2 = timestamp;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$4, null, timestamp2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$4, null, null);
            }
            return timestamp2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$4, null, throwable2);
            }
            throw throwable;
        }
    }

    public static DATE toDATE(byte[] byArray) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$5, null, new Object[]{byArray});
            }
            byte[] byArray2 = new byte[7];
            System.arraycopy(byArray, 0, byArray2, 0, 7);
            DATE dATE = new DATE(byArray2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$5, null, dATE);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$5, null, null);
            }
            return dATE;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$5, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Timestamp timestampValue() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$6, this, new Object[0]);
            }
            Timestamp timestamp = TIMESTAMP.toTimestamp(this.getBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$6, this, timestamp);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$6, this, null);
            }
            return timestamp;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Timestamp timestampValue(Calendar calendar) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$7, this, calendar);
            }
            Timestamp timestamp = TIMESTAMP.toTimestamp(this.getBytes(), calendar);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$7, this, timestamp);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$7, this, null);
            }
            return timestamp;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    @DisableTrace
    public static String toString(byte[] byArray) {
        int n2;
        int[] nArray = new int[byArray.length];
        for (n2 = 0; n2 < byArray.length; ++n2) {
            nArray[n2] = byArray[n2] < 0 ? byArray[n2] + 256 : byArray[n2];
        }
        n2 = TIMESTAMP.getJavaYear(nArray[0], nArray[1]);
        int n3 = nArray[2];
        int n4 = nArray[3];
        int n5 = nArray[4] - 1;
        int n6 = nArray[5] - 1;
        int n7 = nArray[6] - 1;
        int n8 = 0;
        if (byArray.length > 7) {
            n8 = TIMESTAMP.getNanos(byArray, 7);
        }
        return TIMESTAMPTZ.toString(n2, n3, n4, n5, n6, n7, n8, null);
    }

    @Override
    public byte[] toBytes() {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$8, this, new Object[0]);
            }
            byte[] byArray = this.getBytes();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$8, this, byArray);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$8, this, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(Time time) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$9, null, time);
            }
            if (time == null) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$9, null, byArray);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$9, null, null);
                }
                return null;
            }
            byte[] byArray = new byte[7];
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(time);
            byArray[0] = 119;
            byArray[1] = -86;
            byArray[2] = 1;
            byArray[3] = 1;
            byArray[4] = (byte)(calendar.get(11) + 1);
            byArray[5] = (byte)(calendar.get(12) + 1);
            byArray[6] = (byte)(calendar.get(13) + 1);
            byte[] byArray2 = byArray;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$9, null, byArray2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$9, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$9, null, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(Date date) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$10, null, date);
            }
            if (date == null) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$10, null, byArray);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$10, null, null);
                }
                return null;
            }
            byte[] byArray = new byte[7];
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            int n2 = TIMESTAMP.getOracleYear(calendar);
            byArray[0] = (byte)(n2 / 100 + 100);
            byArray[1] = (byte)(n2 % 100 + 100);
            byArray[2] = (byte)(calendar.get(2) + 1);
            byArray[3] = (byte)calendar.get(5);
            if (!OracleDriver.getSystemPropertyDateZeroTime()) {
                byArray[4] = (byte)(calendar.get(11) + 1);
                byArray[5] = (byte)(calendar.get(12) + 1);
                byArray[6] = (byte)(calendar.get(13) + 1);
            } else {
                byArray[4] = 1;
                byArray[5] = 1;
                byArray[6] = 1;
            }
            byte[] byArray2 = byArray;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$10, null, byArray2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$10, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$10, null, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(Timestamp timestamp) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$11, null, timestamp);
            }
            byte[] byArray = TIMESTAMP.toBytes(timestamp, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$11, null, byArray);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$11, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$11, null, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(Timestamp timestamp, Calendar calendar) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$12, null, timestamp, calendar);
            }
            if (timestamp == null) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$12, null, byArray);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$12, null, null);
                }
                return null;
            }
            int n2 = timestamp.getNanos();
            byte[] byArray = n2 == 0 ? new byte[7] : new byte[11];
            Calendar calendar2 = calendar == null ? Calendar.getInstance() : Calendar.getInstance(calendar.getTimeZone());
            calendar2.setTime(timestamp);
            int n3 = TIMESTAMP.getOracleYear(calendar2);
            byArray[0] = (byte)(n3 / 100 + 100);
            byArray[1] = (byte)(n3 % 100 + 100);
            byArray[2] = (byte)(calendar2.get(2) + 1);
            byArray[3] = (byte)calendar2.get(5);
            byArray[4] = (byte)(calendar2.get(11) + 1);
            byArray[5] = (byte)(calendar2.get(12) + 1);
            byArray[6] = (byte)(calendar2.get(13) + 1);
            if (n2 != 0) {
                byArray[7] = (byte)(n2 >> 24);
                byArray[8] = (byte)(n2 >> 16 & 0xFF);
                byArray[9] = (byte)(n2 >> 8 & 0xFF);
                byArray[10] = (byte)(n2 & 0xFF);
            }
            byte[] byArray2 = byArray;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$12, null, byArray2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$12, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$12, null, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(DATE dATE) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$13, null, dATE);
            }
            if (dATE == null) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$13, null, byArray);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$13, null, null);
                }
                return null;
            }
            byte[] byArray = new byte[7];
            System.arraycopy(dATE.getBytes(), 0, byArray, 0, 7);
            byte[] byArray2 = byArray;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$13, null, byArray2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$13, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$13, null, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(String string) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$14, null, string);
            }
            byte[] byArray = TIMESTAMP.toBytes(Timestamp.valueOf(string));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$14, null, byArray);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$14, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$14, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Object toJdbc() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$15, this, new Object[0]);
            }
            Timestamp timestamp = this.timestampValue();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$15, this, timestamp);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$15, this, null);
            }
            return timestamp;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Object makeJdbcArray(int n2) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            Timestamp[] timestampArray;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$16, this, n2);
            }
            Timestamp[] timestampArray2 = timestampArray = new Timestamp[n2];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$16, this, timestampArray2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$16, this, null);
            }
            return timestampArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean isConvertibleTo(Class<?> clazz) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$17, this, clazz);
            }
            if (clazz.getName().compareTo("java.sql.Date") == 0 || clazz.getName().compareTo("java.sql.Time") == 0 || clazz.getName().compareTo("java.sql.Timestamp") == 0 || clazz.getName().compareTo("java.lang.String") == 0) {
                boolean bl2 = true;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$17, this, bl2);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$17, this, null);
                }
                return true;
            }
            boolean bl3 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$17, this, bl3);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$17, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    public static TIMESTAMP TimeZoneConvert(Connection connection, TIMESTAMP tIMESTAMP, TimeZone timeZone, TimeZone timeZone2) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            byte[] byArray;
            int n3;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$18, null, connection, tIMESTAMP, timeZone, timeZone2);
            }
            int[] nArray = (n3 = (byArray = tIMESTAMP.getBytes()).length) == 11 ? new int[11] : new int[7];
            for (n2 = 0; n2 < n3; ++n2) {
                nArray[n2] = byArray[n2] & 0xFF;
            }
            n2 = TIMESTAMP.getJavaYear(nArray[0], nArray[1]);
            int n4 = nArray[2] - 1;
            int n5 = nArray[3];
            int n6 = nArray[4] - 1;
            int n7 = nArray[5] - 1;
            int n8 = nArray[6] - 1;
            Calendar calendar = Calendar.getInstance(timeZone);
            calendar.set(1, n2);
            calendar.set(2, n4);
            calendar.set(5, n5);
            calendar.set(11, n6);
            calendar.set(12, n7);
            calendar.set(13, n8);
            calendar.set(14, 0);
            long l2 = calendar.getTimeInMillis();
            Timestamp timestamp = new Timestamp(l2);
            int n9 = 0;
            if (n3 == 11) {
                n9 = TIMESTAMP.getNanos(byArray, 7);
            }
            timestamp.setNanos(n9);
            Calendar calendar2 = Calendar.getInstance(timeZone2);
            TIMESTAMP tIMESTAMP2 = new TIMESTAMP(timestamp, calendar2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$18, null, tIMESTAMP2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$18, null, null);
            }
            return tIMESTAMP2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$18, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String stringValue() {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$19, this, new Object[0]);
            }
            String string = TIMESTAMP.toString(this.getBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$19, this, string);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$19, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    @DisableTrace
    public String toString() {
        return this.stringValue();
    }

    public static int getOracleYear(Calendar calendar) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$20, null, calendar);
            }
            int n2 = calendar.get(1);
            if (calendar.get(0) == 0) {
                n2 = -n2;
            }
            if (n2 < -4712 || n2 > 9999) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid year value");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$20, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$20, null, illegalArgumentException);
                }
                throw illegalArgumentException;
            }
            int n3 = n2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$20, null, n3);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$20, null, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$20, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Date dateValue() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$21, this, new Object[0]);
            }
            Date date = TIMESTAMP.toDate(this.getBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$21, this, date);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$21, this, null);
            }
            return date;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Time timeValue() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$22, this, new Object[0]);
            }
            Time time = TIMESTAMP.toTime(this.getBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$22, this, time);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$22, this, null);
            }
            return time;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    public static int getJavaYear(int n2, int n3) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            int n4;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$23, null, n2, n3);
            }
            if ((n4 = (n2 - 100) * 100 + (n3 - 100)) < 0) {
                ++n4;
            }
            int n5 = n4;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$23, null, n5);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$23, null, null);
            }
            return n5;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$23, null, throwable2);
            }
            throw throwable;
        }
    }

    public static TIMESTAMP of(LocalDateTime localDateTime) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$24, null, localDateTime);
            }
            TIMESTAMP tIMESTAMP = new TIMESTAMP(Timestamp.valueOf(localDateTime));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$24, null, tIMESTAMP);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$24, null, null);
            }
            return tIMESTAMP;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$24, null, throwable2);
            }
            throw throwable;
        }
    }

    public LocalDateTime toLocalDateTime() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$25, this, new Object[0]);
            }
            LocalDateTime localDateTime = this.timestampValue().toLocalDateTime();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$25, this, localDateTime);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$25, this, null);
            }
            return localDateTime;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$25, this, throwable2);
            }
            throw throwable;
        }
    }

    private static byte[] initTimestamp() {
        byte[] byArray = new byte[11];
        byArray[0] = 119;
        byArray[1] = -86;
        byArray[2] = 1;
        byArray[3] = 1;
        byArray[4] = 1;
        byArray[5] = 1;
        byArray[6] = 1;
        return byArray;
    }

    private boolean isLeapYear(int n2) {
        return n2 % 4 == 0 && (n2 <= 1582 ? n2 != -4712 : n2 % 100 != 0 || n2 % 400 == 0);
    }

    private boolean isValid() {
        byte[] byArray = this.getBytes();
        if (byArray.length != 11 && byArray.length != 7) {
            return false;
        }
        int n2 = ((byArray[0] & 0xFF) - 100) * 100 + ((byArray[1] & 0xFF) - 100);
        if (n2 < -4712 || n2 > 9999) {
            return false;
        }
        if (n2 == 0) {
            return false;
        }
        int n3 = byArray[2] & 0xFF;
        if (n3 < 1 || n3 > 12) {
            return false;
        }
        int n4 = byArray[3] & 0xFF;
        if (n4 < 1 || n4 > 31) {
            return false;
        }
        if (!(n4 <= daysInMonth[n3 - 1] || this.isLeapYear(n2) && n3 == 2 && n4 == 29)) {
            return false;
        }
        if (n2 == 1582 && n3 == 10 && n4 >= 5 && n4 < 15) {
            return false;
        }
        int n5 = byArray[4] & 0xFF;
        if (n5 < 1 || n5 > 24) {
            return false;
        }
        int n6 = byArray[5] & 0xFF;
        if (n6 < 1 || n6 > 60) {
            return false;
        }
        int n7 = byArray[6] & 0xFF;
        return n7 >= 1 && n7 <= 60;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (!this.isValid()) {
            throw new IOException("Invalid TIMESTAMP");
        }
    }

    static {
        try {
            $$$methodRef$$$37 = TIMESTAMP.class.getDeclaredConstructor(String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$36 = TIMESTAMP.class.getDeclaredConstructor(DATE.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$35 = TIMESTAMP.class.getDeclaredConstructor(Timestamp.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$34 = TIMESTAMP.class.getDeclaredConstructor(Timestamp.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$33 = TIMESTAMP.class.getDeclaredConstructor(Date.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$32 = TIMESTAMP.class.getDeclaredConstructor(Time.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$31 = TIMESTAMP.class.getDeclaredConstructor(byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$30 = TIMESTAMP.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$29 = TIMESTAMP.class.getDeclaredMethod("readObject", ObjectInputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$28 = TIMESTAMP.class.getDeclaredMethod("isValid", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$27 = TIMESTAMP.class.getDeclaredMethod("isLeapYear", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$26 = TIMESTAMP.class.getDeclaredMethod("initTimestamp", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$25 = TIMESTAMP.class.getDeclaredMethod("toLocalDateTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$24 = TIMESTAMP.class.getDeclaredMethod("of", LocalDateTime.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$23 = TIMESTAMP.class.getDeclaredMethod("getJavaYear", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$22 = TIMESTAMP.class.getDeclaredMethod("timeValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$21 = TIMESTAMP.class.getDeclaredMethod("dateValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$20 = TIMESTAMP.class.getDeclaredMethod("getOracleYear", Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$19 = TIMESTAMP.class.getDeclaredMethod("stringValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$18 = TIMESTAMP.class.getDeclaredMethod("TimeZoneConvert", Connection.class, TIMESTAMP.class, TimeZone.class, TimeZone.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$17 = TIMESTAMP.class.getDeclaredMethod("isConvertibleTo", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$16 = TIMESTAMP.class.getDeclaredMethod("makeJdbcArray", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$15 = TIMESTAMP.class.getDeclaredMethod("toJdbc", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$14 = TIMESTAMP.class.getDeclaredMethod("toBytes", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$13 = TIMESTAMP.class.getDeclaredMethod("toBytes", DATE.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$12 = TIMESTAMP.class.getDeclaredMethod("toBytes", Timestamp.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$11 = TIMESTAMP.class.getDeclaredMethod("toBytes", Timestamp.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$10 = TIMESTAMP.class.getDeclaredMethod("toBytes", Date.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$9 = TIMESTAMP.class.getDeclaredMethod("toBytes", Time.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$8 = TIMESTAMP.class.getDeclaredMethod("toBytes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$7 = TIMESTAMP.class.getDeclaredMethod("timestampValue", Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$6 = TIMESTAMP.class.getDeclaredMethod("timestampValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$5 = TIMESTAMP.class.getDeclaredMethod("toDATE", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$4 = TIMESTAMP.class.getDeclaredMethod("toTimestamp", byte[].class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$3 = TIMESTAMP.class.getDeclaredMethod("toTimestamp", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$2 = TIMESTAMP.class.getDeclaredMethod("toTime", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$1 = TIMESTAMP.class.getDeclaredMethod("toDate", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$0 = TIMESTAMP.class.getDeclaredMethod("getNanos", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        daysInMonth = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    }
}

