/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.Executable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.diagnostics.SecuredLogger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.AcceptPacket;
import oracle.net.ns.ConnectPacket;
import oracle.net.ns.DataPacket;
import oracle.net.ns.MarkerPacket;
import oracle.net.ns.NSProtocol;
import oracle.net.ns.NetException;
import oracle.net.ns.NetInputStream;
import oracle.net.ns.NetOutputStream;
import oracle.net.ns.Packet;
import oracle.net.ns.RedirectPacket;
import oracle.net.ns.RefusePacket;
import oracle.net.ns.SessionAtts;
import oracle.net.nt.AsyncOutboundTimeoutHandler;
import oracle.net.nt.ConnOption;

@DefaultLogger(value="oracle.net.ns")
@Supports(value={Feature.NET})
public class NSProtocolStream
extends NSProtocol {
    private MarkerPacket mkPkt;
    private DataPacket probePacket;
    private Packet packet;
    DMSFactory.DMSNoun dmsParent = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;

    public NSProtocolStream() {
        this(SecuredLogger.noOpLogger());
    }

    public NSProtocolStream(SecuredLogger securedLogger) {
        this.sAtts = new SessionAtts(this, 0x200000, 0x200000, false, false, securedLogger);
        this.sAtts.connected = false;
    }

    @Override
    void negotiateConnection(NVFactory nVFactory, NVNavigator nVNavigator, boolean bl, boolean bl2, DMSFactory.DMSNoun dMSNoun) throws IOException, NetException {
        RefusePacket refusePacket;
        RedirectPacket redirectPacket;
        AcceptPacket acceptPacket;
        ConnectPacket connectPacket;
        this.dmsParent = dMSNoun;
        NVPair nVPair = null;
        String string = null;
        block13: while (true) {
            Object object;
            String string2;
            IOException iOException = null;
            long l2 = System.currentTimeMillis();
            connectPacket = new ConnectPacket(this.sAtts, !bl, bl2);
            this.packet = new Packet(this.sAtts, this.sAtts.getSDU());
            try {
                connectPacket.send();
                this.packet.receive();
            }
            catch (InterruptedIOException interruptedIOException) {
                string2 = String.format("%s, connect lapse %d ms.", interruptedIOException.getMessage(), System.currentTimeMillis() - l2);
                object = new IOException(string2, interruptedIOException);
                throw object;
            }
            catch (IOException iOException2) {
                this.packet.type = 4;
                string2 = String.format("%s, connect lapse %d ms.", iOException2.getMessage(), System.currentTimeMillis() - l2);
                object = new IOException(string2, iOException2);
                iOException = object;
            }
            switch (this.packet.type) {
                case 2: {
                    acceptPacket = new AcceptPacket(this.packet);
                    this.sAtts.setConnectData(acceptPacket.connectData);
                    this.sAtts.cOption.nt.resetInetAddress();
                    this.sAtts.connected = true;
                    if (!acceptPacket.isOOBCheckEnabled) break block13;
                    this.tryUrgentByte();
                    this.sendMarker(2, (byte)3);
                    break block13;
                }
                case 5: {
                    redirectPacket = new RedirectPacket(this.packet);
                    ConnOption connOption = this.sAtts.cOption;
                    this.addrRes.connection_redirected = true;
                    this.sAtts.cOption.nt.disconnect();
                    this.sAtts.cOption.nt.resetInetAddress();
                    string2 = redirectPacket.getData();
                    object = string2;
                    String string3 = null;
                    if ((redirectPacket.flags & 2) == 2 && string2.indexOf(0) != -1) {
                        object = string2.substring(0, string2.indexOf(0));
                        this.sAtts.redirecting = true;
                        string3 = string2.substring(string2.indexOf(0) + 1, string2.length());
                    }
                    this.sAtts = this.establishConnection((String)object, this.dmsParent);
                    this.sAtts.cOption.restoreFromOrigCoption(connOption);
                    if (!this.sAtts.redirecting) continue block13;
                    this.sAtts.cOption.conn_data.setLength(0);
                    this.sAtts.cOption.conn_data.append(string3);
                    break;
                }
                case 4: {
                    refusePacket = new RefusePacket(this.packet);
                    this.sAtts.cOption.nt.disconnect();
                    this.sAtts.cOption = null;
                    try {
                        this.establishConnection(null, this.dmsParent);
                    }
                    catch (NetException netException) {
                        // empty catch block
                    }
                    if (this.sAtts.cOption != null) continue block13;
                    if (iOException != null) {
                        throw iOException;
                    }
                    try {
                        NVPair nVPair2;
                        nVPair = nVNavigator.findNVPairRecurse(nVFactory.createNVPair(refusePacket.getData()), "ERROR");
                        if (nVPair != null && (nVPair2 = nVNavigator.findNVPairRecurse(nVPair, "CODE")) != null) {
                            string = nVPair2.valueToString();
                        }
                    }
                    catch (NLException nLException) {
                    }
                    throw new NetException(string == null ? 206 : Integer.parseInt(string), "");
                }
                case 11: {
                    if ((this.packet.flags & 8) != 8) continue block13;
                    this.sAtts.renegotiateSSLSession();
                    break;
                }
                default: {
                    this.sAtts.cOption.nt.disconnect();
                    throw new NetException(205);
                }
            }
        }
        this.setNetStreams();
        this.packet = null;
        connectPacket = null;
        acceptPacket = null;
        redirectPacket = null;
        refusePacket = null;
    }

    @Override
    final CompletionStage<Void> negotiateConnectionAsync(NVFactory nVFactory, NVNavigator nVNavigator, boolean bl, boolean bl2, DMSFactory.DMSNoun dMSNoun, AsyncOutboundTimeoutHandler asyncOutboundTimeoutHandler, Executor executor) {
        return CompletionStageUtil.failedStage(new UnsupportedOperationException("Asynchronous IO is not supported when oracle.jdbc.javaNetNio=false"));
    }

    @Override
    public void writeZeroCopyIO(byte[] byArray, int n2, int n3) throws IOException, NetException {
        NetOutputStream netOutputStream = this.getNetOutputStream();
        netOutputStream.writeZeroCopyIO(byArray, n2, n3);
    }

    @Override
    public boolean readZeroCopyIO(byte[] byArray, int n2, int[] nArray) throws IOException, NetException {
        NetInputStream netInputStream = this.getNetInputStream();
        boolean bl = netInputStream.readZeroCopyIO(byArray, n2, nArray);
        return bl;
    }

    @Override
    public void writeZeroCopyIOHeader(boolean bl, int n2, boolean bl2) throws IOException {
        NetOutputStream netOutputStream = this.getNetOutputStream();
        netOutputStream.writeZeroCopyIOHeader(bl, n2, bl2);
    }

    @Override
    public void writeZeroCopyIOData(byte[] byArray, int n2, int n3) throws IOException {
        NetOutputStream netOutputStream = this.getNetOutputStream();
        netOutputStream.writeZeroCopyIO(byArray, n2, n3);
    }

    @Override
    public void disconnect() throws IOException, NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        IOException iOException = null;
        try {
            this.sAtts.nsOutputStream.close();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        this.sAtts.connected = false;
        this.dmsParent = null;
        this.sAtts.cOption.nt.disconnect();
        if (iOException != null) {
            throw iOException;
        }
    }

    @Override
    public void sendReset() throws IOException, NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        this.sendMarker(1, (byte)2);
        while (this.sAtts.onBreakReset) {
            Packet packet = ((NetInputStream)this.sAtts.getInputStream()).getCurrentPacket();
            packet.receive();
            if (packet.type != 12) continue;
            this.mkPkt = new MarkerPacket(packet);
            if (this.mkPkt.data != 2) continue;
            this.sAtts.onBreakReset = false;
        }
        this.mkPkt = null;
    }

    @Override
    public void sendBreak() throws IOException, NetException {
        if ((this.sAtts.negotiatedOptions & 0x400) == 1024) {
            this.sAtts.nt.sendUrgentByte(33);
            if ((this.sAtts.negotiatedOptions & 0x800) != 2048) {
                this.sendMarker(2, (byte)1);
            }
        } else {
            this.sendMarker(1, (byte)1);
        }
    }

    @Override
    public void sendInterrupt() throws IOException, NetException {
        if ((this.sAtts.negotiatedOptions & 0x400) == 1024) {
            this.sAtts.nt.sendUrgentByte(33);
            if ((this.sAtts.negotiatedOptions & 0x800) != 2048) {
                this.sendMarker(2, (byte)3);
            }
        } else {
            this.sendMarker(1, (byte)3);
        }
    }

    @Override
    public NetInputStream getNetInputStream() throws NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        return this.sAtts.nsInputStream;
    }

    @Override
    public InputStream getInputStream() throws NetException {
        return this.getNetInputStream();
    }

    @Override
    public NetOutputStream getNetOutputStream() throws NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        return this.sAtts.nsOutputStream;
    }

    @Override
    public OutputStream getOutputStream() throws NetException {
        return this.getNetOutputStream();
    }

    @Override
    void initializeSessionAttributes() throws NetException, IOException {
        this.sAtts.ntInputStream = this.sAtts.cOption.nt.getInputStream();
        this.sAtts.ntOutputStream = this.sAtts.cOption.nt.getOutputStream();
        this.sAtts.dataEOF = false;
        if (this.sAtts.attemptingReconnect) {
            this.sAtts.nsOutputStream.reinitialize(this.sAtts);
            this.sAtts.nsInputStream.reinitialize(this.sAtts);
            if (this.mkPkt != null) {
                this.mkPkt.reinitialize(this.sAtts);
            }
        } else {
            this.sAtts.nsOutputStream = new NetOutputStream(this.sAtts, 255);
            this.sAtts.nsInputStream = new NetInputStream(this.sAtts);
        }
    }

    private void setNetStreams() throws NetException, IOException {
        this.sAtts.nsOutputStream = new NetOutputStream(this.sAtts);
        this.sAtts.nsInputStream = new NetInputStream(this.sAtts);
    }

    @Override
    protected void sendMarker(int n2, byte by) throws IOException, NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        this.mkPkt = new MarkerPacket(this.sAtts, n2, by);
        this.mkPkt.send();
        this.mkPkt = null;
    }

    @Override
    void sendProbePacket() throws IOException {
        if (this.probePacket == null) {
            this.probePacket = new DataPacket(this.sAtts, 26);
        } else {
            this.probePacket.reinitialize(this.sAtts);
        }
        this.probePacket.send();
    }

    @Override
    public void sendZDP() throws IOException {
        DataPacket dataPacket = new DataPacket(this.sAtts, 10);
        dataPacket.send();
    }

    @Override
    public boolean needsToBeClosed() {
        return this.sAtts.needsToBeClosed;
    }

    @Override
    public void readInbandNotification() {
    }

    @Override
    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    static {
        try {
            $$$methodRef$$$22 = NSProtocolStream.class.getDeclaredConstructor(SecuredLogger.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$21 = NSProtocolStream.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$20 = NSProtocolStream.class.getDeclaredMethod("readInbandNotification", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$19 = NSProtocolStream.class.getDeclaredMethod("needsToBeClosed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$18 = NSProtocolStream.class.getDeclaredMethod("sendZDP", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$17 = NSProtocolStream.class.getDeclaredMethod("sendProbePacket", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$16 = NSProtocolStream.class.getDeclaredMethod("sendMarker", Integer.TYPE, Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$15 = NSProtocolStream.class.getDeclaredMethod("setNetStreams", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$14 = NSProtocolStream.class.getDeclaredMethod("initializeSessionAttributes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$13 = NSProtocolStream.class.getDeclaredMethod("getOutputStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$12 = NSProtocolStream.class.getDeclaredMethod("getNetOutputStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$11 = NSProtocolStream.class.getDeclaredMethod("getInputStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$10 = NSProtocolStream.class.getDeclaredMethod("getNetInputStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$9 = NSProtocolStream.class.getDeclaredMethod("sendInterrupt", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$8 = NSProtocolStream.class.getDeclaredMethod("sendBreak", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$7 = NSProtocolStream.class.getDeclaredMethod("sendReset", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$6 = NSProtocolStream.class.getDeclaredMethod("disconnect", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$5 = NSProtocolStream.class.getDeclaredMethod("writeZeroCopyIOData", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$4 = NSProtocolStream.class.getDeclaredMethod("writeZeroCopyIOHeader", Boolean.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$3 = NSProtocolStream.class.getDeclaredMethod("readZeroCopyIO", byte[].class, Integer.TYPE, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$2 = NSProtocolStream.class.getDeclaredMethod("writeZeroCopyIO", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$1 = NSProtocolStream.class.getDeclaredMethod("negotiateConnectionAsync", NVFactory.class, NVNavigator.class, Boolean.TYPE, Boolean.TYPE, DMSFactory.DMSNoun.class, AsyncOutboundTimeoutHandler.class, Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$0 = NSProtocolStream.class.getDeclaredMethod("negotiateConnection", NVFactory.class, NVNavigator.class, Boolean.TYPE, Boolean.TYPE, DMSFactory.DMSNoun.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
    }
}

