/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.net.ns.NetException;
import oracle.net.ns.Packet;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.ZLIBCodec;

public class AcceptPacket
extends Packet
implements SQLnetDef {
    protected int version;
    protected int options;
    protected int sduSize;
    protected int tduSize;
    protected int myHWByteOrder;
    protected int flag0;
    protected int flag1;
    String connectData;
    boolean isOOBCheckEnabled;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;

    public AcceptPacket(Packet packet) throws IOException, NetException {
        super(packet);
        int n2;
        this.version = this.buffer[8] & 0xFF;
        this.version <<= 8;
        this.version |= this.buffer[9] & 0xFF;
        this.options = this.buffer[10] & 0xFF;
        this.options <<= 8;
        this.options |= this.buffer[11] & 0xFF;
        this.sduSize = this.buffer[12] & 0xFF;
        this.sduSize <<= 8;
        this.sduSize |= this.buffer[13] & 0xFF;
        this.tduSize = this.buffer[14] & 0xFF;
        this.tduSize <<= 8;
        this.tduSize |= this.buffer[15] & 0xFF;
        this.myHWByteOrder = this.buffer[16] & 0xFF;
        this.myHWByteOrder <<= 8;
        this.myHWByteOrder |= this.buffer[17] & 0xFF;
        this.dataLen = this.buffer[18] & 0xFF;
        this.dataLen <<= 8;
        this.dataLen |= this.buffer[19] & 0xFF;
        this.dataOff = this.buffer[20] & 0xFF;
        this.dataOff <<= 8;
        this.dataOff |= this.buffer[21] & 0xFF;
        this.flag0 = this.buffer[22];
        this.flag1 = this.buffer[23];
        boolean bl = this.sAtts.noAnoServices = (this.flag1 & 8) == 8;
        if (!this.sAtts.noAnoServices) {
            this.sAtts.noAnoServices = (this.flag0 & 4) == 4;
        }
        this.sAtts.timeout = AcceptPacket.toUb2(this.buffer, 24);
        this.sAtts.tick = AcceptPacket.toUb2(this.buffer, 26);
        this.sAtts.timeout -= this.sAtts.tick;
        this.sAtts.timeout *= 10;
        int n3 = AcceptPacket.toUb2(this.buffer, 28);
        int n4 = AcceptPacket.toUb2(this.buffer, 30);
        if (n3 > 0) {
            this.sAtts.reconnectAddress = new byte[n3];
            System.arraycopy(this.buffer, n4, this.sAtts.reconnectAddress, 0, n3);
        }
        if (this.version >= 315) {
            this.sduSize = AcceptPacket.toUb4(this.buffer, 32);
            this.tduSize = AcceptPacket.toUb4(this.buffer, 36);
            this.sAtts.isLargeSDU = true;
            n2 = this.buffer[40];
            boolean bl2 = true;
            if (!this.sAtts.cOption.protocol.equalsIgnoreCase("tcp") && (n2 & 2) == 0) {
                bl2 = false;
            }
            if (bl2 && (n2 & 0x80) != 0) {
                this.sAtts.negotiatedNetworkCompression = (n2 & 0x40) != 0 ? "auto" : "on";
                this.sAtts.negotiatedNetworkCompressionScheme = (n2 & 0x3C) >> 2;
                this.sAtts.networkCompressionEnabled = true;
                if (this.sAtts.negotiatedNetworkCompressionScheme == 1) {
                    throw new IOException("Unsupported Compression Scheme");
                }
                if (this.sAtts.negotiatedNetworkCompressionScheme == 2) {
                    this.sAtts.compressionCodec = new ZLIBCodec();
                }
            } else {
                this.sAtts.negotiatedNetworkCompression = "off";
                this.sAtts.networkCompressionEnabled = false;
            }
        }
        if (this.version >= 318) {
            n2 = AcceptPacket.toUb4(this.buffer, 41);
            this.isOOBCheckEnabled = !this.sAtts.noAnoServices && (n2 & 1) > 0;
        }
        if (this.sAtts.timeout > 0) {
            n2 = this.dataLen + this.dataOff;
            this.sAtts.poolEnabled = true;
            this.sAtts.sessionId = new byte[16];
            System.arraycopy(this.buffer, n2, this.sAtts.sessionId, 0, 16);
            this.sAtts.nsInputStream.poolEnabled(true);
            this.sAtts.nsOutputStream.poolEnabled(true);
            this.sAtts.timestampLastIO = System.currentTimeMillis();
        }
        this.extractData();
        this.connectData = this.getData();
        this.sAtts.setSDU(this.sduSize);
        this.sAtts.setTDU(this.tduSize);
        this.sAtts.negotiatedSDU = this.sdu;
        if (this.tduSize < this.sduSize) {
            this.sAtts.setSDU(this.tduSize);
        }
        this.sAtts.setNegotiatedOptions(this.options);
    }

    @DisableTrace
    public String toString() {
        return "version=" + this.version + ", options=" + this.options + ", sduSize=" + this.sduSize + ", tduSize=" + this.tduSize + "\nmyHWByteOrder=" + this.myHWByteOrder + ", dataLen=" + this.dataLen + ", flag0=" + this.flag0 + ", flag1=" + this.flag1 + "\n" + (String)(this.sAtts.poolEnabled ? "timeout=" + this.sAtts.timeout + ",re-connect: " + this.sAtts.reconnectAddress + "\n(byte)Dumping session-id:\n" + this.dumpBytes(this.sAtts.sessionId, 0, 16) : "") + "\n\n";
    }

    static {
        try {
            $$$methodRef$$$0 = AcceptPacket.class.getDeclaredConstructor(Packet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

