/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringBufferInputStream;
import java.io.Writer;
import java.lang.reflect.Executable;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.ROWSET})
public class OracleSerialClob
implements Clob,
NClob,
Serializable,
Cloneable {
    private static final int MAX_CHAR_BUFFER_SIZE = 1024;
    private char[] buffer;
    private long length;
    private boolean isFreed = false;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;

    public OracleSerialClob(char[] cArray) throws SQLException {
        if (cArray == null) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        this.length = cArray.length;
        this.buffer = new char[(int)this.length];
        int n2 = 0;
        while ((long)n2 < this.length) {
            this.buffer[n2] = cArray[n2];
            ++n2;
        }
    }

    public OracleSerialClob(Clob clob) throws SQLException {
        if (clob == null) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        this.length = clob.length();
        this.buffer = new char[(int)this.length];
        BufferedReader bufferedReader = new BufferedReader(clob.getCharacterStream());
        try {
            int n2 = 0;
            int n3 = 0;
            do {
                n2 = bufferedReader.read(this.buffer, n3, (int)(this.length - (long)n3));
                n3 += n2;
            } while (n2 > 0);
        }
        catch (IOException iOException) {
            throw (SQLException)DatabaseError.createSqlException(null, 347, iOException.getMessage()).fillInStackTrace();
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                throw (SQLException)DatabaseError.createSqlException(null, 347, iOException.getMessage()).fillInStackTrace();
            }
        }
    }

    public OracleSerialClob(Reader reader) throws SQLException {
        if (reader == null) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        try {
            int n2 = 0;
            char[] cArray = new char[1024];
            StringBuilder stringBuilder = new StringBuilder(1024);
            while ((n2 = reader.read(cArray)) != -1) {
                stringBuilder.append(cArray, 0, n2);
            }
            reader.close();
            this.buffer = stringBuilder.toString().toCharArray();
            this.length = this.buffer.length;
        }
        catch (Exception exception) {
            throw (SQLException)DatabaseError.createSqlException(null, 347, exception.getMessage()).fillInStackTrace();
        }
    }

    public OracleSerialClob(Reader reader, long l2) throws SQLException {
        if (reader == null) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        try {
            int n2 = 0;
            char[] cArray = new char[1024];
            StringBuilder stringBuilder = new StringBuilder(1024);
            for (long i2 = l2; i2 > 0L && (n2 = reader.read(cArray, 0, Math.min(1024, (int)i2))) != -1; i2 -= (long)n2) {
                stringBuilder.append(cArray, 0, n2);
            }
            reader.close();
            this.buffer = stringBuilder.toString().toCharArray();
            this.length = this.buffer.length;
        }
        catch (Exception exception) {
            throw (SQLException)DatabaseError.createSqlException(null, 347, exception.getMessage()).fillInStackTrace();
        }
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        if (this.isFreed) {
            throw (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
        }
        return new StringBufferInputStream(new String(this.buffer));
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        if (this.isFreed) {
            throw (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
        }
        return new CharArrayReader(this.buffer);
    }

    @Override
    public String getSubString(long l2, int n2) throws SQLException {
        if (this.isFreed) {
            throw (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
        }
        if (l2 < 1L || n2 < 0 || (long)n2 > this.length || l2 + (long)n2 - 1L > this.length) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        if (n2 == 0) {
            return new String();
        }
        return new String(this.buffer, (int)l2 - 1, n2);
    }

    @Override
    public long length() throws SQLException {
        if (this.isFreed) {
            throw (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
        }
        return this.length;
    }

    @Override
    public long position(String string, long l2) throws SQLException {
        if (this.isFreed) {
            throw (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
        }
        if (l2 < 1L) {
            throw (SQLException)DatabaseError.createSqlException(null, 68, "position()").fillInStackTrace();
        }
        if (l2 > this.length || l2 + (long)string.length() - 1L > this.length) {
            return -1L;
        }
        char[] cArray = string.toCharArray();
        int n2 = (int)(l2 - 1L);
        boolean bl = false;
        long l3 = cArray.length;
        while ((long)n2 < this.length) {
            int n3 = 0;
            long l4 = n2 + 1;
            int n4 = n2;
            while ((long)n3 < l3 && (long)n4 < this.length && cArray[n3] == this.buffer[n4]) {
                ++n4;
                if ((long)(++n3) != l3) continue;
                return l4;
            }
            ++n2;
        }
        return -1L;
    }

    @Override
    public long position(Clob clob, long l2) throws SQLException {
        if (this.isFreed) {
            throw (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
        }
        return this.position(clob.getSubString(1L, (int)clob.length()), l2);
    }

    @Override
    public int setString(long l2, String string) throws SQLException {
        if (this.isFreed) {
            throw (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
        }
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public int setString(long l2, String string, int n2, int n3) throws SQLException {
        if (this.isFreed) {
            throw (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
        }
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public OutputStream setAsciiStream(long l2) throws SQLException {
        if (this.isFreed) {
            throw (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
        }
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public Writer setCharacterStream(long l2) throws SQLException {
        if (this.isFreed) {
            throw (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
        }
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public void truncate(long l2) throws SQLException {
        if (this.isFreed) {
            throw (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
        }
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public void free() throws SQLException {
        if (this.isFreed) {
            return;
        }
        this.isFreed = true;
        this.buffer = null;
        this.length = 0L;
    }

    @Override
    public Reader getCharacterStream(long l2, long l3) throws SQLException {
        if (this.isFreed) {
            throw (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
        }
        if (--l2 < 0L || l2 + 1L > this.length || l3 < 0L || l3 > this.length || l2 + l3 > this.length) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        return new CharArrayReader(this.buffer, (int)l2, (int)l3);
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    static {
        try {
            $$$methodRef$$$17 = OracleSerialClob.class.getDeclaredConstructor(Reader.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleSerialClob.class.getDeclaredConstructor(Reader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleSerialClob.class.getDeclaredConstructor(Clob.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleSerialClob.class.getDeclaredConstructor(char[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleSerialClob.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleSerialClob.class.getDeclaredMethod("getCharacterStream", Long.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleSerialClob.class.getDeclaredMethod("free", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleSerialClob.class.getDeclaredMethod("truncate", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleSerialClob.class.getDeclaredMethod("setCharacterStream", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleSerialClob.class.getDeclaredMethod("setAsciiStream", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleSerialClob.class.getDeclaredMethod("setString", Long.TYPE, String.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleSerialClob.class.getDeclaredMethod("setString", Long.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleSerialClob.class.getDeclaredMethod("position", Clob.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleSerialClob.class.getDeclaredMethod("position", String.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleSerialClob.class.getDeclaredMethod("length", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleSerialClob.class.getDeclaredMethod("getSubString", Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleSerialClob.class.getDeclaredMethod("getCharacterStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleSerialClob.class.getDeclaredMethod("getAsciiStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

