/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.parser;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.logging.Logger;
import oracle.jdbc.driver.json.BufferPoolImpl;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.parser.JsonLocationImpl;
import oracle.sql.json.OracleJsonParser;

final class JsonTokenizer
implements Closeable {
    private static final int[] HEX;
    private static final int HEX_LENGTH;
    private final BufferPoolImpl bufferPool;
    private final Reader reader;
    private char[] buf;
    private int readBegin;
    private int readEnd;
    private int storeBegin;
    private int storeEnd;
    private long lineNo = 1L;
    private long lastLineOffset = 0L;
    private long bufferOffset = 0L;
    private boolean minus;
    private boolean fracOrExp;
    private BigDecimal bd;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;

    JsonTokenizer(Reader reader, BufferPoolImpl bufferPoolImpl) {
        this.reader = reader;
        this.bufferPool = bufferPoolImpl;
        this.buf = bufferPoolImpl.take();
    }

    private OracleJsonExceptions.ExceptionFactory factory() {
        return OracleJsonExceptions.ORACLE_FACTORY;
    }

    private void readString() {
        int n2;
        boolean bl = true;
        this.storeBegin = this.storeEnd = this.readBegin;
        block4: while (true) {
            if (bl) {
                while (this.readBegin < this.readEnd && (n2 = this.buf[this.readBegin]) >= 32 && n2 != 92) {
                    if (n2 == 34) {
                        this.storeEnd = this.readBegin++;
                        return;
                    }
                    ++this.readBegin;
                }
                this.storeEnd = this.readBegin;
            }
            if ((n2 = this.read()) >= 32 && n2 != 34 && n2 != 92) {
                if (!bl) {
                    this.buf[this.storeEnd] = (char)n2;
                }
                ++this.storeEnd;
                continue;
            }
            switch (n2) {
                case 92: {
                    bl = false;
                    this.unescape();
                    continue block4;
                }
                case 34: {
                    return;
                }
            }
            break;
        }
        throw this.unexpectedChar(n2);
    }

    private void unescape() {
        int n2 = this.read();
        switch (n2) {
            case 98: {
                this.buf[this.storeEnd++] = 8;
                break;
            }
            case 116: {
                this.buf[this.storeEnd++] = 9;
                break;
            }
            case 110: {
                this.buf[this.storeEnd++] = 10;
                break;
            }
            case 102: {
                this.buf[this.storeEnd++] = 12;
                break;
            }
            case 114: {
                this.buf[this.storeEnd++] = 13;
                break;
            }
            case 34: 
            case 47: 
            case 92: {
                this.buf[this.storeEnd++] = (char)n2;
                break;
            }
            case 117: {
                int n3 = 0;
                for (int i2 = 0; i2 < 4; ++i2) {
                    int n4;
                    int n5 = this.read();
                    int n6 = n4 = n5 >= 0 && n5 < HEX_LENGTH ? HEX[n5] : -1;
                    if (n4 < 0) {
                        throw this.unexpectedChar(n5);
                    }
                    n3 = n3 << 4 | n4;
                }
                this.buf[this.storeEnd++] = (char)n3;
                break;
            }
            default: {
                throw this.unexpectedChar(n2);
            }
        }
    }

    private int readNumberChar() {
        if (this.readBegin < this.readEnd) {
            return this.buf[this.readBegin++];
        }
        this.storeEnd = this.readBegin;
        return this.read();
    }

    private void readNumber(int n2) {
        int n3;
        this.storeBegin = this.storeEnd = this.readBegin - 1;
        if (n2 == 45) {
            this.minus = true;
            n2 = this.readNumberChar();
            if (n2 < 48 || n2 > 57) {
                throw this.unexpectedChar(n2);
            }
        }
        if (n2 == 48) {
            n2 = this.readNumberChar();
        } else {
            while ((n2 = this.readNumberChar()) >= 48 && n2 <= 57) {
            }
        }
        if (n2 == 46) {
            this.fracOrExp = true;
            n3 = 0;
            do {
                n2 = this.readNumberChar();
                ++n3;
            } while (n2 >= 48 && n2 <= 57);
            if (n3 == 1) {
                throw this.unexpectedChar(n2);
            }
        }
        if (n2 == 101 || n2 == 69) {
            this.fracOrExp = true;
            n2 = this.readNumberChar();
            if (n2 == 43 || n2 == 45) {
                n2 = this.readNumberChar();
            }
            n3 = 0;
            while (n2 >= 48 && n2 <= 57) {
                n2 = this.readNumberChar();
                ++n3;
            }
            if (n3 == 0) {
                throw this.unexpectedChar(n2);
            }
        }
        if (n2 != -1) {
            --this.readBegin;
            this.storeEnd = this.readBegin;
        }
    }

    private void readTrue() {
        int n2 = this.read();
        if (n2 != 114) {
            throw this.expectedChar(n2, 'r');
        }
        int n3 = this.read();
        if (n3 != 117) {
            throw this.expectedChar(n3, 'u');
        }
        int n4 = this.read();
        if (n4 != 101) {
            throw this.expectedChar(n4, 'e');
        }
    }

    private void readFalse() {
        int n2 = this.read();
        if (n2 != 97) {
            throw this.expectedChar(n2, 'a');
        }
        int n3 = this.read();
        if (n3 != 108) {
            throw this.expectedChar(n3, 'l');
        }
        int n4 = this.read();
        if (n4 != 115) {
            throw this.expectedChar(n4, 's');
        }
        int n5 = this.read();
        if (n5 != 101) {
            throw this.expectedChar(n5, 'e');
        }
    }

    private void readNull() {
        int n2 = this.read();
        if (n2 != 117) {
            throw this.expectedChar(n2, 'u');
        }
        int n3 = this.read();
        if (n3 != 108) {
            throw this.expectedChar(n3, 'l');
        }
        int n4 = this.read();
        if (n4 != 108) {
            throw this.expectedChar(n4, 'l');
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    JsonToken nextToken() {
        this.reset();
        int n2 = this.read();
        while (n2 == 32 || n2 == 9 || n2 == 10 || n2 == 13) {
            block19: {
                if (n2 == 13) {
                    ++this.lineNo;
                    n2 = this.read();
                    if (n2 == 10) {
                        this.lastLineOffset = this.bufferOffset + (long)this.readBegin;
                        break block19;
                    } else {
                        this.lastLineOffset = this.bufferOffset + (long)this.readBegin - 1L;
                        continue;
                    }
                }
                if (n2 == 10) {
                    ++this.lineNo;
                    this.lastLineOffset = this.bufferOffset + (long)this.readBegin;
                }
            }
            n2 = this.read();
        }
        switch (n2) {
            case 34: {
                this.readString();
                return JsonToken.STRING;
            }
            case 123: {
                return JsonToken.CURLYOPEN;
            }
            case 91: {
                return JsonToken.SQUAREOPEN;
            }
            case 58: {
                return JsonToken.COLON;
            }
            case 44: {
                return JsonToken.COMMA;
            }
            case 116: {
                this.readTrue();
                return JsonToken.TRUE;
            }
            case 102: {
                this.readFalse();
                return JsonToken.FALSE;
            }
            case 110: {
                this.readNull();
                return JsonToken.NULL;
            }
            case 93: {
                return JsonToken.SQUARECLOSE;
            }
            case 125: {
                return JsonToken.CURLYCLOSE;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.readNumber(n2);
                return JsonToken.NUMBER;
            }
            case -1: {
                return JsonToken.EOF;
            }
        }
        throw this.unexpectedChar(n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean hasNextToken() {
        this.reset();
        int n2 = this.peek();
        while (n2 == 32 || n2 == 9 || n2 == 10 || n2 == 13) {
            block5: {
                if (n2 == 13) {
                    ++this.lineNo;
                    ++this.readBegin;
                    n2 = this.peek();
                    if (n2 == 10) {
                        this.lastLineOffset = this.bufferOffset + (long)this.readBegin + 1L;
                        break block5;
                    } else {
                        this.lastLineOffset = this.bufferOffset + (long)this.readBegin;
                        continue;
                    }
                }
                if (n2 == 10) {
                    ++this.lineNo;
                    this.lastLineOffset = this.bufferOffset + (long)this.readBegin + 1L;
                }
            }
            ++this.readBegin;
            n2 = this.peek();
        }
        if (n2 == -1) return false;
        return true;
    }

    private int peek() {
        try {
            if (this.readBegin == this.readEnd) {
                int n2 = this.fillBuf();
                if (n2 == -1) {
                    return -1;
                }
                assert (n2 != 0);
                this.readBegin = this.storeEnd;
                this.readEnd = this.readBegin + n2;
            }
            return this.buf[this.readBegin];
        }
        catch (IOException iOException) {
            throw OracleJsonExceptions.IO.create(this.factory(), iOException, new Object[0]);
        }
    }

    JsonLocationImpl getLastCharLocation() {
        return new JsonLocationImpl(this.lineNo, this.bufferOffset + (long)this.readBegin - this.lastLineOffset, this.bufferOffset + (long)this.readBegin - 1L);
    }

    JsonLocationImpl getLocation() {
        return new JsonLocationImpl(this.lineNo, this.bufferOffset + (long)this.readBegin - this.lastLineOffset + 1L, this.bufferOffset + (long)this.readBegin);
    }

    private int read() {
        try {
            if (this.readBegin == this.readEnd) {
                int n2 = this.fillBuf();
                if (n2 == -1) {
                    return -1;
                }
                assert (n2 != 0);
                this.readBegin = this.storeEnd;
                this.readEnd = this.readBegin + n2;
            }
            return this.buf[this.readBegin++];
        }
        catch (IOException iOException) {
            throw OracleJsonExceptions.IO.create(this.factory(), iOException, new Object[0]);
        }
    }

    private int fillBuf() throws IOException {
        if (this.storeEnd != 0) {
            int n2 = this.storeEnd - this.storeBegin;
            if (n2 > 0) {
                if (n2 == this.buf.length) {
                    char[] cArray = Arrays.copyOf(this.buf, 2 * this.buf.length);
                    this.bufferPool.recycle(this.buf);
                    this.buf = cArray;
                } else {
                    System.arraycopy(this.buf, this.storeBegin, this.buf, 0, n2);
                    this.storeEnd = n2;
                    this.storeBegin = 0;
                    this.bufferOffset += (long)(this.readBegin - this.storeEnd);
                }
            } else {
                this.storeEnd = 0;
                this.storeBegin = 0;
                this.bufferOffset += (long)this.readBegin;
            }
        } else {
            this.bufferOffset += (long)this.readBegin;
        }
        return this.reader.read(this.buf, this.storeEnd, this.buf.length - this.storeEnd);
    }

    private void reset() {
        if (this.storeEnd != 0) {
            this.storeBegin = 0;
            this.storeEnd = 0;
            this.bd = null;
            this.minus = false;
            this.fracOrExp = false;
        }
    }

    String getValue() {
        return new String(this.buf, this.storeBegin, this.storeEnd - this.storeBegin);
    }

    BigDecimal getBigDecimal() {
        if (this.bd == null) {
            this.bd = new BigDecimal(this.buf, this.storeBegin, this.storeEnd - this.storeBegin);
        }
        return this.bd;
    }

    int getInt() {
        int n2 = this.storeEnd - this.storeBegin;
        if (!this.fracOrExp && (n2 <= 9 || this.minus && n2 <= 10)) {
            int n3;
            int n4 = 0;
            int n5 = n3 = this.minus ? 1 : 0;
            while (n3 < n2) {
                n4 = n4 * 10 + (this.buf[this.storeBegin + n3] - 48);
                ++n3;
            }
            return this.minus ? -n4 : n4;
        }
        return this.getBigDecimal().intValue();
    }

    long getLong() {
        int n2 = this.storeEnd - this.storeBegin;
        if (!this.fracOrExp && (n2 <= 18 || this.minus && n2 <= 19)) {
            int n3;
            long l2 = 0L;
            int n4 = n3 = this.minus ? 1 : 0;
            while (n3 < n2) {
                l2 = l2 * 10L + (long)(this.buf[this.storeBegin + n3] - 48);
                ++n3;
            }
            return this.minus ? -l2 : l2;
        }
        return this.getBigDecimal().longValue();
    }

    boolean isDefinitelyInt() {
        int n2 = this.storeEnd - this.storeBegin;
        return !this.fracOrExp && (n2 <= 9 || this.minus && n2 <= 10);
    }

    boolean isDefinitelyLong() {
        int n2 = this.storeEnd - this.storeBegin;
        return !this.fracOrExp && (n2 <= 18 || this.minus && n2 <= 19);
    }

    boolean isIntegral() {
        return !this.fracOrExp || this.getBigDecimal().scale() == 0;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
        this.bufferPool.recycle(this.buf);
    }

    private RuntimeException unexpectedChar(int n2) {
        JsonLocationImpl jsonLocationImpl = this.getLastCharLocation();
        return OracleJsonExceptions.TOKEN_UNEXPECTED_CHAR.create(this.factory(), this.chToString(n2), jsonLocationImpl.getLineNumber(), jsonLocationImpl.getColumnNumber());
    }

    private RuntimeException expectedChar(int n2, char c2) {
        JsonLocationImpl jsonLocationImpl = this.getLastCharLocation();
        return OracleJsonExceptions.TOKEN_EXPECTED_CHAR.create(this.factory(), this.chToString(n2), jsonLocationImpl.getLineNumber(), jsonLocationImpl.getColumnNumber(), this.chToString(c2));
    }

    private String chToString(int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 >= 32 && n2 <= 126) {
            stringBuilder.append("'");
            stringBuilder.appendCodePoint(n2);
            stringBuilder.append("'");
        } else {
            stringBuilder.append("0x");
            stringBuilder.append(Integer.toHexString(n2));
        }
        return stringBuilder.toString();
    }

    static {
        int n2;
        try {
            $$$methodRef$$$27 = JsonTokenizer.class.getDeclaredConstructor(Reader.class, BufferPoolImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = JsonTokenizer.class.getDeclaredMethod("chToString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = JsonTokenizer.class.getDeclaredMethod("expectedChar", Integer.TYPE, Character.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = JsonTokenizer.class.getDeclaredMethod("unexpectedChar", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = JsonTokenizer.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = JsonTokenizer.class.getDeclaredMethod("isIntegral", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = JsonTokenizer.class.getDeclaredMethod("isDefinitelyLong", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = JsonTokenizer.class.getDeclaredMethod("isDefinitelyInt", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = JsonTokenizer.class.getDeclaredMethod("getLong", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = JsonTokenizer.class.getDeclaredMethod("getInt", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = JsonTokenizer.class.getDeclaredMethod("getBigDecimal", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = JsonTokenizer.class.getDeclaredMethod("getValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = JsonTokenizer.class.getDeclaredMethod("reset", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = JsonTokenizer.class.getDeclaredMethod("fillBuf", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = JsonTokenizer.class.getDeclaredMethod("read", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = JsonTokenizer.class.getDeclaredMethod("getLocation", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = JsonTokenizer.class.getDeclaredMethod("getLastCharLocation", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = JsonTokenizer.class.getDeclaredMethod("peek", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = JsonTokenizer.class.getDeclaredMethod("hasNextToken", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = JsonTokenizer.class.getDeclaredMethod("nextToken", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = JsonTokenizer.class.getDeclaredMethod("readNull", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = JsonTokenizer.class.getDeclaredMethod("readFalse", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = JsonTokenizer.class.getDeclaredMethod("readTrue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = JsonTokenizer.class.getDeclaredMethod("readNumber", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = JsonTokenizer.class.getDeclaredMethod("readNumberChar", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = JsonTokenizer.class.getDeclaredMethod("unescape", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = JsonTokenizer.class.getDeclaredMethod("readString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = JsonTokenizer.class.getDeclaredMethod("factory", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        HEX = new int[128];
        Arrays.fill(HEX, -1);
        for (n2 = 48; n2 <= 57; ++n2) {
            JsonTokenizer.HEX[n2] = n2 - 48;
        }
        for (n2 = 65; n2 <= 70; ++n2) {
            JsonTokenizer.HEX[n2] = 10 + n2 - 65;
        }
        for (n2 = 97; n2 <= 102; ++n2) {
            JsonTokenizer.HEX[n2] = 10 + n2 - 97;
        }
        HEX_LENGTH = HEX.length;
    }

    static final class JsonToken
    extends Enum<JsonToken> {
        public static final /* enum */ JsonToken CURLYOPEN;
        public static final /* enum */ JsonToken SQUAREOPEN;
        public static final /* enum */ JsonToken COLON;
        public static final /* enum */ JsonToken COMMA;
        public static final /* enum */ JsonToken STRING;
        public static final /* enum */ JsonToken NUMBER;
        public static final /* enum */ JsonToken TRUE;
        public static final /* enum */ JsonToken FALSE;
        public static final /* enum */ JsonToken NULL;
        public static final /* enum */ JsonToken CURLYCLOSE;
        public static final /* enum */ JsonToken SQUARECLOSE;
        public static final /* enum */ JsonToken EOF;
        private final OracleJsonParser.Event event;
        private final boolean value;
        private static final /* synthetic */ JsonToken[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;

        public static JsonToken[] values() {
            return (JsonToken[])$VALUES.clone();
        }

        public static JsonToken valueOf(String string) {
            return Enum.valueOf(JsonToken.class, string);
        }

        private JsonToken(OracleJsonParser.Event event, boolean bl) {
            this.event = event;
            this.value = bl;
        }

        OracleJsonParser.Event getEvent() {
            return this.event;
        }

        boolean isValue() {
            return this.value;
        }

        static {
            try {
                $$$methodRef$$$4 = JsonToken.class.getDeclaredConstructor(String.class, Integer.TYPE, OracleJsonParser.Event.class, Boolean.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = JsonToken.class.getDeclaredMethod("isValue", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = JsonToken.class.getDeclaredMethod("getEvent", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = JsonToken.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = JsonToken.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            CURLYOPEN = new JsonToken(OracleJsonParser.Event.START_OBJECT, false);
            SQUAREOPEN = new JsonToken(OracleJsonParser.Event.START_ARRAY, false);
            COLON = new JsonToken(null, false);
            COMMA = new JsonToken(null, false);
            STRING = new JsonToken(OracleJsonParser.Event.VALUE_STRING, true);
            NUMBER = new JsonToken(OracleJsonParser.Event.VALUE_DECIMAL, true);
            TRUE = new JsonToken(OracleJsonParser.Event.VALUE_TRUE, true);
            FALSE = new JsonToken(OracleJsonParser.Event.VALUE_FALSE, true);
            NULL = new JsonToken(OracleJsonParser.Event.VALUE_NULL, true);
            CURLYCLOSE = new JsonToken(OracleJsonParser.Event.END_OBJECT, false);
            SQUARECLOSE = new JsonToken(OracleJsonParser.Event.END_ARRAY, false);
            EOF = new JsonToken(null, false);
            $VALUES = new JsonToken[]{CURLYOPEN, SQUAREOPEN, COLON, COMMA, STRING, NUMBER, TRUE, FALSE, NULL, CURLYCLOSE, SQUARECLOSE, EOF};
        }
    }
}

