/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateTimeCommonAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.Datum;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class TimestampAccessor
extends DateTimeCommonAccessor {
    static final int MAXLENGTH = 11;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;

    TimestampAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl) throws SQLException {
        super(Representation.TIMESTAMP, oracleStatement, 11, bl);
        this.init(oracleStatement, 180, 180, s2, bl);
        this.initForDataAccess(n3, n2, null);
    }

    TimestampAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, long l2, int n6, short s2) throws SQLException {
        super(Representation.TIMESTAMP, oracleStatement, 11, false);
        this.init(oracleStatement, 180, 180, s2, false);
        this.initForDescribe(180, n2, bl, n3, n4, n5, l2, n6, s2, null);
        this.initForDataAccess(0, n2, null);
    }

    @Override
    String getString(int n2) throws SQLException {
        if (this.isUseLess || this.isNull(n2)) {
            return null;
        }
        this.getBytesInternal(n2, this.tmpBytes);
        int n3 = this.getLength(n2);
        int n4 = this.oracleYear(this.tmpBytes);
        int n5 = -1;
        if (n3 == 11) {
            n5 = this.oracleNanos(this.tmpBytes);
        }
        int n6 = this.oracleHour(this.tmpBytes);
        String string = this.toText(n4, this.oracleMonth(this.tmpBytes) + 1, this.oracleDay(this.tmpBytes), n6, this.oracleMin(this.tmpBytes), this.oracleSec(this.tmpBytes), n5, n6 < 12, null);
        return string;
    }

    @Override
    Object getObject(int n2) throws SQLException {
        if (this.isUseLess || this.isNull(n2)) {
            return null;
        }
        if (this.externalType == 0) {
            if (this.statement.connection.j2ee13Compliant) {
                return this.getTimestamp(n2);
            }
            return this.getTIMESTAMP(n2);
        }
        switch (this.externalType) {
            case 93: {
                return this.getTimestamp(n2);
            }
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
    }

    @Override
    Datum getOracleObject(int n2) throws SQLException {
        return this.getTIMESTAMP(n2);
    }

    @Override
    Object getObject(int n2, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(n2);
    }

    static {
        try {
            $$$methodRef$$$5 = TimestampAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = TimestampAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Short.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = TimestampAccessor.class.getDeclaredMethod("getObject", Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = TimestampAccessor.class.getDeclaredMethod("getOracleObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = TimestampAccessor.class.getDeclaredMethod("getObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = TimestampAccessor.class.getDeclaredMethod("getString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

