/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.aq.AQAgent;
import oracle.jdbc.aq.AQDequeueOptions;
import oracle.jdbc.aq.AQEnqueueOptions;
import oracle.jdbc.aq.AQMessageProperties;
import oracle.jdbc.driver.AQAgentI;
import oracle.jdbc.driver.AQMessagePropertiesI;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIaqm;
import oracle.jdbc.driver.T4Ctoh;
import oracle.jdbc.internal.JMSDequeueOptions;
import oracle.jdbc.internal.JMSEnqueueOptions;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CTTIaqo {
    T4CConnection connection;
    T4CMAREngine meg;
    T4CTTIaqm aqm;
    T4Ctoh toh;
    private byte[] payload = null;
    private AQMessagePropertiesI aqMessageProperties = null;
    private JMSDequeueOptions jmsDequeueOptions = null;
    private byte[] outMsgId = null;
    private int aqxaqopt = 0;
    private JMSEnqueueOptions jmsEnqueueOptions;
    private boolean isAQMsg = false;
    private AQEnqueueOptions aqEnqueueOptions = null;
    private AQDequeueOptions aqDequeueOptions = null;
    private boolean isRawQueue = false;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;

    T4CTTIaqo(T4CConnection t4CConnection, int n2, JMSEnqueueOptions jMSEnqueueOptions, AQMessagePropertiesI aQMessagePropertiesI, JMSDequeueOptions jMSDequeueOptions, boolean bl) throws IOException, SQLException {
        this.initCommon(t4CConnection, n2, aQMessagePropertiesI, bl);
        this.jmsEnqueueOptions = jMSEnqueueOptions;
        this.jmsDequeueOptions = jMSDequeueOptions;
    }

    T4CTTIaqo(T4CConnection t4CConnection, int n2, AQEnqueueOptions aQEnqueueOptions, AQMessagePropertiesI aQMessagePropertiesI, AQDequeueOptions aQDequeueOptions, boolean bl) throws IOException, SQLException {
        this.isAQMsg = true;
        this.initCommon(t4CConnection, n2, aQMessagePropertiesI, bl);
        this.aqEnqueueOptions = aQEnqueueOptions;
        this.aqDequeueOptions = aQDequeueOptions;
    }

    void initCommon(T4CConnection t4CConnection, int n2, AQMessagePropertiesI aQMessagePropertiesI, boolean bl) {
        this.connection = t4CConnection;
        this.meg = this.connection.getMarshalEngine();
        this.aqxaqopt = n2;
        this.aqMessageProperties = aQMessagePropertiesI;
        this.toh = new T4Ctoh(t4CConnection);
        this.aqm = new T4CTTIaqm(this.connection, this.toh);
        this.isRawQueue = bl;
    }

    void unmarshal() throws IOException, SQLException {
        Object[] objectArray;
        int n2;
        int n3;
        int n4 = this.meg.unmarshalUB2();
        if (n4 > 0) {
            Object object;
            n3 = this.meg.unmarshalUB1();
            this.aqm.initToDefaultValues();
            this.aqm.receive();
            this.aqMessageProperties.setPriority(this.aqm.aqmpri);
            this.aqMessageProperties.setDelay(this.aqm.aqmdel);
            this.aqMessageProperties.setExpiration(this.aqm.aqmexp);
            if (this.aqm.aqmcorBytes != null) {
                object = this.meg.conv.CharBytesToString(this.aqm.aqmcorBytes, this.aqm.aqmcorBytesLength, true);
                this.aqMessageProperties.setCorrelation((String)object);
            }
            this.aqMessageProperties.setAttempts(this.aqm.aqmatt);
            if (this.aqm.aqmeqnBytes != null) {
                object = this.meg.conv.CharBytesToString(this.aqm.aqmeqnBytes, this.aqm.aqmeqnBytesLength, true);
                this.aqMessageProperties.setExceptionQueue((String)object);
            }
            this.aqMessageProperties.setMessageState(AQMessageProperties.MessageState.getMessageState(this.aqm.aqmsta));
            if (this.aqm.aqmeqt != null) {
                this.aqMessageProperties.setEnqueueTime(this.aqm.aqmeqt.timestampValue());
            }
            object = new AQAgentI();
            if (this.aqm.senderAgentName != null) {
                ((AQAgentI)object).setName(this.meg.conv.CharBytesToString(this.aqm.senderAgentName, this.aqm.senderAgentNameLength, true));
            }
            if (this.aqm.senderAgentAddress != null) {
                ((AQAgentI)object).setAddress(this.meg.conv.CharBytesToString(this.aqm.senderAgentAddress, this.aqm.senderAgentAddressLength, true));
            }
            ((AQAgentI)object).setProtocol(this.aqm.senderAgentProtocol);
            this.aqMessageProperties.setSender((AQAgent)object);
            this.aqMessageProperties.setPreviousQueueMessageId(this.aqm.originalMsgId);
            this.aqMessageProperties.setDeliveryMode(AQMessageProperties.DeliveryMode.getDeliveryMode(this.aqm.aqmflg));
            if (this.aqm.aqmetiBytes != null) {
                String string = this.meg.conv.CharBytesToString(this.aqm.aqmetiBytes, this.aqm.aqmetiBytes.length, true);
                this.aqMessageProperties.setTransactionGroup(string);
            }
        }
        if ((n3 = this.meg.unmarshalUB2()) > 0) {
            // empty if block
        }
        int n5 = this.meg.unmarshalUB2();
        if (this.aqxaqopt == 2) {
            this.toh.unmarshal(this.meg);
            n5 = this.toh.imageLength;
        }
        if (n5 > 0) {
            int n6 = n5;
            if (this.isRawQueue) {
                if (n5 > 4) {
                    n6 -= 4;
                }
                n2 = this.isAQMsg ? this.aqDequeueOptions.getMaximumBufferLength() : n6;
                n6 = Math.min(n6, n2);
                objectArray = new byte[n6];
                int[] nArray = new int[1];
                if (n5 > 4) {
                    this.meg.unmarshalCLR((byte[])objectArray, 0, nArray, objectArray.length, 4);
                } else {
                    this.meg.unmarshalCLR((byte[])objectArray, 0, nArray, objectArray.length);
                }
                this.payload = (byte[])objectArray;
            } else {
                byte[] byArray = new byte[n6];
                objectArray = new int[1];
                this.meg.unmarshalCLR(byArray, 0, (int[])objectArray, byArray.length);
                this.payload = byArray;
            }
        }
        int n7 = this.meg.unmarshalSWORD();
        if ((this.aqxaqopt == 1 && !this.isAQMsg && this.jmsEnqueueOptions != null && this.jmsEnqueueOptions.isRetrieveMessageId() || this.aqxaqopt == 2 && !this.isAQMsg && this.jmsDequeueOptions != null && this.jmsDequeueOptions.isRetrieveMessageId() || this.aqxaqopt == 1 && this.isAQMsg && this.aqEnqueueOptions != null && this.aqEnqueueOptions.getRetrieveMessageId() || this.aqxaqopt == 2 && this.isAQMsg && this.aqDequeueOptions != null && this.aqDequeueOptions.getRetrieveMessageId()) && n7 > 0) {
            byte[] byArray = new byte[n7];
            objectArray = new int[1];
            this.meg.unmarshalCLR(byArray, 0, (int[])objectArray);
            this.outMsgId = byArray;
        }
        if ((n2 = this.meg.unmarshalUB2()) > 0) {
            // empty if block
        }
        int n8 = this.meg.unmarshalUB2();
    }

    byte[] getMsgId() {
        return this.outMsgId;
    }

    byte[] getPayload() {
        return this.payload;
    }

    static {
        try {
            $$$methodRef$$$5 = T4CTTIaqo.class.getDeclaredConstructor(T4CConnection.class, Integer.TYPE, AQEnqueueOptions.class, AQMessagePropertiesI.class, AQDequeueOptions.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4CTTIaqo.class.getDeclaredConstructor(T4CConnection.class, Integer.TYPE, JMSEnqueueOptions.class, AQMessagePropertiesI.class, JMSDequeueOptions.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4CTTIaqo.class.getDeclaredMethod("getPayload", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4CTTIaqo.class.getDeclaredMethod("getMsgId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CTTIaqo.class.getDeclaredMethod("unmarshal", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CTTIaqo.class.getDeclaredMethod("initCommon", T4CConnection.class, Integer.TYPE, AQMessagePropertiesI.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

