/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DynamicByteArray;
import oracle.jdbc.driver.T4CTypeRep;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.net.ns.Communication;
import oracle.net.ns.NetException;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
abstract class T4CMAREngine {
    static final int TTCC_MXL = 252;
    static final int TTCC_ESC = 253;
    static final int TTCC_LNG = 254;
    static final int TTCC_ERR = 255;
    static final int TTCC_MXIN = Short.MAX_VALUE;
    static final int TTCC_MXIN_OLD = 64;
    private int effectiveTTCC_MXIN = 64;
    static final byte TTCLXMULTI = 1;
    static final byte TTCLXMCONV = 2;
    T4CTypeRep types;
    Communication net;
    DBConversion conv;
    short proSvrVer;
    static final byte[] NO_BYTES;
    boolean useCLRBigChunks = false;
    static final byte[] IGNORED;
    final byte[] tmpBuffer1 = new byte[1];
    final byte[] tmpBuffer2 = new byte[2];
    final byte[] tmpBuffer3 = new byte[3];
    final byte[] tmpBuffer4 = new byte[4];
    final byte[] tmpBuffer5 = new byte[5];
    final byte[] tmpBuffer6 = new byte[6];
    final byte[] tmpBuffer7 = new byte[7];
    final byte[] tmpBuffer8 = new byte[8];
    final byte[] tmpBuffer10 = new byte[10];
    final int[] retLen = new int[1];
    AtomicReference<OracleConnection> connForException = new AtomicReference();
    static final byte[] NULL_PTR;
    static final byte[] NOTNULL_PTR;
    ArrayList<byte[]> refVector = null;
    private ArrayList<byte[]> clrList = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;

    T4CMAREngine() {
    }

    static String toHex(long l2, int n2) {
        String string;
        switch (n2) {
            case 1: {
                string = "00" + Long.toString(l2 & 0xFFL, 16);
                break;
            }
            case 2: {
                string = "0000" + Long.toString(l2 & 0xFFFFL, 16);
                break;
            }
            case 3: {
                string = "000000" + Long.toString(l2 & 0xFFFFFFL, 16);
                break;
            }
            case 4: {
                string = "00000000" + Long.toString(l2 & 0xFFFFFFFFL, 16);
                break;
            }
            case 5: {
                string = "0000000000" + Long.toString(l2 & 0xFFFFFFFFFFL, 16);
                break;
            }
            case 6: {
                string = "000000000000" + Long.toString(l2 & 0xFFFFFFFFFFFFL, 16);
                break;
            }
            case 7: {
                string = "00000000000000" + Long.toString(l2 & 0xFFFFFFFFFFFFFFL, 16);
                break;
            }
            case 8: {
                return T4CMAREngine.toHex(l2 >> 32, 4) + T4CMAREngine.toHex(l2, 4).substring(2);
            }
            default: {
                return "more than 8 bytes";
            }
        }
        return "0x" + string.substring(string.length() - 2 * n2);
    }

    static String toHex(byte by) {
        String string = "00" + Integer.toHexString(by & 0xFF);
        return "0x" + string.substring(string.length() - 2);
    }

    static String toHex(short s2) {
        return T4CMAREngine.toHex(s2, 2);
    }

    static String toHex(int n2) {
        return T4CMAREngine.toHex(n2, 4);
    }

    static String toHex(byte[] byArray, int n2) {
        if (byArray == null) {
            return "null";
        }
        if (n2 > byArray.length) {
            return "byte array not long enough";
        }
        Object object = "[";
        int n3 = Math.min(64, n2);
        for (int i2 = 0; i2 < n3; ++i2) {
            object = (String)object + T4CMAREngine.toHex(byArray[i2]) + " ";
        }
        if (n3 < n2) {
            object = (String)object + "...";
        }
        return (String)object + "]";
    }

    static String toHex(byte[] byArray) {
        if (byArray == null) {
            return "null";
        }
        return T4CMAREngine.toHex(byArray, byArray.length);
    }

    abstract void marshalSB1(byte var1) throws IOException;

    abstract void marshalUB1(short var1) throws IOException;

    abstract void marshalSB2(short var1) throws IOException;

    abstract void marshalUB2(int var1) throws IOException;

    abstract void marshalNativeUB2(short var1, boolean var2) throws IOException;

    abstract void marshalSB4(int var1) throws IOException;

    abstract void marshalUB4(long var1) throws IOException;

    abstract void marshalUB8(long var1) throws IOException;

    abstract void marshalSB8(long var1) throws IOException;

    final void marshalSWORD(int n2) throws IOException {
        this.marshalSB4(n2);
    }

    final void marshalUWORD(long l2) throws IOException {
        this.marshalSB4((int)(l2 & 0xFFFFFFFFFFFFFFFFL));
    }

    abstract void marshalB1Array(byte[] var1) throws IOException;

    abstract void marshalB1Array(byte[] var1, int var2, int var3) throws IOException;

    final void marshalUB4Array(long[] lArray) throws IOException {
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            this.marshalSB4((int)(lArray[i2] & 0xFFFFFFFFFFFFFFFFL));
        }
    }

    final void marshalO2U(boolean bl) throws IOException {
        if (bl) {
            this.addPtr((byte)1);
        } else {
            this.addPtr((byte)0);
        }
    }

    final void marshalNULLPTR() throws IOException {
        this.addPtr((byte)0);
    }

    final void marshalPTR() throws IOException {
        this.addPtr((byte)1);
    }

    final void marshalCHR(byte[] byArray) throws IOException {
        this.marshalCHR(byArray, 0, byArray.length);
    }

    final void marshalCHR(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 > 0) {
            if (this.types.isConvNeeded()) {
                this.marshalCLR(byArray, n2, n3);
            } else {
                this.marshalB1Array(byArray, n2, n3);
            }
        }
    }

    final void marshalCLR(byte[] byArray, int n2) throws IOException {
        this.marshalCLR(byArray, 0, n2);
    }

    final void marshalCLR(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 > 252) {
            int n4;
            int n5 = 0;
            this.marshalUB1((short)-2);
            do {
                int n6;
                int n7 = n4 = (n6 = n3 - n5) > this.effectiveTTCC_MXIN ? this.effectiveTTCC_MXIN : n6;
                if (this.useCLRBigChunks) {
                    this.marshalSB4(n4);
                } else {
                    this.marshalUB1((byte)(n4 & 0xFF));
                }
                this.marshalB1Array(byArray, n2 + n5, n4);
            } while ((n5 += n4) < n3);
            this.marshalUB1((short)0);
        } else {
            this.marshalUB1((byte)(n3 & 0xFF));
            if (byArray.length != 0) {
                this.marshalB1Array(byArray, n2, n3);
            }
        }
    }

    final void marshalCLR(DynamicByteArray dynamicByteArray, long l2, int n2) throws IOException {
        if (n2 > 252) {
            int n3;
            int n4 = 0;
            this.marshalUB1((short)-2);
            do {
                int n5;
                int n6 = n3 = (n5 = n2 - n4) > this.effectiveTTCC_MXIN ? this.effectiveTTCC_MXIN : n5;
                if (this.useCLRBigChunks) {
                    this.marshalSB4(n3);
                } else {
                    this.marshalUB1((byte)(n3 & 0xFF));
                }
                dynamicByteArray.marshalB1Array(this, l2 + (long)n4, n3);
            } while ((n4 += n3) < n2);
            this.marshalUB1((short)0);
        } else {
            this.marshalUB1((byte)(n2 & 0xFF));
            if (dynamicByteArray.length != 0L) {
                dynamicByteArray.marshalB1Array(this, l2, n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void marshalCLR(InputStream inputStream, int n2) throws IOException {
        int n3 = this.effectiveTTCC_MXIN;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        boolean bl = false;
        this.marshalUB1((short)254);
        try {
            while (!bl) {
                n4 = inputStream.read(byArray, 0, n3);
                if (n4 == -1) {
                    bl = true;
                }
                if (n4 <= 0) continue;
                if (this.useCLRBigChunks) {
                    this.marshalSB4(n4);
                } else {
                    this.marshalUB1((byte)(n4 & 0xFF));
                }
                this.marshalB1Array(byArray, 0, n4);
            }
        }
        finally {
            this.marshalUB1((short)0);
        }
    }

    final void marshalKEYVAL(byte[][] byArray, int[] nArray, byte[][] byArray2, int[] nArray2, byte[] byArray3, int n2) throws IOException {
        for (int i2 = 0; i2 < n2; ++i2) {
            if (byArray[i2] != null && nArray[i2] > 0) {
                this.marshalUB4(nArray[i2]);
                this.marshalCLR(byArray[i2], 0, nArray[i2]);
            } else {
                this.marshalUB4(0L);
            }
            if (byArray2[i2] != null && nArray2[i2] > 0) {
                this.marshalUB4(nArray2[i2]);
                this.marshalCLR(byArray2[i2], 0, nArray2[i2]);
            } else {
                this.marshalUB4(0L);
            }
            if (byArray3[i2] != 0) {
                this.marshalUB4(1L);
                continue;
            }
            this.marshalUB4(0L);
        }
    }

    final void marshalKEYVAL(byte[][] byArray, byte[][] byArray2, byte[] byArray3, int n2) throws IOException {
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            if (byArray[i2] != null) {
                nArray[i2] = byArray[i2].length;
            }
            if (byArray2[i2] == null) continue;
            nArray2[i2] = byArray2[i2].length;
        }
        this.marshalKEYVAL(byArray, nArray, byArray2, nArray2, byArray3, n2);
    }

    final void marshalDALC(byte[] byArray) throws IOException {
        if (byArray == null || byArray.length < 1) {
            this.marshalUB4(0L);
        } else {
            this.marshalUB4(byArray.length);
            this.marshalCLR(byArray, byArray.length);
        }
    }

    final void marshalKPDKV(byte[][] byArray, byte[][] byArray2, int[] nArray) throws IOException {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2] != null) {
                this.marshalUB4(byArray[i2].length);
                this.marshalCLR(byArray[i2], 0, byArray[i2].length);
            } else {
                this.marshalUB4(0L);
            }
            if (byArray2[i2] != null) {
                this.marshalUB4(byArray2[i2].length);
                this.marshalCLR(byArray2[i2], 0, byArray2[i2].length);
            } else {
                this.marshalUB4(0L);
            }
            this.marshalUB2(nArray[i2]);
        }
    }

    final void unmarshalKPDKV(byte[][] byArray, int[] nArray, byte[][] byArray2, int[] nArray2) throws IOException, SQLException {
        int n2 = 0;
        int[] nArray3 = new int[1];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            n2 = (int)this.unmarshalUB4();
            if (n2 > 0) {
                byArray[i2] = new byte[n2];
                this.unmarshalCLR(byArray[i2], 0, nArray3, n2);
                nArray[i2] = nArray3[0];
            }
            if ((n2 = (int)this.unmarshalUB4()) > 0) {
                byArray2[i2] = new byte[n2];
                this.unmarshalCLR(byArray2[i2], 0, nArray3, n2);
            }
            nArray2[i2] = this.unmarshalUB2();
        }
    }

    final void addPtr(byte by) throws IOException {
        if (this.types.rep[4] == 1) {
            this.marshalUB1(by);
        } else if (by == 0) {
            this.marshalB1Array(NULL_PTR);
        } else {
            this.marshalB1Array(NOTNULL_PTR);
        }
    }

    abstract byte unmarshalSB1() throws SQLException, IOException;

    abstract short unmarshalUB1() throws SQLException, IOException;

    abstract short unmarshalSB2() throws SQLException, IOException;

    int unmarshalNativeUB2(boolean bl) throws SQLException, IOException {
        int n2 = 0;
        this.unmarshalNBytes(this.tmpBuffer2, 0, 2);
        n2 = bl ? this.tmpBuffer2[1] << 8 & 0xFF00 | this.tmpBuffer2[0] & 0xFF : this.tmpBuffer2[0] << 8 & 0xFF00 | this.tmpBuffer2[1] & 0xFF;
        return n2;
    }

    abstract int unmarshalUB2() throws SQLException, IOException;

    final int unmarshalUCS2(byte[] byArray, long l2) throws SQLException, IOException {
        int n2 = this.unmarshalUB2();
        this.tmpBuffer2[0] = (byte)((n2 & 0xFF00) >> 8);
        this.tmpBuffer2[1] = (byte)(n2 & 0xFF);
        if (l2 + 1L < (long)byArray.length) {
            byArray[(int)l2] = this.tmpBuffer2[0];
            byArray[(int)l2 + 1] = this.tmpBuffer2[1];
        }
        return this.tmpBuffer2[0] == 0 ? (this.tmpBuffer2[1] == 0 ? 1 : 2) : 3;
    }

    abstract int unmarshalSB4() throws SQLException, IOException;

    abstract long unmarshalUB4() throws SQLException, IOException;

    final int unmarshalSB4(byte[] byArray) throws SQLException, IOException {
        long l2 = this.buffer2Value((byte)2, new ByteArrayInputStream(byArray));
        return (int)l2;
    }

    final long unmarshalSB8() throws SQLException, IOException {
        long l2 = this.buffer2Value((byte)3);
        return l2;
    }

    final int unmarshalRefCursor(byte[] byArray) throws SQLException, IOException {
        int n2 = this.unmarshalSB4(byArray);
        return n2;
    }

    int unmarshalSWORD() throws SQLException, IOException {
        int n2 = (int)this.unmarshalUB4();
        return n2;
    }

    long unmarshalUWORD() throws SQLException, IOException {
        long l2 = this.unmarshalUB4();
        return l2;
    }

    abstract byte[] unmarshalNBytes(int var1) throws SQLException, IOException;

    abstract int unmarshalNBytes(byte[] var1, int var2, int var3) throws SQLException, IOException;

    abstract int getNBytes(byte[] var1, int var2, int var3) throws SQLException, IOException;

    abstract byte[] getNBytes(int var1) throws SQLException, IOException;

    abstract byte[] unmarshalTEXT(int var1) throws SQLException, IOException;

    byte[] unmarshalCHR(int n2) throws SQLException, IOException {
        byte[] byArray = null;
        if (this.types.isConvNeeded()) {
            byArray = this.unmarshalCLR(n2, this.retLen);
            if (byArray.length != this.retLen[0]) {
                byte[] byArray2 = new byte[this.retLen[0]];
                System.arraycopy(byArray, 0, byArray2, 0, this.retLen[0]);
                byArray = byArray2;
            }
        } else {
            byArray = this.getNBytes(n2);
        }
        return byArray;
    }

    void unmarshalCLR(byte[] byArray, int n2, int[] nArray) throws SQLException, IOException {
        this.unmarshalCLR(byArray, n2, nArray, Integer.MAX_VALUE);
    }

    void unmarshalCLR(byte[] byArray, int n2, int[] nArray, int n3) throws SQLException, IOException {
        this.unmarshalCLR(byArray, n2, nArray, n3, 0);
    }

    void unmarshalCLR(byte[] byArray, int n2, int[] nArray, int n3, int n4) throws SQLException, IOException {
        int n5 = 0;
        int n6 = 0;
        int n7 = n2;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        n5 = this.unmarshalUB1();
        if (n5 < 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
        }
        if (n5 == 0) {
            nArray[0] = 0;
            return;
        }
        if (this.escapeSequenceNull(n5)) {
            nArray[0] = 0;
            return;
        }
        if (n5 != 254) {
            if (n4 - n10 >= n5) {
                this.unmarshalBuffer(IGNORED, 0, n5);
                n10 += n5;
                n5 = 0;
            } else if (n4 - n10 > 0) {
                this.unmarshalBuffer(IGNORED, 0, n4 - n10);
                n5 -= n4 - n10;
                n10 += n4 - n10;
            }
            if (n5 > 0) {
                n9 = Math.min(n3 - n8, n5);
                n7 = this.unmarshalBuffer(byArray, n7, n9);
                n8 += n9;
                int n11 = n5 - n9;
                if (n11 > 0) {
                    this.unmarshalBuffer(IGNORED, 0, n11);
                }
            }
        } else {
            while (true) {
                int n12 = n5 = this.useCLRBigChunks ? this.unmarshalSB4() : (int)this.unmarshalUB1();
                if (n5 <= 0) break;
                if (n7 == -1) {
                    this.unmarshalBuffer(IGNORED, 0, n5);
                    continue;
                }
                n6 = n5;
                if (n4 - n10 >= n6) {
                    this.unmarshalBuffer(IGNORED, 0, n6);
                    n10 += n6;
                    n6 = 0;
                } else if (n4 - n10 > 0) {
                    this.unmarshalBuffer(IGNORED, 0, n4 - n10);
                    n6 -= n4 - n10;
                    n10 += n4 - n10;
                }
                if (n6 <= 0) continue;
                n9 = Math.min(n3 - n8, n6);
                n7 = this.unmarshalBuffer(byArray, n7, n9);
                n8 += n9;
                int n13 = n6 - n9;
                if (n13 <= 0) continue;
                this.unmarshalBuffer(IGNORED, 0, n13);
            }
        }
        if (nArray != null) {
            nArray[0] = n7 != -1 ? n8 : byArray.length - n2;
        }
    }

    final byte[] unmarshalCLR(int n2, int[] nArray) throws SQLException, IOException {
        byte[] byArray = new byte[n2 * this.conv.c2sNlsRatio];
        this.unmarshalCLR(byArray, 0, nArray, n2);
        return byArray;
    }

    final int[] unmarshalKEYVAL(byte[][] byArray, byte[][] byArray2, int n2) throws SQLException, IOException {
        byte[] byArray3 = new byte[1000];
        int[] nArray = new int[1];
        int[] nArray2 = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.unmarshalSB4();
            if (n3 > 0) {
                this.unmarshalCLR(byArray3, 0, nArray);
                byArray[i2] = new byte[nArray[0]];
                System.arraycopy(byArray3, 0, byArray[i2], 0, nArray[0]);
            }
            if ((n3 = this.unmarshalSB4()) > 0) {
                this.unmarshalCLR(byArray3, 0, nArray);
                byArray2[i2] = new byte[nArray[0]];
                System.arraycopy(byArray3, 0, byArray2[i2], 0, nArray[0]);
            }
            nArray2[i2] = this.unmarshalSB4();
        }
        byArray3 = null;
        return nArray2;
    }

    final int unmarshalBuffer(byte[] byArray, int n2, int n3) throws SQLException, IOException {
        if (n3 <= 0) {
            return n2;
        }
        if (byArray.length < n2 + n3) {
            this.unmarshalNBytes(byArray, n2, byArray.length - n2);
            this.unmarshalNBytes(IGNORED, 0, n2 + n3 - byArray.length);
            n2 = -1;
        } else {
            this.unmarshalNBytes(byArray, n2, n3);
            n2 += n3;
        }
        return n2;
    }

    final byte[] unmarshalCLRforREFS() throws SQLException, IOException {
        int n2 = 0;
        short s2 = 0;
        byte[] byArray = null;
        short s3 = this.unmarshalUB1();
        if (s3 < 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
        }
        if (s3 == 0) {
            return null;
        }
        boolean bl = this.escapeSequenceNull(s3);
        if (!bl) {
            if (this.refVector == null) {
                this.refVector = new ArrayList(10);
            } else {
                this.refVector.clear();
            }
        }
        if (!bl) {
            byte[] byArray2;
            if (s3 == 254) {
                while ((n2 = this.useCLRBigChunks ? this.unmarshalSB4() : (int)this.unmarshalUB1()) > 0) {
                    if (n2 == 254 && !this.useCLRBigChunks && this.types.isServerConversion()) continue;
                    s2 = (short)(s2 + n2);
                    byArray2 = new byte[n2];
                    this.unmarshalBuffer(byArray2, 0, n2);
                    this.refVector.add(byArray2);
                }
            } else {
                s2 = s3;
                byArray2 = new byte[s3];
                this.unmarshalBuffer(byArray2, 0, s3);
                this.refVector.add(byArray2);
            }
            byArray = new byte[s2];
            int n3 = 0;
            while (this.refVector.size() > 0) {
                int n4 = this.refVector.get(0).length;
                System.arraycopy(this.refVector.get(0), 0, byArray, n3, n4);
                n3 += n4;
                this.refVector.remove(0);
            }
        } else {
            byArray = null;
        }
        return byArray;
    }

    final byte[] unmarshalCLR() throws SQLException, IOException {
        int n2 = 0;
        short s2 = 0;
        byte[] byArray = null;
        short s3 = this.unmarshalUB1();
        if (s3 < 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
        }
        if (s3 == 0) {
            return null;
        }
        boolean bl = this.escapeSequenceNull(s3);
        if (!bl) {
            if (this.clrList == null) {
                this.clrList = new ArrayList(10);
            } else {
                this.clrList.clear();
            }
        }
        if (!bl) {
            byte[] byArray2;
            if (s3 == 254) {
                while ((n2 = this.useCLRBigChunks ? this.unmarshalSB4() : (int)this.unmarshalUB1()) > 0) {
                    s2 = (short)(s2 + n2);
                    byArray2 = new byte[n2];
                    this.unmarshalBuffer(byArray2, 0, n2);
                    this.clrList.add(byArray2);
                }
            } else {
                s2 = s3;
                byArray2 = new byte[s3];
                this.unmarshalBuffer(byArray2, 0, s3);
                this.clrList.add(byArray2);
            }
            byArray = new byte[s2];
            int n3 = 0;
            while (this.clrList.size() > 0) {
                int n4 = this.clrList.get(0).length;
                System.arraycopy(this.clrList.get(0), 0, byArray, n3, n4);
                n3 += n4;
                this.clrList.remove(0);
            }
        } else {
            byArray = null;
        }
        return byArray;
    }

    final boolean escapeSequenceNull(int n2) throws SQLException {
        boolean bl = false;
        switch (n2) {
            case 0: {
                bl = true;
                break;
            }
            case 253: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
            }
            case 255: {
                bl = true;
                break;
            }
            case 254: {
                break;
            }
        }
        return bl;
    }

    final int processIndicator(boolean bl, int n2) throws SQLException, IOException {
        short s2 = this.unmarshalSB2();
        int n3 = 0;
        if (!bl) {
            n3 = s2 == 0 ? n2 : (s2 == -2 || s2 > 0 ? (int)s2 : 65536 + s2);
        }
        return n3;
    }

    final int unmarshalDALC(byte[] byArray, int n2) throws SQLException, IOException {
        int n3 = (int)this.unmarshalUB4();
        if (n3 > 0) {
            this.unmarshalCLR(byArray, n2, this.retLen);
        }
        return n3;
    }

    final byte[] unmarshalDALC() throws SQLException, IOException {
        byte[] byArray;
        int n2 = (int)this.unmarshalUB4();
        if (n2 > 0) {
            byArray = this.unmarshalCLR(n2, this.retLen);
            if (byArray == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
            }
        } else {
            this.retLen[0] = 0;
            byArray = NO_BYTES;
        }
        return byArray;
    }

    final byte[] unmarshalDALC(int[] nArray) throws SQLException, IOException {
        byte[] byArray;
        int n2 = (int)this.unmarshalUB4();
        if (n2 > 0) {
            byArray = this.unmarshalCLR(n2, nArray);
            if (byArray == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
            }
        } else {
            nArray[0] = 0;
            byArray = NO_BYTES;
        }
        return byArray;
    }

    abstract long buffer2Value(byte var1) throws SQLException, IOException;

    final long buffer2Value(byte by, ByteArrayInputStream byteArrayInputStream) throws SQLException, IOException {
        byte[] byArray;
        boolean bl;
        long l2;
        int n2;
        block13: {
            block11: {
                block12: {
                    n2 = 0;
                    l2 = 0L;
                    bl = false;
                    if ((this.types.rep[by] & 1) <= 0) break block11;
                    n2 = byteArrayInputStream.read();
                    if ((n2 & 0x80) > 0) {
                        n2 &= 0x7F;
                        bl = true;
                    }
                    if (n2 < 0) {
                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 410).fillInStackTrace();
                    }
                    if (n2 == 0) {
                        return 0L;
                    }
                    if (by == 1 && n2 > 2) break block12;
                    if (by != 2 || n2 <= 4) break block13;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 412).fillInStackTrace();
            }
            if (by == 1) {
                n2 = 2;
            } else if (by == 2) {
                n2 = 4;
            }
        }
        if (byteArrayInputStream.read(byArray = new byte[n2]) < 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 410).fillInStackTrace();
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            short s2 = (this.types.rep[by] & 2) > 0 ? (short)(byArray[byArray.length - 1 - i2] & 0xFF) : (short)(byArray[i2] & 0xFF);
            l2 |= (long)(s2 << 8 * (byArray.length - 1 - i2));
        }
        l2 &= 0xFFFFFFFFFFFFFFFFL;
        if (bl) {
            l2 = -l2;
        }
        return l2;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connForException.get();
    }

    protected void setConnectionDuringExceptionHandling(OracleConnection oracleConnection) {
        this.connForException.set(oracleConnection);
    }

    protected abstract void flush() throws IOException;

    abstract void setByteOrder(byte var1) throws IOException;

    abstract void writeZeroCopyIO(byte[] var1, int var2, int var3) throws IOException, NetException;

    void writeZeroCopyIO(DynamicByteArray dynamicByteArray, long l2, int n2) throws IOException, NetException {
        dynamicByteArray.writeZeroCopyIO(this, l2, n2);
    }

    abstract void writeZeroCopyIOHeader(boolean var1, int var2, boolean var3) throws IOException, NetException;

    abstract void writeZeroCopyIOData(byte[] var1, int var2, int var3) throws IOException, NetException;

    boolean readZeroCopyIO(byte[] byArray, int n2, int[] nArray) throws IOException, NetException {
        boolean bl = this.net.readZeroCopyIO(byArray, n2, nArray);
        return bl;
    }

    void setUseCLRBigChunks(boolean bl) {
        this.useCLRBigChunks = bl;
        if (bl) {
            this.effectiveTTCC_MXIN = Short.MAX_VALUE;
        } else {
            assert (false);
            this.effectiveTTCC_MXIN = 64;
        }
    }

    abstract void clearWriteBuffer();

    abstract void prepareForUnmarshalAsync(Consumer<Throwable> var1) throws IOException;

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    static {
        try {
            $$$methodRef$$$51 = T4CMAREngine.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$50 = T4CMAREngine.class.getDeclaredMethod("setUseCLRBigChunks", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$49 = T4CMAREngine.class.getDeclaredMethod("readZeroCopyIO", byte[].class, Integer.TYPE, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$48 = T4CMAREngine.class.getDeclaredMethod("writeZeroCopyIO", DynamicByteArray.class, Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$47 = T4CMAREngine.class.getDeclaredMethod("setConnectionDuringExceptionHandling", OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$46 = T4CMAREngine.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$45 = T4CMAREngine.class.getDeclaredMethod("buffer2Value", Byte.TYPE, ByteArrayInputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$44 = T4CMAREngine.class.getDeclaredMethod("unmarshalDALC", int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$43 = T4CMAREngine.class.getDeclaredMethod("unmarshalDALC", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$42 = T4CMAREngine.class.getDeclaredMethod("unmarshalDALC", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$41 = T4CMAREngine.class.getDeclaredMethod("processIndicator", Boolean.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$40 = T4CMAREngine.class.getDeclaredMethod("escapeSequenceNull", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = T4CMAREngine.class.getDeclaredMethod("unmarshalCLR", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = T4CMAREngine.class.getDeclaredMethod("unmarshalCLRforREFS", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = T4CMAREngine.class.getDeclaredMethod("unmarshalBuffer", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = T4CMAREngine.class.getDeclaredMethod("unmarshalKEYVAL", byte[][].class, byte[][].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = T4CMAREngine.class.getDeclaredMethod("unmarshalCLR", Integer.TYPE, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = T4CMAREngine.class.getDeclaredMethod("unmarshalCLR", byte[].class, Integer.TYPE, int[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = T4CMAREngine.class.getDeclaredMethod("unmarshalCLR", byte[].class, Integer.TYPE, int[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = T4CMAREngine.class.getDeclaredMethod("unmarshalCLR", byte[].class, Integer.TYPE, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = T4CMAREngine.class.getDeclaredMethod("unmarshalCHR", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = T4CMAREngine.class.getDeclaredMethod("unmarshalUWORD", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = T4CMAREngine.class.getDeclaredMethod("unmarshalSWORD", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = T4CMAREngine.class.getDeclaredMethod("unmarshalRefCursor", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = T4CMAREngine.class.getDeclaredMethod("unmarshalSB8", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = T4CMAREngine.class.getDeclaredMethod("unmarshalSB4", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = T4CMAREngine.class.getDeclaredMethod("unmarshalUCS2", byte[].class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = T4CMAREngine.class.getDeclaredMethod("unmarshalNativeUB2", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = T4CMAREngine.class.getDeclaredMethod("addPtr", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = T4CMAREngine.class.getDeclaredMethod("unmarshalKPDKV", byte[][].class, int[].class, byte[][].class, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = T4CMAREngine.class.getDeclaredMethod("marshalKPDKV", byte[][].class, byte[][].class, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = T4CMAREngine.class.getDeclaredMethod("marshalDALC", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = T4CMAREngine.class.getDeclaredMethod("marshalKEYVAL", byte[][].class, byte[][].class, byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = T4CMAREngine.class.getDeclaredMethod("marshalKEYVAL", byte[][].class, int[].class, byte[][].class, int[].class, byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = T4CMAREngine.class.getDeclaredMethod("marshalCLR", InputStream.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = T4CMAREngine.class.getDeclaredMethod("marshalCLR", DynamicByteArray.class, Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = T4CMAREngine.class.getDeclaredMethod("marshalCLR", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = T4CMAREngine.class.getDeclaredMethod("marshalCLR", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = T4CMAREngine.class.getDeclaredMethod("marshalCHR", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = T4CMAREngine.class.getDeclaredMethod("marshalCHR", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = T4CMAREngine.class.getDeclaredMethod("marshalPTR", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = T4CMAREngine.class.getDeclaredMethod("marshalNULLPTR", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = T4CMAREngine.class.getDeclaredMethod("marshalO2U", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = T4CMAREngine.class.getDeclaredMethod("marshalUB4Array", long[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = T4CMAREngine.class.getDeclaredMethod("marshalUWORD", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = T4CMAREngine.class.getDeclaredMethod("marshalSWORD", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T4CMAREngine.class.getDeclaredMethod("toHex", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4CMAREngine.class.getDeclaredMethod("toHex", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4CMAREngine.class.getDeclaredMethod("toHex", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4CMAREngine.class.getDeclaredMethod("toHex", Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CMAREngine.class.getDeclaredMethod("toHex", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CMAREngine.class.getDeclaredMethod("toHex", Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        NO_BYTES = new byte[0];
        IGNORED = new byte[Short.MAX_VALUE];
        NULL_PTR = new byte[]{0, 0, 0, 0};
        NOTNULL_PTR = new byte[]{127, 127, 127, 127};
    }
}

