/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.util.Hashtable;
import java.util.logging.Logger;
import oracle.jdbc.driver.ResultSetCache;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
final class ResultSetCacheManager {
    private static final Hashtable<String, ResultSetCache> cacheTable;
    private static final Monitor CACHE_TABLE_MONITOR;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;

    ResultSetCacheManager() {
    }

    static ResultSetCache getResultSetCache(String string, long l2, int n2) {
        try (Monitor.CloseableLock closeableLock = CACHE_TABLE_MONITOR.acquireCloseableLock();){
            String string2 = string;
            ResultSetCache resultSetCache = cacheTable.get(string2);
            if (resultSetCache == null) {
                resultSetCache = new ResultSetCache(l2, n2);
                cacheTable.put(string2, resultSetCache);
            }
            ResultSetCache resultSetCache2 = resultSetCache;
            return resultSetCache2;
        }
    }

    static {
        try {
            $$$methodRef$$$1 = ResultSetCacheManager.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = ResultSetCacheManager.class.getDeclaredMethod("getResultSetCache", String.class, Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        cacheTable = new Hashtable(10);
        CACHE_TABLE_MONITOR = Monitor.newInstance();
    }
}

