/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterRepConstants;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterWalker;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.CHARACTER_PROCESSING})
class CharacterSetAL32UTF8
extends CharacterSet
implements CharacterRepConstants {
    private static int[] m_byteLen;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;

    CharacterSetAL32UTF8(int n2) {
        super(n2);
        this.rep = 6;
    }

    @Override
    public boolean isLossyFrom(CharacterSet characterSet) {
        boolean bl = ClioSupport.publicEnter() && (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, CharacterSetAL32UTF8.class, $$$methodRef$$$0, this, characterSet);
            }
            boolean bl3 = bl2 = !characterSet.isUnicode();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, CharacterSetAL32UTF8.class, $$$methodRef$$$0, this, bl2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, CharacterSetAL32UTF8.class, $$$methodRef$$$0, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, CharacterSetAL32UTF8.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean isConvertibleFrom(CharacterSet characterSet) {
        boolean bl = ClioSupport.publicEnter() && (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, CharacterSetAL32UTF8.class, $$$methodRef$$$1, this, characterSet);
            }
            boolean bl3 = bl2 = characterSet.rep <= 1024;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, CharacterSetAL32UTF8.class, $$$methodRef$$$1, this, bl3);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, CharacterSetAL32UTF8.class, $$$methodRef$$$1, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, CharacterSetAL32UTF8.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean isUnicode() {
        boolean bl = ClioSupport.publicEnter() && (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, CharacterSetAL32UTF8.class, $$$methodRef$$$2, this, new Object[0]);
            }
            boolean bl2 = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, CharacterSetAL32UTF8.class, $$$methodRef$$$2, this, bl2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, CharacterSetAL32UTF8.class, $$$methodRef$$$2, this, null);
            }
            return true;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, CharacterSetAL32UTF8.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @DisableTrace
    public String toStringWithReplacement(byte[] byArray, int n2, int n3) {
        try {
            char[] cArray = new char[byArray.length];
            int[] nArray = new int[]{n3};
            int n4 = CharacterSet.convertAL32UTF8BytesToJavaChars(byArray, n2, cArray, 0, nArray, true);
            return new String(cArray, 0, n4);
        }
        catch (SQLException sQLException) {
            return "";
        }
    }

    @Override
    @DisableTrace
    public String toString(byte[] byArray, int n2, int n3) throws SQLException {
        try {
            char[] cArray = new char[byArray.length];
            int[] nArray = new int[]{n3};
            int n4 = CharacterSet.convertAL32UTF8BytesToJavaChars(byArray, n2, cArray, 0, nArray, false);
            return new String(cArray, 0, n4);
        }
        catch (SQLException sQLException) {
            CharacterSetAL32UTF8.failUTFConversion();
            return "";
        }
    }

    @Override
    public byte[] convertWithReplacement(String string) {
        boolean bl = ClioSupport.publicEnter() && (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, CharacterSetAL32UTF8.class, $$$methodRef$$$3, this, string);
            }
            byte[] byArray = CharacterSetAL32UTF8.stringToAL32UTF8(string);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, CharacterSetAL32UTF8.class, $$$methodRef$$$3, this, byArray);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, CharacterSetAL32UTF8.class, $$$methodRef$$$3, this, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, CharacterSetAL32UTF8.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public byte[] convert(String string) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, CharacterSetAL32UTF8.class, $$$methodRef$$$4, this, string);
            }
            byte[] byArray = CharacterSetAL32UTF8.stringToAL32UTF8(string);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, CharacterSetAL32UTF8.class, $$$methodRef$$$4, this, byArray);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, CharacterSetAL32UTF8.class, $$$methodRef$$$4, this, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, CharacterSetAL32UTF8.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public byte[] convert(CharacterSet characterSet, byte[] byArray, int n2, int n3) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            byte[] byArray2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, CharacterSetAL32UTF8.class, $$$methodRef$$$5, this, characterSet, byArray, n2, n3);
            }
            if (characterSet.rep == 6) {
                byArray2 = CharacterSetAL32UTF8.useOrCopy(byArray, n2, n3);
            } else {
                String string = characterSet.toString(byArray, n2, n3);
                byArray2 = CharacterSetAL32UTF8.stringToAL32UTF8(string);
            }
            byte[] byArray3 = byArray2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, CharacterSetAL32UTF8.class, $$$methodRef$$$5, this, byArray3);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, CharacterSetAL32UTF8.class, $$$methodRef$$$5, this, null);
            }
            return byArray2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, CharacterSetAL32UTF8.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    int decode(CharacterWalker characterWalker) throws SQLException {
        byte by;
        int n2;
        byte[] byArray = characterWalker.bytes;
        int n3 = characterWalker.next;
        int n4 = characterWalker.end;
        if (n3 >= n4) {
            CharacterSetAL32UTF8.failUTFConversion();
        }
        if ((n2 = CharacterSetAL32UTF8.getUTFByteLength(by = byArray[n3])) == 0 || n3 + (n2 - 1) >= n4) {
            CharacterSetAL32UTF8.failUTFConversion();
        }
        try {
            char[] cArray = new char[2];
            int[] nArray = new int[]{n2};
            int n5 = CharacterSet.convertAL32UTF8BytesToJavaChars(byArray, n3, cArray, 0, nArray, false);
            characterWalker.next += n2;
            if (n5 == 1) {
                return cArray[0];
            }
            return Character.toCodePoint(cArray[0], cArray[1]);
        }
        catch (SQLException sQLException) {
            CharacterSetAL32UTF8.failUTFConversion();
            return 0;
        }
    }

    @Override
    void encode(CharacterBuffer characterBuffer, int n2) throws SQLException {
        int n3;
        if ((n2 & 0xFFFF0000) != 0) {
            CharacterSetAL32UTF8.need(characterBuffer, 4);
            char[] cArray = new char[]{(char)(n2 >>> 16), (char)n2};
            n3 = CharacterSet.convertJavaCharsToAL32UTF8Bytes(cArray, 0, characterBuffer.bytes, characterBuffer.next, 2);
        } else {
            CharacterSetAL32UTF8.need(characterBuffer, 3);
            char[] cArray = new char[]{(char)n2};
            n3 = CharacterSet.convertJavaCharsToAL32UTF8Bytes(cArray, 0, characterBuffer.bytes, characterBuffer.next, 1);
        }
        characterBuffer.next += n3;
    }

    private static int getUTFByteLength(byte by) {
        return m_byteLen[by >>> 4 & 0xF];
    }

    @Override
    public int encodedByteLength(String string) {
        boolean bl = ClioSupport.publicEnter() && (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, CharacterSetAL32UTF8.class, $$$methodRef$$$9, this, string);
            }
            int n2 = CharacterSet.string32UTF8Length(string);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, CharacterSetAL32UTF8.class, $$$methodRef$$$9, this, n2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, CharacterSetAL32UTF8.class, $$$methodRef$$$9, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, CharacterSetAL32UTF8.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int encodedByteLength(char[] cArray) {
        boolean bl = ClioSupport.publicEnter() && (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, CharacterSetAL32UTF8.class, $$$methodRef$$$10, this, new Object[]{cArray});
            }
            int n2 = CharacterSet.charArray32UTF8Length(cArray);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, CharacterSetAL32UTF8.class, $$$methodRef$$$10, this, n2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, CharacterSetAL32UTF8.class, $$$methodRef$$$10, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, CharacterSetAL32UTF8.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$11 = CharacterSetAL32UTF8.class.getDeclaredConstructor(Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$10 = CharacterSetAL32UTF8.class.getDeclaredMethod("encodedByteLength", char[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$9 = CharacterSetAL32UTF8.class.getDeclaredMethod("encodedByteLength", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$8 = CharacterSetAL32UTF8.class.getDeclaredMethod("getUTFByteLength", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$7 = CharacterSetAL32UTF8.class.getDeclaredMethod("encode", CharacterBuffer.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$6 = CharacterSetAL32UTF8.class.getDeclaredMethod("decode", CharacterWalker.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$5 = CharacterSetAL32UTF8.class.getDeclaredMethod("convert", CharacterSet.class, byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$4 = CharacterSetAL32UTF8.class.getDeclaredMethod("convert", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$3 = CharacterSetAL32UTF8.class.getDeclaredMethod("convertWithReplacement", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$2 = CharacterSetAL32UTF8.class.getDeclaredMethod("isUnicode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$1 = CharacterSetAL32UTF8.class.getDeclaredMethod("isConvertibleFrom", CharacterSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$0 = CharacterSetAL32UTF8.class.getDeclaredMethod("isLossyFrom", CharacterSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        m_byteLen = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 2, 2, 3, 4};
    }
}

