/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;

public class TcpsConfigure {
    static final boolean DEBUG = false;
    private static final int SSL_CERT_SAN_DNS_NAME = 2;
    public static final String[] VALID_SSL_VERSION_STRINGS;
    public static final String[][] TABLE_ENABLED_SSL_PROTOCOLS;
    public static final int[] VALID_SSL_STRING_TO_PROTOCOLS_MAP;
    static final HashSet<String> UNSUPPORTED_PROTOCOLS_SET;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;

    private TcpsConfigure() {
    }

    public static void configureVersion(SSLSocket sSLSocket, SSLEngine sSLEngine, String object, boolean bl) throws NetException, IOException {
        if (object == null) {
            object = System.getProperty("oracle.net.ssl_version");
        }
        String[] stringArray = null;
        int n2 = 0;
        if (object != null) {
            object = ((String)object).startsWith("(") && ((String)object).endsWith(")") ? "(ssl_version=" + ((String)object).substring(1) : "(ssl_version=" + (String)object + ")";
            try {
                NVPair nVPair = new NVFactory().createNVPair((String)object);
                String string = nVPair.getAtom();
                for (int i2 = 0; i2 < VALID_SSL_VERSION_STRINGS.length; ++i2) {
                    if (!string.equalsIgnoreCase(VALID_SSL_VERSION_STRINGS[i2])) continue;
                    n2 = i2;
                    break;
                }
            }
            catch (NLException nLException) {
                throw (NetException)new NetException(400, (String)object).initCause(nLException);
            }
            if (n2 >= VALID_SSL_VERSION_STRINGS.length) {
                throw new NetException(400);
            }
            stringArray = TABLE_ENABLED_SSL_PROTOCOLS[VALID_SSL_STRING_TO_PROTOCOLS_MAP[n2]];
        } else {
            stringArray = TcpsConfigure.getAllSupportedProtocols(bl, sSLEngine, sSLSocket);
            if (stringArray == null) {
                throw new NetException(400);
            }
        }
        try {
            if (!bl) {
                sSLSocket.setEnabledProtocols(stringArray);
            } else {
                sSLEngine.setEnabledProtocols(stringArray);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw (NetException)new NetException(401).initCause(illegalArgumentException);
        }
    }

    public static void configureCipherSuites(SSLSocket sSLSocket, SSLEngine sSLEngine, String object, boolean bl) throws NetException, IOException {
        if (object == null) {
            object = System.getProperty("oracle.net.ssl_cipher_suites");
        }
        if (object == null) {
            return;
        }
        object = ((String)object).startsWith("(") && ((String)object).endsWith(")") ? "(cipher_suites=" + (String)object + ")" : "(cipher_suites=(" + (String)object + "))";
        try {
            NVPair nVPair = new NVFactory().createNVPair((String)object);
            String[] stringArray = new String[nVPair.getListSize()];
            if (nVPair.getRHSType() == NVPair.LIST_COMMASEP || nVPair.getRHSType() == NVPair.RHS_LIST) {
                for (int i2 = 0; i2 < nVPair.getListSize(); ++i2) {
                    stringArray[i2] = nVPair.getListElement(i2).getName();
                }
            } else {
                throw new NetException(403, (String)object);
            }
            if (!bl) {
                sSLSocket.setEnabledCipherSuites(stringArray);
            } else {
                sSLEngine.setEnabledCipherSuites(stringArray);
            }
        }
        catch (NLException nLException) {
            throw new NetException(403, (String)object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw (NetException)new NetException(404).initCause(illegalArgumentException);
        }
    }

    private static String[] getAllSupportedProtocols(boolean bl, SSLEngine sSLEngine, SSLSocket sSLSocket) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = null;
        stringArray = bl ? sSLEngine.getSupportedProtocols() : sSLSocket.getSupportedProtocols();
        if (stringArray == null) {
            return null;
        }
        for (String string : stringArray) {
            if (UNSUPPORTED_PROTOCOLS_SET.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static boolean matchServerDN(X509Certificate x509Certificate, String string, boolean bl, String string2) {
        String string3 = x509Certificate.getSubjectDN().getName();
        if (bl) {
            return TcpsConfigure.matchServerDN(string3, string, true);
        }
        return TcpsConfigure.matchHostName(x509Certificate, string2) || TcpsConfigure.matchServerDN(string3, string, false);
    }

    private static boolean matchHostName(X509Certificate x509Certificate, String string) {
        return TcpsConfigure.matchCN(x509Certificate, string) || TcpsConfigure.matchSANs(x509Certificate, string);
    }

    private static boolean matchCN(X509Certificate x509Certificate, String string) {
        try {
            LdapName ldapName = new LdapName(x509Certificate.getSubjectDN().getName());
            List<Rdn> list = ldapName.getRdns();
            for (Rdn rdn : list) {
                if (!rdn.getType().equalsIgnoreCase("cn")) continue;
                return TcpsConfigure.matchHostNames(rdn.getValue().toString(), string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static boolean matchSANs(X509Certificate x509Certificate, String string) {
        String[] stringArray = TcpsConfigure.getDNSSubjectAlts(x509Certificate);
        if (stringArray == null) {
            return false;
        }
        for (String string2 : stringArray) {
            if (!TcpsConfigure.matchHostNames(string2, string)) continue;
            return true;
        }
        return false;
    }

    private static String[] getDNSSubjectAlts(X509Certificate x509Certificate) {
        LinkedList<String> linkedList = new LinkedList<String>();
        Collection<List<?>> collection = null;
        try {
            collection = x509Certificate.getSubjectAlternativeNames();
        }
        catch (CertificateParsingException certificateParsingException) {
            return null;
        }
        if (collection != null) {
            for (List list : collection) {
                List list2 = list;
                int n2 = (Integer)list2.get(0);
                if (n2 != 2) continue;
                String string = (String)list2.get(1);
                linkedList.add(string);
            }
        }
        if (!linkedList.isEmpty()) {
            String[] stringArray = new String[linkedList.size()];
            linkedList.toArray(stringArray);
            return stringArray;
        }
        return null;
    }

    private static boolean matchHostNames(String string, String string2) {
        string = string.toLowerCase();
        string2 = string2.toLowerCase();
        if (string.startsWith("*.") && string.indexOf(46, 2) != -1) {
            return string2.endsWith(string.substring(1));
        }
        return string.equals(string2);
    }

    public static boolean matchServerDN(String string, String string2, boolean bl) {
        if ((string = TcpsConfigure.normalizeDN(string)) == null) {
            return false;
        }
        if (bl) {
            if ((string2 = TcpsConfigure.normalizeDN(string2)) == null) {
                return false;
            }
            if (string2.equalsIgnoreCase(string)) {
                return true;
            }
            return string2.equalsIgnoreCase(string = TcpsConfigure.reverseDN(string));
        }
        int n2 = string.indexOf("CN=");
        return n2 != -1 && string2.equalsIgnoreCase(string = string.indexOf(44, n2) != -1 ? string.substring(n2, string.indexOf(44, n2)) : string.substring(n2));
    }

    public static String normalizeDN(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        String string3 = null;
        int n2 = 0;
        int n3 = 0;
        string = string.trim();
        while ((n2 = string.indexOf(61, n2)) != -1) {
            string2 = string.substring(n3, n2);
            string2 = string2.trim();
            stringBuffer.append(string2.toUpperCase());
            stringBuffer.append('=');
            n3 = n2;
            if (n3 >= string.length() - 1) {
                return null;
            }
            if ((n2 = string.indexOf(44, n2)) == -1) {
                string3 = string.substring(n3 + 1);
                stringBuffer.append(string3.trim());
                break;
            }
            string3 = string.substring(n3 + 1, n2);
            stringBuffer.append(string3.trim());
            stringBuffer.append(',');
            if (n2 >= string.length() - 1) {
                return null;
            }
            n3 = n2 + 1;
        }
        return stringBuffer.toString();
    }

    public static String reverseDN(String string) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        int n3 = n2 = string.length();
        do {
            if ((n2 = string.lastIndexOf(44, n2)) == -1) {
                stringBuffer.append(string.substring(0, n3));
                break;
            }
            string2 = string.substring(n2 + 1, n3);
            stringBuffer.append(string2);
            stringBuffer.append(',');
            n3 = n2--;
        } while (n2 != -1);
        return stringBuffer.toString();
    }

    static {
        try {
            $$$methodRef$$$12 = TcpsConfigure.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = TcpsConfigure.class.getDeclaredMethod("reverseDN", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = TcpsConfigure.class.getDeclaredMethod("normalizeDN", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = TcpsConfigure.class.getDeclaredMethod("matchServerDN", String.class, String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = TcpsConfigure.class.getDeclaredMethod("matchHostNames", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = TcpsConfigure.class.getDeclaredMethod("getDNSSubjectAlts", X509Certificate.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = TcpsConfigure.class.getDeclaredMethod("matchSANs", X509Certificate.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = TcpsConfigure.class.getDeclaredMethod("matchCN", X509Certificate.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = TcpsConfigure.class.getDeclaredMethod("matchHostName", X509Certificate.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = TcpsConfigure.class.getDeclaredMethod("matchServerDN", X509Certificate.class, String.class, Boolean.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = TcpsConfigure.class.getDeclaredMethod("getAllSupportedProtocols", Boolean.TYPE, SSLEngine.class, SSLSocket.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = TcpsConfigure.class.getDeclaredMethod("configureCipherSuites", SSLSocket.class, SSLEngine.class, String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = TcpsConfigure.class.getDeclaredMethod("configureVersion", SSLSocket.class, SSLEngine.class, String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        VALID_SSL_VERSION_STRINGS = new String[]{"0", "undetermined", "2", "2.0", "version 2", "3", "3.0", "version 3 only", "1", "1.0", "version 1 only", "1 or 3", "1.0 or 3.0", "version 1 or version 3", "1.1", "1.2", "1.1 or 3.0", "1.2 or 3.0", "1.1 or 1.0", "1.2 or 1.0", "1.2 or 1.1", "1.1 or 1.0 or 3.0", "1.2 or 1.0 or 3.0", "1.2 or 1.1 or 1.0", "1.2 or 1.1 or 3.0", "1.2 or 1.1 or 1.0 or 3.0"};
        TABLE_ENABLED_SSL_PROTOCOLS = new String[][]{{"TLSv1.2", "TLSv1.1", "TLSv1"}, {"SSLv2Hello"}, {"SSLv3"}, {"TLSv1"}, {"TLSv1", "SSLv3"}, {"TLSv1.1"}, {"TLSv1.2"}, {"TLSv1.1", "SSLv3"}, {"TLSv1.2", "SSLv3"}, {"TLSv1.1", "TLSv1"}, {"TLSv1.2", "TLSv1"}, {"TLSv1.2", "TLSv1.1"}, {"TLSv1.1", "TLSv1", "SSLv3"}, {"TLSv1.2", "TLSv1", "SSLv3"}, {"TLSv1.2", "TLSv1.1", "TLSv1"}, {"TLSv1.2", "TLSv1.1", "SSLv3"}, {"TLSv1.2", "TLSv1.1", "TLSv1", "SSLv3"}};
        VALID_SSL_STRING_TO_PROTOCOLS_MAP = new int[]{0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
        UNSUPPORTED_PROTOCOLS_SET = new HashSet();
        UNSUPPORTED_PROTOCOLS_SET.add("SSLv3");
        UNSUPPORTED_PROTOCOLS_SET.add("SSLv2Hello");
    }
}

