/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.net.ns.NIOPacket;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

@DefaultLogger(value="oracle.net.ns")
@Supports(value={Feature.NET})
public final class NIODataDescriptorPacket
extends NIOPacket
implements SQLnetDef {
    int totalDataLength;
    int descriptorFLaG;
    int[] sdd = new int[26];
    boolean useLongDescriptor = false;
    private static final byte[] STANDARD_SDD_MAX_DD_HEADER_SHORT_SDU;
    private static final byte[] STANDARD_SDD_MAX_DD_HEADER_LARGE_SDU;
    private static final byte[] STANDARD_SDD_MAX_DD_PAYLOAD;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;

    NIODataDescriptorPacket(SessionAtts sessionAtts) {
        super(sessionAtts);
        this.header.type = 15;
    }

    @Override
    void readPayloadBuffer() throws IOException {
        ByteOrder byteOrder = this.session.readBuffer.order();
        this.session.readBuffer.order(ByteOrder.BIG_ENDIAN);
        this.descriptorFLaG = this.session.payloadBufferForRead.getInt();
        this.useLongDescriptor = (this.descriptorFLaG & 2) == 0;
        this.totalDataLength = this.session.payloadBufferForRead.getInt();
        this.session.readBuffer.order(byteOrder);
    }

    final void writeToSocketChannel(int n2, boolean bl) throws IOException {
        if (n2 == 1703910 && !bl) {
            this.session.writeBuffer.clear();
            if (this.session.isLargeSDU) {
                this.session.writeBuffer.put(STANDARD_SDD_MAX_DD_HEADER_LARGE_SDU, 0, STANDARD_SDD_MAX_DD_HEADER_LARGE_SDU.length);
            } else {
                this.session.writeBuffer.put(STANDARD_SDD_MAX_DD_HEADER_SHORT_SDU, 0, STANDARD_SDD_MAX_DD_HEADER_SHORT_SDU.length);
            }
            this.session.writeBuffer.put(STANDARD_SDD_MAX_DD_PAYLOAD, 0, STANDARD_SDD_MAX_DD_PAYLOAD.length);
            this.session.writeBuffer.flip();
            while (this.session.writeBuffer.hasRemaining()) {
                this.session.socketChannel.write(this.session.writeBuffer);
            }
        } else {
            int n3;
            this.useLongDescriptor = false;
            this.descriptorFLaG = 2;
            if (bl) {
                this.descriptorFLaG |= 1;
            }
            int n4 = 0;
            int n5 = n2;
            while (n5 > 0) {
                this.sdd[n4] = n5 > 65535 ? 65535 : n5;
                n5 -= this.sdd[n4];
                ++n4;
            }
            this.session.payloadBufferForWrite.clear();
            this.session.payloadBufferForWrite.putInt(this.descriptorFLaG);
            this.session.payloadBufferForWrite.putInt(n2);
            this.session.payloadBufferForWrite.putInt(n4);
            for (n3 = 0; n3 < n4; ++n3) {
                this.session.payloadBufferForWrite.putShort((short)this.sdd[n3]);
            }
            for (n3 = n4; n3 < 26; ++n3) {
                this.session.payloadBufferForWrite.putShort((short)0);
            }
            this.writeToSocketChannel();
        }
    }

    @Override
    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    static {
        try {
            $$$methodRef$$$2 = NIODataDescriptorPacket.class.getDeclaredConstructor(SessionAtts.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$1 = NIODataDescriptorPacket.class.getDeclaredMethod("writeToSocketChannel", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$0 = NIODataDescriptorPacket.class.getDeclaredMethod("readPayloadBuffer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        STANDARD_SDD_MAX_DD_HEADER_SHORT_SDU = new byte[]{0, 72, 0, 0, 15, 0, 0, 0};
        STANDARD_SDD_MAX_DD_HEADER_LARGE_SDU = new byte[]{0, 0, 0, 72, 15, 0, 0, 0};
        STANDARD_SDD_MAX_DD_PAYLOAD = new byte[]{0, 0, 0, 2, 0, 25, -1, -26, 0, 0, 0, 26, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    }
}

