/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Executable;
import java.net.SocketException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.net.ns.BreakNetException;
import oracle.net.ns.NetException;
import oracle.net.ns.Packet;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

@DefaultLogger(value="oracle.net.ns")
@Supports(value={Feature.NET})
public class DataPacket
extends Packet
implements SQLnetDef {
    static final boolean DEBUG2 = false;
    protected int pktOffset;
    protected int dataFlags;
    protected boolean isBufferFull = false;
    protected boolean isBufferEmpty = false;
    protected int availableBytesToSend = 0;
    protected int availableBytesToRead = 0;
    protected int sessionIdSize = 0;
    protected byte[] compressedDataBuffer;
    protected byte[] decompressedDataBuffer;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;

    public DataPacket(SessionAtts sessionAtts, int n2) {
        super(sessionAtts, n2, 6, (sessionAtts.poolEnabled ? 1 : 0) | (sessionAtts.isLargeSDU ? 32 : 0));
        this.initialize(n2);
    }

    public DataPacket(SessionAtts sessionAtts) {
        this(sessionAtts, sessionAtts.getSDU());
    }

    @Override
    protected void receive() throws IOException, NetException {
        super.receive();
        this.pktOffset = 10;
        this.dataOff = 10;
        this.dataLen = this.length - this.dataOff - (this.sAtts.poolEnabled ? 16 : 0);
        this.dataFlags = this.buffer[8] & 0xFF;
        this.dataFlags <<= 8;
        this.dataFlags |= this.buffer[9] & 0xFF;
        if (this.type == 6 && (this.dataFlags & 0x40) != 0) {
            this.sAtts.dataEOF = true;
        }
        if (this.type == 6 && 0 == this.dataLen) {
            this.type = 7;
        }
        if ((this.dataFlags & 0x400) != 0) {
            try {
                int n2 = this.sAtts.compressionCodec.decompress(this.buffer, 10, this.dataLen, this.decompressedDataBuffer);
                System.arraycopy(this.decompressedDataBuffer, 0, this.buffer, 10, n2);
                this.dataLen = n2;
                this.length = this.dataLen + this.dataOff;
            }
            catch (DataFormatException dataFormatException) {
                throw (IOException)new IOException("Network Compression failure").initCause(dataFormatException);
            }
        }
        if (this.sAtts.poolEnabled) {
            this.sAtts.timestampLastIO = System.currentTimeMillis();
        }
    }

    @Override
    protected void send() throws IOException {
        this.send(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void send(int n2) throws IOException {
        if (this.sAtts.networkCompressionEnabled && this.pktOffset > this.sAtts.networkCompressionThreshold) {
            try {
                int n3 = this.sAtts.compressionCodec.compress(this.buffer, 10, this.pktOffset - 10, this.compressedDataBuffer);
                if (n3 < this.pktOffset - 10) {
                    n2 |= 0x400;
                    System.arraycopy(this.compressedDataBuffer, 0, this.buffer, 10, n3);
                    this.pktOffset = n3 + 10;
                }
            }
            catch (DataFormatException dataFormatException) {
                throw (IOException)new IOException("Network Compression failure").initCause(dataFormatException);
            }
        }
        this.buffer[8] = (byte)(n2 / 256);
        this.buffer[9] = (byte)(n2 % 256);
        this.setBufferLength(this.pktOffset);
        OutputStream outputStream = this.sAtts.ntOutputStream;
        synchronized (outputStream) {
            if (this.sAtts.poolEnabled) {
                boolean bl;
                int n4 = 20;
                do {
                    bl = false;
                    try {
                        this.sAtts.ntOutputStream.write(this.buffer, 0, this.pktOffset);
                    }
                    catch (SocketException socketException) {
                        if (socketException.getMessage().startsWith("Connection reset") && --n4 > 0) {
                            if (!this.sAtts.attemptingReconnect) {
                                this.sAtts.ns.reconnectIfRequired(false);
                            }
                            bl = true;
                            continue;
                        }
                        throw socketException;
                    }
                } while (bl);
            } else {
                this.sAtts.ntOutputStream.write(this.buffer, 0, this.pktOffset);
            }
        }
        this.pktOffset = 10;
        this.availableBytesToSend = 0;
        this.isBufferFull = false;
        if (this.sAtts.poolEnabled) {
            this.sAtts.timestampLastIO = System.currentTimeMillis();
        }
    }

    protected int putDataInBuffer(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5 = n4 = this.buffer.length - this.sessionIdSize - this.pktOffset <= n3 ? this.buffer.length - this.sessionIdSize - this.pktOffset : n3;
        if (n4 > 0) {
            System.arraycopy(byArray, n2, this.buffer, this.pktOffset, n4);
            this.pktOffset += n4;
            this.isBufferFull = this.pktOffset == this.buffer.length - this.sessionIdSize;
            this.availableBytesToSend = this.dataOff < this.pktOffset ? this.pktOffset - this.dataOff : 0;
        }
        return n4;
    }

    public long readLongLSB(int n2) throws BreakNetException, NetException, IOException {
        long l2 = 0L;
        int n3 = n2;
        int n4 = 0;
        while (n3 > 0) {
            l2 |= ((long)this.buffer[this.pktOffset] & 0xFFL) << 8 * n4;
            --n3;
            ++n4;
            ++this.pktOffset;
            --this.availableBytesToRead;
        }
        return l2;
    }

    public long readLongMSB(int n2) throws BreakNetException, NetException, IOException {
        long l2 = 0L;
        int n3 = n2;
        while (n3 > 0) {
            l2 |= ((long)this.buffer[this.pktOffset] & 0xFFL) << 8 * (n3 - 1);
            --n3;
            ++this.pktOffset;
            --this.availableBytesToRead;
        }
        return l2;
    }

    protected int getDataFromBuffer(byte[] byArray, int n2, int n3) throws NetException {
        int n4;
        int n5 = n4 = this.availableBytesToRead <= n3 ? this.availableBytesToRead : n3;
        if (n4 > 0) {
            System.arraycopy(this.buffer, this.pktOffset, byArray, n2, n4);
            this.pktOffset += n4;
            this.isBufferEmpty = this.pktOffset == this.length;
            this.availableBytesToRead -= n4;
        }
        return n4;
    }

    protected void setBufferLength(int n2) throws NetException {
        if (this.sAtts.poolEnabled) {
            System.arraycopy(this.sAtts.sessionId, 0, this.buffer, this.pktOffset, 16);
            n2 += 16;
            this.pktOffset += 16;
        }
        if (this.sAtts.isLargeSDU) {
            this.buffer[3] = (byte)(n2 & 0xFF);
            this.buffer[2] = (byte)(n2 >> 8 & 0xFF);
            this.buffer[1] = (byte)(n2 >> 16 & 0xFF);
            this.buffer[0] = (byte)(n2 >> 24 & 0xFF);
        } else {
            this.buffer[0] = (byte)(n2 / 256);
            this.buffer[1] = (byte)(n2 % 256);
        }
    }

    protected void initialize(int n2) {
        this.pktOffset = 10;
        this.dataOff = 10;
        this.dataLen = n2 - this.dataOff;
        this.dataFlags = 0;
        int n3 = this.sessionIdSize = this.sAtts.poolEnabled ? 16 : 0;
        if (this.sAtts.networkCompressionEnabled) {
            this.compressedDataBuffer = new byte[this.sdu];
            this.decompressedDataBuffer = new byte[this.sdu];
        }
    }

    @Override
    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    static {
        try {
            $$$methodRef$$$10 = DataPacket.class.getDeclaredConstructor(SessionAtts.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$9 = DataPacket.class.getDeclaredConstructor(SessionAtts.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$8 = DataPacket.class.getDeclaredMethod("initialize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$7 = DataPacket.class.getDeclaredMethod("setBufferLength", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$6 = DataPacket.class.getDeclaredMethod("getDataFromBuffer", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$5 = DataPacket.class.getDeclaredMethod("readLongMSB", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$4 = DataPacket.class.getDeclaredMethod("readLongLSB", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$3 = DataPacket.class.getDeclaredMethod("putDataInBuffer", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$2 = DataPacket.class.getDeclaredMethod("send", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$1 = DataPacket.class.getDeclaredMethod("send", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$0 = DataPacket.class.getDeclaredMethod("receive", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
    }
}

