/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Executable;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.ROWSET})
public class OracleSerialBlob
implements Blob,
Serializable,
Cloneable {
    private byte[] buffer;
    private long length;
    private boolean isFreed = false;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;

    public OracleSerialBlob(byte[] byArray) throws SQLException {
        if (byArray == null) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        this.length = byArray.length;
        this.buffer = new byte[(int)this.length];
        int n2 = 0;
        while ((long)n2 < this.length) {
            this.buffer[n2] = byArray[n2];
            ++n2;
        }
    }

    public OracleSerialBlob(Blob blob) throws SQLException {
        if (blob == null) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        this.length = blob.length();
        this.buffer = new byte[(int)this.length];
        BufferedInputStream bufferedInputStream = new BufferedInputStream(blob.getBinaryStream());
        try {
            int n2 = 0;
            int n3 = 0;
            do {
                n2 = bufferedInputStream.read(this.buffer, n3, (int)(this.length - (long)n3));
                n3 += n2;
            } while (n2 > 0);
        }
        catch (IOException iOException) {
            throw (SQLException)DatabaseError.createSqlException(null, 346, iOException.getMessage()).fillInStackTrace();
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException iOException) {
                throw (SQLException)DatabaseError.createSqlException(null, 346, iOException.getMessage()).fillInStackTrace();
            }
        }
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        if (this.isFreed) {
            throw (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
        }
        return new ByteArrayInputStream(this.buffer);
    }

    @Override
    public byte[] getBytes(long l2, int n2) throws SQLException {
        if (this.isFreed) {
            throw (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
        }
        byte[] byArray = null;
        if (--l2 < 0L || (long)n2 > this.length || l2 + (long)n2 > this.length) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        byArray = new byte[n2];
        System.arraycopy(this.buffer, (int)l2, byArray, 0, n2);
        return byArray;
    }

    @Override
    public long length() throws SQLException {
        if (this.isFreed) {
            throw (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
        }
        return this.length;
    }

    @Override
    public long position(byte[] byArray, long l2) throws SQLException {
        if (this.isFreed) {
            throw (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
        }
        if (l2 < 1L) {
            throw (SQLException)DatabaseError.createSqlException(null, 68, "position()").fillInStackTrace();
        }
        if (l2 > this.length || l2 + (long)byArray.length - 1L > this.length) {
            return -1L;
        }
        int n2 = (int)(l2 - 1L);
        boolean bl = false;
        long l3 = byArray.length;
        while ((long)n2 < this.length) {
            int n3 = 0;
            long l4 = n2 + 1;
            int n4 = n2;
            while ((long)n3 < l3 && (long)n4 < this.length && byArray[n3] == this.buffer[n4]) {
                ++n4;
                if ((long)(++n3) != l3) continue;
                return l4;
            }
            ++n2;
        }
        return -1L;
    }

    @Override
    public long position(Blob blob, long l2) throws SQLException {
        if (this.isFreed) {
            throw (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
        }
        return this.position(blob.getBytes(1L, (int)blob.length()), l2);
    }

    @Override
    public int setBytes(long l2, byte[] byArray) throws SQLException {
        if (this.isFreed) {
            throw (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
        }
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public int setBytes(long l2, byte[] byArray, int n2, int n3) throws SQLException {
        if (this.isFreed) {
            throw (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
        }
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public OutputStream setBinaryStream(long l2) throws SQLException {
        if (this.isFreed) {
            throw (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
        }
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public void truncate(long l2) throws SQLException {
        if (this.isFreed) {
            throw (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
        }
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public void free() throws SQLException {
        if (this.isFreed) {
            return;
        }
        this.isFreed = true;
        this.buffer = null;
        this.length = 0L;
    }

    @Override
    public InputStream getBinaryStream(long l2, long l3) throws SQLException {
        if (this.isFreed) {
            throw (SQLException)DatabaseError.createSqlException(192).fillInStackTrace();
        }
        if (--l2 < 0L || l2 + 1L > this.length || l3 > this.length || l2 > Integer.MAX_VALUE || this.length > Integer.MAX_VALUE || l2 + l3 > this.length) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        return new ByteArrayInputStream(this.buffer, (int)l2, (int)l3);
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    static {
        try {
            $$$methodRef$$$13 = OracleSerialBlob.class.getDeclaredConstructor(Blob.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleSerialBlob.class.getDeclaredConstructor(byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleSerialBlob.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleSerialBlob.class.getDeclaredMethod("getBinaryStream", Long.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleSerialBlob.class.getDeclaredMethod("free", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleSerialBlob.class.getDeclaredMethod("truncate", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleSerialBlob.class.getDeclaredMethod("setBinaryStream", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleSerialBlob.class.getDeclaredMethod("setBytes", Long.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleSerialBlob.class.getDeclaredMethod("setBytes", Long.TYPE, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleSerialBlob.class.getDeclaredMethod("position", Blob.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleSerialBlob.class.getDeclaredMethod("position", byte[].class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleSerialBlob.class.getDeclaredMethod("length", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleSerialBlob.class.getDeclaredMethod("getBytes", Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleSerialBlob.class.getDeclaredMethod("getBinaryStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

