/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.rowset.FilteredRowSet;
import javax.sql.rowset.Predicate;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.rowset.OracleWebRowSet;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.ROWSET})
public class OracleFilteredRowSet
extends OracleWebRowSet
implements FilteredRowSet {
    private Predicate predicate;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;

    @Override
    public void setFilter(Predicate predicate) throws SQLException {
        this.predicate = predicate;
    }

    @Override
    public Predicate getFilter() {
        return this.predicate;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.rowCount <= 0) {
            return false;
        }
        if (this.presentRow >= this.rowCount) {
            return false;
        }
        boolean bl = false;
        do {
            ++this.presentRow;
            if (this.predicate != null && (this.predicate == null || !this.predicate.evaluate(this))) continue;
            bl = true;
            break;
        } while (this.presentRow <= this.rowCount);
        if (bl) {
            this.notifyCursorMoved();
            return true;
        }
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.rowsetType == 1003) {
            throw (SQLException)DatabaseError.createSqlException(344).fillInStackTrace();
        }
        if (this.rowCount <= 0) {
            return false;
        }
        if (this.presentRow <= 1) {
            return false;
        }
        boolean bl = false;
        do {
            --this.presentRow;
            if (this.predicate != null && (this.predicate == null || !this.predicate.evaluate(this))) continue;
            bl = true;
            break;
        } while (this.presentRow >= 1);
        if (bl) {
            this.notifyCursorMoved();
            return true;
        }
        return false;
    }

    @Override
    public boolean absolute(int n2) throws SQLException {
        int n3;
        if (this.rowsetType == 1003) {
            throw (SQLException)DatabaseError.createSqlException(344).fillInStackTrace();
        }
        if (n2 == 0 || Math.abs(n2) > this.rowCount) {
            return false;
        }
        int n4 = n2 < 0 ? this.rowCount + n2 + 1 : n2;
        this.presentRow = 0;
        for (n3 = 0; n3 < n4 && this.presentRow <= this.rowCount; ++n3) {
            if (this.next()) {
                continue;
            }
            return false;
        }
        if (n3 == n4) {
            this.notifyCursorMoved();
            return true;
        }
        return false;
    }

    @Override
    protected void checkAndFilterObject(int n2, Object object) throws SQLException {
        if (this.predicate != null && !this.predicate.evaluate(object, n2)) {
            throw (SQLException)DatabaseError.createSqlException(345).fillInStackTrace();
        }
    }

    @Override
    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    static {
        try {
            $$$methodRef$$$6 = OracleFilteredRowSet.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleFilteredRowSet.class.getDeclaredMethod("checkAndFilterObject", Integer.TYPE, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleFilteredRowSet.class.getDeclaredMethod("absolute", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleFilteredRowSet.class.getDeclaredMethod("previous", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleFilteredRowSet.class.getDeclaredMethod("next", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleFilteredRowSet.class.getDeclaredMethod("getFilter", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleFilteredRowSet.class.getDeclaredMethod("setFilter", Predicate.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

