/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeUPT;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OBJECT_TYPES})
@DefaultLevel(value=Logging.FINEST)
public class TDSPatch {
    static final int S_NORMAL_PATCH = 0;
    static final int S_SIMPLE_PATCH = 1;
    int typeId;
    OracleType owner;
    long position;
    int uptCode;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;

    public TDSPatch(int n2, OracleType oracleType, long l2, int n3) throws SQLException {
        this.typeId = n2;
        this.owner = oracleType;
        this.position = l2;
        this.uptCode = n3;
    }

    int getType() throws SQLException {
        return this.typeId;
    }

    OracleNamedType getOwner() throws SQLException {
        return (OracleNamedType)this.owner;
    }

    long getPosition() throws SQLException {
        return this.position;
    }

    byte getUptTypeCode() throws SQLException {
        return (byte)this.uptCode;
    }

    void apply(OracleType oracleType) throws SQLException {
        this.apply(oracleType, -1);
    }

    void apply(OracleType oracleType, int n2) throws SQLException {
        if (this.typeId == 0) {
            OracleTypeUPT oracleTypeUPT = (OracleTypeUPT)this.owner;
            oracleTypeUPT.realType = (OracleTypeADT)oracleType;
            if (oracleType instanceof OracleNamedType) {
                OracleNamedType oracleNamedType = (OracleNamedType)oracleType;
                oracleNamedType.setParent(oracleTypeUPT.getParent());
                oracleNamedType.setOrder(oracleTypeUPT.getOrder());
            }
        } else if (this.typeId == 1) {
            OracleTypeCOLLECTION oracleTypeCOLLECTION = (OracleTypeCOLLECTION)this.owner;
            oracleTypeCOLLECTION.opcode = n2;
            oracleTypeCOLLECTION.elementType = oracleType;
            if (oracleType instanceof OracleNamedType) {
                OracleNamedType oracleNamedType = (OracleNamedType)oracleType;
                oracleNamedType.setParent(oracleTypeCOLLECTION);
                oracleNamedType.setOrder(1);
            }
        } else {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1).fillInStackTrace();
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    static {
        try {
            $$$methodRef$$$7 = TDSPatch.class.getDeclaredConstructor(Integer.TYPE, OracleType.class, Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = TDSPatch.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = TDSPatch.class.getDeclaredMethod("apply", OracleType.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = TDSPatch.class.getDeclaredMethod("apply", OracleType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = TDSPatch.class.getDeclaredMethod("getUptTypeCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = TDSPatch.class.getDeclaredMethod("getPosition", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = TDSPatch.class.getDeclaredMethod("getOwner", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = TDSPatch.class.getDeclaredMethod("getType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

