/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateTimeCommonAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class TimestampltzAccessor
extends DateTimeCommonAccessor {
    static final int MAXLENGTH = 11;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;

    TimestampltzAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl) throws SQLException {
        super(Representation.TIMESTAMPLTZ, oracleStatement, 11, bl);
        this.init(oracleStatement, 231, 231, s2, bl);
        this.initForDataAccess(n3, n2, null);
    }

    TimestampltzAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, long l2, int n6, short s2) throws SQLException {
        super(Representation.TIMESTAMPLTZ, oracleStatement, 11, false);
        this.init(oracleStatement, 231, 231, s2, false);
        this.initForDescribe(231, n2, bl, n3, n4, n5, l2, n6, s2, null);
        this.initForDataAccess(0, n2, null);
    }

    @Override
    String getString(int n2) throws SQLException {
        if (this.isUseLess || this.isNull(n2)) {
            return null;
        }
        Calendar calendar = this.statement.connection.getDbTzCalendar();
        String string = this.statement.connection.getSessionTimeZone();
        if (string == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 198).fillInStackTrace();
        }
        TimeZone timeZone = TimeZone.getTimeZone(string);
        Calendar calendar2 = Calendar.getInstance(timeZone);
        this.getBytesInternal(n2, this.tmpBytes);
        int n3 = this.oracleYear(this.tmpBytes);
        calendar.set(1, n3);
        calendar.set(2, this.oracleMonth(this.tmpBytes));
        calendar.set(5, this.oracleDay(this.tmpBytes));
        calendar.set(11, this.oracleHour(this.tmpBytes));
        calendar.set(12, this.oracleMin(this.tmpBytes));
        calendar.set(13, this.oracleSec(this.tmpBytes));
        calendar.set(14, 0);
        oracle.sql.TIMESTAMPLTZ.TimeZoneAdjust(this.statement.connection, calendar, calendar2);
        n3 = calendar2.get(1);
        int n4 = calendar2.get(2) + 1;
        int n5 = calendar2.get(5);
        int n6 = calendar2.get(11);
        int n7 = calendar2.get(12);
        int n8 = calendar2.get(13);
        int n9 = 0;
        boolean bl = n6 < 12;
        String string2 = calendar2.getTimeZone().getID();
        if (string2.length() > 3 && string2.startsWith("GMT")) {
            string2 = string2.substring(3);
        }
        if (this.getLength(n2) == 11) {
            n9 = this.oracleNanos(this.tmpBytes);
        }
        return this.toText(n3, n4, n5, n6, n7, n8, n9, bl, string2);
    }

    @Override
    Date getDate(int n2, Calendar calendar) throws SQLException {
        return this.getDate(n2);
    }

    @Override
    Date getDate(int n2) throws SQLException {
        if (this.isUseLess || this.isNull(n2)) {
            return null;
        }
        Calendar calendar = this.statement.connection.getDbTzCalendar();
        String string = this.statement.connection.getSessionTimeZone();
        if (string == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 198).fillInStackTrace();
        }
        this.getBytesInternal(n2, this.tmpBytes);
        int n3 = this.oracleYear(this.tmpBytes);
        calendar.set(1, n3);
        calendar.set(2, this.oracleMonth(this.tmpBytes));
        calendar.set(5, this.oracleDay(this.tmpBytes));
        calendar.set(11, this.oracleHour(this.tmpBytes));
        calendar.set(12, this.oracleMin(this.tmpBytes));
        calendar.set(13, this.oracleSec(this.tmpBytes));
        calendar.set(14, 0);
        long l2 = oracle.sql.TIMESTAMPLTZ.TimeZoneAdjustUTC(this.statement.connection, calendar);
        return new Date(l2);
    }

    @Override
    Time getTime(int n2, Calendar calendar) throws SQLException {
        return this.getTime(n2);
    }

    @Override
    Time getTime(int n2) throws SQLException {
        if (this.isUseLess || this.isNull(n2)) {
            return null;
        }
        Calendar calendar = this.statement.connection.getDbTzCalendar();
        String string = this.statement.connection.getSessionTimeZone();
        if (string == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 198).fillInStackTrace();
        }
        this.getBytesInternal(n2, this.tmpBytes);
        int n3 = this.oracleYear(this.tmpBytes);
        calendar.set(1, n3);
        calendar.set(2, this.oracleMonth(this.tmpBytes));
        calendar.set(5, this.oracleDay(this.tmpBytes));
        calendar.set(11, this.oracleHour(this.tmpBytes));
        calendar.set(12, this.oracleMin(this.tmpBytes));
        calendar.set(13, this.oracleSec(this.tmpBytes));
        calendar.set(14, 0);
        long l2 = oracle.sql.TIMESTAMPLTZ.TimeZoneAdjustUTC(this.statement.connection, calendar);
        return new Time(l2);
    }

    @Override
    Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        return this.getTimestamp(n2);
    }

    @Override
    Timestamp getTimestamp(int n2) throws SQLException {
        if (this.isUseLess || this.isNull(n2)) {
            return null;
        }
        Calendar calendar = this.statement.connection.getDbTzCalendar();
        String string = this.statement.connection.getSessionTimeZone();
        if (string == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 198).fillInStackTrace();
        }
        this.getBytesInternal(n2, this.tmpBytes);
        int n3 = this.oracleYear(this.tmpBytes);
        calendar.set(1, n3);
        calendar.set(2, this.oracleMonth(this.tmpBytes));
        calendar.set(5, this.oracleDay(this.tmpBytes));
        calendar.set(11, this.oracleHour(this.tmpBytes));
        calendar.set(12, this.oracleMin(this.tmpBytes));
        calendar.set(13, this.oracleSec(this.tmpBytes));
        calendar.set(14, 0);
        long l2 = oracle.sql.TIMESTAMPLTZ.TimeZoneAdjustUTC(this.statement.connection, calendar);
        Timestamp timestamp = new Timestamp(l2);
        if (this.getLength(n2) == 11) {
            timestamp.setNanos(this.oracleNanos(this.tmpBytes));
        }
        return timestamp;
    }

    @Override
    Object getObject(int n2) throws SQLException {
        return this.getTIMESTAMPLTZ(n2);
    }

    @Override
    Datum getOracleObject(int n2) throws SQLException {
        return this.getTIMESTAMPLTZ(n2);
    }

    @Override
    Object getObject(int n2, Map map) throws SQLException {
        return this.getTIMESTAMPLTZ(n2);
    }

    @Override
    TIMESTAMPLTZ getTIMESTAMPLTZ(int n2) throws SQLException {
        if (this.isUseLess || this.isNull(n2)) {
            return null;
        }
        return new TIMESTAMPLTZ(this.getBytesInternal(n2));
    }

    @Override
    TIMESTAMPTZ getTIMESTAMPTZ(int n2) throws SQLException {
        if (this.isUseLess || this.isNull(n2)) {
            return null;
        }
        return oracle.sql.TIMESTAMPLTZ.toTIMESTAMPTZ(this.statement.connection, this.getBytesInternal(n2));
    }

    @Override
    TIMESTAMP getTIMESTAMP(int n2) throws SQLException {
        if (this.isUseLess || this.isNull(n2)) {
            return null;
        }
        TIMESTAMPTZ tIMESTAMPTZ = this.getTIMESTAMPTZ(n2);
        return oracle.sql.TIMESTAMPTZ.toTIMESTAMP(this.statement.connection, tIMESTAMPTZ.getBytes());
    }

    @Override
    DATE getDATE(int n2) throws SQLException {
        if (this.isUseLess || this.isNull(n2)) {
            return null;
        }
        TIMESTAMPTZ tIMESTAMPTZ = this.getTIMESTAMPTZ(n2);
        return oracle.sql.TIMESTAMPTZ.toDATE(this.statement.connection, tIMESTAMPTZ.getBytes());
    }

    static {
        try {
            $$$methodRef$$$15 = TimestampltzAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = TimestampltzAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Short.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = TimestampltzAccessor.class.getDeclaredMethod("getDATE", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = TimestampltzAccessor.class.getDeclaredMethod("getTIMESTAMP", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = TimestampltzAccessor.class.getDeclaredMethod("getTIMESTAMPTZ", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = TimestampltzAccessor.class.getDeclaredMethod("getTIMESTAMPLTZ", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = TimestampltzAccessor.class.getDeclaredMethod("getObject", Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = TimestampltzAccessor.class.getDeclaredMethod("getOracleObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = TimestampltzAccessor.class.getDeclaredMethod("getObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = TimestampltzAccessor.class.getDeclaredMethod("getTimestamp", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = TimestampltzAccessor.class.getDeclaredMethod("getTimestamp", Integer.TYPE, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = TimestampltzAccessor.class.getDeclaredMethod("getTime", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = TimestampltzAccessor.class.getDeclaredMethod("getTime", Integer.TYPE, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = TimestampltzAccessor.class.getDeclaredMethod("getDate", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = TimestampltzAccessor.class.getDeclaredMethod("getDate", Integer.TYPE, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = TimestampltzAccessor.class.getDeclaredMethod("getString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

