/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.spy.jvm;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.HashMap;
import java.util.List;
import oracle.dms.instrument.GroupRefresh;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.State;

public class MemoryPools
implements GroupRefresh {
    private static HashMap<String, MemoryPools> s_statMap = new HashMap();
    private static Noun s_baseNoun = null;
    private MemoryPoolMXBean m_bean = null;
    private State m_valid = null;
    private State m_mmNames = null;
    private State m_collectionUsed = null;
    private State m_used = null;
    private State m_peak = null;
    private State m_type = null;
    private State m_collectionThreshold = null;
    private State m_usageThreshold = null;

    private MemoryPools() {
    }

    private MemoryPools(Noun baseNoun, MemoryPoolMXBean bean) {
        if (s_baseNoun == null) {
            s_baseNoun = baseNoun == null ? Noun.create("/JVM/MxBeans/MemoryPools") : Noun.create(baseNoun, "MemoryPools", "");
        }
        String name = bean.getName();
        Noun noun = Noun.create(s_baseNoun, name, "JVM_MemoryPool");
        this.m_bean = bean;
        this.m_valid = State.create(noun, "valid", (byte)5, "", "whether memory pool is valid in JVM");
        this.m_valid.update(bean.isValid() ? "TRUE" : "FALSE");
        this.m_mmNames = State.create(noun, "memory manager", (byte)5, "", "Memory managers which manage this pool");
        String[] names = bean.getMemoryManagerNames();
        StringBuffer buf = new StringBuffer(512);
        int length = 0;
        for (int i = 0; i < names.length; ++i) {
            buf.append(names[i]);
            buf.append(", ");
            length += names[i].length() + 2;
        }
        String list = buf.substring(0, length -= 2);
        this.m_mmNames.update(list);
        this.m_used = State.create(noun, "usedNow", (byte)2, "KB", "KB of pool currently in use");
        this.m_used.setRefresh(this);
        this.m_collectionUsed = State.create(noun, "usedAfterCollect", (byte)2, "KB", "KB of pool in use after last collection");
        this.m_collectionUsed.setRefresh(this);
        this.m_peak = State.create(noun, "usedPeak", (byte)2, "KB", "maximum number of KB of pool used");
        this.m_peak.setRefresh(this);
        this.m_type = State.create(noun, "type", (byte)5, "", "heap versus non-heap memory pool");
        this.m_type.update((Object)bean.getType());
        this.refresh();
    }

    public static void create(Noun base) {
        if (s_statMap.size() > 0) {
            return;
        }
        MemoryPools stat = null;
        String name = null;
        List<MemoryPoolMXBean> beans = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean bean : beans) {
            stat = new MemoryPools(base, bean);
            name = bean.getName();
            s_statMap.put(name, stat);
        }
    }

    @Override
    public void refresh() {
        MemoryUsage collection = this.m_bean.getCollectionUsage();
        MemoryUsage usage = this.m_bean.getUsage();
        MemoryUsage peak = this.m_bean.getPeakUsage();
        long kb = 0L;
        if (collection != null) {
            kb = (collection.getUsed() + 500L) / 1000L;
            this.m_collectionUsed.update(kb);
        }
        if (usage != null) {
            kb = (usage.getUsed() + 500L) / 1000L;
            this.m_used.update(kb);
        }
        if (peak != null) {
            kb = (peak.getUsed() + 500L) / 1000L;
            this.m_peak.update(kb);
        }
        this.m_valid.update(this.m_bean.isValid() ? "TRUE" : "FALSE");
        String[] names = this.m_bean.getMemoryManagerNames();
        StringBuilder buf = new StringBuilder(512);
        int length = 0;
        for (String name : names) {
            buf.append(name).append(", ");
            length += name.length() + 2;
        }
        String list = buf.substring(0, length -= 2);
        this.m_mmNames.update(list);
    }

    static void exit() {
        s_statMap.clear();
        s_baseNoun = null;
    }
}

