/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.util;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class URIUtils {
    public static Map<String, String> parseQueryString(String queryString) {
        HashMap<String, String> retVal = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(queryString, "&");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            String[] parsedToken = URIUtils.parseQueryStringParameterToken(token);
            if (parsedToken[0] == null) continue;
            retVal.put(parsedToken[0], parsedToken[1]);
        }
        return retVal;
    }

    public static String[] parseQueryStringParameterToken(String token) {
        String paramName = null;
        String paramValue = null;
        int splitPoint = token.indexOf(61);
        if (splitPoint > 0) {
            paramName = token.substring(0, splitPoint);
            if (splitPoint + 1 < token.length() - 1) {
                paramValue = token.substring(splitPoint + 1, token.length());
            }
        }
        return new String[]{paramName, paramValue};
    }

    public static String buildQueryString(Map<String, String> params) {
        StringBuilder sb = new StringBuilder();
        if (params != null) {
            boolean addParamSeparator = false;
            for (Map.Entry<String, String> entry : params.entrySet()) {
                if (addParamSeparator) {
                    sb.append('&');
                }
                addParamSeparator = true;
                sb.append(URIUtils.escapeForQueryString(entry.getKey()));
                if (entry.getValue() == null || entry.getValue().length() <= 0) continue;
                sb.append("=");
                sb.append(URIUtils.escapeForQueryString(entry.getValue()));
            }
        }
        String retVal = sb.toString();
        return retVal;
    }

    public static String escapeForQueryString(String inString) {
        String retVal = null;
        if (inString != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < inString.length(); ++i) {
                char c = inString.charAt(i);
                if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.' || c == '!' || c == '~' || c == '*' || c == '\'' || c == '(' || c == ')') {
                    sb.append(c);
                    continue;
                }
                sb.append('%');
                sb.append(Integer.toHexString(c));
            }
            retVal = sb.toString();
        }
        return retVal;
    }
}

